/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumTopicMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.dto.PostTopicDTO;
import com.bxm.localnews.news.dto.RelationDTO;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.service.ForumTopicService;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostTopicVO;
import com.bxm.localnews.news.vo.TopicVo;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.RandomUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ForumTopicServiceImpl
extends BaseService
implements ForumTopicService {
    private static final String AREA_PLACE_HOLDER = "{areaname}";
    private static final String TOPIC_PLACE_HOLDER = "{topicname}";
    @Resource
    private ForumTopicMapper forumTopicMapper;
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private IUrlFactory iUrlFactory;
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private LocationIntegrationService locationIntegrationService;

    @Override
    public List<PostTopicVO> listTopicByPostIds(List<Long> postIds, Long userId) {
        ArrayList<PostTopicVO> postTopicVoList = new ArrayList<PostTopicVO>();
        List relationList = this.forumTopicMapper.getPostTopicRelation(postIds);
        if (CollectionUtils.isNotEmpty((Collection)relationList)) {
            for (RelationDTO relation : relationList) {
                TopicVo topicVo;
                PostTopicVO postTopic = new PostTopicVO();
                postTopic.setPostId(relation.getAid());
                if (null != relation.getBid() && null != (topicVo = this.getTopicDetail(relation.getBid(), userId, null))) {
                    BeanUtils.copyProperties((Object)topicVo, (Object)postTopic);
                }
                postTopicVoList.add(postTopic);
            }
        }
        return postTopicVoList;
    }

    @Override
    public List<TopicVo> listTopicByPostId(Long postId, Long userId) {
        ArrayList<TopicVo> topicVoList = new ArrayList<TopicVo>();
        List relationList = this.forumTopicMapper.getPostTopicRelation(Collections.singletonList(postId));
        if (CollectionUtils.isNotEmpty((Collection)relationList)) {
            for (RelationDTO relation : relationList) {
                TopicVo topicVo;
                if (null == relation.getBid() || null == (topicVo = this.getTopicDetail(relation.getBid(), userId, null))) continue;
                topicVoList.add(topicVo);
            }
        }
        return topicVoList;
    }

    @Override
    public void fillTopicShareInfo(TopicVo topicVo, Long userId) {
        if (topicVo != null) {
            topicVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, topicVo.getId(), userId));
            topicVo.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.TOPIC, topicVo.getId(), userId));
        }
    }

    @Override
    public List<TopicVo> listTopic(String areaCode, Integer size, Long userId, Integer postPage) {
        List<Object> topicVoList = this.getTopicList(areaCode);
        if (CollectionUtils.isEmpty(topicVoList)) {
            return topicVoList;
        }
        if (postPage != null && 1 == postPage) {
            Long noteTopicId = this.forumProperties.getNoteTopicId();
            topicVoList = topicVoList.stream().filter(e -> !noteTopicId.equals(e.getId())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(topicVoList)) {
            return topicVoList;
        }
        if (size != null && size == 2) {
            topicVoList = this.generateRandomTopic(topicVoList);
        }
        topicVoList.forEach(e -> this.fillTopicShareInfo((TopicVo)e, userId));
        return topicVoList;
    }

    @Override
    public List<TopicVo> getTopicList(String areaCode) {
        List topicVoList;
        String areaCodeKey = areaCode;
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            areaCodeKey = "0";
        }
        if (CollectionUtils.isNotEmpty((Collection)(topicVoList = (List)this.redisHashMapAdapter.get(RedisConfig.TOPIC, areaCodeKey, (TypeReference)new TypeReference<List<TopicVo>>(){})))) {
            return topicVoList;
        }
        topicVoList = this.forumTopicMapper.getTopicList(areaCode, Integer.valueOf(1));
        if (CollectionUtils.isNotEmpty((Collection)topicVoList)) {
            LocationDTO locationDTO;
            this.calcJoinHeadImgList(topicVoList);
            String areaName = "\u5168\u56fd";
            if (StringUtils.isNotBlank((CharSequence)areaCode) && (locationDTO = this.locationIntegrationService.getLocationByGeocode(areaCode)) != null) {
                areaName = locationDTO.getName();
            }
            for (TopicVo topicVo : topicVoList) {
                String recommendContent = topicVo.getRecommendContent();
                if (StringUtils.isBlank((CharSequence)recommendContent)) {
                    recommendContent = this.forumProperties.getDefaultRecommendContent();
                }
                recommendContent = recommendContent.replace(AREA_PLACE_HOLDER, areaName);
                topicVo.setRecommendContent(recommendContent.replace(TOPIC_PLACE_HOLDER, topicVo.getTitle()));
            }
            this.redisHashMapAdapter.put(RedisConfig.TOPIC, areaCodeKey, (Object)topicVoList);
        }
        return topicVoList;
    }

    @Override
    public TopicVo getTopicDetail(Long id, Long userId, String areaCode) {
        TopicVo topicVo = this.getTopicById(id, areaCode);
        this.fillTopicShareInfo(topicVo, userId);
        return topicVo;
    }

    @Override
    public void updateTopic(ForumPostVo forumPostVo) {
        this.logger.warn("\u5e16\u5b50\u66f4\u65b0\u8bdd\u9898\uff0cid:[{}],\u8bdd\u9898\u5217\u8868:[{}]", (Object)forumPostVo.getId(), JSONObject.toJSON((Object)forumPostVo.getTopicList()));
        if (null == forumPostVo.getId() || CollectionUtils.isEmpty((Collection)forumPostVo.getTopicIdList())) {
            return;
        }
        ArrayList<PostTopicDTO> list = new ArrayList<PostTopicDTO>();
        for (Long topicId : forumPostVo.getTopicIdList()) {
            if (null == topicId) continue;
            PostTopicDTO postTopicDTO = new PostTopicDTO();
            postTopicDTO.setId(this.nextSequence());
            postTopicDTO.setPostId(forumPostVo.getId());
            postTopicDTO.setTopicId(topicId);
            list.add(postTopicDTO);
        }
        this.forumTopicMapper.batchDeleteTopic(forumPostVo.getId());
        if (CollectionUtils.isNotEmpty(list)) {
            this.forumTopicMapper.batchInsertTopic(list);
        }
    }

    private TopicVo getTopicById(Long id, String areaCode) {
        List<TopicVo> topicVoList = this.getTopicList(areaCode);
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            for (TopicVo topicVo : topicVoList) {
                if (!topicVo.getId().equals(id)) continue;
                return topicVo;
            }
        }
        return this.forumTopicMapper.selectTopicById(id, areaCode);
    }

    private void calcJoinHeadImgList(List<TopicVo> topicVoList) {
        for (TopicVo topicVo : topicVoList) {
            List postHeadImgList = this.forumTopicMapper.getPostHeadImgList(topicVo.getId());
            if (CollectionUtils.isEmpty((Collection)postHeadImgList)) continue;
            HashSet joinHeadImgSet = new HashSet(postHeadImgList);
            if (joinHeadImgSet.size() < 5) {
                List likeHeadImgList;
                List postIdList = this.forumTopicMapper.getPostIdListByTopicId(topicVo.getId());
                boolean isNotEnough = false;
                if (CollectionUtils.isNotEmpty((Collection)postIdList)) {
                    for (Long postId : postIdList) {
                        List replyHeadImgList = this.newsReplyMapper.getReplyHeadImgList(postId);
                        if (!CollectionUtils.isNotEmpty((Collection)replyHeadImgList)) continue;
                        joinHeadImgSet.addAll(replyHeadImgList);
                        if (joinHeadImgSet.size() < 5) continue;
                        break;
                    }
                    if (joinHeadImgSet.size() < 5) {
                        isNotEnough = true;
                    }
                }
                if (isNotEnough && CollectionUtils.isNotEmpty((Collection)(likeHeadImgList = this.forumTopicMapper.getLikeHeadImgList(topicVo.getId())))) {
                    joinHeadImgSet.addAll(likeHeadImgList);
                }
            }
            topicVo.setJoinHeadImgList(joinHeadImgSet.stream().limit(5L).collect(Collectors.toList()));
        }
    }

    private List<TopicVo> generateRandomTopic(List<TopicVo> originList) {
        if (originList.size() <= 2) {
            return originList;
        }
        List<TopicVo> randomTopicVoList = originList.stream().limit(6L).collect(Collectors.toList());
        this.logger.debug("\u968f\u673a\u53d6\u4e24\u6761\u8bdd\u9898:[{}]", (Object)originList.size());
        if (CollectionUtils.isNotEmpty(originList)) {
            int random = RandomUtils.nextInt((int)0, (int)originList.size());
            this.logger.debug("\u968f\u673a\u53d6\u65701:[{}]", (Object)random);
            randomTopicVoList.add(originList.get(random));
            originList.remove(random);
            if (CollectionUtils.isNotEmpty(originList)) {
                int random2 = RandomUtils.nextInt((int)0, (int)originList.size());
                this.logger.debug("\u968f\u673a\u53d6\u65702:[{}]", (Object)random2);
                randomTopicVoList.add(originList.get(random2));
            }
        }
        this.logger.debug("\u83b7\u5f97\u8bdd\u9898:[{}]", (Object)JSONObject.toJSONString(randomTopicVoList));
        return randomTopicVoList;
    }
}

