/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.news.domain.InitTagMapper;
import com.bxm.localnews.news.domain.UserTagMapper;
import com.bxm.localnews.news.service.InitTagService;
import com.bxm.localnews.news.vo.UserTag;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class InitTagServiceImpl
extends BaseService
implements InitTagService {
    private InitTagMapper initTagMapper;

    @Autowired
    public InitTagServiceImpl(InitTagMapper initTagMapper) {
        this.initTagMapper = initTagMapper;
    }

    @Override
    public Message createInitTags(final Long userId) {
        Assert.notNull((Object)userId, (String)"userId must has text");
        List initTagList = this.initTagMapper.selectAllTag();
        List userTags = initTagList.stream().map(e -> {
            UserTag userTag = new UserTag();
            userTag.setName(e.getName());
            userTag.setRatio(e.getRatio());
            userTag.setTagType(e.getTagType().intValue());
            return userTag;
        }).collect(Collectors.toList());
        final Date current = new Date();
        new BatchHelper<UserTagMapper, UserTag>(UserTagMapper.class, userTags){

            protected int invoke(UserTag element) {
                element.setId(Long.valueOf(InitTagServiceImpl.this.nextId()));
                element.setUserId(userId);
                element.setStatus(Byte.valueOf((byte)1));
                element.setUpdateTime(current);
                return ((UserTagMapper)this.mapper).insert(element);
            }
        };
        return Message.build((boolean)true);
    }
}

