/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.dto.ReplenishmentDTO;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.MixRecommendService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MixRecommendServiceImpl
extends BaseService
implements MixRecommendService {
    private final MixedRecommendPoolMapper mixedRecommendPoolMapper;
    private ForumPostMapper forumPostMapper;
    private LocationIntegrationService locationIntegrationService;
    private NewsService newsService;
    private ForumPostStatisticService forumPostStatisticService;
    private NewsSearchIntegrationService newsSearchIntegrationService;

    @Autowired
    public MixRecommendServiceImpl(MixedRecommendPoolMapper mixedRecommendPoolMapper, ForumPostMapper forumPostMapper, LocationIntegrationService locationIntegrationService, NewsService newsService, ForumPostStatisticService forumPostStatisticService, NewsSearchIntegrationService newsSearchIntegrationService) {
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.forumPostMapper = forumPostMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.newsService = newsService;
        this.forumPostStatisticService = forumPostStatisticService;
        this.newsSearchIntegrationService = newsSearchIntegrationService;
    }

    @Override
    public List<ReplenishmentDTO> listRecommend(Long userId, String areaCode, Byte type, Integer size) {
        List list;
        List newsVoList;
        List postList;
        ArrayList result = Lists.newArrayList();
        LocationDTO location = null;
        if (StringUtils.isNotEmpty((CharSequence)areaCode)) {
            location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        }
        if (CollectionUtils.isNotEmpty((Collection)(postList = this.mixedRecommendPoolMapper.selectByBrokePost(areaCode, size)))) {
            LocationDTO finalLocation = location;
            postList.forEach(e -> result.add(this.forumRoReplenishment((ForumPostVo)e, finalLocation)));
        }
        if (result.size() < size && CollectionUtils.isNotEmpty((Collection)(newsVoList = this.newsSearchIntegrationService.multipleGet((list = this.mixedRecommendPoolMapper.selectLocalNewsByAreaCode(areaCode, size - result.size())).toArray(new Long[0]))))) {
            LocationDTO finalLocation = location;
            newsVoList.forEach(e -> result.add(this.newsToReplenishment((NewsVO)e, finalLocation)));
        }
        return result;
    }

    @Override
    public ReplenishmentDTO getHotPostOrNews(Long userId, String areaCode, Byte type) {
        List newsVoList;
        if (null == type) {
            type = 3;
        }
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        MixedRecommendPool mixedRecommendPool = this.mixedRecommendPoolMapper.selectHotRecommend(areaCode, userId);
        this.logger.info("[getHotPostOrNews]\u5f97\u5230\u6743\u91cd\u6700\u9ad8\u7684\u5e16\u5b50\u6216\u8005\u65b0\u95fb\uff0c\u63a8\u8350\u5e93\u4e2d\u6743\u91cd\u6700\u9ad8:{}", (Object)JSONObject.toJSONString((Object)mixedRecommendPool));
        if (null == mixedRecommendPool) {
            return null;
        }
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        if ("1".equals(mixedRecommendPool.getOrigin())) {
            ForumPostVo postVo = this.forumPostMapper.selectByPrimaryKey(mixedRecommendPool.getId());
            if (postVo != null) {
                replenishmentDTO = this.forumRoReplenishment(postVo, location);
            }
        } else if (("2".equals(mixedRecommendPool.getOrigin()) || "3".equals(mixedRecommendPool.getOrigin())) && CollectionUtils.isNotEmpty((Collection)(newsVoList = this.newsSearchIntegrationService.multipleGet(new Long[]{mixedRecommendPool.getId()})))) {
            NewsVO newsVO = (NewsVO)newsVoList.get(0);
            replenishmentDTO = this.newsToReplenishment(newsVO, location);
        }
        this.logger.info("[getHotPostOrNews]\u5f97\u5230\u6743\u91cd\u6700\u9ad8\u7684\u5e16\u5b50\u6216\u8005\u65b0\u95fb,\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)replenishmentDTO));
        return replenishmentDTO;
    }

    private ReplenishmentDTO forumRoReplenishment(ForumPostVo forumPostVo, LocationDTO location) {
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        replenishmentDTO.setImgList(this.forumPostStatisticService.getCoverFromPost(forumPostVo.getCoverList(), forumPostVo.getPostImgList(), forumPostVo.getCoverSelect()).stream().map(PostImgVo::getImgUrl).collect(Collectors.toList()));
        replenishmentDTO.setId(forumPostVo.getId());
        this.forumPostStatisticService.judgeEnablePlaceholder(forumPostVo, location);
        this.logger.debug("\u62fc\u88c5\u5206\u4eab\u3001\u8f6e\u64ad\u5e16\u5b50:[{}],\u5730\u533a\u4fe1\u606f:[{}]", (Object)JSONObject.toJSONString((Object)forumPostVo), (Object)JSONObject.toJSONString((Object)location));
        replenishmentDTO.setTitle(ExtendFactory.getSharePostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
        replenishmentDTO.setOrigin("1");
        return replenishmentDTO;
    }

    private ReplenishmentDTO newsToReplenishment(NewsVO news, LocationDTO location) {
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        replenishmentDTO.setId(news.getId());
        if (news.getAreaDetail() != null) {
            replenishmentDTO.setOrigin("2");
        } else {
            replenishmentDTO.setOrigin("3");
        }
        this.newsService.judgeEnablePlaceholder((News)news, location);
        this.logger.debug("\u62fc\u88c5\u5206\u4eab\u3001\u8f6e\u64ad\u65b0\u95fb:[{}],\u5730\u533a\u4fe1\u606f:[{}]", (Object)JSONObject.toJSONString((Object)news), (Object)JSONObject.toJSONString((Object)location));
        replenishmentDTO.setTitle(news.getTitle());
        replenishmentDTO.setImgList(this.newsService.getCoverFromNews(news.getCoverList(), news.getImgUrl(), news.getVideoList(), news.getCoverSelect()).stream().map(PostImgVo::getImgUrl).collect(Collectors.toList()));
        return replenishmentDTO;
    }
}

