/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.AppVersionIntegrationService;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.UserRecommendSourceIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.UserRecommendEnum;
import com.bxm.localnews.mq.common.model.dto.UserRecommendDTO;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.impl.NewsReplyConver;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsReplyLikeMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.NewsTotalMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.domain.VideoLikeMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.NewsReplyDetailDTO;
import com.bxm.localnews.news.dto.NewsReplyMirrorDTO;
import com.bxm.localnews.news.dto.ReplyDTO;
import com.bxm.localnews.news.dto.ReplyNewsDTO;
import com.bxm.localnews.news.dto.ReplyPostDTO;
import com.bxm.localnews.news.dto.ReplyVideoDTO;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.UserReplyParam;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.service.SensitiveWordService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.ForumPostStatistic;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.NewsReplayLike;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.news.vo.UserReply;
import com.bxm.localnews.news.vo.Video;
import com.bxm.localnews.news.vo.VideoLike;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.CharUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class NewNewsReplyServiceImpl
extends BaseService
implements NewNewsReplyService {
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private NewsReplyLikeMapper newsReplyLikeMapper;
    @Resource
    private RedisListAdapter redisListAdapter;
    @Resource
    private UserReplyMapper userReplyMapper;
    @Resource
    private VideoMapper videoMapper;
    @Resource
    private NewsMapper newsMapper;
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private VideoLikeMapper videoLikeMapper;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private IUrlFactory iUrlFactory;
    @Autowired
    private VideoRecommendService videoRecommendService;
    @Autowired
    private NewsStatisticIntegrationService newsStatisticIntegrationService;
    @Autowired
    private NewsTotalMapper newsTotalMapper;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private BizLogIntegrationService bizLogIntegrationService;
    @Autowired
    private NewsSearchIntegrationService newsSearchIntegrationService;
    @Autowired
    private MessageIntegrationService messageIntegrationService;
    @Autowired
    private MissionIntegrationService missionIntegrationService;
    @Autowired
    private NewsReplyConver newsReplyConver;
    @Autowired
    private LocationIntegrationService locationIntegrationService;
    @Autowired
    private AppVersionIntegrationService appVersionIntegrationService;
    @Autowired
    private SensitiveWordService sensitiveWordService;
    @Autowired
    private UserRecommendSourceIntegrationService userRecommendSourceIntegrationService;

    @Override
    public PageWarper<NewsReplyDTO> queryReplyList(NewsReplyParam newsReplyParam) {
        PageWarper newsReplyDTOPageWarper = new PageWarper(this.newsReplyMapper.queryByPageSize(newsReplyParam));
        List list = newsReplyDTOPageWarper.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Long userId;
            List rootIds = list.stream().map(NewsReplyDTO::getId).collect(Collectors.toList());
            List allReplies = this.newsReplyMapper.selectSubReplyLists(rootIds, newsReplyParam.getNewsId());
            if (ReplyTypeEnum.POST_REPLY.getCode() == ((NewsReplyDTO)list.get(0)).getType().byteValue() && null != (userId = this.forumPostMapper.getUserIdByPostId(newsReplyParam.getNewsId()))) {
                list.forEach(e -> {
                    e.setUserIsAuthor(Boolean.valueOf(userId.equals(e.getUserId())));
                    e.setParentUserIsAuthor(Boolean.valueOf(userId.equals(e.getParentUserId())));
                });
                allReplies.forEach(e -> {
                    e.setUserIsAuthor(Boolean.valueOf(userId.equals(e.getUserId())));
                    e.setParentUserIsAuthor(Boolean.valueOf(userId.equals(e.getParentUserId())));
                });
            }
            List replyLikes = this.newsReplyMapper.selectReplyLike(newsReplyParam.getNewsId(), newsReplyParam.getUserId(), null);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                for (NewsReplyDTO vo : newsReplyDTOPageWarper.getList()) {
                    if (vo.getDeleteFlag() == 2) {
                        vo.setDeleteFlag((byte)1);
                        vo.setReplyContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664!");
                    }
                    vo.setIsLike(Integer.valueOf(this.checkIsLike(replyLikes, vo.getId())));
                    vo.setReplyTime(DateUtils.timeConvertString((Date)vo.getAddTime()));
                    List<NewsReplyMirrorDTO> replies = allReplies.stream().filter(e -> e.getRootId().equals(vo.getId())).sorted(Comparator.comparing(NewsReplyMirrorDTO::getAddTime)).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(replies)) continue;
                    replies.forEach(replay -> this.dealSubMirrorDTO((NewsReplyMirrorDTO)replay, newsReplyParam.getUserId(), replyLikes));
                    vo.setList(replies);
                }
            }
        }
        return newsReplyDTOPageWarper;
    }

    private void dealSubMirrorDTO(NewsReplyMirrorDTO replay, Long userId, List<Long> replyLikes) {
        replay.setIsLike(Integer.valueOf(this.checkIsLike(replyLikes, replay.getId())));
        if (replay.getLevel().equals(NewsConstant.REPLY_LEVEL_1)) {
            replay.setParentHeadImg(null);
            replay.setParentUserId(null);
            replay.setParentUserNickname(null);
        }
        replay.setReplyTime(DateUtils.timeConvertString((Date)replay.getAddTime()));
    }

    private int checkIsLike(List<Long> replyLikes, Long replyId) {
        return replyLikes.contains(replyId) ? 1 : 0;
    }

    private boolean isLike(Long userId, Long replyId) {
        NewsReplayLike newsReplayLike = this.newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        return null != newsReplayLike;
    }

    @Override
    public Json<ReplyDTO> doReply(NewsReplyAddParam newsReplyAddParam, BasicParam basicParam) {
        Long userId;
        this.logger.debug("[doReply]\u53d1\u8868\u8bc4\u8bba\uff0c\u53c2\u6570:[{}]", (Object)JSONObject.toJSONString((Object)newsReplyAddParam));
        if (PlatformEnum.APPLET.getCode() == basicParam.getPlatform() ? this.appVersionIntegrationService.hasSensitiveWord(newsReplyAddParam.getReplyContent()) : this.appVersionIntegrationService.needValidSensitive(basicParam) && this.sensitiveWordService.contains(newsReplyAddParam.getReplyContent())) {
            return ResultUtil.genFailedResult((String)"\u60a8\u53d1\u8868\u7684\u8bc4\u8bba\u4e2d\u6709\u654f\u611f\u5185\u5bb9\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u53d1");
        }
        NewsReply newsReply = this.newsReplyConver.convert(newsReplyAddParam);
        this.newsReplyMapper.insertSelective(newsReply);
        if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType().byteValue() && null != (userId = this.forumPostMapper.getUserIdByPostId(newsReply.getNewsId()))) {
            newsReply.setUserIsAuthor(Boolean.valueOf(userId.equals(newsReply.getUserId())));
            newsReply.setParentUserIsAuthor(Boolean.valueOf(userId.equals(newsReply.getParentUserId())));
        }
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
        this.logger.debug("\u7528\u6237userId=[{}]\u53d1\u8868\u8bc4\u8bba,userReply\u53c2\u6570:[{}]", (Object)userReply.getUserId(), (Object)JSONObject.toJSONString((Object)userReply));
        this.userReplyMapper.insertSelective(userReply);
        newsReply.setReplyTime(DateUtils.timeConvertString((Date)newsReply.getAddTime()));
        NewsReply param = new NewsReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)param);
        this.updateComment(newsReply);
        NewNewsReplyService newNewsReplyService = (NewNewsReplyService)SpringContextHolder.getBean(this.getClass());
        newNewsReplyService.processWhenReply(param, newsReplyAddParam, basicParam.getPlatform(), newsReplyAddParam.getAreaCode());
        if (newsReply.getLevel().equals(NewsConstant.REPLY_LEVEL_1) && basicParam.getPlatform() != PlatformEnum.APPLET.getCode()) {
            newsReply.setParentUserId(null);
            newsReply.setParentUserNickname(null);
        }
        ReplyDTO result = new ReplyDTO();
        BeanUtils.copyProperties((Object)newsReply, (Object)result);
        if (ReplyTypeEnum.VIDEO_REPLY.getCode() != newsReply.getType().byteValue() && CharUtil.isCharSatisfied((String)newsReply.getReplyContent(), (int)3)) {
            NewsCompleTaskDTO taskDTO = this.missionIntegrationService.compleTask(newsReply.getUserId(), "TASK_COMMENT_NEWS", newsReply.getId().toString(), "\u8bc4\u8bba\u5956\u52b1");
            this.logger.info("user_id ={}\u5b8c\u6210\u8bc4\u8bba\u4efb\u52a1,\u5956\u52b1{}\u591a\u7ea2\u82b1;", (Object)newsReply.getUserId(), (Object)taskDTO.getGoldNum());
            result.setGoldNum(Long.valueOf(Objects.isNull(taskDTO.getGoldNum()) ? 0L : taskDTO.getGoldNum()));
        }
        return Json.build((Object)result);
    }

    @Override
    @Async
    public void processWhenReply(NewsReply newsReply, NewsReplyAddParam newsReplyAddParam, Integer platform, String areaCode) {
        ForumPostVo forumPostVo;
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        if (Objects.nonNull(newsReply.getRootId()) && newsReply.getRootId() != 0L) {
            NewsReply rootReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = Objects.isNull(interactiveCount) || interactiveCount == 0 ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            this.newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            UserReply userRootReply = new UserReply();
            BeanUtils.copyProperties((Object)rootReply, (Object)userRootReply);
            this.userReplyMapper.updateinteractiveCountById(userRootReply);
        }
        if (Objects.nonNull(newsReplyAddParam.getParentUserId()) && !newsReplyAddParam.getParentUserId().equals(newsReply.getUserId())) {
            this.logger.debug("\u5c01\u88c5\u7684\u6d88\u606f\u683c\u5f0f\u4e3a\uff1a[{}]", (Object)JSON.toJSONString((Object)newsReply));
            if (newsReply.getType().byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode() || newsReply.getType().byteValue() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                NewsService newsService = (NewsService)SpringContextHolder.getBean(NewsService.class);
                News news = (News)this.newsSearchIntegrationService.multipleGet(new Long[]{newsReply.getNewsId()}).get(0);
                newsService.judgeEnablePlaceholder(news, location);
                newsService.exchangeDetailNews(news);
                this.messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.NEWS_REPLY, null, news);
            } else if (newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
                forumPostVo = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
                ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).judgeEnablePlaceholder(forumPostVo, location);
                ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).exchangeDetailPost(forumPostVo);
                this.messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY, forumPostVo, null);
            }
        }
        if (null == newsReplyAddParam.getParentUserId() && newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
            forumPostVo = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).judgeEnablePlaceholder(forumPostVo, location);
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).exchangeDetailPost(forumPostVo);
            this.messageIntegrationService.pushPostReplyMessage(newsReply, forumPostVo);
        }
        if (StringUtils.isNotBlank((CharSequence)newsReplyAddParam.getAreaCode())) {
            this.bizLogIntegrationService.replySuccessed(newsReplyAddParam.getUserId(), newsReplyAddParam.getNewsId(), new Integer(newsReplyAddParam.getType().byteValue()), newsReplyAddParam.getAreaCode(), platform);
        }
        UserRecommendDTO userRecommendDTO = new UserRecommendDTO();
        userRecommendDTO.setUserId(newsReplyAddParam.getUserId());
        userRecommendDTO.setRecommendType(UserRecommendEnum.USER_BEHAVIOR.getTag());
        userRecommendDTO.setLastCommentTime(new Date());
        this.userRecommendSourceIntegrationService.pushUserRecommendInfo(userRecommendDTO);
    }

    @Override
    public void updateComment(NewsReply newsReply) {
        int count = this.newsReplyMapper.selectCountByNewsId(newsReply.getNewsId());
        if (ReplyTypeEnum.NEWS_REPLY.getCode() == newsReply.getType().byteValue()) {
            this.newsTotalMapper.updateNewsComments(newsReply.getNewsId(), Integer.valueOf(count));
            this.newsStatisticIntegrationService.pushCommentData(newsReply.getUserId(), newsReply.getNewsId());
        } else if (ReplyTypeEnum.VIDEO_REPLY.getCode() == newsReply.getType().byteValue()) {
            Video video = new Video();
            video.setId(newsReply.getNewsId());
            video.setCommentCount(Long.valueOf(count));
            this.videoMapper.updateByPrimaryKeySelective(video);
        } else if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType().byteValue()) {
            ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments((Long)newsReply.getNewsId(), (Integer)count);
            List replyList = this.newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(newsReply.getNewsId());
            if (CollectionUtils.isNotEmpty((Collection)replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString((Object)replyList));
            }
            this.forumPostMapper.updateReplyInfoAndCommentByPostId(forumPostStatistic);
        }
    }

    @Override
    public PageWarper<MyReplysVO> selectMyReplys(UserReplyParam newsReplyParam) {
        PageWarper myReplysVOPageWarper = new PageWarper(this.userReplyMapper.selectMyReplys(newsReplyParam));
        List myReplysVOList = myReplysVOPageWarper.getList();
        Long[] newsIds = (Long[])myReplysVOList.stream().filter(e -> e.getType().byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode()).mapToLong(MyReplysVO::getNewsId).boxed().toArray(Long[]::new);
        List newsList = this.newsSearchIntegrationService.multipleGet(newsIds);
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(newsReplyParam.getAreaCode());
        for (MyReplysVO myReplysVO : myReplysVOList) {
            ForumPostVo forumPostVo;
            Date addTime = myReplysVO.getAddTime();
            String replyTime = DateUtils.timeConvertString((Date)addTime);
            myReplysVO.setReplyTime(replyTime);
            Byte type = myReplysVO.getType();
            if (type.byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode()) {
                Optional<NewsVO> newsVoOptional = newsList.stream().filter(e -> e.getId().equals(myReplysVO.getNewsId())).findFirst();
                if (!newsVoOptional.isPresent()) continue;
                NewsVO news = newsVoOptional.get();
                NewsService newsService = (NewsService)SpringContextHolder.getBean(NewsService.class);
                newsService.judgeEnablePlaceholder((News)news, location);
                newsService.exchangeDetailNews((News)news);
                NewsCollect newsCollect = this.newsCollectMapper.selectUserCollect(news.getId(), newsReplyParam.getUserId(), Byte.valueOf((byte)1));
                ReplyNewsDTO replyNewsDTO = this.getNewsDto((News)news, newsReplyParam.getUserId());
                if (null != newsCollect) {
                    replyNewsDTO.setCollect(Integer.valueOf(1));
                } else {
                    replyNewsDTO.setCollect(Integer.valueOf(0));
                }
                myReplysVO.setReplyNewsDto(replyNewsDTO);
                myReplysVO.setTitle(news.getTitle());
                myReplysVO.setNewsImgUrl(news.getImgUrl());
                continue;
            }
            if (type.byteValue() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                Video video = this.videoMapper.selectByPrimaryKey(myReplysVO.getNewsId());
                if (null == video) continue;
                ReplyVideoDTO replyVideoDTO = this.getVideoDto(video, newsReplyParam.getUserId());
                replyVideoDTO.setVideoImg("[\"" + video.getVideoImg() + "\"]");
                myReplysVO.setReplyVideoDto(replyVideoDTO);
                myReplysVO.setTitle(video.getTitle());
                myReplysVO.setNewsImgUrl("[\"" + video.getVideoImg() + "\"]");
                continue;
            }
            if (type.byteValue() != ReplyTypeEnum.POST_REPLY.getCode() || null == (forumPostVo = this.forumPostMapper.selectByPrimaryKey(myReplysVO.getNewsId()))) continue;
            ForumPostStatisticService forumPostStatisticService = (ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class);
            forumPostStatisticService.judgeEnablePlaceholder(forumPostVo, location);
            forumPostStatisticService.exchangeDetailPost(forumPostVo);
            ReplyPostDTO replyPostDTO = this.getForumPostReplyDto(forumPostVo);
            myReplysVO.setReplyPostDto(replyPostDTO);
            myReplysVO.setTitle(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
        }
        return myReplysVOPageWarper;
    }

    @Override
    public NewsReplyDTO delMyReply(Long replyId, Long userId, Long newsId, Byte isUserDelete) {
        NewsReply newsReply = null;
        if (null != newsId && 0L != newsId) {
            newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId);
        }
        if (Objects.isNull(newsReply)) {
            newsReply = this.newsReplyMapper.selectByPrimaryKey(replyId);
        }
        newsReply.setIsUserDelete(isUserDelete);
        this.replyRelationship(newsReply);
        NewsReplyDTO newsReplyDTO = new NewsReplyDTO();
        BeanUtils.copyProperties((Object)newsReply, (Object)newsReplyDTO);
        newsReplyDTO.setDeleteFlag((byte)1);
        newsReplyDTO.setReplyTime(DateUtils.timeConvertString((Date)newsReplyDTO.getAddTime()));
        newsReplyDTO.setReplyContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664\uff01");
        newsReplyDTO.setIsLike(Integer.valueOf(this.isLike(userId, replyId) ? 1 : 0));
        if (newsReply.getRootId() == 0L) {
            List replyMirrorDTOS = this.newsReplyMapper.selectSubReplyList(replyId, newsReply.getNewsId());
            List replyLike = this.newsReplyMapper.selectReplyLike(newsReply.getNewsId(), userId, replyId);
            replyMirrorDTOS.forEach(e -> this.dealSubMirrorDTO((NewsReplyMirrorDTO)e, userId, replyLike));
            newsReplyDTO.setList(replyMirrorDTOS);
        }
        if (newsReply.getLevel() == 1) {
            newsReplyDTO.setParentUserId(null);
            newsReplyDTO.setParentUserNickname(null);
        }
        this.updateComment(newsReply);
        return newsReplyDTO;
    }

    private void replyRelationship(NewsReply newsReply) {
        this.userReplyMapper.deleteByPrimaryKey(newsReply.getId(), newsReply.getUserId(), newsReply.getIsUserDelete());
        if (newsReply.getRootId() == 0L) {
            List list = this.newsReplyMapper.selectSubReplyList(newsReply.getId(), newsReply.getNewsId());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                newsReply.setDeleteFlag((byte)2);
                this.newsReplyMapper.updateByPrimaryKeySelective(newsReply);
            } else {
                this.newsReplyMapper.deleteByPrimaryKey(newsReply.getId(), newsReply.getNewsId(), newsReply.getIsUserDelete());
            }
        } else {
            this.newsReplyMapper.deleteByPrimaryKey(newsReply.getId(), newsReply.getNewsId(), newsReply.getIsUserDelete());
            List list = this.newsReplyMapper.selectSubReplyList(newsReply.getRootId(), newsReply.getNewsId());
            NewsReply rootReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            if (rootReply.getDeleteFlag() != 0 && CollectionUtils.isNotEmpty((Collection)list)) {
                NewsReply record = new NewsReply();
                record.setId(newsReply.getRootId());
                record.setNewsId(newsReply.getNewsId());
                record.setDeleteFlag((byte)2);
                this.newsReplyMapper.updateByPrimaryKeySelective(record);
            }
        }
    }

    @Override
    @Async
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg) {
        List newsReplyList = this.newsReplyMapper.selectByUser(userId);
        for (NewsReply newsReply : newsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setUserNickname(nickname);
            newsReplyUp.setHeadImg(headImg);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
            this.newsReplyMapper.updateUserInfo(newsReplyUp);
            this.userReplyMapper.updateUserInfo(userReply);
        }
        List parentNewsReplyList = this.newsReplyMapper.selectByParentUser(userId);
        for (NewsReply newsReply : parentNewsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setParentUserNickname(nickname);
            newsReplyUp.setParentHeadImg(headImg);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
            this.newsReplyMapper.updateParentUserInfo(newsReplyUp);
            this.userReplyMapper.updateParentUserInfo(userReply);
        }
    }

    @Override
    public Message doProduceNewsReplyLike(NewsReplyLikeParam newsReplyLikeParam) {
        if (!this.checkLikeParam(newsReplyLikeParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        this.logger.info("\u70b9\u8d5e\u7684\u53c2\u6570\u662f:{}", (Object)JSONObject.toJSONString((Object)newsReplyLikeParam));
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");
        this.redisListAdapter.leftPush(keyGenerator, new Object[]{newsReplyLikeParam});
        this.callAsyncConsume();
        return Message.build((boolean)true);
    }

    private void callAsyncConsume() {
        NewNewsReplyService newsReplyService = (NewNewsReplyService)SpringContextHolder.getBean(NewNewsReplyService.class);
        newsReplyService.doNewsReplyLikeConsume();
    }

    @Override
    @Async
    public void doNewsReplyLikeConsume() {
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");
        NewsReplyLikeParam newsReplyLikeWarper = (NewsReplyLikeParam)this.redisListAdapter.rightPop(keyGenerator, NewsReplyLikeParam.class);
        if (null != newsReplyLikeWarper) {
            int count;
            this.logger.info("\u65b0\u95fb\u56de\u590d\u70b9\u8d5e\u5f00\u59cb\u6d88\u8d39...");
            int type = newsReplyLikeWarper.getType();
            NewsReply newsReply = null != newsReplyLikeWarper.getNewsId() && 0L != newsReplyLikeWarper.getNewsId() ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReplyLikeWarper.getReplyId(), newsReplyLikeWarper.getNewsId()) : this.newsReplyMapper.selectByPrimaryKey(newsReplyLikeWarper.getReplyId());
            if (newsReply != null && (count = this.saveReplyLiKeRecord(newsReply.getId(), newsReplyLikeWarper.getUserId(), type)) > 0 && type == 1) {
                this.logger.debug("\u8bc4\u8bba\u5b9e\u4f53:{}", JSONObject.toJSON((Object)newsReply));
                int likeCount = this.generatorLikeCount(type, newsReply.getLikeCount());
                this.logger.debug("\u70b9\u8d5e\u6570:{}", (Object)likeCount);
                NewsReply newsReplyUp = new NewsReply();
                newsReplyUp.setId(newsReplyLikeWarper.getReplyId());
                newsReplyUp.setLikeCount(Integer.valueOf(likeCount));
                newsReplyUp.setUserId(newsReply.getUserId());
                newsReplyUp.setNewsId(newsReply.getNewsId());
                if (newsReply.getRootId() == 0L) {
                    newsReplyUp.setInteractiveCount(Integer.valueOf(newsReply.getInteractiveCount() + 1));
                }
                this.newsReplyMapper.updateByPrimaryKeySelective(newsReplyUp);
                UserReply userReply = new UserReply();
                BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
                this.userReplyMapper.updateinteractiveCountById(userReply);
                if (!newsReplyLikeWarper.getUserId().equals(newsReply.getUserId()) && newsReplyLikeWarper.getType() == 1) {
                    LocationDTO location = this.locationIntegrationService.getLocationByGeocode(newsReplyLikeWarper.getAreaCode());
                    if (newsReply.getType() == 1 || newsReply.getType() == 2) {
                        NewsService newsService = (NewsService)SpringContextHolder.getBean(NewsService.class);
                        News news = (News)this.newsSearchIntegrationService.multipleGet(new Long[]{newsReply.getNewsId()}).get(0);
                        newsService.judgeEnablePlaceholder(news, location);
                        newsService.exchangeDetailNews(news);
                        this.messageIntegrationService.pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.NEWS_LIKE, newsReply, null, news);
                    } else if (newsReply.getType() == 3) {
                        ForumPostVo postVo = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
                        ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).judgeEnablePlaceholder(postVo, location);
                        ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).exchangeDetailPost(postVo);
                        this.messageIntegrationService.pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.POST_LIKE, newsReply, postVo, null);
                    }
                }
                this.userIntegrationService.updateUserLikeNumByUserId(newsReply.getUserId());
            }
            this.doNewsReplyLikeConsume();
        }
    }

    @Override
    public NewsReplyDetailDTO getNewsReplyDetailDTO(Long replyId, Long userId, Long newsId, String areaCode) {
        NewsReply newsReply = null != newsId && 0L != newsId ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId) : this.newsReplyMapper.selectByPrimaryKey(replyId);
        if (Objects.isNull(newsReply) || Objects.isNull(newsReply.getRootId())) {
            return null;
        }
        if (newsReply.getRootId() != 0L) {
            newsReply = null != newsId && 0L != newsId ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsId) : this.newsReplyMapper.selectByPrimaryKey(newsReply.getRootId());
        }
        NewsReplyDetailDTO newsReplyDetailDTO = new NewsReplyDetailDTO();
        if (null != newsReply) {
            BeanUtils.copyProperties((Object)newsReply, (Object)newsReplyDetailDTO);
            if (this.isLike(userId, newsReplyDetailDTO.getId())) {
                newsReplyDetailDTO.setIsLike(Integer.valueOf(1));
            }
            newsReplyDetailDTO.setReplyTime(DateUtils.timeConvertString((Date)newsReplyDetailDTO.getAddTime()));
            this.addSuperiorObject(newsReply, userId, newsReplyDetailDTO, areaCode);
            List replies = this.newsReplyMapper.selectSubReplyList(newsReply.getId(), newsReply.getNewsId());
            if (CollectionUtils.isNotEmpty((Collection)replies)) {
                replies.forEach(replay -> {
                    List replyLike = this.newsReplyMapper.selectReplyLike(replay.getNewsId(), userId, replyId);
                    this.dealSubMirrorDTO((NewsReplyMirrorDTO)replay, userId, replyLike);
                });
            }
            newsReplyDetailDTO.setList(replies);
        }
        return newsReplyDetailDTO;
    }

    private NewsReplyDetailDTO addSuperiorObject(NewsReply newsReply, Long userId, NewsReplyDetailDTO newsReplyDetailDTO, String areaCode) {
        Byte type = newsReply.getType();
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        if (type.byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode()) {
            News news = (News)this.newsSearchIntegrationService.multipleGet(new Long[]{newsReply.getNewsId()}).get(0);
            if (null != news) {
                ((NewsService)SpringContextHolder.getBean(NewsService.class)).judgeEnablePlaceholder(news, location);
                ReplyNewsDTO replyNewsDTO = this.getNewsDto(news, userId);
                newsReplyDetailDTO.setReplyNewsDto(replyNewsDTO);
                newsReplyDetailDTO.setTitle(news.getTitle());
            }
        } else if (type.byteValue() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
            Video video = this.videoMapper.selectByPrimaryKey(newsReply.getNewsId());
            if (null != video) {
                ReplyVideoDTO replyVideoDTO = this.getVideoDto(video, userId);
                newsReplyDetailDTO.setReplyVideoDto(replyVideoDTO);
                newsReplyDetailDTO.setTitle(video.getTitle());
            }
        } else if (type.byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
            ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).judgeEnablePlaceholder(forumPostVo, location);
            if (null != forumPostVo) {
                ReplyPostDTO replyPostDTO = this.getForumPostReplyDto(forumPostVo);
                newsReplyDetailDTO.setReplyPostDto(replyPostDTO);
                newsReplyDetailDTO.setTitle(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
        }
        return newsReplyDetailDTO;
    }

    private ReplyPostDTO getForumPostReplyDto(ForumPostVo forumPostVo) {
        ReplyPostDTO replyPostDTO = new ReplyPostDTO();
        replyPostDTO.setId(forumPostVo.getId());
        replyPostDTO.setStatus(Byte.valueOf((byte)forumPostVo.getStatus().intValue()));
        replyPostDTO.setTitle(forumPostVo.getTitle());
        replyPostDTO.setPostImgList(forumPostVo.getPostImgList());
        return replyPostDTO;
    }

    private ReplyNewsDTO getNewsDto(News news, Long userId) {
        ReplyNewsDTO replyNewsDTO = new ReplyNewsDTO();
        replyNewsDTO.setId(news.getId());
        replyNewsDTO.setImgUrl(news.getImgUrl());
        replyNewsDTO.setLinkUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.DETAIL, news.getId(), userId));
        replyNewsDTO.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.SHARE, news.getId(), userId));
        replyNewsDTO.setComments(news.getComments());
        replyNewsDTO.setStatus(news.getStatus());
        return replyNewsDTO;
    }

    private ReplyVideoDTO getVideoDto(Video video, Long userId) {
        ReplyVideoDTO replyVideoDTO = new ReplyVideoDTO();
        replyVideoDTO.setAuthorImg(video.getAuthorImg());
        replyVideoDTO.setAuthor(video.getAuthorName());
        replyVideoDTO.setId(video.getId());
        VideoLike videoLike = this.videoLikeMapper.selectByModel(new VideoLike(video.getId(), userId));
        if (null != videoLike) {
            replyVideoDTO.setPraise(Boolean.valueOf(true));
        } else {
            replyVideoDTO.setPraise(Boolean.valueOf(false));
        }
        replyVideoDTO.setLikeCount(Integer.valueOf(Math.toIntExact(video.getLikeCount())));
        replyVideoDTO.setVideoUrl(this.videoRecommendService.videoAddressConversion(video.getVideoUrl()));
        replyVideoDTO.setVideoImg(video.getVideoImg());
        replyVideoDTO.setCommentCount(Integer.valueOf(Math.toIntExact(video.getCommentCount())));
        replyVideoDTO.setStatus(video.getStatus());
        return replyVideoDTO;
    }

    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                --likeCount;
            }
        } else {
            ++likeCount;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        NewsReplayLike newsReplayLike = this.newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        if (type == 1) {
            if (null == newsReplayLike) {
                NewsReplayLike newsReplayLikeNew = new NewsReplayLike();
                newsReplayLikeNew.setAddTime(new Date());
                newsReplayLikeNew.setId(this.nextSequence());
                newsReplayLikeNew.setReplyId(replyId);
                newsReplayLikeNew.setUserId(userId);
                count = this.newsReplyLikeMapper.insert(newsReplayLikeNew);
            }
        } else if (null != newsReplayLike) {
            count = this.newsReplyLikeMapper.deleteByPrimaryKey(newsReplayLike.getId());
        }
        return count;
    }

    private boolean checkLikeParam(NewsReplyLikeParam newsReplyLikeParam) {
        return null != newsReplyLikeParam.getReplyId() && null != newsReplyLikeParam.getUserId();
    }

    @Override
    public Boolean doDealHistoryReply() {
        this.newsReplyMapper.deleteNewsReply();
        List userList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(1000));
        for (int i = 0; i < 10; ++i) {
            String tableName = "t_news_reply_" + i;
            List replyList = this.newsReplyMapper.selectByUserIdIsZero(tableName);
            this.dealReplyList(replyList, userList);
        }
        return Boolean.TRUE;
    }

    private void dealReplyList(List<NewsReply> replyList, List<VirtualUserInfo> userList) {
        replyList.forEach(e -> {
            int random = ThreadLocalRandom.current().nextInt(0, userList.size());
            VirtualUserInfo userInfo = (VirtualUserInfo)userList.get(random);
            e.setUserId(userInfo.getId());
            e.setHeadImg(userInfo.getHeadImg());
            e.setUserNickname(userInfo.getNickname());
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)e, (Object)userReply);
            this.newsReplyMapper.updateReplyUserInfo(e);
            this.userReplyMapper.insertSelective(userReply);
        });
    }
}

