/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.dto.MyCollectDTO;
import com.bxm.localnews.news.dto.NewsCollectDTO;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.NewsCollectPageParam;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.ForumPostStatistic;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.PageWarper;
import com.github.pagehelper.Page;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class NewsCollectServiceImpl
extends BaseService
implements NewsCollectService {
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private NewsStatisticIntegrationService newsStatisticIntegrationService;
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private NewsSearchIntegrationService newsSearchIntegrationService;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private ForumProperties forumProperties;

    @Override
    public List<NewsCollectDTO> queryList(Long userId, MPage page) {
        List resultList = this.newsCollectMapper.queryList(userId, Byte.valueOf((byte)1), page);
        return resultList.stream().filter(Objects::nonNull).filter(e -> StringUtils.isNotBlank((CharSequence)e.getTitle())).collect(Collectors.toList());
    }

    @Override
    public Json collectNews(NewsCollect newsCollect, Integer platform, String areaCode) {
        NewsCollect collect = this.newsCollectMapper.selectUserCollect(newsCollect.getNewsId(), newsCollect.getUserId(), newsCollect.getType());
        if (!ObjectUtils.isEmpty((Object)collect)) {
            this.newsCollectMapper.deleteByModel(collect);
            if (newsCollect.getType() == 1) {
                this.newsStatisticIntegrationService.pushCollectData(newsCollect.getUserId(), newsCollect.getNewsId(), Byte.valueOf((byte)0));
            } else if (newsCollect.getType() == 3) {
                ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
                forumPostStatistic.setCollectCount(Integer.valueOf(-1));
                forumPostStatistic.setId(newsCollect.getNewsId());
                this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
            }
        } else {
            newsCollect.setId(this.nextSequence());
            this.newsCollectMapper.insertSelective(newsCollect);
            if (newsCollect.getType() == 1) {
                this.newsStatisticIntegrationService.pushCollectData(newsCollect.getUserId(), newsCollect.getNewsId(), Byte.valueOf((byte)1));
            } else if (newsCollect.getType() == 3) {
                ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
                forumPostStatistic.setCollectCount(Integer.valueOf(1));
                forumPostStatistic.setId(newsCollect.getNewsId());
                this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
            }
            if (Objects.nonNull(platform)) {
                this.bizLogIntegrationService.forumCollectSuccessed(newsCollect.getUserId(), newsCollect.getNewsId(), areaCode, Integer.valueOf(newsCollect.getType().byteValue()), platform);
            }
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public PageWarper<MyCollectDTO> listCollect(NewsCollectPageParam newsCollectPageParam) {
        PageWarper newsCollectPageWarper = new PageWarper(this.newsCollectMapper.queryByPageSize(newsCollectPageParam));
        List newsCollectList = newsCollectPageWarper.getList();
        List postIdList = newsCollectList.stream().filter(mix -> mix.getType() == 3).map(NewsCollect::getNewsId).collect(Collectors.toList());
        List list = this.newsSearchIntegrationService.listRecommendedNews((Long[])newsCollectList.stream().filter(mix -> mix.getType() == 1).map(NewsCollect::getNewsId).toArray(Long[]::new));
        List forumPostVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty(postIdList)) {
            forumPostVoList = this.forumPostMapper.listPostByIdsInHome(postIdList);
        }
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(newsCollectPageParam.getAreaCode());
        Map myNewsCollectDtoList = list.stream().map(e -> this.newsToMyCollectDTO((News)e, location)).collect(Collectors.toMap(MyCollectDTO::getId, Function.identity()));
        Map myForumCollectDtoList = forumPostVoList.stream().map(e -> this.forumToMyCollectDTO((ForumPostVo)e, location)).collect(Collectors.toMap(MyCollectDTO::getId, Function.identity()));
        ArrayList<MyCollectDTO> myCollectDtoList = new ArrayList<MyCollectDTO>();
        for (NewsCollect newsCollect : newsCollectList) {
            MyCollectDTO myCollectDtoOptional;
            if (newsCollect.getType() == 1) {
                myCollectDtoOptional = (MyCollectDTO)myNewsCollectDtoList.get(newsCollect.getNewsId());
                if (null == myCollectDtoOptional) continue;
                myCollectDtoOptional.setCollectTime(DateUtils.timeConvertString((Date)newsCollect.getAddTime()));
                myCollectDtoList.add(myCollectDtoOptional);
                continue;
            }
            if (newsCollect.getType() != 3 || null == (myCollectDtoOptional = (MyCollectDTO)myForumCollectDtoList.get(newsCollect.getNewsId()))) continue;
            myCollectDtoOptional.setCollectTime(DateUtils.timeConvertString((Date)newsCollect.getAddTime()));
            myCollectDtoList.add(myCollectDtoOptional);
        }
        Page page = new Page(newsCollectPageWarper.getPageNum(), newsCollectPageWarper.getPageSize());
        page.setTotal(newsCollectPageWarper.getTotal());
        page.addAll(myCollectDtoList);
        return new PageWarper((List)page);
    }

    private MyCollectDTO forumToMyCollectDTO(ForumPostVo forumPostVo, LocationDTO location) {
        ForumPostStatisticService forumPostStatisticService = (ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class);
        forumPostStatisticService.judgeEnablePlaceholder(forumPostVo, location);
        MyCollectDTO myCollectDTO = new MyCollectDTO();
        myCollectDTO.setId(forumPostVo.getId());
        if (1 == forumPostVo.getPostType()) {
            myCollectDTO.setImgList(forumPostStatisticService.getDetailFromPost(forumPostVo.getPostImgList()).stream().map(PostImgVo::getImgUrl).collect(Collectors.toList()));
            myCollectDTO.setTitle(ExtendFactory.getTitle((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            myCollectDTO.setType(Byte.valueOf((byte)3));
        } else if (2 == forumPostVo.getPostType()) {
            myCollectDTO.setImgList(Collections.singletonList(this.forumProperties.getNoteShareImg()));
            myCollectDTO.setTitle(forumPostVo.getTextField());
            myCollectDTO.setType(Byte.valueOf((byte)4));
        }
        return myCollectDTO;
    }

    private MyCollectDTO newsToMyCollectDTO(News news, LocationDTO location) {
        NewsService newsService = (NewsService)SpringContextHolder.getBean(NewsService.class);
        newsService.judgeEnablePlaceholder(news, location);
        MyCollectDTO myCollectDTO = new MyCollectDTO();
        myCollectDTO.setImgList(((NewsService)SpringContextHolder.getBean(NewsService.class)).getDetailFromNews(news.getImgUrl(), news.getVideoList()).stream().map(PostImgVo::getImgUrl).collect(Collectors.toList()));
        myCollectDTO.setId(news.getId());
        myCollectDTO.setTitle(news.getTitle());
        myCollectDTO.setType(Byte.valueOf((byte)1));
        return myCollectDTO;
    }
}

