/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.NewsShieldMapper;
import com.bxm.localnews.news.enums.NewsShieldEnum;
import com.bxm.localnews.news.param.NewsShieldParam;
import com.bxm.localnews.news.service.NewsShieldService;
import com.bxm.localnews.news.vo.NewsShield;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsNewsShieldServiceImpl
extends BaseService
implements NewsShieldService {
    private static final Logger log = LoggerFactory.getLogger(NewsNewsShieldServiceImpl.class);
    private final NewsShieldMapper newsShieldMapper;
    private final HttpClientService httpClientService;
    private final ForumProperties forumProperties;
    private final RedisSetAdapter redisSetAdapter;

    @Override
    public void save(NewsShieldParam newsShieldParam) {
        NewsShield newsShield = new NewsShield();
        BeanUtils.copyProperties((Object)newsShieldParam, (Object)newsShield);
        newsShield.setId(this.nextSequence());
        newsShield.setAddTime(new Date());
        this.newsShieldMapper.insert(newsShield);
        if (NewsShieldEnum.SHIELD_NEWS.getCode() == newsShieldParam.getShieldType().byteValue()) {
            KeyGenerator keyGenerator = RedisConfig.NEWS_SHIELD.copy().appendKey((Object)"detail").appendKey((Object)newsShieldParam.getUserId());
            this.redisSetAdapter.add(keyGenerator, new Object[]{newsShieldParam.getShieldNewsId()});
        } else if (NewsShieldEnum.SHIELD_USER.getCode() == newsShieldParam.getShieldType().byteValue()) {
            KeyGenerator keyGenerator = RedisConfig.NEWS_SHIELD.copy().appendKey((Object)"user").appendKey((Object)newsShieldParam.getUserId());
            this.redisSetAdapter.add(keyGenerator, new Object[]{newsShieldParam.getShieldUserId()});
        }
        if (NewsShieldEnum.SHIELD_ADVERT.getCode() == newsShieldParam.getShieldType().byteValue() || NewsShieldEnum.SHIELD_ILLEGAL.getCode() == newsShieldParam.getShieldType().byteValue()) {
            StringBuilder content = new StringBuilder();
            content.append("------").append(DateFormatUtils.format((Date)new Date(), (String)"MM\u6708dd\u65e5HH\u65f6mm\u5206")).append("------\n");
            content.append("\u6635\u79f0\uff1a[ID=").append(newsShieldParam.getUserId()).append("]\n");
            content.append("\u5185\u5bb9\u6807\u9898\uff1a[ID=").append(newsShieldParam.getShieldNewsId()).append("]\n");
            if (3 == newsShieldParam.getShieldType()) {
                content.append("\u6295\u8bc9\u7c7b\u578b\uff1a[\u6295\u8bc9\u5e7f\u544a]");
            } else {
                content.append("\u6295\u8bc9\u7c7b\u578b\uff1a[\u5185\u5bb9\u6d89\u5acc\u8fdd\u6cd5]");
            }
            JSONObject text = new JSONObject();
            text.put("content", (Object)content);
            JSONObject msg = new JSONObject();
            msg.put("msgtype", (Object)"text");
            msg.put("text", (Object)text);
            String response = this.httpClientService.doPostJson(this.forumProperties.getCalculatePostWebhook(), msg.toJSONString());
            log.debug("dingding response:{}", (Object)response);
        }
    }

    @Autowired
    public NewsNewsShieldServiceImpl(NewsShieldMapper newsShieldMapper, HttpClientService httpClientService, ForumProperties forumProperties, RedisSetAdapter redisSetAdapter) {
        this.newsShieldMapper = newsShieldMapper;
        this.httpClientService = httpClientService;
        this.forumProperties = forumProperties;
        this.redisSetAdapter = redisSetAdapter;
    }
}

