/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.facade.NewsSyncFeignService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsMonitorMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.param.OptimizationNoticeParam;
import com.bxm.localnews.news.param.PublishNewsBuildParam;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.task.NewsMonitorTask;
import com.bxm.localnews.news.task.OptimizationNoticeTask;
import com.bxm.localnews.news.task.PublishNewsTask;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MonitorTaskBuildParam;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.builder.CronTaskBuilder;
import com.bxm.newidea.component.schedule.builder.OnceTaskBuilder;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsQuartzServiceImpl
extends BaseService
implements NewsQuartzService {
    @Autowired
    private NewsMonitorMapper newsMonitorMapper;
    @Autowired
    private NewsMapper newsMapper;
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    private UserKindMapper userKindMapper;
    @Autowired
    private NewsSyncFeignService newsSyncFeignService;
    @Autowired
    private NewsReplyMapper newsReplyMapper;
    @Autowired
    private UserReplyMapper userReplyMapper;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private MessageIntegrationService messageIntegrationService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private ForumPostStatisticService forumPostStatisticService;
    @Autowired
    private NewsSearchIntegrationService newsSearchIntegrationService;
    @Autowired
    private NewsService newsService;
    @Resource
    private ScheduleService scheduleService;
    @Resource
    private NewsMonitorTask newsMonitorTask;
    @Resource
    private PublishNewsTask publishNewsTask;
    @Resource
    private OptimizationNoticeTask optimizationNoticeTask;

    @Override
    public Integer countNews(MonitorTaskBuildParam monitorTaskBuildParam) {
        return this.newsMonitorMapper.count(monitorTaskBuildParam);
    }

    @Override
    public void syncMykindToData() {
        long limit = 5000L;
        List userIds = this.redisSetAdapter.pop(RedisConfig.NEWS_USER_KIND_SET, Long.valueOf(limit), Long.class);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return;
        }
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>(){};
        userIds.forEach(arg_0 -> this.lambda$syncMykindToData$0((TypeReference)typeReference, arg_0));
        if (this.redisSetAdapter.size(RedisConfig.NEWS_USER_KIND_SET) > 0L) {
            this.syncMykindToData();
        }
    }

    @Override
    public void publishNews(Long newsId) {
        News newsParam = new News();
        newsParam.setId(newsId);
        newsParam.setStatus(Byte.valueOf((byte)1));
        this.newsSyncFeignService.updateStatus(newsParam);
    }

    @Override
    public void expireHotNews() {
        List list = this.newsMapper.getExpireHotList();
        for (News news : list) {
            News newsParam = new News();
            newsParam.setId(news.getId());
            newsParam.setHot(Byte.valueOf((byte)1));
            this.newsSyncFeignService.updateStatus(newsParam);
        }
    }

    @Override
    public void updateMonitorStatus(Long id, int status, String message) {
        this.newsMonitorMapper.updateMonitorStatus(id, status, message);
    }

    @Override
    public void scanningNewsReply() {
        List newsReplyList = this.newsReplyMapper.selectByTime();
        for (NewsReply newsReply : newsReplyList) {
            this.newsReplyMapper.updateStatus(newsReply.getNewsId(), newsReply.getId());
            this.userReplyMapper.updateStatus(newsReply.getUserId(), newsReply.getId());
            this.pushAndStatic(newsReply);
            this.logger.info("\u8bc4\u8bba\u6570\u636e:[{}],\u63a8\u9001\u65f6\u95f4:[{}]", (Object)JSONObject.toJSONString((Object)newsReply), (Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        Collection<List<NewsReply>> values = newsReplyList.stream().collect(Collectors.groupingBy(NewsReply::getNewsId)).values();
        values.stream().forEach(e -> {
            Optional first = e.stream().findFirst();
            if (first.isPresent()) {
                ((NewNewsReplyService)SpringContextHolder.getBean(NewNewsReplyService.class)).updateComment((NewsReply)first.get());
            }
        });
    }

    @Override
    public void addMonitor(MonitorTaskBuildParam param) {
        this.scheduleService.push((ScheduleTask)CronTaskBuilder.builder((String)NewsMonitorTask.generateTaskName(param.getIndexId()), (String)("0 0 " + param.getFireTime() + " * * ?"), (TaskCallback)this.newsMonitorTask).callbackParam((Object)param).build());
    }

    @Override
    public void removeMonitor(Long indexId) {
        this.scheduleService.remove(NewsMonitorTask.generateTaskName(indexId));
    }

    @Override
    public void addPublish(PublishNewsBuildParam param) {
        this.scheduleService.push((ScheduleTask)OnceTaskBuilder.builder((String)PublishNewsTask.generateTaskName(param.getNewsId()), (Date)param.getStartTime(), (TaskCallback)this.publishNewsTask).callbackParam((Object)param).build());
    }

    @Override
    public void addOptimizationNotice(OptimizationNoticeParam param) {
        this.scheduleService.push((ScheduleTask)OnceTaskBuilder.builder((String)OptimizationNoticeTask.generateTaskName(param.getId()), (Date)param.getStartTime(), (TaskCallback)this.optimizationNoticeTask).callbackParam((Object)param).build());
    }

    @Override
    public void removeOptimizationNotice(Long id) {
        this.scheduleService.remove(OptimizationNoticeTask.generateTaskName(id));
    }

    private void pushAndStatic(NewsReply newsReply) {
        ForumPostVo forumPostVo;
        if (newsReply.getParentId() != 0L && newsReply.getRootId() != 0L) {
            NewsReply rootReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = Objects.isNull(interactiveCount) || interactiveCount == 0 ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            this.newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            if (rootReply.getDeleteFlag() == 0) {
                boolean userAvailable;
                UserBean userBean = this.userIntegrationService.selectUserFromCache(newsReply.getParentUserId());
                boolean bl = userAvailable = Objects.nonNull(userBean) && Objects.nonNull(userBean.getState()) && userBean.getState() == 1;
                if (userAvailable) {
                    News news;
                    if (newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
                        ForumPostVo forumPostVo2 = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
                        if (null != forumPostVo2 && forumPostVo2.getStatus() != 4) {
                            try {
                                this.forumPostStatisticService.judgeEnablePlaceholder(forumPostVo2, null);
                                forumPostVo2.setPostImgList(this.forumPostStatisticService.getDetailFromPost(forumPostVo2.getPostImgList()));
                            }
                            catch (Exception e) {
                                this.logger.error("[\u8bc4\u8bba\u5b9a\u65f6\u626b\u63cf]\u626b\u63cf\u8bc4\u8bba\u8868\u7ec4\u88c5\u63a8\u9001\u6d88\u606f\u65f6\u62a5\u9519:[{}],\u6570\u636e:[{}]", (Object)e.getMessage(), (Object)JSONObject.toJSONString((Object)forumPostVo2));
                            }
                            this.messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY, forumPostVo2, null);
                        }
                    } else if (newsReply.getType().byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode() && null != (news = (News)this.newsSearchIntegrationService.multipleGet(new Long[]{newsReply.getNewsId()}).get(0))) {
                        this.newsService.judgeEnablePlaceholder(news, null);
                        this.newsService.exchangeDetailNews(news);
                        this.messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.NEWS_REPLY, null, news);
                    }
                }
            } else {
                rootReply.setDeleteFlag((byte)2);
                this.newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            }
        }
        if (newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode() && newsReply.getRootId() == 0L && Objects.nonNull(forumPostVo = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId())) && forumPostVo.getStatus() != 4) {
            this.forumPostStatisticService.exchangeDetailPost(forumPostVo);
            this.messageIntegrationService.pushPostReplyMessage(newsReply, forumPostVo);
        }
    }

    private /* synthetic */ void lambda$syncMykindToData$0(TypeReference typeReference, Long userId) {
        List newsKindList = (List)this.redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), typeReference);
        if (CollectionUtils.isNotEmpty((Collection)newsKindList)) {
            this.userKindMapper.deleteByUserId(userId);
            ArrayList userKindList = Lists.newArrayList();
            int i = 0;
            for (NewsKind newsKind : newsKindList) {
                UserKind userKind = new UserKind();
                userKind.setUserKindId(this.nextSequence());
                userKind.setUserId(userId);
                userKind.setKindId(newsKind.getId());
                userKind.setSortNo(Integer.valueOf(i));
                userKindList.add(userKind);
                ++i;
            }
            MybatisBatchBuilder.create(UserKindMapper.class, (Collection)userKindList).run(UserKindMapper::insertSelective);
        }
    }
}

