/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostShareMapper;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsShareMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.NewsShareEnum;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.NewsReadRewardService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.strategy.GoldenStrategyContext;
import com.bxm.localnews.news.vo.ForumPostShare;
import com.bxm.localnews.news.vo.ForumPostStatistic;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsShare;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.math.BigDecimal;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsReadRewardServiceImpl
extends BaseService
implements NewsReadRewardService {
    private UserIntegrationService userIntegrationService;
    private RedisStringAdapter redisStringAdapter;
    private NewsStatisticsMapper newsStatisticsMapper;
    private NewsCollectMapper newsCollectMapper;
    private NewsMapper newsMapper;
    private NewsShareMapper newsShareMapper;
    private GoldenStrategyContext goldenStrategyContext;
    private MissionIntegrationService missionIntegrationService;
    private NewsStatisticIntegrationService newsStatisticIntegrationService;
    private ForumPostMapper forumPostMapper;
    private ForumPostShareMapper forumPostShareMapper;
    private DistributedLock distributedLock;
    private LocationIntegrationService locationIntegrationService;

    @Autowired
    public NewsReadRewardServiceImpl(UserIntegrationService userIntegrationService, RedisStringAdapter redisStringAdapter, NewsStatisticsMapper newsStatisticsMapper, NewsCollectMapper newsCollectMapper, NewsMapper newsMapper, NewsShareMapper newsShareMapper, GoldenStrategyContext goldenStrategyContext, MissionIntegrationService missionIntegrationService, NewsStatisticIntegrationService newsStatisticIntegrationService, ForumPostMapper forumPostMapper, ForumPostShareMapper forumPostShareMapper, DistributedLock distributedLock, LocationIntegrationService locationIntegrationService) {
        this.userIntegrationService = userIntegrationService;
        this.redisStringAdapter = redisStringAdapter;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsCollectMapper = newsCollectMapper;
        this.newsMapper = newsMapper;
        this.newsShareMapper = newsShareMapper;
        this.goldenStrategyContext = goldenStrategyContext;
        this.missionIntegrationService = missionIntegrationService;
        this.newsStatisticIntegrationService = newsStatisticIntegrationService;
        this.forumPostMapper = forumPostMapper;
        this.forumPostShareMapper = forumPostShareMapper;
        this.distributedLock = distributedLock;
        this.locationIntegrationService = locationIntegrationService;
    }

    @Override
    public NewsCompleTaskDTO saveShareNews(Long newsId, Long userId, Byte type, String areaCode, int platform) {
        this.logger.info("\u7528\u6237\u5206\u4eab\u65b0\u95fb\uff0c\u53c2\u6570->newsId:{},userId:{},type:{},platform:{}", new Object[]{newsId, userId, type, platform});
        UserBean user = this.userIntegrationService.selectUserFromCache(userId);
        if (user == null || user.getState() != 1) {
            return new NewsCompleTaskDTO();
        }
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        if (NewsShareEnum.SIGN_SHARE.getCode() == type.byteValue()) {
            newsCompleTaskDTO = this.missionIntegrationService.signCompleTaskDTO(userId, "TASK_SIGN_SHARE", newsId.toString(), "");
        } else if (NewsShareEnum.SUPPLEMENT_SHARE.getCode() != type.byteValue()) {
            newsCompleTaskDTO = this.completeNewsShareTask(userId, newsId, areaCode);
        }
        NewsShare share = new NewsShare();
        share.setAddTime(new Date());
        share.setNewsId(newsId);
        share.setUserId(userId);
        share.setId(this.nextSequence());
        share.setReward(Integer.valueOf(Math.toIntExact(newsCompleTaskDTO.getGoldNum())));
        share.setType(type);
        this.newsShareMapper.insertSelective(share);
        this.newsStatisticIntegrationService.pushShareData(userId, newsId);
        return newsCompleTaskDTO;
    }

    private NewsCompleTaskDTO completeNewsShareTask(Long userId, Long newsId, String areaCode) {
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        KeyGenerator shareRecordKey = this.getShareRecordKey(userId, newsId);
        if (!this.redisStringAdapter.hasKey(shareRecordKey).booleanValue()) {
            News news = this.newsMapper.selectByPrimaryKey(newsId);
            NewsService newsService = (NewsService)SpringContextHolder.getBean(NewsService.class);
            LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
            newsService.judgeEnablePlaceholder(news, location);
            String content = "\u8f6c\u53d1\u3010" + ExtendFactory.getContent((String)news.getTitle(), (String)news.getContent()) + "\u3011";
            newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, "TASK_NEWS_SHARE", newsId.toString(), content);
            this.redisStringAdapter.set(shareRecordKey, (Object)"exist", (long)DateUtils.getCurSeconds());
        }
        return newsCompleTaskDTO;
    }

    private KeyGenerator getShareRecordKey(Long userId, Long newsId) {
        return RedisConfig.USER_SHARE_NEWS_RECORD.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)newsId.toString());
    }

    @Override
    public NewsCompleTaskDTO saveShareForums(Long postId, Long userId, Byte type, String areaCode) {
        UserBean user = this.userIntegrationService.selectUserFromCache(userId);
        if (user == null || user.getState() != 1) {
            return new NewsCompleTaskDTO();
        }
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        if (NewsShareEnum.SIGN_SHARE.getCode() == type.byteValue()) {
            newsCompleTaskDTO = this.missionIntegrationService.signCompleTaskDTO(userId, "TASK_SIGN_SHARE", postId.toString(), "");
        } else if (NewsShareEnum.SUPPLEMENT_SHARE.getCode() != type.byteValue()) {
            newsCompleTaskDTO = this.completePostShareTask(userId, postId, areaCode);
        }
        ForumPostShare forumPostShare = new ForumPostShare();
        forumPostShare.setAddTime(new Date());
        forumPostShare.setId(this.nextSequence());
        forumPostShare.setPostId(postId);
        forumPostShare.setReward(Integer.valueOf(Math.toIntExact(newsCompleTaskDTO.getGoldNum())));
        forumPostShare.setUserId(userId);
        forumPostShare.setType(type);
        this.forumPostShareMapper.insertSelective(forumPostShare);
        ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildShares((Long)postId, (Integer)1);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        return newsCompleTaskDTO;
    }

    private NewsCompleTaskDTO completePostShareTask(Long userId, Long postId, String areaCode) {
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        KeyGenerator shareRecordKey = this.getShareRecordKey(userId, postId);
        if (!this.redisStringAdapter.hasKey(shareRecordKey).booleanValue()) {
            ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(postId);
            LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
            ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).judgeEnablePlaceholder(forumPostVo, location);
            String content = "\u8f6c\u53d1\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011\u6210\u529f";
            newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, "TASK_NEWS_SHARE", postId.toString(), content);
            this.redisStringAdapter.set(shareRecordKey, (Object)"exist", (long)DateUtils.getCurSeconds());
        }
        return newsCompleTaskDTO;
    }

    @Override
    public Json<NewsGoldMeta> execGetGold(ExecGoldParam execGoldParam) {
        News news;
        if (null != execGoldParam.getUserId() && null != execGoldParam.getNewsId() && this.isNewsExsit(news = this.newsMapper.selectByPrimaryKey(execGoldParam.getNewsId()), execGoldParam.getViewTime())) {
            NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
            ExecGoldCalParam execGoldCalParam = new ExecGoldCalParam();
            BeanUtils.copyProperties((Object)execGoldParam, (Object)execGoldCalParam);
            execGoldCalParam.setNewsGoldMeta(newsGoldMeta);
            execGoldCalParam.setNews(news);
            this.goldenStrategyContext.chooseCalulator(execGoldCalParam);
            return ResultUtil.genSuccessResult((Object)execGoldCalParam.getNewsGoldMeta());
        }
        NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
        newsGoldMeta.setGoldNum(0);
        newsGoldMeta.setTaskName("\u9605\u8bfb\u65b0\u95fb");
        newsGoldMeta.setGoldType((byte)1);
        newsGoldMeta.setTotalGold(BigDecimal.ZERO);
        return ResultUtil.genSuccessResult((Object)newsGoldMeta);
    }

    private boolean isNewsExsit(News news, Integer viewTime) {
        return news != null && viewTime != null;
    }
}

