/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.NewsTotalMapper;
import com.bxm.localnews.news.domain.OldNewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.dto.OldNewsReplyDto;
import com.bxm.localnews.news.service.NewsReplyService;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.OldMyReplysVO;
import com.bxm.localnews.news.vo.OldNewsReply;
import com.bxm.localnews.news.vo.UserReply;
import com.bxm.newidea.component.service.BaseService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class NewsReplyServiceImpl
extends BaseService
implements NewsReplyService {
    @Resource
    private OldNewsReplyMapper oldNewsReplyMapper;
    @Autowired
    private UserReplyMapper userReplyMapper;
    @Autowired
    private NewsReplyMapper newsReplyMapper;
    @Autowired
    private NewsTotalMapper newsTotalMapper;

    @Override
    public List<OldNewsReplyDto> queryReplyList(Long newsId, MPage page) {
        List list = this.oldNewsReplyMapper.queryParentList(newsId, page);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OldNewsReplyDto vo : list) {
                List replies;
                if (vo.getDeleteFlag() == 1) {
                    vo.setReplyContent(null);
                }
                if (!CollectionUtils.isNotEmpty((Collection)(replies = this.oldNewsReplyMapper.selectReplyList(newsId, vo.getId())))) continue;
                replies.forEach(replay -> {
                    if (replay.getDeleteFlag() == 1) {
                        replay.setReplyContent(null);
                    }
                });
                vo.setList(replies);
            }
        }
        return list;
    }

    @Override
    public Json reply(OldNewsReply newsReply) {
        newsReply.setStatus(Byte.valueOf((byte)1));
        newsReply.setLikeCount(Integer.valueOf(0));
        newsReply.setRootId(Long.valueOf(0L));
        newsReply.setLevel(Byte.valueOf((byte)0));
        newsReply.setAddTime(new Date());
        newsReply.setInteractiveCount(Integer.valueOf(0));
        newsReply.setRootId(Long.valueOf(0L));
        newsReply.setLevel(Byte.valueOf((byte)0));
        newsReply.setType(Byte.valueOf((byte)1));
        Long id = this.nextSequence();
        newsReply.setId(id);
        this.oldNewsReplyMapper.insertSelective(newsReply);
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
        this.userReplyMapper.insertSelective(userReply);
        this.newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId(), Integer.valueOf(1));
        return ResultUtil.genSuccessResult();
    }

    @Override
    public List<OldMyReplysVO> selectMyReplys(Long userId, MPage page) {
        return this.oldNewsReplyMapper.selectMyReplys(userId, page);
    }

    @Override
    public Json delMyReply(Long replyId) {
        NewsReply newsReply = this.newsReplyMapper.selectByPrimaryKey(replyId);
        if (null != newsReply) {
            this.newsReplyMapper.deleteByPrimaryKey(replyId, newsReply.getNewsId(), Byte.valueOf((byte)1));
            this.userReplyMapper.deleteByPrimaryKey(replyId, newsReply.getUserId(), Byte.valueOf((byte)1));
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page) {
        return null;
    }
}

