/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.integration.AppVersionIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.convert.impl.ForumPostConvert;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.localnews.news.domain.NewsLikeMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.domain.NewsSearchWordMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.NewsLikeDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.enums.UrlCategoryEnum;
import com.bxm.localnews.news.enums.UrlPositionEnum;
import com.bxm.localnews.news.enums.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.NewsLikeParam;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.vo.FailVideo;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsDetailVO;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.NewsLike;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.news.vo.NewsSearchWord;
import com.bxm.localnews.news.vo.NewsUrlVo;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.HtmlContentUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

@Service
public class NewsServiceImpl
extends BaseService
implements NewsService {
    @Resource
    private NewsMapper newsMapper;
    @Resource
    private NewsRecordMapper newsRecordMapper;
    @Resource
    private NewsStatisticsMapper newsStatisticsMapper;
    @Resource
    private NewsSearchWordMapper newsSearchWordMapper;
    @Resource
    private NewsKindMapper newsKindMapper;
    @Resource
    private AppVersionIntegrationService appVersionIntegrationService;
    @Resource
    private NewsRecommendIntegrationService newsRecommendIntegrationService;
    @Resource
    private NewsSearchIntegrationService newsSearchIntegrationService;
    @Resource
    private NewsStatisticIntegrationService newsStatisticIntegrationService;
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private AssemblyService assemblyService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private MessageIntegrationService messageIntegrationService;
    @Resource
    private IUrlFactory iUrlFactory;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private NewsLikeMapper newsLikeMapper;
    @Resource
    private UserProperties userProperties;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private NewsProperties newsProperties;

    @Override
    public Json<NewsUrlVo> getUrlAddress(Long newsId, Long userId, Byte type) {
        News news;
        if (this.isNews(type) && null != (news = this.newsMapper.selectByPrimaryKey(newsId))) {
            String url = this.getNewsUrlBegin(type, news.getType()) + "newsId=" + newsId + "&userId=" + userId + "&type=" + type;
            NewsUrlVo newsUrlVo = new NewsUrlVo(url);
            return ResultUtil.genSuccessResult((Object)newsUrlVo);
        }
        this.logger.error("\u83b7\u5f97\u8be6\u60c5\u5730\u5740\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728-newsId:{},userId:{},type:{}", new Object[]{newsId, userId, type});
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83b7\u5f97\u8be6\u60c5\u5730\u5740\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728");
    }

    private boolean isEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 1;
    }

    private boolean isIconEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 2;
    }

    private boolean isVideoShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 3;
    }

    private boolean isEssayDetail(Byte type) {
        return type == 1 || type == 3;
    }

    private boolean isNews(Byte type) {
        return type != 4;
    }

    private String getNewsUrlBegin(byte type, byte newsType) {
        String url = "";
        if (this.isEssayShare(type, newsType)) {
            url = "shareNewsDetail.html?";
        }
        if (this.isIconEssayShare(type, newsType)) {
            url = "sharePicDetail.html?";
        }
        if (this.isVideoShare(type, newsType)) {
            url = "shareVideoDetail.html?";
        }
        if (this.isEssayDetail(type)) {
            url = "newsDetail.html?";
        }
        return url;
    }

    @Override
    public Json<NewsDetailVO> getNewsDetail(NewsParam newsParam, BasicParam basicParam) {
        long begin = System.currentTimeMillis();
        if (null == newsParam.getNewsId()) {
            return ResultUtil.genSuccessResult((Object)new NewsDetailVO());
        }
        List newsVoList = this.newsSearchIntegrationService.multipleGet(new Long[]{newsParam.getNewsId()});
        if (newsVoList.isEmpty()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83b7\u53d6\u8be6\u60c5\u65f6\u65b0\u95fb\u7f3a\u5931");
        }
        NewsVO newsVO = (NewsVO)newsVoList.get(0);
        if (newsVO.getStatus() != 1) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u65b0\u95fb\u5df2\u4e0b\u67b6");
        }
        this.fillDetailExtInfo(newsVO, newsParam, basicParam);
        NewsDetailVO newsDetailVO = new NewsDetailVO(newsVO);
        this.logger.debug("[getNewsDetail]\u65b0\u95fb\u8be6\u60c5es\u62c9\u53d6\u5b8c\u6bd5, param:[{}] ,content:[{}],\u8017\u65f6:[{}]", new Object[]{newsParam, JSONObject.toJSONString((Object)newsDetailVO), System.currentTimeMillis() - begin});
        if (null != newsParam.getUserId()) {
            this.newsStatisticIntegrationService.pushNewClickData(newsParam.getUserId(), newsParam.getNewsId());
            this.newsStatisticIntegrationService.pushViewData(newsParam.getUserId(), newsParam.getNewsId());
        }
        return ResultUtil.genSuccessResult((Object)newsDetailVO);
    }

    private void fillDetailExtInfo(NewsVO newsVO, NewsParam newsParam, BasicParam basicParam) {
        newsVO.setCollect(Integer.valueOf(0));
        newsVO.setLiked(Byte.valueOf((byte)0));
        if (newsParam.getUserId() != null) {
            newsVO.setCollect(Integer.valueOf(this.newsCollectMapper.selectUserCollect(newsParam.getNewsId(), newsParam.getUserId(), Byte.valueOf((byte)1)) != null ? 1 : 0));
            NewsLike newsLike = this.newsLikeMapper.selectByUserIdAndNewsId(newsParam.getUserId(), newsParam.getNewsId());
            if (Objects.nonNull(newsLike)) {
                newsVO.setLiked(Byte.valueOf((byte)1));
            }
        }
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(newsParam.getAreaCode());
        this.judgeEnablePlaceholder((News)newsVO, location);
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)newsVO.getEditorMessage())) {
            newsVO.setContent(newsVO.getContent() + newsVO.getEditorMessage());
        }
        newsVO.setLocal(Byte.valueOf((byte)1));
        if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)newsVO.getAreaDetail())) {
            newsVO.setLocal(Byte.valueOf((byte)2));
        }
        newsVO.setLinkUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.DETAIL, newsParam.getNewsId(), newsParam.getUserId()));
        newsVO.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.SHARE, newsParam.getNewsId(), newsParam.getUserId()));
        newsVO.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.NEWS, newsParam.getNewsId(), newsParam.getUserId()));
        if (this.appVersionIntegrationService.getPublishState((BasicParam)newsParam).booleanValue()) {
            newsVO.setAuthor("");
            newsVO.setAuthorImg("");
        }
        if (Objects.isNull(newsVO.getIsBootDownload())) {
            newsVO.setIsBootDownload(Byte.valueOf((byte)0));
        }
        String shareDesc = HtmlContentUtils.getHtmlDesc((String)newsVO.getContent(), (int)50);
        newsVO.setShareDesc(shareDesc);
        this.exchangeDetailNews((News)newsVO);
    }

    @Override
    @Async
    public void completeTaskAndPush(NewsParam newsParam, NewsVO newsVO) {
        if (PlatformEnum.APPLET.getCode() == newsParam.getPlatform() && Objects.nonNull(newsParam.getShareUserId()) && !newsParam.getShareUserId().equals(newsParam.getUserId())) {
            String content = "\u8f6c\u53d1\u3010" + ExtendFactory.getContent((String)newsVO.getTitle(), (String)newsVO.getContent()) + "\u3011\u88ab\u9605\u8bfb";
            NewsCompleTaskDTO completeTask = this.missionIntegrationService.compleTask(newsParam.getShareUserId(), TaskEnum.TASK_FIRST_BROWSE.name(), newsParam.getUserId().toString(), content);
            if (Objects.nonNull(completeTask) && completeTask.getGoldNum() > 0L) {
                String extendUrl;
                String extendContent = null;
                List<PostImgVo> imgList = this.getDetailFromNews(newsVO.getImgUrl(), newsVO.getVideoList());
                String string = extendUrl = CollectionUtils.isNotEmpty(imgList) ? imgList.get(0).getImgUrl() : null;
                if (com.bxm.newidea.component.tools.StringUtils.isEmpty(extendUrl)) {
                    extendContent = ExtendFactory.getContent((String)newsVO.getTitle(), (String)newsVO.getContent());
                }
                this.messageIntegrationService.addMessage(newsParam.getShareUserId(), newsParam.getUserId(), completeTask, newsParam.getNewsId(), Byte.valueOf(ReplyTypeEnum.NEWS_REPLY.getCode()), extendUrl, extendContent, newsVO.getTitle());
            }
        }
    }

    @Override
    public Json doRecordNews(Long newsId, Long userId, Integer viewTime, String tabType, String advertShow) {
        NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);
        Date d = new Date();
        if (nRecord != null) {
            nRecord.setUpdateTime(d);
            if (viewTime > nRecord.getCheckTime()) {
                nRecord.setCheckTime(viewTime);
            }
            this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
        } else {
            NewsRecord nr = new NewsRecord();
            nr.setId(this.nextSequence());
            nr.setNewsId(newsId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(viewTime);
            nr.setGetGold(Byte.valueOf((byte)1));
            nr.setAddTime(d);
            nr.setLastLocation(tabType);
            nr.setAdViewType(Byte.valueOf(advertShow));
            this.newsRecordMapper.insertSelective(nr);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json<List<News4Client>> listRecommendNews(Long newsId, Long userId, Integer size, String areaCode, Integer platform) {
        if (newsId == null || userId == null) {
            this.logger.error("\u65b0\u95fb\u8be6\u60c5\u63a8\u8350\u5217\u8868\u63a5\u53e3----\u53c2\u6570\u6709\u8bef,newsId:{},userId:{}", (Object)newsId, (Object)userId);
        }
        if (size == null) {
            size = 5;
        }
        List ids = this.newsRecommendIntegrationService.recommendByNewsDetail(newsId, userId, size, platform);
        this.logger.debug("[listRecommendNews]\u65b0\u95fb\u8be6\u60c5\u63a8\u8350\uff1a{}", (Object)JSONObject.toJSONString((Object)ids));
        List<MixRecommendDTO> mixRecommendDTOList = ForumPostConvert.convertIds2MixRecommendDTO(ids);
        List<News4Client> news4Clients = ((RecommendService)SpringContextHolder.getBean(RecommendService.class)).listNews4Client(mixRecommendDTOList, userId, areaCode, true);
        return ResultUtil.genSuccessResult(news4Clients);
    }

    @Override
    public Json<List<News4Client>> listRecommendNews4ImgNews(Long newsId) {
        List list = this.newsMapper.queryRecommendNewsList(newsId, 8, null);
        List news4ClientList = list.stream().map(e -> new News4Client(e, null)).collect(Collectors.toList());
        return ResultUtil.genSuccessResult(news4ClientList);
    }

    @Override
    public Json<List<NewsSearchWord>> listHotTitle() {
        return ResultUtil.genSuccessResult((Object)this.newsSearchWordMapper.queryList());
    }

    @Override
    public Json<List<NewsKind>> listNewsKinds() {
        return ResultUtil.genSuccessResult((Object)this.newsKindMapper.selectVideoKinds());
    }

    @Override
    @Deprecated
    public Json<FailVideo> getFailVideo(Long newsId) {
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u65e0\u6548\u89c6\u9891");
    }

    @Override
    public Json doSaveNewsClick(Long newsId) {
        this.newsStatisticsMapper.searchRecommended(newsId);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public void fillExtInfo(Long userId, List<News> result, String areaCode) {
        List newsCollect = new ArrayList();
        if (userId != null) {
            newsCollect = this.newsCollectMapper.selectByIds(userId, Byte.valueOf((byte)1));
        }
        ArrayList finalNewsCollect = newsCollect;
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        result.parallelStream().forEach(item -> {
            item.setLinkUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.DETAIL, item.getId(), userId));
            item.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.SHARE, item.getId(), userId));
            item.setCollect(Integer.valueOf(finalNewsCollect.stream().anyMatch(e -> e.equals(item.getId())) ? 1 : 0));
            item.setLocal(Byte.valueOf((byte)(com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)item.getAreaDetail()) ? 2 : 1)));
            this.exchangeCoverNews((News)item);
            this.judgeEnablePlaceholder((News)item, location);
        });
    }

    @Override
    public void exchangeCoverNews(News news) {
        List<PostImgVo> coverFromNews = this.getCoverFromNews(news.getCoverList(), news.getImgUrl(), news.getVideoList(), news.getCoverSelect());
        news.setNewsImgList(coverFromNews);
        news.setShareImg(this.getShareImg(coverFromNews));
        news.setImgUrl(JSONObject.toJSONString(news.getNewsImgList().stream().map(PostImgVo::getImgUrl).collect(Collectors.toList())));
    }

    @Override
    public void exchangeDetailNews(News news) {
        List<PostImgVo> coverFromNews = this.getCoverFromNews(news.getCoverList(), news.getImgUrl(), news.getVideoList(), news.getCoverSelect());
        news.setShareImg(this.getShareImg(coverFromNews));
        news.setNewsImgList(this.getDetailFromNews(news.getImgUrl(), news.getVideoList()));
        news.setImgUrl(JSONObject.toJSONString(news.getNewsImgList().stream().map(PostImgVo::getImgUrl).collect(Collectors.toList())));
    }

    private PostImgVo getShareImg(List<PostImgVo> coverList) {
        Optional<PostImgVo> imgVoOptional;
        PostImgVo postImgVo = null;
        if (CollectionUtils.isNotEmpty(coverList) && (imgVoOptional = coverList.stream().filter(e -> com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)e.getImgUrl()) && !e.getImgUrl().contains(".gif")).findFirst()).isPresent()) {
            postImgVo = imgVoOptional.get();
        }
        if (Objects.isNull(postImgVo)) {
            postImgVo = PostImgVo.buildImg((String)this.newsProperties.getDefaultShareCover());
        }
        return postImgVo;
    }

    @Override
    public List<PostImgVo> getCoverFromNews(String coverStr, String imgUrl, List<PostImgVo> videoList, Byte coverSelect) {
        List<Object> coverArray = new ArrayList();
        if (null == coverSelect) {
            coverSelect = 0;
        }
        Integer vodeoSize = 1;
        Integer imageSize = 3;
        if (coverSelect == 0) {
            coverArray = this.getCoverByCoverStr(coverStr);
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = this.getCoverByVideo(videoList, vodeoSize);
            }
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = this.getCoverByImgUrl(imgUrl, imageSize);
            }
        } else if (coverSelect == 1) {
            coverArray = this.getCoverByVideo(videoList, vodeoSize);
            if (CollectionUtils.isEmpty(coverArray)) {
                coverArray = this.getCoverByImgUrl(imgUrl, imageSize);
            }
        } else if (coverSelect == 2 && (coverArray = this.getCoverByVideo(videoList, vodeoSize = Integer.valueOf(3))).size() < 3) {
            imageSize = vodeoSize - coverArray.size();
            List<PostImgVo> coverByImgUrl = this.getCoverByImgUrl(imgUrl, imageSize);
            coverArray.addAll(coverByImgUrl);
        }
        return coverArray;
    }

    @Override
    public List<PostImgVo> getCoverByCoverStr(String coverStr) {
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)coverStr)) {
            List coverList = JSONObject.parseArray((String)coverStr, String.class);
            List<PostImgVo> coverArray = coverList.stream().filter(StringUtils::isNotBlank).map(e -> this.assemblyService.buildImgCover((String)e)).map(PostImgVo::buildImg).limit(3L).collect(Collectors.toList());
            return coverArray;
        }
        return Lists.newArrayList();
    }

    private List<PostImgVo> getCoverByImgUrl(String imgUrl, Integer size) {
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)imgUrl)) {
            List imgList = JSONArray.parseArray((String)imgUrl, String.class);
            List<PostImgVo> coverArray = imgList.stream().filter(StringUtils::isNotBlank).map(e -> this.assemblyService.buildImgCover((String)e)).map(PostImgVo::buildImg).limit(size.intValue()).collect(Collectors.toList());
            return coverArray;
        }
        return Lists.newArrayList();
    }

    private List<PostImgVo> getCoverByVideo(List<PostImgVo> videoList, Integer size) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(videoList)) {
            for (PostImgVo e : videoList) {
                if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)e.getImgUrl())) {
                    e.setImgUrl(this.assemblyService.buildVideoCover(e.getImgUrl()));
                    result.add(e);
                }
                if (result.size() < size) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public List<PostImgVo> getDetailFromNews(String imgUrl, List<PostImgVo> videoList) {
        ArrayList<PostImgVo> coverArray = new ArrayList<PostImgVo>();
        if (CollectionUtils.isNotEmpty(videoList)) {
            videoList.stream().filter(e -> com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)e.getImgUrl())).forEach(e -> e.setImgUrl(this.assemblyService.buildVideoCover(e.getImgUrl())));
            coverArray.addAll(videoList);
        }
        if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)imgUrl)) {
            List imgList = JSONArray.parseArray((String)imgUrl, String.class);
            coverArray.addAll(imgList.stream().filter(xva$0 -> com.bxm.newidea.component.tools.StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).map(e -> this.assemblyService.buildImgCover((String)e)).map(PostImgVo::buildImg).collect(Collectors.toList()));
        }
        return coverArray.stream().limit(9L).collect(Collectors.toList());
    }

    @Override
    public Json<NewsDetailVO> getNewsDetailById(NewsParam newsParam, BasicParam basicParam, String ip) {
        if (Objects.isNull(newsParam.getNewsId())) {
            return ResultUtil.genSuccessResult((Object)new NewsDetailVO());
        }
        Json<NewsDetailVO> data = this.getNewsDetail(newsParam, basicParam);
        if (data.success()) {
            NewsDetailVO result = (NewsDetailVO)data.getResult();
            NewsVO news = result.getNews();
            String content = news.getContent();
            if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)content)) {
                String htmlContent = PlatformEnum.APPLET.getCode() == basicParam.getPlatform() || PlatformEnum.WEB.getCode() == basicParam.getPlatform() ? this.assemblyService.fixContent(content, basicParam, ip, ReplyTypeEnum.NEWS_REPLY.getCode(), newsParam.getUserId(), newsParam.getAreaCode(), newsParam.getNewsId()) : this.assemblyService.assemblyContent(content, basicParam, ip, ReplyTypeEnum.NEWS_REPLY.getCode(), newsParam.getUserId(), newsParam.getAreaCode(), newsParam.getNewsId());
                news.setContent(htmlContent);
            }
            result.setNews(news);
            data.setResult((Object)result);
            if (newsParam.getShareUserId() != null && newsParam.getShareUserId() != 0L) {
                NewsService newsService = (NewsService)SpringContextHolder.getBean(NewsService.class);
                newsService.completeTaskAndPush(newsParam, news);
            }
        }
        return data;
    }

    @Override
    public PostLikeDto doNewsLike(NewsLikeParam newsLikeParam) {
        PostLikeDto postLikeDto;
        NewsLike newsLike = this.newsLikeMapper.selectByUserIdAndNewsId(newsLikeParam.getUserId(), newsLikeParam.getNewsId());
        UserBean userBean = this.userIntegrationService.selectUserFromCache(newsLikeParam.getUserId());
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)userBean.getHeadImg()) || com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)userBean.getNickname())) {
            this.logger.info("\u5e16\u5b50\u70b9\u8d5e\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)userBean));
        }
        if (Objects.isNull(newsLike) || newsLike.getType() == 0) {
            long id = this.generateNewsLike(newsLike, (byte)1, newsLikeParam.getNewsId(), newsLikeParam.getUserId(), userBean);
            News news = this.newsMapper.selectByPrimaryKey(newsLikeParam.getNewsId());
            postLikeDto = this.calculateFlower(news, newsLikeParam.getUserId(), id, newsLikeParam.getAreaCode());
        } else {
            postLikeDto = null;
        }
        return postLikeDto;
    }

    private PostLikeDto calculateFlower(News news, Long userId, long id, String areaCode) {
        ForumPostStatisticService forumPostStatisticService = (ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class);
        int postLikeConsume = forumPostStatisticService.getPostLikeConsume(0);
        LocationDTO location = this.locationIntegrationService.getLocationByGeocode(areaCode);
        this.judgeEnablePlaceholder(news, location);
        String consumeContent = "\u70b9\u8d5e\u3010" + ExtendFactory.getContent((String)news.getTitle(), (String)news.getContent()) + "\u3011 \u6d88\u8017\u5c0f\u7ea2\u82b1";
        Boolean consume = this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeExpendParam((Long)userId, (int)postLikeConsume, (Long)id, (String)consumeContent));
        PostLikeDto postLikeDto = new PostLikeDto();
        if (consume.booleanValue()) {
            postLikeDto.setAmount(Integer.valueOf(postLikeConsume));
            postLikeDto.setCode(Integer.valueOf(1));
            forumPostStatisticService.fillPostLikeDto(postLikeDto, userId, userId, postLikeConsume);
        } else {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            postLikeDto.setCode(Integer.valueOf(0));
            postLikeDto.setShowFlower(Integer.valueOf(0));
            postLikeDto.setCopyWriter("\u4f60\u7684\u5c0f\u7ea2\u82b1\u4f59\u989d\u4e0d\u8db3\uff0c\u5feb\u8f6c\u53d1\u6587\u7ae0\u8d5a\u5c0f\u7ea2\u82b1");
        }
        return postLikeDto;
    }

    private Long generateNewsLike(NewsLike newsLike, Byte type, Long newsId, Long userId, UserBean userBean) {
        long id;
        String updateNickname;
        String updateHeadImg = com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)userBean.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg();
        String string = updateNickname = com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)userBean.getNickname()) ? null : userBean.getNickname();
        if (Objects.isNull(newsLike)) {
            id = this.nextId();
            newsLike = NewsLike.buildNewsLike((Long)newsId, (Long)userId);
            newsLike.setId(Long.valueOf(id));
            newsLike.setType(type);
            newsLike.setHeadImg(updateHeadImg);
            newsLike.setUserNickname(updateNickname);
            this.newsLikeMapper.insertSelective(newsLike);
        } else {
            id = newsLike.getId();
            newsLike.setType(type);
            newsLike.setHeadImg(updateHeadImg);
            newsLike.setUserNickname(updateNickname);
            this.newsLikeMapper.updateByPrimaryKeySelective(newsLike);
        }
        return id;
    }

    @Override
    public List<NewsLikeDTO> listPostLikeByNewsId(Long newsId) {
        return this.newsLikeMapper.selectByNewsId(newsId);
    }

    @Override
    public News judgeEnablePlaceholder(News newsVo, LocationDTO location) {
        boolean titleFlag;
        boolean flag = Objects.nonNull(newsVo) && Objects.nonNull(newsVo.getEnablePlaceholder()) && newsVo.getEnablePlaceholder() == 1;
        boolean contentFlag = Objects.nonNull(newsVo) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)newsVo.getContent());
        boolean bl = titleFlag = Objects.nonNull(newsVo) && com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)newsVo.getTitle());
        if (flag) {
            String replacement = "\u672c\u5730";
            replacement = Objects.isNull(location) || com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)location.getName()) ? "\u672c\u5730" : location.getName();
            if (titleFlag) {
                newsVo.setTitle(newsVo.getTitle().replace("{areaname}", replacement));
            }
            if (contentFlag) {
                newsVo.setContent(newsVo.getContent().replace("{areaname}", replacement));
            }
        }
        return newsVo;
    }

    @Override
    @Async
    public void doTriggerUpdateNewsLikeInfo(Long userId, String nickname, String headImg) {
        if (com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)nickname) && com.bxm.newidea.component.tools.StringUtils.isBlank((CharSequence)headImg)) {
            return;
        }
        this.newsLikeMapper.updateNickNameAndHeadImgByUserId(userId, nickname, headImg);
    }
}

