/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.integration.UserRecommendSourceIntegrationService;
import com.bxm.localnews.mq.common.constant.UserRecommendEnum;
import com.bxm.localnews.mq.common.model.dto.UserRecommendDTO;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.enums.PostStatusEnum;
import com.bxm.localnews.news.enums.PostTypeEnum;
import com.bxm.localnews.news.param.NoteParam;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.localnews.news.service.ForumTopicService;
import com.bxm.localnews.news.service.NoteService;
import com.bxm.localnews.news.service.SensitiveWordService;
import com.bxm.localnews.news.util.AreaCodeUtils;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.NotePublishVo;
import com.bxm.localnews.news.vo.NoteVo;
import com.bxm.newidea.component.emoji.EmojiCodeParser;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.CharUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class NoteServiceImpl
extends BaseService
implements NoteService {
    @Resource
    private SensitiveWordService sensitiveWordService;
    @Resource
    private ForumPostService forumPostService;
    @Resource
    private ForumTopicService forumTopicService;
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private UserRecommendSourceIntegrationService userRecommendSourceIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;

    @Override
    public Message create(NoteParam noteParam) {
        if (null == noteParam || null == noteParam.getUserId() || StringUtils.isEmpty((String)noteParam.getTextField()) || null == noteParam.getValidDay()) {
            return Message.build((boolean)false, (String)"\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
        }
        if (StringUtils.isBlank((String)noteParam.getTextField())) {
            return Message.build((boolean)false, (String)"\u53d1\u5e03\u5185\u5bb9\u4e3a\u7a7a");
        }
        if (CharUtil.getWordCount((String)noteParam.getTextField()) > 50) {
            return Message.build((boolean)false, (String)"\u53d1\u5e03\u5185\u5bb9\u8fc7\u957f");
        }
        if (this.sensitiveWordService.contains(noteParam.getTextField())) {
            return Message.build((boolean)false, (String)"\u542b\u6709\u654f\u611f\u8bcd\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91");
        }
        this.getPublishNum(noteParam.getUserId());
        KeyGenerator key = this.getUserNotePublishKey(noteParam.getUserId());
        if (this.redisStringAdapter.decrement(key) < 0L) {
            this.redisStringAdapter.increment(key);
            return Message.build((boolean)false, (String)"\u4eca\u65e5\u5c0f\u7eb8\u6761\u6b21\u6570\u4e0d\u591f\u7528\u4e86\uff0c\u660e\u5929\u518d\u6765\u5427");
        }
        ForumPostVo forumPostVo = new ForumPostVo();
        BeanUtils.copyProperties((Object)noteParam, (Object)forumPostVo);
        forumPostVo.setPostType(Byte.valueOf(PostTypeEnum.NOTE.getCode()));
        forumPostVo.setStatus(Integer.valueOf(PostStatusEnum.APPROVING.getCode()));
        forumPostVo.setTextField(EmojiCodeParser.replaceSoftbankEmoji((String)noteParam.getTextField()));
        forumPostVo.setContent(noteParam.getTextField());
        forumPostVo.setDeliveryType(Integer.valueOf(0));
        if (StringUtils.isNotBlank((String)forumPostVo.getAreaCode())) {
            forumPostVo.setDeliveryType(Integer.valueOf(1));
            forumPostVo.setAreaCode(AreaCodeUtils.completeAreaCode((String)forumPostVo.getAreaCode()));
        }
        forumPostVo.setTopicIdList(Collections.singletonList(this.forumProperties.getNoteTopicId()));
        forumPostVo.setValidDate(DateUtils.addField((Date)new Date(), (int)5, (int)forumPostVo.getValidDay()));
        this.forumPostService.saveForumPost(forumPostVo);
        this.forumTopicService.updateTopic(forumPostVo);
        UserRecommendDTO userRecommendDTO = new UserRecommendDTO();
        userRecommendDTO.setUserId(noteParam.getUserId());
        userRecommendDTO.setRecommendType(UserRecommendEnum.USER_BEHAVIOR.getTag());
        userRecommendDTO.setLastNoteTime(new Date());
        this.userRecommendSourceIntegrationService.pushUserRecommendInfo(userRecommendDTO);
        ((ForumPostStatisticService)SpringContextHolder.getBean(ForumPostStatisticService.class)).doAsyncAddPublishNum(forumPostVo);
        this.bizLogIntegrationService.noteSucceed((BasicParam)noteParam, forumPostVo.getId(), forumPostVo.getUserId(), forumPostVo.getAreaCode());
        NoteVo noteVo = new NoteVo();
        noteVo.setId(forumPostVo.getId());
        noteVo.setUserId(forumPostVo.getUserId());
        noteVo.setUserImg(forumPostVo.getUserImg());
        noteVo.setTextField(forumPostVo.getTextField());
        noteVo.setValidDay(forumPostVo.getValidDay());
        noteVo.setDisplayTime(forumPostVo.getDisplayDateTime());
        return Message.build((boolean)true).addParam("note", (Object)noteVo);
    }

    @Override
    public Message delete(Long noteId) {
        Long userId = this.forumPostMapper.getUserIdByPostId(noteId);
        ForumPostVo forumPostVo = new ForumPostVo();
        forumPostVo.setId(noteId);
        forumPostVo.setStatus(Integer.valueOf(PostStatusEnum.USER_DELETE.getCode()));
        this.forumPostMapper.updateByPrimaryKeySelective(forumPostVo);
        this.mixedRecommendPoolMapper.deleteMixRecommandPoolById(noteId);
        this.userIntegrationService.addPostReplyNum(userId, Integer.valueOf(2));
        this.redisHashMapAdapter.remove(RedisConfig.USER_FORUM_NOTE, new String[]{userId + ""});
        return Message.build((boolean)true);
    }

    @Override
    public NotePublishVo getNotePublish(Long userId) {
        NotePublishVo notePublishVo = new NotePublishVo();
        notePublishVo.setPublishNum(this.getPublishNum(userId));
        notePublishVo.setCarouselList(this.forumPostMapper.getCarouselNoteList());
        return notePublishVo;
    }

    @Override
    public List<NoteVo> batchGetUserNote(List<Long> userIdList, Long currentUserId) {
        List noteVoList;
        ArrayList<NoteVo> userNoteVoList = new ArrayList<NoteVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return userNoteVoList;
        }
        boolean hasCurrent = false;
        if (currentUserId != null && userIdList.contains(currentUserId)) {
            userIdList.remove(currentUserId);
            hasCurrent = true;
        }
        if (CollectionUtils.isNotEmpty(userIdList)) {
            Set userIds = userIdList.stream().map(Object::toString).collect(Collectors.toSet());
            List userNoteCache = this.redisHashMapAdapter.multiGet(RedisConfig.USER_FORUM_NOTE, userIds, String.class);
            if (CollectionUtils.isNotEmpty((Collection)userNoteCache)) {
                userNoteCache.forEach(userCache -> {
                    List noteVoList = JSON.parseArray((String)userCache, NoteVo.class);
                    if (CollectionUtils.isNotEmpty((Collection)noteVoList)) {
                        userIdList.remove(((NoteVo)noteVoList.get(0)).getUserId());
                        userNoteVoList.add((NoteVo)noteVoList.get(0));
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(userIdList)) {
                userNoteVoList.addAll(this.batchLoadUserNoteVoToRedis(userIdList));
            }
        }
        if (hasCurrent && CollectionUtils.isNotEmpty((Collection)(noteVoList = this.forumPostMapper.batchGetUserNotes(Collections.singletonList(currentUserId), Integer.valueOf(1))))) {
            userNoteVoList.add((NoteVo)noteVoList.get(0));
        }
        return userNoteVoList;
    }

    @Override
    public void cacheUserNote(Date startTime) {
        List userIdList = this.forumPostMapper.getUpdatedUser(startTime);
        this.batchLoadUserNoteVoToRedis(userIdList);
    }

    @Override
    public List<NoteVo> getUserNoteList(Long userId) {
        List noteVoList;
        if (null == userId) {
            return new ArrayList<NoteVo>();
        }
        String userNoteCache = (String)this.redisHashMapAdapter.get(RedisConfig.USER_FORUM_NOTE, userId.toString(), String.class);
        if (StringUtils.isNotBlank((String)userNoteCache) && CollectionUtils.isNotEmpty((Collection)(noteVoList = JSON.parseArray((String)userNoteCache, NoteVo.class)))) {
            return noteVoList;
        }
        return this.batchLoadUserNoteVoToRedis(Collections.singletonList(userId));
    }

    private List<NoteVo> batchLoadUserNoteVoToRedis(List<Long> userIdList) {
        List<Object> resultList = new ArrayList<NoteVo>();
        if (CollectionUtils.isEmpty(userIdList)) {
            return resultList;
        }
        resultList = this.forumPostMapper.batchGetUserNotes(userIdList, Integer.valueOf(0));
        if (CollectionUtils.isEmpty(resultList)) {
            return resultList;
        }
        Map<Long, List<NoteVo>> userNoteMap = resultList.stream().collect(Collectors.groupingBy(NoteVo::getUserId));
        HashMap userNoteStrMap = new HashMap();
        userIdList.forEach(userId -> {
            List noteVoList = (List)userNoteMap.get(userId);
            userNoteStrMap.put(userId.toString(), JSON.toJSONString((Object)noteVoList));
        });
        if (userNoteMap.size() > 0) {
            this.redisHashMapAdapter.putAll(RedisConfig.USER_FORUM_NOTE, userNoteStrMap);
        }
        return resultList;
    }

    private Integer getPublishNum(Long userId) {
        KeyGenerator key = this.getUserNotePublishKey(userId);
        if (this.redisStringAdapter.hasKey(key).booleanValue()) {
            return this.redisStringAdapter.getInt(key);
        }
        Integer publishNum = this.forumProperties.getUserPublishNum();
        this.redisStringAdapter.set(key, (Object)publishNum);
        this.redisStringAdapter.expire(key, (long)DateUtils.getCurSeconds());
        return publishNum;
    }

    private KeyGenerator getUserNotePublishKey(Long userId) {
        return RedisConfig.USER_NOTE_PUBLISH.copy().appendKey((Object)userId);
    }
}

