/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.domain.SensitiveWordMapper;
import com.bxm.localnews.news.service.SensitiveWordService;
import com.bxm.localnews.news.vo.SensitiveWordBean;
import com.bxm.localnews.news.vo.WordNode;
import com.bxm.newidea.component.tools.BCConvert;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class SensitiveWordServiceImpl
implements SensitiveWordService {
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordServiceImpl.class);
    private static final Set<Integer> STOP_WORD_SET = new HashSet<Integer>();
    private static Set<Integer> FIRST_WORD_SET = new HashSet<Integer>();
    private boolean initd = true;
    private static Map<Integer, WordNode> TRIE_TREE = new HashMap<Integer, WordNode>(2048, 1.0f);
    private final SensitiveWordMapper sensitiveWordMapper;

    @Autowired
    public SensitiveWordServiceImpl(SensitiveWordMapper sensitiveWordMapper) {
        this.sensitiveWordMapper = sensitiveWordMapper;
    }

    private static int charConvert(char src) {
        int r = BCConvert.qj2bj((char)src);
        return r >= 65 && r <= 90 ? r + 32 : r;
    }

    @Override
    public boolean contains(String source) {
        if (this.initd) {
            this.init();
            this.initd = false;
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            return false;
        }
        char[] chs = source.toCharArray();
        int length = chs.length;
        for (int i = 0; i < length; ++i) {
            WordNode node;
            int firstWord = SensitiveWordServiceImpl.charConvert(chs[i]);
            if (!FIRST_WORD_SET.contains(firstWord) || (node = TRIE_TREE.get(firstWord)) == null) continue;
            boolean couldMark = false;
            int k = i;
            if (node.isLast()) {
                couldMark = true;
            } else {
                int temp;
                while (++k < length && !STOP_WORD_SET.contains(temp = SensitiveWordServiceImpl.charConvert(chs[k])) && (node = node.querySub(temp)) != null) {
                    if (!node.isLast()) continue;
                    couldMark = true;
                }
            }
            if (!couldMark) continue;
            String sensitiveWord = source.substring(i, k);
            log.warn("[{}]\u4e2d\u5b58\u5728\u654f\u611f\u8bcd\uff0c\u654f\u611f\u8bcd\u4e3a\uff1a[{}]", (Object)source, (Object)sensitiveWord);
            return true;
        }
        return false;
    }

    @Override
    public void reload() {
        List words = this.sensitiveWordMapper.getEnable();
        if (words != null && words.size() > 0) {
            HashSet firstWordSet = Sets.newHashSet();
            HashMap<Integer, WordNode> nodes = new HashMap<Integer, WordNode>(2048, 1.0f);
            for (SensitiveWordBean word : words) {
                WordNode firstNode;
                char[] chs = word.getWord().toCharArray();
                int firstWordChar = SensitiveWordServiceImpl.charConvert(chs[0]);
                if (!firstWordSet.contains(firstWordChar)) {
                    firstWordSet.add(firstWordChar);
                    firstNode = new WordNode(firstWordChar, chs.length == 1);
                    nodes.put(firstWordChar, firstNode);
                } else {
                    firstNode = (WordNode)nodes.get(firstWordChar);
                    if (!firstNode.isLast() && chs.length == 1) {
                        firstNode.setLast(true);
                    }
                }
                int lastIndex = chs.length - 1;
                for (int i = 1; i < chs.length; ++i) {
                    firstNode = firstNode.addIfNoExist(SensitiveWordServiceImpl.charConvert(chs[i]), i == lastIndex);
                }
            }
            FIRST_WORD_SET = firstWordSet;
            TRIE_TREE = nodes;
        }
    }

    public void init() {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("stop_words.txt")));){
            String buf;
            ArrayList<String> words = new ArrayList<String>(1200);
            while ((buf = br.readLine()) != null) {
                if ("".equals(buf)) continue;
                words.add(buf);
            }
            words.add(" ");
            if (words.size() > 0) {
                for (String curr : words) {
                    char[] chs;
                    for (char c : chs = curr.toCharArray()) {
                        STOP_WORD_SET.add(SensitiveWordServiceImpl.charConvert(c));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u505c\u7528\u8bcd\u51fa\u9519", (Throwable)e);
        }
        this.reload();
    }
}

