/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.BatchHelper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.domain.UserTagMapper;
import com.bxm.localnews.news.dto.UserLikeDTO;
import com.bxm.localnews.news.service.UserTagService;
import com.bxm.localnews.news.vo.UserTag;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class UserTagServiceImpl
extends BaseService
implements UserTagService {
    private UserTagMapper userTagMapper;
    private ForumPostMapper forumPostMapper;
    private UserReplyMapper userReplyMapper;

    public UserTagServiceImpl(UserTagMapper userTagMapper, ForumPostMapper forumPostMapper, UserReplyMapper userReplyMapper) {
        this.userTagMapper = userTagMapper;
        this.forumPostMapper = forumPostMapper;
        this.userReplyMapper = userReplyMapper;
    }

    @Override
    public int doCopyTags(Long fromUid, final Long toUid, Date time) {
        List userTags = this.userTagMapper.getUserTag(fromUid);
        final Date current = new Date();
        new BatchHelper<UserTagMapper, UserTag>(UserTagMapper.class, (Collection)userTags){

            protected int invoke(UserTag element) {
                element.setId(Long.valueOf(UserTagServiceImpl.this.nextId()));
                element.setUserId(toUid);
                element.setUpdateTime(current);
                return ((UserTagMapper)this.mapper).insert(element);
            }
        };
        return 1;
    }

    @Override
    public List<UserLikeDTO> getLikeNumByUserIds(List<Long> userIds) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userIds)) {
            userIds.forEach(e -> {
                UserLikeDTO userLikeDTO = new UserLikeDTO();
                userLikeDTO.setUserId(e);
                Integer postNum = this.forumPostMapper.getPostLikeNumByUserId(e);
                Integer replyNum = this.userReplyMapper.selectReplyLikeNumByUserId(e);
                userLikeDTO.setLikeNum(Integer.valueOf(postNum + replyNum));
                result.add(userLikeDTO);
            });
        }
        return result;
    }
}

