/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.news.param.VideoQueryParam;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoRecommendServiceImpl
extends BaseService
implements VideoRecommendService {
    private NewsRecommendIntegrationService newsRecommendIntegrationService;

    @Autowired
    public VideoRecommendServiceImpl(NewsRecommendIntegrationService newsRecommendIntegrationService) {
        this.newsRecommendIntegrationService = newsRecommendIntegrationService;
    }

    @Override
    public List<VideoDto> execRecommend(VideoQueryParam param) {
        List result = this.newsRecommendIntegrationService.recommendVideoList(param.getUserId(), Integer.valueOf(param.getPageSize()));
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            result.forEach(video -> {
                String videoUrl = video.getVideoUrl();
                video.setVideoUrl(this.videoAddressConversion(videoUrl));
            });
        }
        return result;
    }

    @Override
    public String videoAddressConversion(String oldAddress) {
        if (StringUtils.isBlank((CharSequence)oldAddress)) {
            return oldAddress;
        }
        int fistQuestionMarkIndex = StringUtils.indexOf((CharSequence)oldAddress, (CharSequence)"?") + 1;
        String firstPart = StringUtils.substring((String)oldAddress, (int)0, (int)fistQuestionMarkIndex);
        oldAddress = StringUtils.substring((String)oldAddress, (int)fistQuestionMarkIndex);
        try {
            String queryPart = URLEncoder.encode(oldAddress, StandardCharsets.UTF_8.name());
            queryPart = StringUtils.replace((String)queryPart, (String)"%25", (String)"%");
            queryPart = StringUtils.replace((String)queryPart, (String)"%26", (String)"&");
            queryPart = StringUtils.replace((String)queryPart, (String)"%3D", (String)"=");
            return firstPart + queryPart;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return oldAddress;
        }
    }
}

