/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.domain.VideoReplyLikeMapper;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.VideoReplyDto;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.VideoReplyLikeParam;
import com.bxm.localnews.news.param.VideoReplyListQueryParam;
import com.bxm.localnews.news.param.VideoReplyParam;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.VideoReplyService;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.news.vo.UserReply;
import com.bxm.localnews.news.vo.Video;
import com.bxm.localnews.news.vo.VideoReplyLike;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class VideoReplyServiceImpl
extends BaseService
implements VideoReplyService {
    private final VideoMapper videoMapper;
    private final VideoReplyLikeMapper videoReplyLikeMapper;
    private final UserIntegrationService userIntegrationService;
    private final NewsReplyMapper newsReplyMapper;
    private final NewNewsReplyService newsReplyService;
    private final UserReplyMapper userReplyMapper;

    @Autowired
    public VideoReplyServiceImpl(VideoMapper videoMapper, VideoReplyLikeMapper videoReplyLikeMapper, UserIntegrationService userIntegrationService, NewsReplyMapper newsReplyMapper, NewNewsReplyService newsReplyService, UserReplyMapper userReplyMapper) {
        this.videoMapper = videoMapper;
        this.videoReplyLikeMapper = videoReplyLikeMapper;
        this.userIntegrationService = userIntegrationService;
        this.newsReplyMapper = newsReplyMapper;
        this.newsReplyService = newsReplyService;
        this.userReplyMapper = userReplyMapper;
    }

    @Override
    public PageWarper<VideoReplyDto> queryByPageSize(VideoReplyListQueryParam param) {
        NewsReplyParam newsReplyParam = new NewsReplyParam();
        newsReplyParam.setPageNum(param.getPageNum());
        newsReplyParam.setPageSize(param.getPageSize());
        newsReplyParam.setUserId(param.getUserId());
        newsReplyParam.setNewsId(param.getVideoId());
        ArrayList<VideoReplyDto> videoReplyDtoList = new ArrayList<VideoReplyDto>();
        PageWarper newsReplyDTOPageWarper = new PageWarper(this.newsReplyMapper.queryVideoReplyByPageSize(newsReplyParam));
        List newsReplyDTOList = newsReplyDTOPageWarper.getList();
        for (NewsReplyDTO newsReplyDTO : newsReplyDTOList) {
            NewsReply sourceReply;
            VideoReplyDto videoReplyDto = new VideoReplyDto();
            if (this.isLike(newsReplyDTO.getUserId(), newsReplyDTO.getId())) {
                videoReplyDto.setIsLike(Integer.valueOf(1));
            }
            videoReplyDto.setAddTime(newsReplyDTO.getAddTime());
            videoReplyDto.setComment(newsReplyDTO.getReplyContent());
            videoReplyDto.setDeleleFlag((int)newsReplyDTO.getDeleteFlag());
            videoReplyDto.setId(newsReplyDTO.getId());
            videoReplyDto.setLikeCount(newsReplyDTO.getLikeCount());
            videoReplyDto.setUserId(newsReplyDTO.getUserId());
            videoReplyDto.setUserImg(newsReplyDTO.getHeadImg());
            videoReplyDto.setUserName(newsReplyDTO.getUserNickname());
            if (newsReplyDTO.getParentId() != 0L && null != (sourceReply = this.newsReplyMapper.selectByPrimaryKey(newsReplyDTO.getParentId()))) {
                VideoReplyDto vSourceReply = new VideoReplyDto();
                if (this.isLike(sourceReply.getUserId(), sourceReply.getId())) {
                    vSourceReply.setIsLike(Integer.valueOf(1));
                }
                vSourceReply.setAddTime(sourceReply.getAddTime());
                vSourceReply.setComment(sourceReply.getReplyContent());
                vSourceReply.setDeleleFlag((int)sourceReply.getDeleteFlag());
                vSourceReply.setId(sourceReply.getId());
                vSourceReply.setLikeCount(sourceReply.getLikeCount());
                vSourceReply.setUserId(sourceReply.getUserId());
                vSourceReply.setUserImg(sourceReply.getHeadImg());
                vSourceReply.setUserName(sourceReply.getUserNickname());
                videoReplyDto.setSourceReply(vSourceReply);
            }
            videoReplyDtoList.add(videoReplyDto);
        }
        return new PageWarper(videoReplyDtoList);
    }

    private boolean isLike(Long userId, Long replyId) {
        VideoReplyLike videoReplyLike = this.videoReplyLikeMapper.selectByModel(new VideoReplyLike(replyId, userId));
        return null != videoReplyLike;
    }

    @Override
    public Message replyVideo(VideoReplyParam videoReplyParam) {
        Video video;
        UserBean userInfoDTO;
        NewsReply newsReplyDb;
        if (!this.checkReplyParam(videoReplyParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        NewsReply newsReply = new NewsReply();
        newsReply.setType(Byte.valueOf((byte)2));
        newsReply.setNewsId(videoReplyParam.getVideoId());
        newsReply.setRootId(Long.valueOf(0L));
        newsReply.setParentId(Long.valueOf(0L));
        newsReply.setLevel(Byte.valueOf((byte)0));
        newsReply.setStatus(Byte.valueOf((byte)1));
        newsReply.setLikeCount(Integer.valueOf(0));
        newsReply.setId(this.nextSequence());
        newsReply.setReplyContent(videoReplyParam.getComment());
        if (videoReplyParam.getReplyId() != null && (newsReplyDb = this.newsReplyMapper.selectByPrimaryKey(videoReplyParam.getReplyId())) != null) {
            UserBean userInfoDTO2 = this.userIntegrationService.selectUserFromCache(newsReplyDb.getUserId());
            if (null != userInfoDTO2) {
                newsReply.setParentUserNickname(userInfoDTO2.getNickname());
                newsReply.setParentUserId(userInfoDTO2.getId());
                newsReply.setParentHeadImg(userInfoDTO2.getHeadImg());
            }
            newsReply.setParentId(newsReplyDb.getId());
            newsReply.setRootId(newsReplyDb.getRootId());
            Byte level = newsReplyDb.getLevel();
            if (level == 0) {
                newsReply.setLevel(Byte.valueOf((byte)1));
                newsReply.setRootId(newsReplyDb.getId());
            } else {
                newsReply.setLevel(Byte.valueOf((byte)2));
                newsReply.setRootId(newsReplyDb.getRootId());
            }
        }
        if (null != (userInfoDTO = this.userIntegrationService.selectUserFromCache(videoReplyParam.getUserId()))) {
            newsReply.setUserNickname(userInfoDTO.getNickname());
            newsReply.setUserId(userInfoDTO.getId());
            newsReply.setHeadImg(userInfoDTO.getHeadImg());
        }
        int count = this.newsReplyMapper.insertSelective(newsReply);
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
        this.userReplyMapper.insertSelective(userReply);
        if (count > 0 && null != (video = this.videoMapper.selectByPrimaryKey(videoReplyParam.getVideoId()))) {
            Video videoUp = new Video();
            videoUp.setId(videoReplyParam.getVideoId());
            videoUp.setCommentCount(Long.valueOf(video.getCommentCount() + 1L));
            this.videoMapper.updateByPrimaryKeySelective(videoUp);
        }
        return Message.build((boolean)true);
    }

    private boolean checkReplyParam(VideoReplyParam videoReplyParam) {
        return null != videoReplyParam.getUserId() && null != videoReplyParam.getComment() && null != videoReplyParam.getVideoId();
    }

    @Override
    public Message produceVideoReplyLike(VideoReplyLikeParam videoReplyLikeParam) {
        if (!this.checkLikeParam(videoReplyLikeParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        NewsReplyLikeParam newsReplyLikeParam = new NewsReplyLikeParam();
        newsReplyLikeParam.setReplyId(videoReplyLikeParam.getReplyId());
        newsReplyLikeParam.setType(videoReplyLikeParam.getType());
        newsReplyLikeParam.setUserId(videoReplyLikeParam.getUserId());
        return this.newsReplyService.doProduceNewsReplyLike(newsReplyLikeParam);
    }

    private boolean checkLikeParam(VideoReplyLikeParam videoReplyLikeParam) {
        return null != videoReplyLikeParam.getReplyId() && null != videoReplyLikeParam.getUserId();
    }
}

