/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.strategy;

import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.strategy.GoldenStrategy;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;

public abstract class AbstractGoldenStrategy
extends BaseService
implements GoldenStrategy {
    public boolean viewTimeFlag = true;
    public boolean advertShowFlag = true;
    public boolean tabTYpeFlag = true;
    @Resource
    public NewsRecordMapper newsRecordMapper;
    @Resource
    public UserIntegrationService userIntegrationService;
    @Resource
    public NewsStatisticsMapper newsStatisticsMapper;
    @Resource
    public RedisStringAdapter redisStringAdapter;
    @Resource
    public MissionIntegrationService missionIntegrationService;
    public Integer randomInterval;
    public String configTabType;
    public String configAdvertShow;
    public Integer configViewTime;
    @Resource
    private NewsProperties newsProperties;

    @PostConstruct
    public void init() {
        this.randomInterval = RandomUtils.getRandomTime((String)this.newsProperties.getAwardTimeLag());
        this.configTabType = this.newsProperties.getTabType();
        this.configAdvertShow = this.newsProperties.getShowAdvert();
        this.configViewTime = this.newsProperties.getViewTime();
    }

    @Override
    public void commonJudgment(ExecGoldCalParam execGoldParam) {
        Long newsId = execGoldParam.getNewsId();
        Long userId = execGoldParam.getUserId();
        Integer viewTime = execGoldParam.getViewTime();
        String advertShow = execGoldParam.getAdvertShow();
        String isRecommendNews = execGoldParam.getIsRecommendNews();
        NewsGoldMeta newsGoldMeta = execGoldParam.getNewsGoldMeta();
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        this.newsStatisticsMapper.addActiveViews(newsId);
        Date today = new Date();
        if (this.isGuestUser(userBean)) {
            newsGoldMeta.setGoldType((byte)1);
        } else {
            NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);
            if (nRecord != null && nRecord.getGetGold() == 2) {
                this.doUpdateRecord(newsGoldMeta, viewTime, nRecord);
            } else {
                if (nRecord != null && nRecord.getActiveView() != 2) {
                    this.doUpdateRecord(newsGoldMeta, viewTime, nRecord);
                } else if (nRecord == null) {
                    nRecord = this.generatorNewsRecord((ExecGoldParam)execGoldParam);
                    this.newsRecordMapper.insertSelective(nRecord);
                }
                nRecord.setUpdateTime(today);
                nRecord.setCheckTime(viewTime);
                nRecord.setAdViewType(Byte.valueOf(advertShow));
                boolean suspendFlag = this.isSuspend(userId);
                newsGoldMeta.setGoldType((byte)1);
                execGoldParam.setNewsGoldMeta(newsGoldMeta);
                execGoldParam.setnRecord(nRecord);
                execGoldParam.setSuspendFlag(suspendFlag);
                this.calculator(execGoldParam);
            }
        }
    }

    protected boolean isSuspend(Long userId) {
        NewsRecord record = this.newsRecordMapper.getOneByUserId(userId, (byte)2);
        if (record != null) {
            Long time = record.getGetGoldTime().getTime() + (long)(record.getIntervalNum() * 1000);
            Long time2 = System.currentTimeMillis();
            return time <= time2;
        }
        return true;
    }

    NewsRecord generatorNewsRecord(ExecGoldParam execGoldParam) {
        Date today = new Date();
        NewsRecord nRecord = new NewsRecord();
        nRecord.setId(this.nextSequence());
        nRecord.setNewsId(execGoldParam.getNewsId());
        nRecord.setUserId(execGoldParam.getUserId());
        nRecord.setUpdateTime(today);
        nRecord.setCheckTime(execGoldParam.getViewTime());
        nRecord.setGetGold(Byte.valueOf((byte)1));
        nRecord.setAddTime(today);
        nRecord.setLastLocation(execGoldParam.getTabType());
        nRecord.setAdViewType(Byte.valueOf(execGoldParam.getAdvertShow()));
        nRecord.setActiveView(Byte.valueOf((byte)2));
        return nRecord;
    }

    private boolean isGuestUser(UserBean user) {
        return user == null || user.getState() == 3;
    }

    private void doUpdateRecord(NewsGoldMeta newsGoldMeta, Integer viewTime, NewsRecord nRecord) {
        newsGoldMeta.setGoldType((byte)1);
        nRecord.setUpdateTime(new Date());
        if (viewTime > nRecord.getCheckTime()) {
            nRecord.setCheckTime(viewTime);
        }
        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
    }

    private KeyGenerator getReadNewsCacheKey(Long userId) {
        KeyGenerator key = RedisConfig.RECOMMEND_NEWS_READ.copy();
        key.setKey(userId + ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date()));
        return key;
    }

    boolean checkViewTimeFlag(Integer configViewTime, Integer viewTime) {
        return viewTime > configViewTime;
    }

    boolean checkAdvertShowFlag(String configAdvertShow, String advertShow) {
        return !"2".equals(configAdvertShow) || "2".equals(advertShow);
    }

    boolean checkTabTYpeFlag(String configTabType, String tabType) {
        return !"2".equals(configTabType) || "2".equals(tabType);
    }

    protected Integer initReadNum(KeyGenerator key) {
        Integer number = this.newsProperties.getReadNumAwardCount();
        this.redisStringAdapter.set(key, (Object)number, (long)DateUtils.getCurSeconds());
        return number;
    }

    protected boolean isNumberNotExsit(String number) {
        return StringUtils.isEmpty((CharSequence)number);
    }

    protected boolean isNumberRemained(Integer number) {
        return null != number && number > 0;
    }
}

