/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.vo.ForumPostClickCountVo;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CalcPostClickCountTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(CalcPostClickCountTask.class);
    private static final Integer BATCH_SIZE = 50;
    @Resource
    private ForumPostFacadeService forumPostFacadeService;

    protected ReturnT<String> service(String param) {
        log.info(".....................................\u5e16\u5b50\u9605\u8bfb\u6570\u76f8\u5173\u8ba1\u7b97 begin...................................");
        List<ForumPostClickCountVo> forumPostClickCountVoList = this.forumPostFacadeService.getRecentPosts(6000);
        if (CollectionUtils.isNotEmpty(forumPostClickCountVoList)) {
            log.debug("\u83b7\u53d6\u5230\u9700\u8981\u8ba1\u7b97\u7684\u5e16\u5b50\u5217\u8868\uff1a" + JSON.toJSONString(forumPostClickCountVoList));
            ArrayList<Long> newForumPosts = new ArrayList<Long>();
            ArrayList<Long> oldPassedForumPosts = new ArrayList<Long>();
            ArrayList<Long> oldOtherForumPosts = new ArrayList<Long>();
            for (ForumPostClickCountVo forumPostClickCountVo : forumPostClickCountVoList) {
                if (null == forumPostClickCountVo.getClickCount() || forumPostClickCountVo.getClickCount() < 1500) {
                    newForumPosts.add(forumPostClickCountVo.getId());
                    continue;
                }
                if (forumPostClickCountVo.getStatus() == null) continue;
                if (1 == forumPostClickCountVo.getStatus()) {
                    oldPassedForumPosts.add(forumPostClickCountVo.getId());
                    continue;
                }
                oldOtherForumPosts.add(forumPostClickCountVo.getId());
            }
            this.addPostClickCount(newForumPosts, oldPassedForumPosts, oldOtherForumPosts);
        }
        log.info(".....................................\u5e16\u5b50\u9605\u8bfb\u6570\u76f8\u5173\u8ba1\u7b97 end...................................");
        return ReturnT.SUCCESS;
    }

    private void addPostClickCount(List<Long> newForumPosts, List<Long> oldPassedForumPosts, List<Long> oldOtherForumPosts) {
        ArrayList forumPostClickList = new ArrayList();
        if (CollectionUtils.isNotEmpty(newForumPosts)) {
            newForumPosts.forEach(e -> {
                ForumPostClickCountVo forumPostClickCountVo = new ForumPostClickCountVo();
                forumPostClickCountVo.setId(e);
                forumPostClickCountVo.setClickCount(Integer.valueOf(40 + new Random().nextInt(20)));
                forumPostClickList.add(forumPostClickCountVo);
            });
        }
        if (CollectionUtils.isNotEmpty(oldPassedForumPosts)) {
            oldPassedForumPosts.forEach(e -> {
                ForumPostClickCountVo forumPostClickCountVo = new ForumPostClickCountVo();
                forumPostClickCountVo.setId(e);
                forumPostClickCountVo.setClickCount(Integer.valueOf(5 + new Random().nextInt(15)));
                forumPostClickList.add(forumPostClickCountVo);
            });
        }
        if (CollectionUtils.isNotEmpty(oldOtherForumPosts)) {
            oldOtherForumPosts.forEach(e -> {
                ForumPostClickCountVo forumPostClickCountVo = new ForumPostClickCountVo();
                forumPostClickCountVo.setId(e);
                forumPostClickCountVo.setClickCount(Integer.valueOf(5 + new Random().nextInt(3)));
                forumPostClickList.add(forumPostClickCountVo);
            });
        }
        if (CollectionUtils.isNotEmpty(forumPostClickList)) {
            int i = 0;
            while (i + BATCH_SIZE < forumPostClickList.size()) {
                this.forumPostFacadeService.batchAddClick(forumPostClickList.subList(i, i + BATCH_SIZE));
                i += BATCH_SIZE.intValue();
            }
            this.forumPostFacadeService.batchAddClick(forumPostClickList.subList(i, forumPostClickList.size()));
        }
    }

    public String taskName() {
        return "calcPostClickCountTask";
    }

    public String cron() {
        return "30 1/6 * * * ? ";
    }

    public String description() {
        return "\u5b9a\u65f6\u589e\u52a0\u5e16\u5b50\u9605\u8bfb\u6570\u4efb\u52a1";
    }
}

