/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.service.ForumPostStatisticService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CalculatePostTask
extends AbstractCronTask<String> {
    private static final Logger log = LoggerFactory.getLogger(CalculatePostTask.class);
    @Resource
    private ForumProperties forumProperties;
    @Resource
    private HttpClientService httpClientService;
    @Resource
    private ForumPostStatisticService forumPostStatisticService;

    protected ReturnT<String> service(String param) {
        List<CalculatePostDTO> calculatePostList = this.forumPostStatisticService.calculatePostCount();
        if (CollectionUtils.isNotEmpty(calculatePostList)) {
            StringBuilder content = new StringBuilder();
            content.append("------").append(DateFormatUtils.format((Date)new Date(), (String)"MM\u6708dd\u65e5HH\u65f6mm\u5206")).append("------\n");
            calculatePostList.forEach(e -> {
                content.append("\u5730\u533a\uff1a[").append(e.getAreaName()).append("]\n");
                content.append("\u6700\u8fd15\u5206\u949f\u65b0\u589e\u5f85\u5ba1\u6838\u5e16\u5b50\uff1a[").append(e.getPendingReviewCount()).append("]\n");
                content.append("\u6700\u8fd15\u5206\u949f\u624b\u673a\u7aef\u53d1\u5e16\u6570\u91cf\uff1a[").append(e.getNewPostCount()).append("]\n");
                content.append("\u6700\u8fd15\u5206\u949f\u624b\u673a\u7aef\u53d1\u5e16\u4eba\u6570\uff1a[").append(e.getUserCount()).append("]\n");
            });
            JSONObject text = new JSONObject();
            text.put("content", (Object)content);
            JSONObject msg = new JSONObject();
            msg.put("msgtype", (Object)"text");
            msg.put("text", (Object)text);
            String response = this.httpClientService.doPostJson(this.forumProperties.getCalculatePostWebhook(), msg.toJSONString());
            log.debug("dingding response:{}", (Object)response);
        }
        return ReturnT.SUCCESS;
    }

    public String taskName() {
        return "calculatePostTask";
    }

    public String cron() {
        return "0 0/5 * * * ? ";
    }

    public String description() {
        return "\u5ba2\u6237\u7aef\u53d1\u5e16\u6d88\u606f\u901a\u77e5";
    }
}

