/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.facade.DingtalkPushService;
import com.bxm.localnews.news.domain.NewsMonitorMapper;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.localnews.news.vo.MonitorTaskBuildParam;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.xxl.job.core.biz.model.ReturnT;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewsMonitorTask
extends AbstractTaskCallback<MonitorTaskBuildParam> {
    private static final Logger log = LoggerFactory.getLogger(NewsMonitorTask.class);
    @Resource
    private NewsMonitorMapper newsMonitorMapper;
    @Resource
    private DingtalkPushService dingtalkPushService;
    @Resource
    private NewsQuartzService newsQuartzService;

    protected ReturnT<String> service(MonitorTaskBuildParam param) {
        if (null == param || null == param.getIndexId() || null == param.getMonitorId() || param.getNum() == null) {
            return ReturnT.FAIL;
        }
        log.warn("\u65b0\u95fb\u76d1\u63a7\u6267\u884c\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        Date startTime = new Date();
        startTime = DateUtils.clearTimePart((Date)startTime);
        Date endTime = DateUtils.addField((Date)startTime, (int)11, (int)NumberUtils.parseToInt((String)param.getFireTime()));
        param.setStartTime(DateUtils.formatDateTime((Date)startTime));
        param.setEndTime(DateUtils.formatDateTime((Date)endTime));
        if (0 == param.getKindId()) {
            param.setKindId(null);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getAreaCodes())) {
            String[] areaArray;
            for (String areaCode : areaArray = StringUtils.split((String)param.getAreaCodes(), (String)",")) {
                param.setAreaCode(areaCode);
                log.warn("\u65b0\u95fb\u76d1\u63a7\u6267\u884c\u53c2\u6570[\u589e\u52a0\u65f6\u95f4\u533a\u95f4]\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
                this.sendMsg(param, areaCode);
            }
        } else {
            this.sendMsg(param, null);
        }
        return ReturnT.SUCCESS;
    }

    private void sendMsg(MonitorTaskBuildParam param, String areaCode) {
        int total = this.newsQuartzService.countNews(param);
        if (total < param.getNum()) {
            String content = "\u76d1\u63a7\u6307\u6807[" + param.getName() + "]\u5f02\u5e38\uff0c\u8981\u6c42\u65b0\u95fb\u6570\u91cf:[" + param.getNum() + "],\u5b9e\u9645\u6570\u91cf:[" + total + "]";
            if (areaCode != null) {
                content = content + "\uff0c\u76d1\u63a7\u533a\u57df\uff1a[" + this.newsMonitorMapper.getAreaName(areaCode) + "]";
            }
            this.dingtalkPushService.push(content);
            this.newsQuartzService.updateMonitorStatus(param.getMonitorId(), 1, content);
        } else {
            this.newsQuartzService.updateMonitorStatus(param.getMonitorId(), 0, null);
        }
    }

    public static String generateTaskName(Long indexId) {
        return "newsMonitorTask_" + indexId;
    }
}

