/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.task;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.param.PublishNewsBuildParam;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.schedule.task.AbstractTaskCallback;
import com.bxm.newidea.component.tools.StringUtils;
import com.xxl.job.core.biz.model.ReturnT;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PublishNewsTask
extends AbstractTaskCallback<PublishNewsBuildParam> {
    private static final Logger log = LoggerFactory.getLogger(PublishNewsTask.class);
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private NewsQuartzService newsQuartzService;

    protected ReturnT<String> service(PublishNewsBuildParam param) {
        log.debug("\u5b9a\u65f6\u65b0\u95fb\u53d1\u5e03\u5f00\u59cb\u6267\u884c:", (Object)JSON.toJSONString((Object)param));
        if (null != param) {
            String areaCodes = param.getAreaCodes();
            Long newsId = param.getNewsId();
            this.newsQuartzService.publishNews(newsId);
            this.clearRedisCacheOfTopNewsList(areaCodes);
            log.info("id\u4e3a{}\u7684\u65b0\u95fb\u53d1\u5e03\u6210\u529f", (Object)newsId);
        }
        return ReturnT.SUCCESS;
    }

    private void clearRedisCacheOfTopNewsList(String areaCodeStr) {
        log.info("\u6e05\u9664\u9996\u9875\u7f6e\u9876\u65b0\u95fb\u5217\u8868\u7f13\u5b58\u5f00\u59cb\u6267\u884c:");
        if (StringUtils.isNotEmpty((CharSequence)areaCodeStr)) {
            String[] areaCodes;
            for (String areaCode : areaCodes = areaCodeStr.split(",")) {
                KeyGenerator keyGenerator = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey((Object)areaCode);
                this.redisStringAdapter.remove(keyGenerator);
            }
        } else {
            this.redisStringAdapter.remove(RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST);
        }
    }

    public static String generateTaskName(Long newsId) {
        return "publishNewsTask_" + newsId;
    }
}

