/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.timer;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ForumSchedule {
    private static final Logger log = LoggerFactory.getLogger(ForumSchedule.class);
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Scheduled(cron="0 0/5 * * * ?")
    public void synchronizeRewardList() {
        List forumPostVoList = this.forumPostMapper.getRewardPostList(Integer.valueOf(50));
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            this.redisStringAdapter.set(RedisConfig.FORUM_POST_REWARD_LIST.copy(), (Object)JSON.toJSONString((Object)forumPostVoList));
        }
    }
}

