package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.NewsReplyDetailDTO;
import com.bxm.localnews.news.dto.ReplyDTO;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.UserReplyParam;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 新闻回复接口 包括普通新闻回复和小视频回复
 */
public interface NewNewsReplyService {

    /**
     * 用途：获取新闻|小视频|帖子回复列表
     * @param newsReplyParam 新闻|小视频|帖子传参
     * @return 返回评论实体，根据评论的分级分别显示不同的实体
     */
    PageWarper<NewsReplyDTO> queryReplyList(NewsReplyParam newsReplyParam);

    /**
     * 用途：用户发表评论
     * @param newsReply
     * @return
     */
    ReplyDTO doReply(NewsReplyAddParam newsReply, Integer platform);

    /**
     * 用途：根据用户id获取用户的评论列表
     * @param newsReplyParam
     * @return
     */
    PageWarper<MyReplysVO> selectMyReplys(UserReplyParam newsReplyParam);

    /**
     * 用途：删除评论
     * @param replyId
     * @return
     */
    NewsReplyDTO delMyReply(Long replyId,Long userId,Long newsId);

    /**
     * 更新评论中用户头像以及昵称
     * @param userId
     * @param nickname
     * @param headImg
     */
    void doTriggerUpdateInfo(Long userId, String nickname, String headImg);

    /**
     * 用途：用户对新闻的评论进行点赞后，都在服务端处理并输送至redis阻塞队列，等待
     * 消费端，每5秒钟消费一次,更新评论信息
     * @param newsReplyLikeParam
     */
    Message doProduceNewsReplyLike(NewsReplyLikeParam newsReplyLikeParam);

    /**
     * 用途：对redis队列中的回复点赞进行消费
     */
    void doNewsReplyLikeConsume();

    /**
     * 用途：获取新闻|小视频|帖子评论详情
     * @param replyId
     * @param userId
     * @param newsId
     * @return
     */
    NewsReplyDetailDTO getNewsReplyDetailDTO(Long replyId, Long userId,Long newsId);

    /**
     * 用途：用户在评论后所做的一系列异步操作
     *     1.保存至用户评论中
     *     2.新闻不是根级评论时将根级评论互动值+3
     *     3.增加评论数
     *     4.推送消息，自己给自己评论不推送信息
     *     5.记录事件埋点
     * @param newsReply
     * @param newsReplyAddParam
     */
    void processWhenReply(NewsReply newsReply,NewsReplyAddParam newsReplyAddParam, Integer platform);

    /**
     * 用途：获取收到的评论列表【暂时不用】
     * @param userId
     * @param page
     * @return
     */
    List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page);

    /**
     * 获得零点时间
     * @param amount
     * @return
     */
    Calendar getMorningTime(Integer amount);

}
