package com.bxm.localnews.news.service.impl;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.QuartzIntegrationService;
import com.bxm.localnews.integration.*;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.config.ClientConfigProperties;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.constant.*;
import com.bxm.localnews.news.convert.impl.ForumBasicConvert;
import com.bxm.localnews.news.convert.impl.ForumParamPageConvert;
import com.bxm.localnews.news.convert.impl.ForumPostConvert;
import com.bxm.localnews.news.convert.impl.ForumTopPostConvert;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.*;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.param.ForumPostInformParam;
import com.bxm.localnews.news.param.ForumPostListQueryParam;
import com.bxm.localnews.news.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.param.UserTopPostBuildParam;
import com.bxm.localnews.news.service.*;
import com.bxm.localnews.news.vo.*;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.param.ForumParam;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.*;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class ForumServiceImpl extends BaseService implements ForumService {

    @Resource
    private ForumMapper forumMapper;

    @Resource
    private SequenceCreater sequenceCreater;

    @Resource
    private SensitiveWordService sensitiveWordService;

    @Resource
    private IUrlFactory iUrlFactory;

    @Resource
    private ForumPostInformMapper forumPostInformMapper;

    @Resource
    private ForumPostCollectMapper forumPostCollectMapper;

    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;

    @Resource
    private ForumPostMapper forumPostMapper;

    @Resource
    private UserIntegrationService userIntegrationService;

    @Resource
    private NewsRecommendIntegrationService newsRecommendIntegrationService;

    @Resource
    private BizLogIntegrationService bizLogIntegrationService;

    @Resource
    private AssemblyService assemblyService;

    @Resource
    private NewsReadRewardService newsReadRewardService;

    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    @Resource
    private NewsMapper newsMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;

    @Resource
    private ForumPostRecordMapper forumPostRecordMapper;

    @Resource
    private BizConfigProperties bizConfigProperties;

    @Resource
    private QuartzIntegrationService quartzIntegrationService;

    @Resource
    private RedisListAdapter redisListAdapter;

    @Resource
    private LocationIntegrationService locationIntegrationService;

    @Resource
    private MessageIntegrationService messageIntegrationService;

    @Resource
    private MissionIntegrationService missionIntegrationService;

    @Resource
    private ForumBasicConvert forumBasicConvert;

    @Resource
    private NewsReplyMapper newsReplyMapper;

    @Resource
    private ForumParamPageConvert forumParamPageConvert;

    @Resource
    private ForumTopPostConvert forumTopPostConvert;

    @Resource
    private ClientConfigProperties clientConfigProperties;

    @Resource
    private UserProperties userProperties;

    @Override
    public List<ForumVo> listForum(String areaCode, Integer enable, Long userId, Integer size, BasicParam basicParam) {
        if (null == size) {
            size = -1;
        }
        List<ForumVo> forumVoList = forumMapper.getForumList(areaCode, enable);

        if (CollectionUtils.isNotEmpty(forumVoList)) {

            //如果在首页展示，则需要加入最近浏览
            this.sortForm(forumVoList, userId);
            forumVoList = forumVoList.stream().distinct().collect(Collectors.toList());

            //如果传了数量，则做限制
            if (size != -1) {
                forumVoList = forumVoList.stream().limit(size).collect(Collectors.toList());
            }

            //填补分享链接
            forumVoList.forEach(e -> {
                e.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, e.getId(), userId));
                e.setShareUrl(bizConfigProperties.getH5ServerHost());
            });
            if (5 == basicParam.getPlatform() && bizConfigProperties.getAppletReviewEnable()) {
                ArrayList<Long> postIds = new ArrayList<>(Arrays.asList(
                        72317665317008L,
                        79585788760192L,
                        80775388106880L,
                        81892185086080L,
                        77973991071872L,
                        80669901684864L,
                        79211746459776L,
                        79211241126016L));

                forumVoList = forumVoList.stream().filter(e->!postIds.contains(e.getId())).collect(Collectors.toList());
            }

        }

        //todo 板块需要做个缓存[沈涛]
        return forumVoList;
    }

    /**
     * 个性化板块显示
     *
     * @param forumVoList
     * @param userId
     */
    private void sortForm(List<ForumVo> forumVoList, Long userId) {
        KeyGenerator forumKey = RedisConfig.FORUM_INFO.copy().appendKey(userId).appendKey("forum").appendKey("recent");
        if (redisListAdapter.size(forumKey) > 0) {
            List<Long> forumList = redisListAdapter.leftIndex(forumKey, redisListAdapter.size(forumKey), Long.class);
            if (CollectionUtils.isNotEmpty(forumList)) {

                List<ForumVo> existence = new ArrayList<>();

                for (Long id : forumList) {
                    for (ForumVo forumVo : forumVoList) {
                        if (forumVo.getId().equals(id)) {
                            existence.add(forumVo);
                        }
                    }
                }
                //将用户最近访问的放在第三个位置
                if (forumVoList.size() >= 2) {
                    forumVoList.addAll(2, existence);
                } else {
                    forumVoList.addAll(existence);
                }
            }
        }
    }

    @Override
    public ForumVo getForumDetail(Long id, Long userId) {
        this.updateForum(id, userId);
        ForumVo forumVo = forumMapper.selectForumById(id);
        forumVo.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, forumVo.getId(), userId));
        forumVo.setShareUrl(bizConfigProperties.getH5ServerHost());
        return forumVo;
    }

    /**
     * 保存用户最近浏览的板块，保存3天
     *
     * @param forumId
     * @param userId
     */
    private void updateForum(Long forumId, Long userId) {
        List<Long> ids = new ArrayList<>();
        ids.add(forumId);
        KeyGenerator forumKey = RedisConfig.FORUM_INFO.copy().appendKey(userId).appendKey("forum").appendKey("recent");
        if (redisListAdapter.size(forumKey) > 0) {
            List<Long> forumList = redisListAdapter.leftIndex(forumKey, redisListAdapter.size(forumKey), Long.class);
            ids.addAll(forumList);
        }
        ids = ids.stream().distinct().collect(Collectors.toList());
        logger.debug("根据id进入板块详情获取推荐流更新板块顺序,id:{},userId:{},redisKey:{}", forumId, userId, forumKey.gen());
        redisListAdapter.remove(forumKey);
        redisListAdapter.rightPush(forumKey, ids.toArray(new Long[0]));
        redisListAdapter.expire(forumKey, 3 * 24 * 60 * 60);
    }

    @Override
    public List<TopicVo> listTopic(String areaCode, Integer enable, Integer size, Long userId) {
        if (null == size) {
            size = -1;
        }
        List<TopicVo> topicVoList = forumMapper.getTopicList(areaCode, enable);
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            //如果数量传了2，则进行随机取
            if (size == 2) {

                topicVoList = topicVoList.stream().limit(6).collect(Collectors.toList());

                if (topicVoList.size()>2) {
                    List<TopicVo> randomTopicVoList = new ArrayList<>();
                    generateRandomTopic(topicVoList, randomTopicVoList);
                    topicVoList = randomTopicVoList;
                }

                logger.debug("获得话题:{}", JSONObject.toJSONString(topicVoList));

            }
            topicVoList.forEach(e -> {
                e.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, e.getId(), userId));
                e.setShareUrl(bizConfigProperties.getH5ServerHost());
            });
        }
        return topicVoList;
    }

    /**
     * 随机取两条话题
     *
     * @param originList
     * @param randomTopicVoList
     */
    private void generateRandomTopic(List<TopicVo> originList, List<TopicVo> randomTopicVoList) {
        logger.debug("随机取两条话题:{}", originList.size());
        if (CollectionUtils.isNotEmpty(originList)) {
            int random = RandomUtils.nextInt(0, originList.size());
            logger.debug("随机取数1:{}", random);
            randomTopicVoList.add(originList.get(random));
            originList.remove(random);
            if (CollectionUtils.isNotEmpty(originList)) {
                int random2 = RandomUtils.nextInt(0, originList.size());
                logger.debug("随机取数2:{}", random2);
                randomTopicVoList.add(originList.get(random2));
            }
        }
    }

    @Override
    public TopicVo getTopicDetail(Long id, Long userId) {
        TopicVo topicVo = forumMapper.selectTopicById(id);
        topicVo.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, topicVo.getId(), userId));
        topicVo.setShareUrl(bizConfigProperties.getH5ServerHost());
        return topicVo;
    }

    @Override
    public PageWarper<ForumPostVo> listForumPost(ForumPostListQueryParam param,BasicParam basicParam) {
        logger.debug("获取推荐流,param:{}", JSONObject.toJSON(param));

        PageWarper<ForumPostVo> forumPostPage = new PageWarper<>();

        List<Long> postIdList ;
        if (5 == basicParam.getPlatform() && bizConfigProperties.getAppletReviewEnable()&&3 == param.getType()) {
            postIdList = forumMapper.listPostRecommend(param);
        }else {
            //每访问一次板块详情，对其进行记录
            if (param.getRecommendType() == 1 && param.getForumId() != null) {
                this.updateForum(param.getForumId(), param.getUserId());
            }

            //包装参数，从推荐引擎中获取相应的帖子id
            ForumParam forumParam = forumParamPageConvert.convert(param);
            postIdList = newsRecommendIntegrationService.recommendList(forumParam);

        }
        if (CollectionUtils.isNotEmpty(postIdList)) {
            List<ForumPostVo> postList = forumMapper.listPostByIds(postIdList);
            forumPostPage.setList(postList);
            forumPostPage.setPageNum(param.getPageNum());
            forumPostPage.setPageSize(param.getPageSize());
            fillExtInfo(forumPostPage.getList(), param.getUserId(), param.getAreaCode());
        }

        if (CollectionUtils.isEmpty(postIdList) || postIdList.size() < param.getPageSize()) {
            forumPostPage.setIsLastPage(true);
            forumPostPage.setHasNextPage(false);
        } else {
            forumPostPage.setHasNextPage(true);
        }

        logger.debug("[listForumPost]拉取帖子列表完毕,结果:{}", StringUtils.substring(JSONObject.toJSONString(JSONObject.toJSONString(forumPostPage)), 0, 500));


        return forumPostPage;
    }

    @Override
    public PageWarper<ForumPostVo> listForumPostByUser(ForumPostListUserQueryParam param) {
        PageWarper<ForumPostVo> forumPostWarper = new PageWarper<>();

        if (null == param || null == param.getType()) {
            return null;
        }
        if (1 == param.getType()) {
            forumPostWarper = new PageWarper<>(forumMapper.getPostList(param));
        } else if (2 == param.getType()) {
            forumPostWarper = new PageWarper<>(forumMapper.getCollectPostList(param));
        }

        if (CollectionUtils.isNotEmpty(forumPostWarper.getList())) {
            this.fillExtInfo(forumPostWarper.getList(), param.getUserId(), null);
        }

        return forumPostWarper;
    }

    @Override
    public ForumPostVo getForumPostDetail(Long id, Long userId, String deviceId, Long shareUserId, BasicParam basicParam, String areaCode) {
        ForumPostVo forumPostVo = forumMapper.getPostDetailById(id);

        String locationName = null;
        if (StringUtils.isNotEmpty(areaCode)) {
            LocationDTO location = locationIntegrationService.getLocationByGeocode(areaCode);
            if (null != location) {
                locationName = location.getName();
            }
        }
        this.completePostInfo(forumPostVo, userId, locationName);

        if (null != forumPostVo) {
            if (forumPostVo.getStatus() != null && (3 == forumPostVo.getStatus() || 4 == forumPostVo.getStatus())) {
                return null;
            }
            if (StringUtils.isNotEmpty(forumPostVo.getContent())) {
                // 1是h5的标志，h5在内嵌在app时，继承上级上下文，所以platforum不能区分
                if (StringUtils.equals("1", deviceId)) {
                    //取body的内容
                    forumPostVo.setContent(assemblyService.fixContent(forumPostVo.getContent()));
                } else {
                    String content = assemblyService.assemblyContent(forumPostVo.getContent());
                    forumPostVo.setContent(content);
                }
                //小程序隐藏帖子中的视频
                if (basicParam.getPlatform() == 5) {
                    String appletsContent = assemblyService.deleteVideoLabel(forumPostVo.getContent());
                    forumPostVo.setContent(appletsContent);
                }
//                forumPostVo.setContent(assemblyService.deleteNbspFromVideo(forumPostVo.getContent()));
            }
             //添加帖子阅读记录
            this.doRecordForumPost(userId, id, shareUserId, basicParam.getPlatform(), forumPostVo);
            //Android,ios,H5 拼接编辑寄语到content
            int platform = basicParam.getPlatform();
            boolean flag = (platform == 1 || platform == 2 || platform == 3) && StringUtils.isNotBlank(forumPostVo.getEditorMessage());
            if (flag){
                forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getEditorMessage());
            }
            //帖子分享,在在小程序中每日首次打开,分享人随机获得20-50的小红花
            SpringContextHolder.getBean(ForumService.class).doAsyncReadPost(userId, id, shareUserId, basicParam.getPlatform(), forumPostVo);

        }

        return forumPostVo;
    }

    @Override
    public Message doCreateOrUpdatePost(ForumBasicVo forumBasicVo) {
        if (sensitiveWordService.contains(forumBasicVo.getTextField())) {
            return Message.build(false);
        }

        Message message = Message.build(true);
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();

        //转换实体
        ForumPostVo forumPostVo = forumBasicConvert.convert(forumBasicVo);

        if (null == forumPostVo.getId()) {
            //保存帖子至数据库
            this.saveForumPost(forumPostVo);

            //将用户发的帖放入至redis中
            SpringContextHolder.getBean(ForumService.class).doAsyncCallService(forumPostVo);
            SpringContextHolder.getBean(ForumService.class).createPostUserTopTaskJob(forumPostVo);

            //完成任务
            newsCompleTaskDTO = completeTask(forumPostVo, forumBasicVo.getUserId(), forumPostVo.getId());

        } else {
            //修改帖子后需要后台进行审核，审核通过方可改变状态
            this.forumPostMapper.deleteMixRecommandPoolById(forumPostVo.getId());
            this.forumMapper.updateByPrimaryKeySelective(forumPostVo);
        }

        //更新话题信息
        this.updateTopic(forumPostVo);

        //拼装返回实体
        ForumPostCreateDTO forumPostCreateDTO = generateForumPost(forumPostVo, newsCompleTaskDTO, forumBasicVo.getUserId());
        message.addParam("completeTaskAndPush", forumPostCreateDTO);

        return message;
    }

    /**
     * 拼装返回实体
     *
     * @param forumPostVo
     * @param newsCompleTaskDTO
     * @param userId
     * @return
     */
    private ForumPostCreateDTO generateForumPost(ForumPostVo forumPostVo, NewsCompleTaskDTO newsCompleTaskDTO, Long userId) {
        ForumPostCreateDTO.ForumPost forumPost = new ForumPostCreateDTO.ForumPost();
        forumPost.setId(forumPostVo.getId());
        if (CollectionUtils.isNotEmpty(forumPostVo.getPostImgList())) {
            forumPost.setPostImgUrl(forumPostVo.getPostImgList().get(0).getImgUrl());
        }
        forumPost.setTextField(forumPostVo.getTextField());
        forumPost.setTitle(forumPostVo.getTitle());

        ForumPostCreateDTO forumPostCreateDTO = new ForumPostCreateDTO();
        forumPostCreateDTO.setGoldNum(Objects.isNull(newsCompleTaskDTO.getGoldNum()) ? 0 : newsCompleTaskDTO.getGoldNum());
        forumPostCreateDTO.setTaskName(newsCompleTaskDTO.getTaskName());
        forumPostCreateDTO.setTotalGold(newsCompleTaskDTO.getTotalGold());
        forumPostCreateDTO.setShareUrl(iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), userId));
        forumPostCreateDTO.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), userId));
        forumPostCreateDTO.setForumPost(forumPost);
        return forumPostCreateDTO;
    }

    /**
     * 完成任务
     *
     * @param forumPostVo
     * @param userId
     * @param postId
     * @return
     */
    private NewsCompleTaskDTO completeTask(ForumPostVo forumPostVo, Long userId, Long postId) {
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        String textField = forumPostVo.getTextField();
        if (CharUtil.isCharSatisfied(textField, 20)) {
            //首次发帖
            newsCompleTaskDTO = missionIntegrationService.compleTask(userId, TaskEnum.TASK_FIRST_POST_INTIVATION.name(), postId.toString());
            //日常发帖
            if (null == newsCompleTaskDTO || null == newsCompleTaskDTO.getGoldNum() || 0L == newsCompleTaskDTO.getGoldNum()) {
                newsCompleTaskDTO = missionIntegrationService.compleTask(userId, TaskEnum.TASK_POST_INTIVATION.name(), postId.toString());
            }
        }
        return newsCompleTaskDTO;
    }

    /**
     * 保存帖子入库
     *
     * @param forumPostVo
     */
    private void saveForumPost(ForumPostVo forumPostVo) {
        forumPostVo.setId(getPostId());
        UserBean user = userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
        if (null != user) {
            if (StringUtils.isBlank(user.getHeadImg()) || StringUtils.isBlank(user.getNickname())){
                logger.info("帖子保存用户头像或昵称为空,userInfo={}",JSON.toJSONString(user));
            }
            forumPostVo.setUserImg(user.getHeadImg());
            forumPostVo.setUserName(user.getNickname());
        }
        forumPostVo.setCreateTime(new Date());
        forumPostVo.setDisplayDateTime(new Date());
        forumPostVo.setPublishTime(new Date());
        this.forumMapper.insertSelective(forumPostVo);
    }

    /**
     * 更新话题
     *
     * @param forumPostVo
     */
    private void updateTopic(ForumPostVo forumPostVo) {
        if (CollectionUtils.isNotEmpty(forumPostVo.getTopicIdList())) {
            List<PostTopicDTO> list = new ArrayList<>();
            for (Long topicId : forumPostVo.getTopicIdList()) {
                PostTopicDTO postTopicDTO = new PostTopicDTO();
                postTopicDTO.setId(sequenceCreater.nextLongId());
                postTopicDTO.setPostId(forumPostVo.getId());
                postTopicDTO.setTopicId(topicId);
                list.add(postTopicDTO);
            }
            this.forumMapper.batchDeleteTopic(forumPostVo.getId());
            this.forumMapper.batchInsertTopic(list);
        }
    }

    @Override
    @Async
    public void doAsyncCallService(ForumPostVo forumPostVo) {
        try {
            userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), 1);
            bizLogIntegrationService.forumSuccessed(forumPostVo.getUserId(), forumPostVo.getAreaCode(), null);
        } catch (Exception e) {
            logger.debug("新增帖子调用服务失败：", e);
        }
    }

    @Async
    @Override
    public void createPostUserTopTaskJob(ForumPostVo forumPostVo) {
        ForumTopPost forumTopPost = forumTopPostConvert.convert(forumPostVo);
        logger.debug("[createPostUserTopTaskJob]用户发帖完毕，开始处理用户置顶帖子:{}", JSONObject.toJSONString(forumTopPost));
        KeyGenerator postUserTop = RedisConfig.FORUM_RECOMMENDED.copy().appendKey(forumPostVo.getUserId()).appendKey("top");
        Long size = redisListAdapter.size(postUserTop);
        List<ForumTopPost> result = new ArrayList<>();
        if (size == 0) {
            result.add(forumTopPost);
        } else {
            List<ForumTopPost> forumTopPostList = redisListAdapter.leftIndex(postUserTop, size - 1, ForumTopPost.class);
            forumTopPostList.add(forumTopPost);
            result = forumTopPostList.stream().sorted(Comparator.comparing(ForumTopPost::getId).reversed()).collect(Collectors.toList());
        }
        logger.debug("[createPostUserTopTaskJob]将用户帖子置顶存入redis中:{}", JSONObject.toJSONString(result));
        redisListAdapter.remove(postUserTop);
        redisListAdapter.rightPush(postUserTop, result.toArray(new ForumTopPost[0]));
        redisListAdapter.expire(postUserTop, 60 * 60);

        UserTopPostBuildParam param = new UserTopPostBuildParam();
        param.setPostId(forumPostVo.getId());
        param.setUserId(forumPostVo.getUserId());
        param.setAddTime(forumPostVo.getCreateTime());
        logger.debug("创建发布帖子置顶:{}", JSON.toJSONString(param));
        quartzIntegrationService.removePostUserTopTask(param);
    }

    @Override
    public Boolean deleteForumPost(Long id) {
        logger.debug("开始删除帖子，id：" + id);
        ForumPostVo forumPostVo = this.forumMapper.getPostDetailById(id);
        if (forumPostVo == null) {
            return false;
        }
        forumPostVo.setStatus(4);
        this.forumMapper.updateByPrimaryKeySelective(forumPostVo);
        this.forumPostMapper.deleteMixRecommandPoolById(id);

        //在帖子被删后仍需被匹配标签
        //this.forumMapper.deletePostTag(id);

        logger.debug("开始回收金币，id：" + id);
        Integer goldNum = userAccountIntegrationService.countGoldByPostId(id, forumPostVo.getUserId());
        if (null != goldNum && goldNum > 0) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(forumPostVo.getUserId());
            param.setGold(-goldNum);
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("TASK_POST_DELETE");
            param.setAddTotal(false);
            param.setRelationId(id);
            userAccountIntegrationService.addGold(param);
        }

        //清除用户临时置顶帖子
        newsRecommendIntegrationService.cleanUserTop(forumPostVo.getUserId(), forumPostVo.getId());

        //更新用户发布数
        userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), 2);
        logger.debug("帖子删除完成，id：" + id);
        return true;
    }

    @Override
    public void fillExtInfo(List<ForumPostVo> forumPostList, Long userId, String areaCode) {
        String locationName = null;
        if (StringUtils.isNotEmpty(areaCode)) {
            LocationDTO location = locationIntegrationService.getLocationByGeocode(areaCode);
            if (null != location) {
                locationName = location.getName();
            }
        }

        List<Long> postId = forumPostList.stream().map(ForumPostVo::getId).collect(Collectors.toList());

        List<PostTopicVO> postTopicVOList = forumMapper.listPostTopic(postId);
        postTopicVOList.forEach(e -> {
            e.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, e.getId(), userId));
            e.setShareUrl(bizConfigProperties.getH5ServerHost());
        });
        List<PostForumVO> postForumVOList = forumMapper.listPostForum(postId);
        postForumVOList.forEach(e -> {
            e.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, e.getId(), userId));
            e.setShareUrl(bizConfigProperties.getH5ServerHost());
        });
        List<Long> postLikeIdList = forumMapper.listUserPostLike(userId);
        List<Long> postCollectIdList = forumMapper.listUserPostCollect(userId);

        if (!CollectionUtils.isEmpty(forumPostList)) {
            for (ForumPostVo forumPostVo : forumPostList) {
                this.completePostInfo(forumPostVo, userId, locationName, postForumVOList, postTopicVOList, postLikeIdList, postCollectIdList);
            }
        }
    }

    @Override
    public void doRecordForumPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo) {

        ForumPostRecord pRecord = this.forumPostRecordMapper.selectByIds(postId, userId, null);
        Date d = new Date();
        if (pRecord != null) {
            pRecord.setUpdateTime(d);
            this.forumPostRecordMapper.updateByPrimaryKeySelective(pRecord);
        } else {
            ForumPostRecord nr = new ForumPostRecord();
            nr.setId(nextSequence());
            nr.setPostId(postId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(0);
            nr.setGetGold(AppConst.UN_GOLD);
            nr.setAddTime(d);
            nr.setLastLocation("1");
            nr.setAdViewType((byte) 1);
            this.forumPostRecordMapper.insertSelective(nr);
        }

        this.doConsumeClickCount(postId, userId);
    }

    @Async
    @Override
    public void doAsyncReadPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo) {
        if (5 == platform && Objects.nonNull(shareUserId) && !shareUserId.equals(userId)) {
            //用户首次打开小程序完成
            NewsCompleTaskDTO firstBrowse = missionIntegrationService.compleTask(shareUserId, TaskEnum.TASK_FISRT_BROWSE.name(), userId.toString());
            logger.info("用户={}在小程序中打开帖子,新闻id={},分享人的shareUserId={},完成任务接口返回={}",userId,forumPostVo.getId(),shareUserId,JSONObject.toJSONString(firstBrowse));
            if (Objects.nonNull(firstBrowse) && firstBrowse.getGoldNum() > 0) {
                //提取必要信息
                String extendContent = null;
                String extendUrl = getExtendUrl(forumPostVo.getImgList());
                if (com.bxm.newidea.component.tools.StringUtils.isEmpty(extendUrl)) {
                    extendContent = getExtendContent(forumPostVo.getTitle(), forumPostVo.getContent());
                }

                messageIntegrationService.addMessage(
                        shareUserId,
                        userId,
                        firstBrowse,
                        forumPostVo.getId(),
                        ReplyTypeEnum.POST_REPLY.getCode(),
                        extendUrl,
                        extendContent,
                        forumPostVo.getTitle());
            }
        }
    }

    /**
     * 提取帖子中的第一张图片
     *
     * @param imgStr
     * @return
     */
    private String getExtendUrl(String imgStr) {
        //视频封面暂不需要
        List<PostImgVo> postImgVos = JSONObject.parseArray(imgStr, PostImgVo.class);
        List<PostImgVo> imageList = postImgVos.stream().filter(e -> StringUtils.equalsIgnoreCase("IMG", e.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(imageList)) {
            return imageList.get(0).getImgUrl();
        }
        return null;
    }

    /**
     * 提取帖子中的前10个内容
     *
     * @param title
     * @param content
     * @return
     */
    private String getExtendContent(String title, String content) {
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank(title)) {
            return title;
        } else {
            return HtmlContentUtils.getHtmlDesc(content, 10);
        }
    }

    /**
     * 为详情提供的实体属性填充
     *
     * @param forumPostVo
     * @param userId
     * @param locationName
     */
    private void completePostInfo(ForumPostVo forumPostVo, Long userId, String locationName) {
        if (forumPostVo != null) {
            if (null != forumPostVo.getForumId()) {
                ForumVo forumVo = forumMapper.selectForumById(forumPostVo.getForumId());
                if (null != forumVo) {
                    forumVo.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, forumVo.getId(), userId));
                    forumVo.setShareUrl(bizConfigProperties.getH5ServerHost());
                    forumPostVo.setForum(forumVo);
                }
            }
            List<TopicVo> topicVoList = forumMapper.getTopicListByPostId(forumPostVo.getId());
            if (CollectionUtils.isNotEmpty(topicVoList)) {
                topicVoList.forEach(e -> {
                    e.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, e.getId(), userId));
                    e.setShareUrl(bizConfigProperties.getH5ServerHost());
                });
                forumPostVo.setTopicList(topicVoList);
            }

            if (null != userId) {
                Integer like = this.forumMapper.getUserPostLike(forumPostVo.getId(), userId);
                if (null != like && 1 == like) {
                    forumPostVo.setLiked(1);
                } else {
                    forumPostVo.setLiked(0);
                }

                Integer count = this.forumMapper.countUserPostCollect(forumPostVo.getId(), userId);
                if (null != count && count > 0) {
                    forumPostVo.setCollected(1);
                } else {
                    forumPostVo.setCollected(0);
                }
            }

            this.completeCommonPostInfo(forumPostVo, locationName, userId);
        }
    }

    /**
     * 专为列表提供的实体属性填充
     *
     * @param forumPostVo       帖子实体
     * @param userId            用户id
     * @param locationName      位置名称
     * @param forumVoList       帖子列表所在的板块列表
     * @param postTopVoList     帖子列表所在的话题列表
     * @param postLikeIdList    用户对帖子的点赞列表
     * @param postCollectIdList 用户对帖子的收藏列表
     */
    private void completePostInfo(ForumPostVo forumPostVo,
                                  Long userId,
                                  String locationName,
                                  List<PostForumVO> forumVoList,
                                  List<PostTopicVO> postTopVoList,
                                  List<Long> postLikeIdList,
                                  List<Long> postCollectIdList) {
        if (forumPostVo != null) {
            if (null != forumPostVo.getForumId()) {
                Optional<PostForumVO> forumVoOptional = forumVoList.stream().filter(e -> e.getPostId().equals(forumPostVo.getId())).findFirst();
                forumVoOptional.ifPresent(forumPostVo::setForum);
            }

            if (CollectionUtils.isNotEmpty(postTopVoList)) {
                List<TopicVo> topicVoList = postTopVoList.stream().filter(e -> e.getPostId().equals(forumPostVo.getId())).collect(Collectors.toList());
                forumPostVo.setTopicList(topicVoList);
            }

            if (null != userId) {
                boolean postLikeFlag = postLikeIdList.stream().anyMatch(e -> e.equals(forumPostVo.getId()));
                if (postLikeFlag) {
                    forumPostVo.setLiked(1);
                } else {
                    forumPostVo.setLiked(0);
                }

                boolean postCollectFlag = postCollectIdList.stream().anyMatch(e -> e.equals(forumPostVo.getId()));
                if (postCollectFlag) {
                    forumPostVo.setCollected(1);
                } else {
                    forumPostVo.setCollected(0);
                }
            }

            if (CollectionUtils.isNotEmpty(forumPostVo.getReplyInfo())) {
                forumPostVo.setLeftRelyNum(forumPostVo.getCommentCount() - forumPostVo.getReplyInfo().size());
            } else {
                forumPostVo.setLeftRelyNum(forumPostVo.getCommentCount());
            }

            this.completeCommonPostInfo(forumPostVo, locationName, userId);
        }
    }

    /**
     * 帖子列表和详情->通用属性的实体填充
     *
     * @param forumPostVo
     * @param locationName
     * @param userId
     */
    private void completeCommonPostInfo(ForumPostVo forumPostVo, String locationName, Long userId) {
        if (null == forumPostVo.getLocation()) {
            forumPostVo.setLocation(locationName);
        }

        if (StringUtils.isNotBlank(forumPostVo.getTextField())) {
            forumPostVo.setTextField(StringEscapeUtils.unescapeHtml(forumPostVo.getTextField()));
        }

        if (StringUtils.isNotBlank(forumPostVo.getContent())) {
            forumPostVo.setContent(StringEscapeUtils.unescapeHtml(forumPostVo.getContent()));
        }

        if (StringUtils.isNotBlank(forumPostVo.getImgList())) {
            forumPostVo.setPostImgList(JSON.parseArray(forumPostVo.getImgList(), PostImgVo.class));
        }

        if (null != forumPostVo.getDisplayDateTime()) {
            forumPostVo.setDisplayTime(DateUtils.timeConvertString(forumPostVo.getDisplayDateTime()));
        }

        forumPostVo.setShareUrl(iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), userId));
        forumPostVo.setAppletShareUrl(iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), userId));
    }

    @Override
    public NewsCompleTaskDTO doShareForumPost(Long userId, Long postId, String areaCode, Byte type, Integer platform) {
        NewsCompleTaskDTO completeTaskDTO = new NewsCompleTaskDTO();

        bizLogIntegrationService.shareForumSuccessed(userId, postId, areaCode, platform);
        Json<NewsCompleTaskDTO> result = newsReadRewardService.saveShareForums(postId, userId, type);
        if (null != result) {
            completeTaskDTO = result.getResult();
        }

        return completeTaskDTO;
    }

    @Override
    public void doLikeForumPost(Long userId, Long postId, int type, String areaCode, Integer platform) {
        ForumPostLike postLike = forumPostLikeMapper.selectByUserIdAndPostId(userId, postId);
        UserBean userBean = userIntegrationService.selectUserFromCache(userId);

        this.generateForumPostLike(postLike, type, postId, userId, userBean);

        this.doUpdateForumInfo(type, postId);

        SpringContextHolder.getBean(ForumService.class).doAsyncLikePost(userId, postId, type, areaCode, (byte) 1, platform);
    }

    /**
     * 生成一条帖子点赞记录
     *
     * @param postLike
     * @param type
     * @param postId
     * @param userId
     * @param userBean
     */
    private Long generateForumPostLike(ForumPostLike postLike, int type, Long postId, Long userId, UserBean userBean) {
        String updateHeadImg = StringUtils.isBlank(userBean.getHeadImg()) ? userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg();
        String updateNickname = StringUtils.isBlank(userBean.getNickname())? null : userBean.getNickname();
        long id;
        if (Objects.isNull(postLike)) {
            id = nextId();
            ForumPostLike forumPostLike = ForumPostLike.buildPostLike(postId, userId);
            forumPostLike.setId(id);
            forumPostLike.setType((byte) type);
            forumPostLike.setHeadImg(updateHeadImg);
            forumPostLike.setUserNickname(updateNickname);
            //插入点赞表
            forumPostLikeMapper.insertSelective(forumPostLike);
        } else {
            id = postLike.getId();
            postLike.setType((byte) type);
            postLike.setHeadImg(updateHeadImg);
            postLike.setUserNickname(updateNickname);
            forumPostLikeMapper.updateByPrimaryKeySelective(postLike);
        }
        return id;
    }

    /**
     * 更新帖子点赞数量
     *
     * @param type
     * @param postId
     */
    private void doUpdateForumInfo(int type, Long postId) {
        //更新帖子点赞数量
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setId(postId);
        forumPostStatistic.setLikeCount(type == 0 ? -1 : 1);

        //维护帖子点赞概览信息
        List<ForumPostLike> forumPostLikes = forumPostLikeMapper.selectByPostIdAndOrderByAddtime(postId);
        if (CollectionUtils.isNotEmpty(forumPostLikes)) {
            forumPostStatistic.setLikeInfo(JSONObject.toJSONString(forumPostLikes));
        }
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Async
    @Override
    public void doAsyncLikePost(Long userId, Long postId, int type, String areaCode, byte isOld, Integer platform) {
        if (1 == type) {
            ForumPostVo forumPostVo = forumMapper.getPostDetailById(postId);
            //添加马甲号点赞(旧版没有马甲号点赞)
            this.generateVirtualLike(forumPostVo, isOld);
            //数据埋点(马甲号点赞时没有platform)
            if (Objects.nonNull(platform)) {
                bizLogIntegrationService.forumLikeSuccessed(userId, postId, areaCode, platform);
            }else{
                //马甲号点赞调用新版文文案接口 isOld = 0为新版文案接口
                isOld = 0;
            }
            //消息推送(新旧版文案不一)
            this.messageIntegrationService.pushPostLikeMessage(forumPostVo, userId, isOld,getPostLikeConsume(forumPostVo.getIsBrilliant()));

        }
    }

    /**
     * 生成机器人点赞信息
     *
     * @param forumPostVo
     * @param isOld       是否是旧版点赞 1：旧版 0：新版
     */
    private void generateVirtualLike(ForumPostVo forumPostVo, int isOld) {
        if (isOld == 0) {
            //当用户已经在该条帖子发布评论时,或者获得虚拟用户为空时 重新获得虚拟用户
            List<VirtualUserInfo> virtualUserList = userIntegrationService.getVirtualUserList(20);
            if (CollectionUtils.isNotEmpty(virtualUserList)) {
                for (VirtualUserInfo virtualUserInfo : virtualUserList) {
                    ForumPostLike like = forumPostLikeMapper.selectByUserIdAndPostId(virtualUserInfo.getId(), forumPostVo.getId());
                    if (Objects.isNull(like)) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(Calendar.MINUTE, 3);
                        ForumPostLike postLike = ForumPostLike.buildVestPostLike(nextId(), forumPostVo.getId(), virtualUserInfo.getId());
                        postLike.setAddTime(calendar.getTime());
                        postLike.setHeadImg(virtualUserInfo.getHeadImg());
                        postLike.setUserNickname(virtualUserInfo.getNickname());
                        forumPostLikeMapper.insertSelective(postLike);
                        logger.info("添加马甲点赞成功,点赞信息:{}", JSONObject.toJSONString(postLike));
                        break;
                    }
                }
            }
        }
    }

    @Override
    public Message doInformForumPost(ForumPostInformParam param) {
        ForumPostInform forumPostInformParam = new ForumPostInform();
        forumPostInformParam.setPostId(param.getPostId());
        forumPostInformParam.setUserId(param.getUserId());
        List<ForumPostInform> informList = this.forumPostInformMapper.selectByModel(forumPostInformParam);
        if (CollectionUtils.isNotEmpty(informList)) {
            return Message.build(false, "您已举报过");
        }
        ForumPostInform forumPostInform = new ForumPostInform();
        BeanUtils.copyProperties(param, forumPostInform);
        forumPostInform.setId(nextSequence());
        this.forumPostInformMapper.insertSelective(forumPostInform);
        return Message.build(true);
    }

    @Override
    public void doCollectForumPost(Long userId, Long postId) {
        ForumPostCollect forumPostCollect = forumPostCollectMapper.selectUserCollect(new ForumPostCollect(userId, postId));

        int num;
        //插入收藏表
        if (!ObjectUtils.isEmpty(forumPostCollect)) {
            this.forumPostCollectMapper.deleteByPrimaryKey(forumPostCollect.getId());
            num = -1;
        } else {
            ForumPostCollect newForumPostCollect = new ForumPostCollect();
            newForumPostCollect.setAddTime(new Date());
            newForumPostCollect.setId(nextSequence());
            newForumPostCollect.setPostId(postId);
            newForumPostCollect.setUserId(userId);
            forumPostCollectMapper.insertSelective(newForumPostCollect);
            num = 1;
        }

        //更新收藏数量
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setCollectCount(num);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeRecommendedCount(List<Long> ids, Long userId) {
        List<ForumPostStatistic> forumPostStatisticList =
                ids.stream().map(id -> ForumPostStatistic.buildRecommend(id, 1)).collect(Collectors.toList());
        MybatisBatchBuilder.create(ForumPostMapper.class, forumPostStatisticList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public void doConsumeClickCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setClickCount(1);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeActiveViewCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setReviewCount(1);
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Async
    @Override
    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
        List<ForumPostVo> forumPostVoList = forumMapper.selectForumPostByUser(userId);
        for (ForumPostVo forumPostVo : forumPostVoList) {
            forumPostMapper.updateUserInfo(forumPostVo.getId(), userId, headImg, nickname);
        }
    }

    @Override
    public void doSavePostClick(Long postId, Long clickCount) {
        this.forumPostMapper.addPostClick(postId, clickCount);
    }

    @Override
    public void calcParticipantsNum() {
        logger.info("calculate participants num start. ");

        //计算版块参与人数
        List<ForumVo> forumVoList = forumMapper.getForumList(null, 0);
        if (CollectionUtils.isNotEmpty(forumVoList)) {
            for (ForumVo forumVo : forumVoList) {
                Integer participantsNum = forumMapper.calcPostNum(forumVo.getId(), null);
                if (null == participantsNum) {
                    participantsNum = 0;
                }

                List<Long> postIdList = forumMapper.getPostIdList(forumVo.getId(), null);
                if (CollectionUtils.isNotEmpty(postIdList)) {
                    for (Long postId : postIdList) {
                        Integer replyNum = forumMapper.calcReplyNum(postId);
                        if (replyNum != null) {
                            participantsNum += replyNum;
                        }
                    }
                }
                forumMapper.updateForum(forumVo.getId(), participantsNum);
            }
        }

        //计算话题参与人数
        List<TopicVo> topicVoList = forumMapper.getTopicList(null, 0);
        if (CollectionUtils.isNotEmpty(topicVoList)) {
            for (TopicVo topicVo : topicVoList) {
                Integer participantsNum = forumMapper.calcPostNum(null, topicVo.getId());
                if (null == participantsNum) {
                    participantsNum = 0;
                }

                List<Long> postIdList = forumMapper.getPostIdList(null, topicVo.getId());
                if (CollectionUtils.isNotEmpty(postIdList)) {
                    for (Long postId : postIdList) {
                        Integer replyNum = forumMapper.calcReplyNum(postId);
                        if (replyNum != null) {
                            participantsNum += replyNum;
                        }
                    }
                }
                forumMapper.updateTopic(topicVo.getId(), participantsNum);
            }
        }

        logger.info("calculate participants num end. ");
    }

    @Override
    public List<News4Client> listPostDetailRecommend(Long postId, Long userId, Integer size, String areaCode) {
        ForumParam forumParam = generateForumParam(size, postId, userId, areaCode);

        List<Long> idList = newsRecommendIntegrationService.recommendList(forumParam);
        logger.debug("[listPostDetailRecommend]新闻详情推荐：{}", JSONObject.toJSONString(idList));
        List<MixRecommendDTO> mixRecommendDTOList = ForumPostConvert.convertIds2MixRecommendDTO(idList);

        return SpringContextHolder.getBean(RecommendService.class).listNews4Client(mixRecommendDTOList, userId, areaCode);
    }

    private ForumParam generateForumParam(Integer size, Long postId, Long userId, String areaCode) {
        if (null == size) {
            size = 5;
        }
        ForumParam forumParam = new ForumParam();
        forumParam.setOperationId(7);
        forumParam.setPostId(postId);
        forumParam.setUserId(userId);
        forumParam.setAreaCode(areaCode);
        if (size == 5) {
            forumParam.setPostNum(3);
            forumParam.setNewsNum(2);
        } else if (size == 15) {
            forumParam.setPostNum(10);
            forumParam.setNewsNum(5);
        }
        return forumParam;
    }

    @Override
    public ReplenishmentDTO getHotPostOrNews(Long userId, String areaCode, Byte type) {
        if (null == type) {
            type = 3;
        }
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        MixedRecommendPool mixedRecommendPool = mixedRecommendPoolMapper.selectHotRecommend(areaCode, userId);
        logger.info("[getHotPostOrNews]得到权重最高的帖子或者新闻，推荐库中权重最高:{}", JSONObject.toJSONString(mixedRecommendPool));
        if (null == mixedRecommendPool) {
            return null;
        }
        replenishmentDTO.setId(mixedRecommendPool.getId());
        replenishmentDTO.setOrigin(mixedRecommendPool.getOrigin());
        replenishmentDTO.setTitle(mixedRecommendPool.getTitle());

        if ("1".equals(mixedRecommendPool.getOrigin())) {
            ForumPostVo postVo = forumMapper.getPostDetailById(mixedRecommendPool.getId());
            if (postVo != null) {
                if (StringUtils.isNotEmpty(postVo.getImgList())) {
                    List<PostImgVo> postImgList = JSON.parseArray(postVo.getImgList(), PostImgVo.class);
                    if (CollectionUtils.isNotEmpty(postImgList)) {
                        List<String> imgList = postImgList.stream().map(PostImgVo::getImgUrl).collect(Collectors.toList());
                        String[] imgStr = new String[imgList.size()];
                        replenishmentDTO.setImgList(imgList.toArray(imgStr));
                    }
                }
                if (StringUtils.isBlank(postVo.getTitle())) {
                    replenishmentDTO.setTitle(postVo.getTextField().substring(0, 10));
                }
            }

        } else if ("2".equals(mixedRecommendPool.getOrigin()) || "3".equals(mixedRecommendPool.getOrigin())) {
            News news = newsMapper.selectByPrimaryKey(mixedRecommendPool.getId());
            if (news != null) {
                if (StringUtils.isNotEmpty(news.getImgUrl())) {
                    JSONArray imgArray = JSON.parseArray(news.getImgUrl());
                    List<String> imgList = new ArrayList<>();
                    for (Object jsonpObject : imgArray) {
                        imgList.add((String) jsonpObject);
                    }
                    String[] imgStr = new String[imgList.size()];
                    replenishmentDTO.setImgList(imgList.toArray(imgStr));
                }
            }
        }


        logger.info("[getHotPostOrNews]得到权重最高的帖子或者新闻,结果:{}", JSONObject.toJSONString(replenishmentDTO));
        return replenishmentDTO;
    }


    @Override
    public PostLikeDto doLikeForumPost(Long postId, Long userId, String areaCode, String userNickname, String headImg, Integer platform) {
        PostLikeDto postLikeDto = new PostLikeDto();
        long id;
        ForumPostLike postLike = forumPostLikeMapper.selectByUserIdAndPostId(userId, postId);
        UserBean userBean = userIntegrationService.selectUserFromCache(userId);
        if (StringUtils.isBlank(userBean.getHeadImg()) || StringUtils.isBlank(userBean.getNickname())){
            logger.info("帖子点赞用户头像或昵称为空,userInfo={}", JSON.toJSONString(userBean));
        }
        //判断帖子是否被用户点赞,或者为是取消点赞状态
        if (Objects.isNull(postLike) || postLike.getType() == 0) {
            //生成帖子点赞记录
            id = this.generateForumPostLike(postLike, 1, postId, userId, userBean);

            //帖子概览数据的更新
            this.doUpdateForumInfo(1, postId);

            //判断是否是自己给自己点赞，如果是则只加点赞数
            ForumPostVo postVo = forumPostMapper.selectByPrimaryKey(postId);
            boolean flag = Objects.nonNull(userId) && Objects.nonNull(postVo.getUserId()) && userId.equals(postVo.getUserId());
            if (flag) {
                postLikeDto.setCode(PostLikeDto.successCode);
                postLikeDto.setCopyWriter(null);
                postLikeDto.setShowFlower(PostLikeDto.failureCode);
            } else {
                postLikeDto = calculateFlower(postVo, userId, id, areaCode, platform);
            }
        } else {
            return null;
        }
        return postLikeDto;
    }

    /**
     * 点赞之后对鲜花的增减以及返回包装类
     *
     * @param postVo
     * @param userId
     * @param id
     * @param areaCode
     * @param platform
     * @return
     */
    private PostLikeDto calculateFlower(ForumPostVo postVo, Long userId, Long id, String areaCode, int platform) {
        //根据是否精华帖获得赞赏鲜花的数量
        final int postLikeConsume = getPostLikeConsume(postVo.getIsBrilliant());

        //点赞用户减少红花
        Boolean consume = userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeExpendParam(userId, postLikeConsume, id));

        PostLikeDto postLikeDto = new PostLikeDto();
        if (consume) {
            //帖子作者增加红花
            userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeAddParam(postVo.getUserId(), postLikeConsume, id));

            //红花增减成功，填充返回实体
            postLikeDto.setAmount(postLikeConsume);
            postLikeDto.setCode(PostLikeDto.successCode);

            //自己给自己点赞没有文案
            fillPostLikeDto(postLikeDto, userId, postVo.getUserId(), postLikeConsume);

            //异步推送信息
            SpringContextHolder.getBean(ForumService.class).doAsyncLikePost(userId, postVo.getId(), 1, areaCode, (byte) 0, platform);
        } else {
            //扣除红花失败,回滚数据
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            //扣款失败
            postLikeDto.setCode(PostLikeDto.failureCode);
            postLikeDto.setShowFlower(PostLikeDto.failureCode);
            postLikeDto.setCopyWriter("你的小红花余额不足，快转发文章赚小红花");
        }
        return postLikeDto;
    }

    /**
     * 返回包装类，如已经点赞过两篇文章，则不返回文案
     *
     * @param postLikeDto
     * @param userId
     * @param authorUserId
     * @param postLikeConsume
     */
    private void fillPostLikeDto(PostLikeDto postLikeDto, Long userId, Long authorUserId, int postLikeConsume) {
        String dateKey = DateFormatUtils.format(new Date(), "yyyy-MM-dd");
        KeyGenerator forumPostLikeTimeKey = RedisConfig.FORUMPOST_LIEK_TIME.copy().appendKey(dateKey).appendKey(userId);
        //点赞次数
        long likeCount = redisStringAdapter.incrementWithDefault(forumPostLikeTimeKey, 1, 1, 86400);
        if (likeCount <= 2L) {
            postLikeDto.setCopyWriter("已赞赏作者" + postLikeConsume + "朵小红花");
            postLikeDto.setShowFlower(PostLikeDto.successCode);
        } else {
            postLikeDto.setCopyWriter(null);
            postLikeDto.setShowFlower(PostLikeDto.failureCode);
        }
    }

    @Override
    public int getPostLikeConsume(Integer isBrilliant) {
        if (Objects.isNull(isBrilliant) || isBrilliant == 0) {
            return clientConfigProperties.getPostCommonLikeConsume();
        } else {
            return clientConfigProperties.getPostBrilliantLikeConsume();
        }
    }

    @Override
    public List<ForumPostLikeDTO> getPostLikeDetail(Long id, Long userId, String devcId) {
        ArrayList<ForumPostLikeDTO> result = Lists.newArrayList();
        List<ForumPostLike> forumPostLikes = forumPostLikeMapper.selectPostById(id);
        forumPostLikes.forEach(e -> {
            ForumPostLikeDTO postLikeDTO = new ForumPostLikeDTO();
            BeanUtils.copyProperties(e, postLikeDTO);
            if (StringUtils.isBlank(postLikeDTO.getHeadImg())){
                postLikeDTO.setHeadImg(userProperties.getDefaultHeadImgUrl());
            }
            result.add(postLikeDTO);
        });
        return result;
    }

    @Override
    public int doRefreshLikeInfo() {
        Date currentTime = new Date();

        //根据时间查询要修改的帖子点赞信息
        List<ForumPostLike> postLikes = forumPostLikeMapper.selectNotShowPostLike(currentTime);

        //根据时间更新帖子点赞表信息
        int result = forumPostLikeMapper.updateNotShowPostLike(currentTime);

        postLikes.forEach(e -> {
            ForumPostVo postVo = forumPostMapper.selectByPrimaryKey(e.getPostId());
            final int postLikeConsume = getPostLikeConsume(postVo.getIsBrilliant());

            //用户添加金币
            AccountGoldParam usableParam = new AccountGoldParam(postVo.getUserId(), "USABLE_GOLD", true, postLikeConsume, e.getId(), "ARTICLE_LIKE_ADD");
            this.userAccountIntegrationService.addGold(usableParam);

            //帖子概览数据的更新
            this.doUpdateForumInfo(1, postVo.getId());

            //推送点赞信息(机器人点赞没有platform)
            SpringContextHolder.getBean(ForumService.class).doAsyncLikePost(e.getUserId(), e.getPostId(), 1, postVo.getAreaCode(), (byte) 1, null);

        });

        return result;
    }

    //---------------------------------------------------------------------------------------------------------------------------------------

    @Override
    public void doSyncPostLikeInfo() {
        List<Long> list = forumPostLikeMapper.selectNotExitsUserInfo();
        List<ForumPostLike> paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostLike postLike = new ForumPostLike();
            postLike.setUserId(e);
            UserInfoDTO userInfo = userIntegrationService.getUserInfo(e);
            if (Objects.nonNull(userInfo)) {
                postLike.setUserNickname(userInfo.getNickname());
                postLike.setHeadImg(userInfo.getHeadImg());
                paramList.add(postLike);
            }
        });
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, paramList).run(ForumPostLikeMapper::updateUserInfoByUserId);
    }

    @Override
    public void doSyncPostStaticInfo() {
        List<Long> list = forumPostMapper.selectNotExitReplyAndLikeInfo();
        List<ForumPostStatistic> paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
            forumPostStatistic.setId(e);
            List<NewsReply> replyList = newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(e);
            if (CollectionUtils.isNotEmpty(replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString(replyList));
            }
            List<ForumPostLike> forumPostLikes = forumPostLikeMapper.selectByPostIdAndOrderByAddtime(e);
            if (CollectionUtils.isNotEmpty(forumPostLikes)) {
                forumPostStatistic.setLikeInfo(JSONObject.toJSONString(forumPostLikes));
            }
            boolean flag = !(StringUtils.isBlank(forumPostStatistic.getLikeInfo()) && StringUtils.isBlank(forumPostStatistic.getReplyInfo()));
            if (flag) {
                paramList.add(forumPostStatistic);
            }
        });
        MybatisBatchBuilder.create(ForumPostMapper.class, paramList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public CalculatePostDTO calculatePostCount() {
        CalculatePostDTO calculatePostDTO = new CalculatePostDTO();

        Calendar instance = Calendar.getInstance();
        instance.add(Calendar.MINUTE, -30);
        Date time = instance.getTime();

        int pendingReviewCount = forumPostMapper.selectPendingReviewCount(time);
        calculatePostDTO.setPendingReviewCount(pendingReviewCount);

        int newPostCount = forumPostMapper.selectNewPostCount(time);
        calculatePostDTO.setNewPostCount(newPostCount);

        int userCount = forumPostMapper.selectUserCount(time);
        calculatePostDTO.setUserCount(userCount);

        return calculatePostDTO;
    }

    @Override
    public void doTriggerUpdateForumpostLikeInfo(Long userId, String nickname, String headImg) {
        if(StringUtils.isBlank(nickname) && StringUtils.isBlank(nickname)){
            return ;
        }
        forumPostMapper.updateNickNameAndHeadImgByUserId(userId,nickname,headImg);
    }

    /**
     * 获取帖子生成id，默认从4000000000000000开始
     *
     * @return
     */
    private Long getPostId() {
        KeyGenerator postKeyGenerator = RedisConfig.SEQ_POST_ID.copy();
        return redisStringAdapter.incrementWithDefault(postKeyGenerator, 4000000000000000L, 1);
    }
}
