package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.facade.NewsRecommendFeignService;
import com.bxm.localnews.integration.AppVersionIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.impl.ForumPostConvert;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.ForumPostDTO;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.news.param.HomeRecommendParam;
import com.bxm.localnews.news.param.VideoQueryParam;
import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.*;
import com.bxm.localnews.param.MixRecommendParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;


@Service("recommendService")
public class RecommendServiceImpl extends BaseService implements RecommendService {

    private MixedRecommendPoolMapper mixedRecommendPoolMapper;

    private MarketingActivitiesMapper marketingActivitiesMapper;

    private MarketingActivitiesRecommendedMapper marketingActivitiesRecommendedMapper;

    private AppVersionIntegrationService appVersionIntegrationService;

    private NewsProperties newsProperties;

    private VideoRecommendService videoRecommendService;

    private RedisStringAdapter redisStringAdapter;

    private NewsRecommendFeignService newsRecommendFeignService;

    private NewsSearchIntegrationService newsSearchIntegrationService;

    private NewsCollectMapper newsCollectMapper;

    private NewsService newsService;

    private DistributedLock distributedLock;

    private NewsRecommendIntegrationService newsRecommendIntegrationService;

    private ForumPostMapper forumPostMapper;

    private LocationIntegrationService locationIntegrationService;

    private ForumService forumService;

    @Autowired
    public RecommendServiceImpl(MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                MarketingActivitiesMapper marketingActivitiesMapper,
                                MarketingActivitiesRecommendedMapper marketingActivitiesRecommendedMapper,
                                AppVersionIntegrationService appVersionIntegrationService,
                                NewsProperties newsProperties,
                                VideoRecommendService videoRecommendService,
                                RedisStringAdapter redisStringAdapter,
                                NewsRecommendFeignService newsRecommendFeignService,
                                NewsSearchIntegrationService newsSearchIntegrationService,
                                NewsCollectMapper newsCollectMapper,
                                NewsService newsService,
                                DistributedLock distributedLock,
                                NewsRecommendIntegrationService newsRecommendIntegrationService,
                                ForumPostMapper forumPostMapper,
                                LocationIntegrationService locationIntegrationService,
                                ForumService forumService) {
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.marketingActivitiesMapper = marketingActivitiesMapper;
        this.marketingActivitiesRecommendedMapper = marketingActivitiesRecommendedMapper;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.newsProperties = newsProperties;
        this.videoRecommendService = videoRecommendService;
        this.redisStringAdapter = redisStringAdapter;
        this.newsRecommendFeignService = newsRecommendFeignService;
        this.newsSearchIntegrationService = newsSearchIntegrationService;
        this.newsCollectMapper = newsCollectMapper;
        this.newsService = newsService;
        this.distributedLock = distributedLock;
        this.newsRecommendIntegrationService = newsRecommendIntegrationService;
        this.forumPostMapper = forumPostMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.forumService = forumService;
    }

    @Override
    public Json<NewsMeta> execRecommend(NewsRecommendParam param,BasicParam basicParam) {
        logger.debug("[oldExecRecommend]新闻推荐请求+1：{}",param);
        int count = 0;
        return retry(param, count,basicParam);

    }

    private Json<NewsMeta> retry(NewsRecommendParam param, int count,BasicParam basicParam) {
        long begin = System.currentTimeMillis();
        NewsMeta meta = new NewsMeta();
//        if (count >= 3) {
//            logger.warn("[oldExecRecommend]老哥请求太快了，先给你返回个空:{}",JSONObject.toJSONString(param));
//            return ResultUtil.genSuccessResult(meta);
//        }
//        String requestId = String.valueOf(nextSequence());
//        String userId = String.valueOf(param.getUserId());

        List<Long> idList = new ArrayList<>();
//        if (distributedLock.lock(userId, requestId)) {
            // 调用推荐系统提供的推荐服务
            idList = newsRecommendIntegrationService.recommendList(param.getUserId(),
                    param.getKindId().intValue(),
                    param.getPagesize(),
                    param.getAreaCode(),
                    param.getCurPage());

            logger.debug("[oldExecRecommend]用户id:{},推荐引擎返回:{},耗时:{}", param.getUserId(), idList,System.currentTimeMillis() - begin);
            //解锁
//            distributedLock.unlock(userId, requestId);
//        } else {
//            logger.info("[oldExecRecommend]新闻推荐请求过快，请休息一会!参数:{}", JSON.toJSONString(param));
//            try {
//                // 休息 500ms
//                Thread.sleep(1000);
//            } catch (InterruptedException e) {
//                logger.error(e.getMessage(), e);
//            }
//            return retry(param, ++count,basicParam);
//        }


        if (CollectionUtils.isEmpty(idList)) {
            return ResultUtil.genSuccessResult(meta);
        }
        //从es中获取新闻列表信息
        List<News> list = newsSearchIntegrationService.listRecommendedNews(idList.toArray(new Long[0]));
        logger.debug("[oldExecRecommend]从es中获取新闻列表信息,耗时:{}", System.currentTimeMillis() - begin);

        //包装新闻
        List<News> result = packageNews(list, idList, param.getUserId(), param.getAreaCode());
        logger.debug("[oldExecRecommend]新闻包装(新闻&营销活动),耗时:{}", System.currentTimeMillis() - begin);

        //塞进新闻返回实体
        List<News4Client> news4ClientList = result.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
        logger.debug("[oldExecRecommend]新闻返回体包装,耗时:{}", System.currentTimeMillis() - begin);


        if (CollectionUtils.isEmpty(news4ClientList)) {
            return ResultUtil.genSuccessResult(meta);
        }
        //添加小视频
        if (!getPublishState(basicParam)) {
            if (param.getKindId() == null || this.newsProperties.getRecommendKindId() == param.getKindId()) {
                addRecommendVideo(param.getUserId(), param.getCurPage(), news4ClientList);
            }
        }
        logger.debug("[oldExecRecommend]小视频添加,耗时:{}", System.currentTimeMillis() - begin);

        meta.setList(news4ClientList);
        meta.setNewsCount(meta.getList().size());
        // 隐藏敏感信息
        hideInfo(param, meta);
        logger.debug("[oldExecRecommend]拉取新闻列表完毕,参数:{},耗时：{}",JSONObject.toJSONString(meta) , System.currentTimeMillis() - begin);

        return ResultUtil.genSuccessResult(meta);
    }


    /**
     * 对新闻数据进行包装，包括在其中增加营销新闻，拼接新闻的是否收藏，详情地址，分享地址
     * @param list
     * @param idList
     * @param userId
     * @param areaCode
     * @return
     */
    private List<News> packageNews(List<News> list,
                                   List<Long> idList,
                                   Long userId,
                                   String areaCode){
        //开始拼装
        List<News> result = new ArrayList<>();

        // 获取营销活动
        List<News> activityNews = addMarketingActivities(userId, areaCode);
        if (CollectionUtils.isNotEmpty(activityNews)) {
            result.addAll(activityNews);
            result = result.stream().sorted(Comparator.comparing(News::getShowLevel)).collect(Collectors.toList());
        }

        result.addAll(list);

        //填充额外参数
        newsService.fillExtInfo(userId, result);

       return result;
    }

    /**
     * 推荐小视频，每2页显示一次小视频
     * @param userId 用户id
     * @param curPage 当前页数
     * @param news4ClientList
     */
    private void addRecommendVideo(Long userId,Integer curPage, List<News4Client> news4ClientList) {
        logger.info("NewsRecommendParam----userId:{},curPage:{}", userId,curPage);
        if (curPage != 0 && curPage % 2 == 0) {
            VideoQueryParam videoParam = new VideoQueryParam();
            videoParam.setUserId(userId);
            // 在新闻列表中间插入
            List<VideoDto> videoDtoList = videoRecommendService.execRecommend(videoParam);
            if (CollectionUtils.isNotEmpty(videoDtoList)) {
                int size = news4ClientList.size();
                news4ClientList.add(size / 2, new News4Client(videoDtoList));
            }
        }
    }

    /**
     * 插入营销活动
     */
    private List<News> addMarketingActivities(Long userId, String areaCode) {
        List<MarketingActivities> list = marketingActivitiesMapper.listForRecommend(userId, areaCode);
        List<News> newsList = new ArrayList<>();
        for (MarketingActivities activities : list) {
            News news = new News();
            news.setId(activities.getId());
            news.setTitle(activities.getTitle());
            news.setAuthor(activities.getAuthor());
            news.setContent(activities.getLinkUrl());
            news.setKindId(activities.getDeliveryChannel());
            // 1否2是 这个奇葩数值兼容前人挖的坑
            news.setActivity((byte) 2);
            news.setIssueTime(activities.getShowTime());
            if (activities.getCoverUrl() != null) {
                String[] coverUrls = StringUtils.split(activities.getCoverUrl(), ",");
                news.setImgUrl(JSON.toJSONString(coverUrls));
            }
            // 1否
            news.setHot((byte) 1);
            // 1否
            news.setTop((byte) 1);
            // '新闻类型 1：文章 2：组图 3：视频',
            news.setType((byte) 1);
            news.setShowLevel(activities.getShowLevel());
            news.setShowLevelDetail(activities.getShowLevelDetail());
            news.setDeliveryType(activities.getDeliveryType());
            news.setAreaDetail(activities.getAreaDetail());
            news.setLinkUrl(activities.getLinkUrl());
            newsList.add(news);
            marketingActivitiesRecommendedMapper.save(userId, activities.getId());
        }
        return newsList;
    }

    /**
     * 处于提包状态时，隐藏部分敏感信息，用于上包 去除作者信息
     * @param param 推荐参数
     * @param meta  返回结果
     */
    private void hideInfo(BasicParam param, NewsMeta meta) {
        if (appVersionIntegrationService.getPublishState(param)) {
            meta.getList().removeIf(client -> client.getVideos() != null);
            for (News4Client client : meta.getList()) {
                if (client.getNews() != null) {
                    client.getNews().setAuthor(null);
                    client.getNews().setAuthorImg(null);
                }
            }
        }
    }

    /**
     * 查询置顶新闻
     */
    @Override
    public Json<NewsMeta> getTopNewsList(NewsTopListParam param) {
        // 置顶新闻列表
        List<News> topNewsList;

        // 区域性性置顶新闻
        List<News> topNewsOfAreaList = new ArrayList<>();
        KeyGenerator keyGeneratorOfArea = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey(param.getAreaCode());
        String topNewsOfAreaListStr = redisStringAdapter.getString(keyGeneratorOfArea);
        if (StringUtils.isNotBlank(topNewsOfAreaListStr)) {
            topNewsOfAreaList = JSON.parseArray(topNewsOfAreaListStr, News.class);
        } else {
            if (param.getAreaCode() != null) {
                topNewsOfAreaList = newsSearchIntegrationService.listTopNews(5, param.getAreaCode());
                if (topNewsOfAreaList != null && topNewsOfAreaList.size() > 0) {
                    redisStringAdapter.set(keyGeneratorOfArea, JSON.toJSONString(topNewsOfAreaList));
                }
            }else {
                redisStringAdapter.set(keyGeneratorOfArea, "[]");
                redisStringAdapter.expire(keyGeneratorOfArea, 10);
            }

        }

        // 全国性置顶新闻
        List<News> topNewsOfWholeCountryList;
        KeyGenerator keyGeneratorOfWholeCountry = RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST;
        String topNewsOfWholeCountryListStr = redisStringAdapter.getString(keyGeneratorOfWholeCountry);
        if (StringUtils.isNotBlank(topNewsOfWholeCountryListStr)) {
            topNewsOfWholeCountryList = JSON.parseArray(topNewsOfWholeCountryListStr, News.class);
        } else {
            topNewsOfWholeCountryList = newsSearchIntegrationService.listTopNews(5,  null);
            if (topNewsOfWholeCountryList != null && topNewsOfWholeCountryList.size() > 0) {
                redisStringAdapter.set(keyGeneratorOfWholeCountry, JSON.toJSONString(topNewsOfWholeCountryList));
            } else {
                redisStringAdapter.set(keyGeneratorOfWholeCountry, "[]");
                redisStringAdapter.expire(keyGeneratorOfWholeCountry, 10);
            }
        }

        NewsMeta newsMeta = new NewsMeta();
        if (CollectionUtils.isEmpty(topNewsOfAreaList) && CollectionUtils.isEmpty(topNewsOfWholeCountryList)) {
            logger.debug("当前未配置置顶新闻");
            return ResultUtil.genSuccessResult(newsMeta);
        }

        topNewsList = this.filterTopNews(topNewsOfAreaList, topNewsOfWholeCountryList, param);


        List<News> newTopNewsList = newsSearchIntegrationService.listRecommendedNews(topNewsList.stream()
                .map(News::getId)
                .toArray(Long[]::new));

        // 组装结构数据
        if (CollectionUtils.isEmpty(newTopNewsList)) {
            return ResultUtil.genSuccessResult(newsMeta);
        }
        newsService.fillExtInfo(param.getUserId(), newTopNewsList);
        List<News4Client> news4ClientList = Lists.newArrayList();

        for (News news : newTopNewsList) {
            News4Client news4Client = new News4Client();
            news4Client.setNews(news);
            news4ClientList.add(news4Client);
        }
        newsMeta.setList(news4ClientList);
        newsMeta.setNewsCount(newsMeta.getList().size());
        // 隐藏敏感信息
        this.hideInfo(param, newsMeta);

        return ResultUtil.genSuccessResult(newsMeta);
    }

    @Override
    public Json<NewsMeta> listMixRecommend(HomeRecommendParam param,BasicParam basicParam) {
        if (getPublishState(basicParam)) {
            //如果是在提审中
            NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
            newsRecommendParam.setAreaCode(param.getAreaCode());
            newsRecommendParam.setCurPage(param.getPageNum());
            newsRecommendParam.setKindId(param.getKindId());
            newsRecommendParam.setPagesize(param.getPageSize());
            if (param.getRecommendType()!=null) {
                newsRecommendParam.setType((byte)param.getRecommendType().intValue());
            }else{
                newsRecommendParam.setType((byte)1);
            }
            newsRecommendParam.setUserId(param.getUserId());
            return execRecommend(newsRecommendParam,basicParam);
        }
        //如果是推广地区，则获取新版推荐器获取混合推荐内容（包括帖子）
        if (checkIsNewVersionRecommend(param)) {
            return listMixRecommendByPromotion(param,basicParam);
        }else{
            //如果是非推广地区，则走原来的接口获取原来的推荐内容（只有新闻和小视频）
            NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
            newsRecommendParam.setAreaCode(param.getAreaCode());
            newsRecommendParam.setCurPage(param.getPageNum());
            newsRecommendParam.setKindId(param.getKindId());
            newsRecommendParam.setPagesize(param.getPageSize());
            if (param.getRecommendType()!=null) {
                newsRecommendParam.setType((byte)param.getRecommendType().intValue());
            }else{
                newsRecommendParam.setType((byte)1);
            }
            newsRecommendParam.setUserId(param.getUserId());
            return execRecommend(newsRecommendParam,basicParam);
        }
    }

    /**
     * 是否处于提包状态
     *
     * @param basicParam
     * @return
     */
    private Boolean getPublishState(BasicParam basicParam) {
        return appVersionIntegrationService.getPublishState(basicParam);
    }

    /**
     * 判断是否走2.1.0新版首页推荐
     * 如果满足地区已经开通社区，且频道为36或空，则走新的混合推荐器
     * @return
     */
    private boolean checkIsNewVersionRecommend(HomeRecommendParam param){
        return checkForumPostEnable(param.getAreaCode()) && (param.getKindId()==null || param.getKindId() == this.newsProperties.getRecommendKindId());
    }

    /**
     * 根据地区编号去查询该编号所在的地区是否开启社区
     * 旧版本不传areaCode字段，在此判断
     * @param areaCode
     * @return
     */
    private boolean checkForumPostEnable(String areaCode) {
        if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty(areaCode)) {
            LocationDTO locationDTO = locationIntegrationService.getLocationByGeocode(areaCode);
            if (locationDTO != null) {
                return locationDTO.getEnableCommunityContent() == 1;
            }
        }
        return false;
    }

    /**
     * 获得混合推荐返回类
     * @param param
     * @param basicParam
     * @return
     */
    public Json<NewsMeta> listMixRecommendByPromotion(HomeRecommendParam param,BasicParam basicParam) {
        logger.debug("[listMixRecommendByPromotion]新闻推荐请求+1：{}",param);
        int count = 0;
        return retryMixResult(param, basicParam,count);
    }

    private Json<NewsMeta> retryMixResult(HomeRecommendParam param,BasicParam basicParam,Integer count){
        long begin = System.currentTimeMillis();
        NewsMeta meta = new NewsMeta();
//        if (count >= 3) {
//            logger.error("[listMixRecommendByPromotion]老哥请求太快了，先给你返回个空:{}",JSONObject.toJSONString(param));
//            return ResultUtil.genSuccessResult(meta);
//        }
//        String requestId = String.valueOf(nextSequence());
//        String userId = "mix_"+ param.getUserId();

        List<MixRecommendDTO> mixRecommendDTOList = new ArrayList<>();
//        if (distributedLock.lock(userId, requestId)) {
            MixRecommendParam mixRecommendParam = new MixRecommendParam();
            BeanUtils.copyProperties(param, mixRecommendParam);
            mixRecommendParam.setActionType(param.getRecommendType());

            //推荐器获取混合id列表
            mixRecommendDTOList = newsRecommendIntegrationService.listMixRecommendDTO(mixRecommendParam);
            logger.debug("[listMixRecommendByPromotion]从es中获取新闻列表信息,结果：{},耗时:{}",JSONObject.toJSONString(mixRecommendDTOList),System.currentTimeMillis() - begin);

//            distributedLock.unlock(userId, requestId);
//        } else {
//            logger.info("[listMixRecommendByPromotion]新闻推荐请求过快，请休息一会!参数:{}", JSON.toJSONString(param));
//            try {
//                // 休息 500ms
//                Thread.sleep(1000);
//            } catch (InterruptedException e) {
//                logger.error(e.getMessage(), e);
//            }
//           return retryMixResult(param, basicParam, ++count);
//
//        }

        if (CollectionUtils.isEmpty(mixRecommendDTOList)) {
            return ResultUtil.genSuccessResult(meta);
        }

        //添加新闻和帖子
        List<News4Client> news4ClientList = listNews4Client(mixRecommendDTOList,param.getUserId(),param.getAreaCode());
        logger.debug("[listMixRecommendByPromotion]新闻包装(新闻&营销活动),耗时:{}", System.currentTimeMillis() - begin);

        if (CollectionUtils.isEmpty(news4ClientList)) {
            return ResultUtil.genSuccessResult(meta);
        }

        //添加小视频
        if (5!=basicParam.getPlatform()) {
            addRecommendVideo(param.getUserId(), param.getPageNum(), news4ClientList);
            logger.debug("[listMixRecommendByPromotion]小视频添加,耗时:{}", System.currentTimeMillis() - begin);
        }

        //隐藏敏感信息
        hideInfo(basicParam, meta);

        meta.setList(news4ClientList);
        meta.setNewsCount(meta.getList().size());

        logger.debug("[listMixRecommendByPromotion]拉取新闻列表完毕,结果:{},耗时：{}",JSONObject.toJSONString(meta) , System.currentTimeMillis() - begin);
        return ResultUtil.genSuccessResult(meta);
    }

    @Override
    public List<News4Client> listNews4Client(List<MixRecommendDTO> mixRecommendDTOList,Long userId,String areaCode){
        //分别得到新闻和帖子的id列表
        List<Long> postIdList = mixRecommendDTOList.stream().filter(mix->mix.getOrigin().equals("1")).map(MixRecommendDTO::getId).collect(Collectors.toList());
        List<Long> newsIdList = mixRecommendDTOList.stream().filter(mix->!mix.getOrigin().equals("1")).map(MixRecommendDTO::getId).collect(Collectors.toList());

        //根据id列表获得新闻列表内容，进行包装
        List<News> list = newsSearchIntegrationService.listRecommendedNews(newsIdList.toArray(new Long[0]));
        List<News> result = packageNews(list,newsIdList,userId,areaCode);

        //根据id列表获得帖子列表内容，进行包装
        List<ForumPostVo> forumPostVoList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(postIdList)) {
            forumPostVoList = forumPostMapper.listPostByIds(postIdList);
            forumService.fillExtInfo(forumPostVoList, userId,areaCode);
        }
        List<ForumPostDTO> forumPostResult = forumPostVoList.stream().map(ForumPostConvert::convertForumPost2DTO).collect(Collectors.toList());

        //包装返回实体对象
        List<News4Client> news4ClientList = new ArrayList<>();
        for (MixRecommendDTO mixRecommendDTO : mixRecommendDTOList) {
            // 如果是帖子
            if (mixRecommendDTO.getOrigin().equals("1")) {
                ForumPostDTO post = forumPostResult.stream().filter(forumPostDTO -> forumPostDTO.getId().equals(mixRecommendDTO.getId())).findFirst().orElse(null);
                if (Objects.nonNull(post)) {
                    News4Client news4Client = new News4Client();
                    news4Client.setPost(post);
                    news4ClientList.add(news4Client);
                }
            } else {
                News news = result.stream().filter(newsDTO -> newsDTO.getId().equals(mixRecommendDTO.getId())).findFirst().orElse(null);
                if (Objects.nonNull(news) && 1 == news.getStatus()) {
                    News4Client news4Client = new News4Client();
                    news4Client.setNews(news);
                    news4ClientList.add(news4Client);
                }
            }
        }
        return news4ClientList;
    }

    @Override
    public Json<NewsMeta> listPostByMixRecommendPool(HomeRecommendParam param) {
        NewsMeta meta = new NewsMeta();
        List<Long> postIdList = mixedRecommendPoolMapper.listPostRecommend(param);
        if (CollectionUtils.isNotEmpty(postIdList)) {
            List<ForumPostVo> forumPostVoList = forumPostMapper.listPostByIds(postIdList);
            forumService.fillExtInfo(forumPostVoList, param.getUserId(), param.getAreaCode());

            List<ForumPostDTO> forumPostResult = forumPostVoList.stream().map(ForumPostConvert::convertForumPost2DTO).collect(Collectors.toList());

            //包装返回实体对象
            List<News4Client> news4ClientList = new ArrayList<>();
            for (Long mixRecommendDTO : postIdList) {

                ForumPostDTO post = forumPostResult.stream().filter(forumPostDTO -> forumPostDTO.getId().equals(mixRecommendDTO)).findFirst().orElse(null);
                if (Objects.nonNull(post)) {
                    News4Client news4Client = new News4Client();
                    news4Client.setPost(post);
                    news4ClientList.add(news4Client);
                }

            }
            meta.setList(news4ClientList);
            meta.setNewsCount(meta.getList().size());
        }

        return ResultUtil.genSuccessResult(meta);
    }

    @Override
    public Json<NewsMeta> listTopMixRecommend(NewsTopListParam param) {
        return null;
    }


    /**
     * 填充置顶新闻
     * 置顶条数限制改为最多显示两条
     * 当本地置顶和全国置顶都存在时显示一条本地一条全国，最新编辑的优先展示
     * 当只有本地资讯时展示最多两条本地置顶，最新编辑的优先展示
     * 当只有全国资讯时展示最多两条全国置顶，最新编辑的优先展示
     * @param topNewsOfAreaList         区域置顶新闻
     * @param topNewsOfWholeCountryList 全国置顶新闻
     * @return 合并处理过的置顶新闻
     */
    private List<News> filterTopNews(List<News> topNewsOfAreaList, List<News> topNewsOfWholeCountryList, NewsTopListParam param) {
        List<News> topNewsList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(topNewsOfAreaList) && CollectionUtils.isNotEmpty(topNewsOfWholeCountryList)) {
            topNewsList.add(topNewsOfAreaList.get(0));
            topNewsList.add(topNewsOfWholeCountryList.get(0));
            return topNewsList;
        } else if (CollectionUtils.isNotEmpty(topNewsOfAreaList) && CollectionUtils.isEmpty(topNewsOfWholeCountryList)) {
            topNewsList.addAll(topNewsOfAreaList);
        } else if (CollectionUtils.isNotEmpty(topNewsOfWholeCountryList) && CollectionUtils.isEmpty(topNewsOfAreaList)) {
            topNewsList.addAll(topNewsOfWholeCountryList);
        }
        topNewsList = topNewsList.stream().limit(2).collect(Collectors.toList());


        return topNewsList;

    }
}
