package com.bxm.localnews.news.convert.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.news.convert.Converter;
import com.bxm.localnews.news.vo.ForumBasicVo;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ForumBasicConvert implements Converter<ForumBasicVo, ForumPostVo> {

    @Override
    public ForumPostVo convert(ForumBasicVo data) {
        ForumPostVo forumPostVo = new ForumPostVo();
        BeanUtils.copyProperties(data, forumPostVo);

        forumPostVo.setStatus(2);

        if (StringUtils.isNotBlank(forumPostVo.getAreaCode()) && forumPostVo.getAreaCode().length() < 12) {
            String areaCode = forumPostVo.getAreaCode() + "000000000000".substring(forumPostVo.getAreaCode().length());
            forumPostVo.setAreaCode(areaCode);
        }

        //组装content
        StringBuilder content = new StringBuilder("<p>");
        if (StringUtils.isNotBlank(forumPostVo.getTextField())) {
            content.append(forumPostVo.getTextField().replaceAll("\\n", "</p><p>"));
        }
        content.append("</p>");
        if (CollectionUtils.isNotEmpty(forumPostVo.getPostImgList())) {
            forumPostVo.setImgList(JSON.toJSONString(forumPostVo.getPostImgList()));
            for (PostImgVo postImgVo : forumPostVo.getPostImgList()) {
                content.append("<img src=\"");
                content.append(postImgVo.getImgUrl());
                content.append("\"></img>");
            }
        }
        forumPostVo.setContent(content.toString());
        String imgList = forumPostVo.getImgList();
        //兼容安卓客户端图片列表没有传type
        List<PostImgVo> postImgVos = JSONObject.parseArray(imgList, PostImgVo.class);
        if (CollectionUtils.isNotEmpty(postImgVos)){
            postImgVos.stream().forEach(e->{
                if (StringUtils.isBlank(e.getType())){
                    e.setType("IMG");
                }
            });
            forumPostVo.setImgList(JSONObject.toJSONString(postImgVos));
        }
        return forumPostVo;
    }
}
