package com.bxm.localnews.news.factory.impl;

import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.constant.UrlCategoryEnum;
import com.bxm.localnews.news.constant.UrlPositionEnum;
import com.bxm.localnews.news.constant.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author shentao
 */
@Component
public class UrlFactory implements IUrlFactory {

    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Override
    public String getAppUrl(UrlCategoryEnum urlCategoryEnum, UrlTypeEnum urlTypeEnum, Long id, Long userId) {
        if (UrlCategoryEnum.NEWS.equals(urlCategoryEnum)) {
            if (UrlTypeEnum.DETAIL.equals(urlTypeEnum)) {
                if (userId == null) {
                    return bizConfigProperties.getH5ServerHost() + "/newsDetail.html?" + "newsId=" + id + "&type=" + 1;
                } else {
                    return bizConfigProperties.getH5ServerHost() + "/newsDetail.html?" + "newsId=" + id + "&userId=" + userId + "&type=" + 1;
                }
            } else if (UrlTypeEnum.SHARE.equals(urlTypeEnum)) {
                if (userId == null) {
                    return bizConfigProperties.getH5ServerHost() + "/shareNewsDetail.html?" + "newsId=" + id + "&type=" + 2;
                } else {
                    return bizConfigProperties.getH5ServerHost() + "/shareNewsDetail.html?" + "newsId=" + id + "&userId=" + userId + "&type=" + 2;
                }
            }
        } else if (UrlCategoryEnum.FORUM.equals(urlCategoryEnum)) {
           return bizConfigProperties.getH5ServerHost() + "/shareInvitationDetail.html?userId="
                    + userId + "&id=" + id;
        }
        return null;
    }

    @Override
    public String getAppletUrl(UrlPositionEnum urlPositionEnum, Long id, Long userId) {
        switch (urlPositionEnum) {
            case BLOCK:
                return bizConfigProperties.getAppletServerHost() + "?tp=block&id=" + id + "&isShare=1&uid=" + userId;
            case TOPIC:
                return bizConfigProperties.getAppletServerHost() + "?tp=topic&id=" + id + "&isShare=1&uid=" + userId;
            case POST:
                return bizConfigProperties.getAppletServerHost() + "?tp=post&id=" + id + "&isShare=1&uid=" + userId;
            case NEWS:
                return bizConfigProperties.getAppletServerHost() + "?tp=news&id=" + id + "&isShare=1&uid=" + userId;
            case MANLL_HOME:
                return bizConfigProperties.getAppletServerHost() + "?tp=manllHome&id=" + id + "&isShare=1&uid=" + userId;
            default:
                return null;
        }
    }
}
