package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.vo.NewsGoldMeta;

/**
 * 新闻阅读奖励相关业务服务接口
 * @author liujia
 */
public interface NewsReadRewardService {
    /**
     * 新闻分享成功金币赠送
     * @param newsId
     * @param userId
     * @return
     */
    Json<NewsCompleTaskDTO> saveShareNews(Long newsId, Long userId,Byte type);

    /**
     * 帖子分享成功金币赠送
     * @param postId
     * @param userId
     * @return
     */
    Json<NewsCompleTaskDTO> saveShareForums(Long postId, Long userId,Byte type);

    /**
     * 执行阅读文章奖励机制
     * @param execGoldParam
     * @return
     */
    Json<NewsGoldMeta> execGetGold(ExecGoldParam execGoldParam);
}
