package com.bxm.localnews.news.service;

import java.util.List;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.OldNewsReplyDto;
import com.bxm.localnews.news.vo.*;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
public interface NewsReplyService {

    /**
     * 获取回复列表
     *
     * @param newsId
     * @param page
     * @return
     */
    List<OldNewsReplyDto> queryReplyList(Long newsId, MPage page);

    /**
     * 用户发表评论
     *
     * @param newsReply
     * @return
     */
    Json reply(OldNewsReply newsReply);

    /**
     * 获取用户的评论列表
     *
     * @param userId
     * @param page
     * @return
     */
    List<OldMyReplysVO> selectMyReplys(Long userId, MPage page);

    /**
     * 删除评论
     *
     * @param replyId
     * @return
     */
    Json delMyReply(Long replyId);

    /**
     * 获取收到的评论列表
     * 暂时不用
     * @param userId
     * @param page
     * @return
     */
    List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page);


}
