package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.constant.NewsTemplateConst;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.FileUtils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class AssemblyServiceImpl implements AssemblyService {

    private final AliyunOSSService aliyunOSSService;

    @Autowired
    public AssemblyServiceImpl(AliyunOSSService aliyunOSSService) {
        this.aliyunOSSService = aliyunOSSService;
    }

    @Override
    public String assemblyContent(String target) {
        String newsTemplate = NewsTemplateConst.getNewsTemplate();
        if (StringUtils.isBlank(newsTemplate)) {
            newsTemplate = aliyunOSSService.getOssContentByPath(NewsTemplateConst.getPath());
            NewsTemplateConst.setNewsTemplate(newsTemplate);
        }
        if (StringUtils.isNotBlank(target)) {
            target = fixContent(target);
            return newsTemplate.replace("{body}", target);
        }
        return newsTemplate;
    }

    /**
     * 修正内容
     * 内容中的图片添加水印和压缩参数
     * 删除video上下文中的nbsp
     * @param content html内容
     * @return 处理过后的html内容
     */
    @Override
    public String fixContent(String content) {
        content = appletAdapter(content);
        //提取HTTP地址
        Document document = Jsoup.parse(content);
        document.outputSettings().prettyPrint(true).indentAmount(1);

        this.addWatermark(document);

        this.deleteNbspFromVideo(document);

        return document.body().html().replace("\n", "");
    }

    /**
     * 适配小程序，临时处理方案，将活动描述文案进行修改。用于和实际活动匹配
     * 文案原本存在于编辑寄语
     * @param content 内容部分
     * @return 处理结果
     */
    private String appletAdapter(String content){
        return StringUtils.replace(content,"你将获得10朵小红花","最多获得300朵小红花");
    }

    /**
     * 内容中的图片添加水印和压缩参数
     * @param document
     */
    private void addWatermark(Document document){
        // 图片添加水印
        Elements elements = document.select("img");
        if (null != elements) {
            for (Element element : elements) {
                String src = element.attr("src");
                if (StringUtils.isBlank(src)) {
                    src = element.attr("data-src");
                    if (StringUtils.isBlank(src)) {
                        continue;
                    }
                }
                String url = src;
                int lastIndex = src.lastIndexOf("?");
                if (-1 != lastIndex) {
                    url = src.substring(0, lastIndex);
                }
                String extend = FileUtils.getFilextension(url);

                if ("gif".equalsIgnoreCase(extend)) {
                    url += "?x-oss-process=style/mcompress";
                } else {
                    url += "?x-oss-process=style/wcompress";
                }

                element.attr("src", url);
            }
        }
    }

    @Override
    public String deleteVideoLabel(String content) {
        Document document = Jsoup.parse(content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        document.select("video").remove();
        return document.body().html().replace("\n", "");
    }

    @Override
    public String deleteNbspFromVideo(Document document) {
        Elements elements = document.select("video");
        if (!elements.isEmpty()) {
            for (Element element : elements) {
              Element parent =  element.parent();
              parent.html(parent.html().replace("&nbsp;", ""));
            }
        }
        return document.body().html().replace("\n", "");
    }
}
