package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.domain.InitTagMapper;
import com.bxm.localnews.news.service.InitTagService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class InitTagServiceImpl implements InitTagService {

    private InitTagMapper initTagMapper;

    @Autowired
    public InitTagServiceImpl(InitTagMapper initTagMapper) {
        this.initTagMapper = initTagMapper;
    }

    @Override
    public Message createInitTags(Long userId) {
        Assert.notNull(userId, "userId must has text");
        return Message.build(this.initTagMapper.initUserTag(userId));
    }

}
