package com.bxm.localnews.news.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.integration.*;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.constant.UrlCategoryEnum;
import com.bxm.localnews.news.constant.UrlTypeEnum;
import com.bxm.localnews.news.convert.impl.NewsReplyConver;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.*;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.UserReplyParam;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.CharUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class NewNewsReplyServiceImpl extends BaseService implements NewNewsReplyService {

    @Resource
    private NewsReplyMapper newsReplyMapper;

    @Resource
    private NewsReplyLikeMapper newsReplyLikeMapper;

    @Resource
    private RedisListAdapter redisListAdapter;

    @Resource
    private UserReplyMapper userReplyMapper;

    @Resource
    private VideoMapper videoMapper;

    @Resource
    private NewsMapper newsMapper;

    @Resource
    private NewsCollectMapper newsCollectMapper;

    @Resource
    private VideoLikeMapper videoLikeMapper;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private IUrlFactory iUrlFactory;

    @Autowired
    private VideoRecommendService videoRecommendService;

    @Autowired
    private NewsStatisticIntegrationService newsStatisticIntegrationService;

    @Autowired
    private NewsTotalMapper newsTotalMapper;

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private BizLogIntegrationService bizLogIntegrationService;

    @Autowired
    private ForumMapper forumMapper;

    @Autowired
    private MessageIntegrationService messageIntegrationService;

    @Autowired
    private MissionIntegrationService missionIntegrationService;

    @Autowired
    private NewsReplyConver newsReplyConver;

    @Override
    public PageWarper<NewsReplyDTO> queryReplyList(NewsReplyParam newsReplyParam) {
        //分页查找level为0的评论
        PageWarper<NewsReplyDTO> newsReplyDTOPageWarper = new PageWarper<>(this.newsReplyMapper.queryByPageSize(newsReplyParam));
        List<NewsReplyDTO> list = newsReplyDTOPageWarper.getList();
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> rootIds = list.stream().map(NewsReplyDTO::getId).collect(Collectors.toList());
            //查找所有的根评论的子评论
            List<NewsReplyMirrorDTO> allReplies = this.newsReplyMapper.selectSubReplyLists(rootIds, newsReplyParam.getNewsId());
            //查询该用户在该条新闻下的所有评论的额点赞记录
            List<Long> replyLikes = newsReplyMapper.selectReplyLike(newsReplyParam.getNewsId(), newsReplyParam.getUserId(), null);

            if (CollectionUtils.isNotEmpty(newsReplyDTOPageWarper.getList())) {
                for (NewsReplyDTO vo : newsReplyDTOPageWarper.getList()) {
                    //用户是否点赞
                    vo.setIsLike(checkIsLike(replyLikes, vo.getId()));
                    vo.setReplyTime(DateUtils.timeConvertString(vo.getAddTime()));
                    //查询该评论下的子评论
                    List<NewsReplyMirrorDTO> replies = allReplies.stream().filter(e -> e.getRootId().equals(vo.getId())).collect((Collectors.toList()));
                    if (CollectionUtils.isNotEmpty(replies)) {
                        replies.forEach(replay -> {
                            //用户是否点赞
                            dealSubMirrorDTO(replay, newsReplyParam.getUserId(), replyLikes);
                        });
                        vo.setList(replies);
                    }
                }
            }
        }
        return newsReplyDTOPageWarper;
    }

    private void dealSubMirrorDTO(NewsReplyMirrorDTO replay, Long userId, List<Long> replyLikes) {
        replay.setIsLike(checkIsLike(replyLikes, replay.getId()));
        //隐藏父级回复，详细需求问强哥
        if (replay.getLevel().equals(NewsConstant.REPLY_LEVEL_1)) {
            replay.setParentHeadImg(null);
            replay.setParentUserId(null);
            replay.setParentUserNickname(null);
        }
        replay.setReplyTime(DateUtils.timeConvertString(replay.getAddTime()));

    }

    private int checkIsLike(List<Long> replyLikes, Long replyId) {
        return replyLikes.contains(replyId) ? 1 : 0;
    }

    /**
     * 判断当前用户是否对此回复点赞
     *
     * @param userId
     * @param replyId
     * @return
     */
    private boolean isLike(Long userId, Long replyId) {
        NewsReplayLike newsReplayLike = newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        return null != newsReplayLike;
    }

    @Override
    public ReplyDTO doReply(NewsReplyAddParam newsReplyAddParam, Integer platform) {
        logger.debug("[doReply]发表评论，参数:[{}]", JSONObject.toJSONString(newsReplyAddParam));
        NewsReply newsReply = newsReplyConver.convert(newsReplyAddParam);
        this.newsReplyMapper.insertSelective(newsReply);
        //保存至用户评论中
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties(newsReply, userReply);
        this.userReplyMapper.insertSelective(userReply);
        //兼容评论时间
        newsReply.setReplyTime(DateUtils.timeConvertString(newsReply.getAddTime()));
        //异步执行
        NewsReply param = new NewsReply();
        BeanUtils.copyProperties(newsReply, param);
        //计算帖子,新闻,小视频的评论数,及帖子的评论概览
        this.updateComment(newsReply);
        //异步调用推送
        NewNewsReplyService newNewsReplyService = SpringContextHolder.getBean(this.getClass());
        newNewsReplyService.processWhenReply(param, newsReplyAddParam, platform);
        //隐藏父级评论
        if (newsReply.getLevel().equals(NewsConstant.REPLY_LEVEL_1) && platform != 5) {
            newsReply.setParentUserId(null);
            newsReply.setParentUserNickname(null);
        }
        ReplyDTO result = new ReplyDTO();
        BeanUtils.copyProperties(newsReply, result);
        //评论新闻并且超过15字
        if (ReplyTypeEnum.VIDEO_REPLY.getCode() != newsReply.getType() && CharUtil.isCharSatisfied(newsReply.getReplyContent(), 15)) {
            //调用完成任务接口
            NewsCompleTaskDTO taskDTO = missionIntegrationService.compleTask(newsReply.getUserId(), "TASK_COMMENT_NEWS", newsReply.getId().toString());
            logger.info("user_id ={}完成评论任务,奖励{}多红花;", newsReply.getUserId(), taskDTO.getGoldNum());
            result.setGoldNum(Objects.isNull(taskDTO.getGoldNum()) ? 0 : taskDTO.getGoldNum());
        }
        return result;
    }

    @Async
    @Override
    public void processWhenReply(NewsReply newsReply, NewsReplyAddParam newsReplyAddParam, Integer platform) {
        //1.新闻不是根级评论时将根级评论互动值+3
        if (Objects.nonNull(newsReply.getRootId()) && newsReply.getRootId() != 0) {
            NewsReply rootReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = (Objects.isNull(interactiveCount) || interactiveCount == 0) ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            UserReply userRootReply = new UserReply();
            BeanUtils.copyProperties(rootReply, userRootReply);
            userReplyMapper.updateinteractiveCountById(userRootReply);
        }
        //计算发布数
        userIntegrationService.addPostReplyNum(newsReplyAddParam.getUserId(), 3);

        logger.info("用户[{}]评论了用户[{}]的消息，给用户[{}]发送推送,推送类型为[{}]， \n推送的数据：[{}]", newsReplyAddParam.getUserId(),
                newsReplyAddParam.getParentUserId(), newsReplyAddParam.getParentUserId(), newsReplyAddParam.getType(),
                JSON.toJSONString(newsReplyAddParam));
        //3.推送消息，自己给自己评论不推送信息
        if (Objects.nonNull(newsReplyAddParam.getParentUserId()) &&
                !(newsReplyAddParam.getParentUserId().equals(newsReply.getUserId()))) {
            logger.debug("封装的消息格式为：[{}]", JSON.toJSONString(newsReply));
            if (newsReply.getType() == ReplyTypeEnum.NEWS_REPLY.getCode() || newsReply.getType() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.NEWS_REPLY);
            } else if (newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
                messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY);
            }
        }
        //4.回复帖子的推送
        if (null == newsReplyAddParam.getParentUserId() && newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
            messageIntegrationService.pushPostRepkyMessage(newsReply);
        }
        //5.记录事件埋点
        if (StringUtils.isNotBlank(newsReplyAddParam.getAreaCode())) {
            bizLogIntegrationService.replySuccessed(newsReplyAddParam.getUserId(), newsReplyAddParam.getNewsId(),
                    new Integer(newsReplyAddParam.getType()), newsReplyAddParam.getAreaCode(), platform);
        }
    }

    private void updateComment(NewsReply newsReply) {
        if (ReplyTypeEnum.NEWS_REPLY.getCode() == newsReply.getType()) {
            newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId(), 1);
            newsStatisticIntegrationService.pushCommentData(newsReply.getUserId(), newsReply.getNewsId());
        } else if (ReplyTypeEnum.VIDEO_REPLY.getCode() == newsReply.getType()) {
            Video video = new Video();
            video.setId(newsReply.getNewsId());
            video.setCommentCount(1L);
            videoMapper.updateStatisticByPrimaryKeySelective(video);
        } else if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType()) {
            //维护帖子评论概览及帖子的评论
            // 数
            ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments(newsReply.getNewsId(), 1);
            List<NewsReply> replyList = newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(newsReply.getNewsId());
            if (CollectionUtils.isNotEmpty(replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString(replyList));
            }
            forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        }
    }

    @Override
    public PageWarper<MyReplysVO> selectMyReplys(UserReplyParam newsReplyParam) {
        PageWarper<MyReplysVO> myReplysVOPageWarper = new PageWarper<>(this.userReplyMapper.selectMyReplys(newsReplyParam));
        List<MyReplysVO> myReplysVOList = myReplysVOPageWarper.getList();
        for (MyReplysVO myReplysVO : myReplysVOList) {
            Date addTime = myReplysVO.getAddTime();
            String replyTime = DateUtils.timeConvertString(addTime);
            myReplysVO.setReplyTime(replyTime);
            Byte type = myReplysVO.getType();
            if (type == ReplyTypeEnum.NEWS_REPLY.getCode()) {
                News news = newsMapper.selectByPrimaryKey(myReplysVO.getNewsId());
                if (null != news) {
                    NewsCollect newsCollect = newsCollectMapper.selectUserCollect(news.getId(), newsReplyParam.getUserId(), (byte) 1);
                    ReplyNewsDTO replyNewsDTO = getNewsDto(news, newsReplyParam.getUserId());
                    if (null != newsCollect) {
                        replyNewsDTO.setCollect(1);
                    } else {
                        replyNewsDTO.setCollect(0);
                    }
                    myReplysVO.setReplyNewsDto(replyNewsDTO);
                    myReplysVO.setTitle(news.getTitle());
                    myReplysVO.setNewsImgUrl(news.getImgUrl());
                }
            } else if (type == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                Video video = videoMapper.selectByPrimaryKey(myReplysVO.getNewsId());
                if (null != video) {
                    ReplyVideoDTO replyVideoDTO = getVideoDto(video, newsReplyParam.getUserId());
                    replyVideoDTO.setVideoImg("[\"" + video.getVideoImg() + "\"]");
                    myReplysVO.setReplyVideoDto(replyVideoDTO);
                    myReplysVO.setTitle(video.getTitle());
                    myReplysVO.setNewsImgUrl("[\"" + video.getVideoImg() + "\"]");
                }
            } else if (type == ReplyTypeEnum.POST_REPLY.getCode()) {
                ForumPostVo forumPostVo = forumMapper.getPostDetailById(myReplysVO.getNewsId());
                if (null != forumPostVo) {
                    ReplyPostDTO replyPostDTO = getForumPostReplyDto(forumPostVo);
                    myReplysVO.setReplyPostDto(replyPostDTO);
                    if (StringUtils.isNotEmpty(forumPostVo.getTitle())) {
                        myReplysVO.setTitle(forumPostVo.getTitle());
                    } else {
                        if (forumPostVo.getTextField().length() > 50) {
                            myReplysVO.setTitle(forumPostVo.getTextField().substring(0, 50));
                        } else {
                            myReplysVO.setTitle(forumPostVo.getTextField());
                        }
                    }
                }
            }
        }
        return myReplysVOPageWarper;
    }

    @Override
    public NewsReplyDTO delMyReply(Long replyId, Long userId, Long newsId) {
        NewsReply newsReply = null;
        if (null != newsId && 0 != newsId) {
            newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId);
        }
        if (Objects.isNull(newsReply)) {
            newsReply = this.newsReplyMapper.selectByPrimaryKey(replyId);
        }
        this.newsReplyMapper.deleteByPrimaryKey(replyId, newsReply.getNewsId());
        this.userReplyMapper.deleteByPrimaryKey(replyId, newsReply.getUserId());
        NewsReplyDTO newsReplyDTO = new NewsReplyDTO();
        BeanUtils.copyProperties(newsReply, newsReplyDTO);
        //评论状态置为删除
        newsReplyDTO.setDeleteFlag((byte) 1);
        newsReplyDTO.setReplyTime(DateUtils.timeConvertString(newsReplyDTO.getAddTime()));
        newsReplyDTO.setReplyContent("该评论已删除！");
        newsReplyDTO.setIsLike(isLike(userId, replyId) ? 1 : 0);
        if (newsReply.getRootId() == 0) {
            List<NewsReplyMirrorDTO> replyMirrorDTOS = newsReplyMapper.selectSubReplyList(replyId, newsReply.getNewsId());
            List<Long> replyLike = newsReplyMapper.selectReplyLike(newsReply.getNewsId(), userId, replyId);
            replyMirrorDTOS.forEach(e -> {
                dealSubMirrorDTO(e, userId, replyLike);
            });
            newsReplyDTO.setList(replyMirrorDTOS);
        }
        if (newsReply.getLevel() == 1) {
            newsReplyDTO.setParentUserId(null);
            newsReplyDTO.setParentUserNickname(null);
        }
        //帖子评论数修改
        userIntegrationService.addPostReplyNum(userId, 4);
        //评论数-1
        reduceComment(newsReply);
        return newsReplyDTO;
    }

    private void reduceComment(NewsReply newsReply) {
        if (ReplyTypeEnum.NEWS_REPLY.getCode() == newsReply.getType()) {
            newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId(), -1);
        } else if (ReplyTypeEnum.VIDEO_REPLY.getCode() == newsReply.getType()) {
            Video video = new Video();
            video.setId(newsReply.getNewsId());
            video.setCommentCount(-1L);
            videoMapper.updateStatisticByPrimaryKeySelective(video);
        } else if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType()) {
            //维护帖子评论概览及帖子的评论
            // 数
            ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments(newsReply.getNewsId(), -1);
            List<NewsReply> replyList = newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(newsReply.getNewsId());
            if (CollectionUtils.isNotEmpty(replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString(replyList));
            }
            forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        }
    }

    @Override
    public List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page) {
        List<MyReceiveReplysVO> result = this.newsReplyMapper.myReceiveReplys(userId, page);

        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(reply -> {
                if (reply.getDeleteFlag() == 1) {
                    reply.setReplyContent(null);
                }
            });
        }

        return result;
    }

    @Async
    @Override
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg) {
        //更新自己的评论
        List<NewsReply> newsReplyList = newsReplyMapper.selectByUser(userId);
        for (NewsReply newsReply : newsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setUserNickname(nickname);
            newsReplyUp.setHeadImg(headImg);

            UserReply userReply = new UserReply();
            BeanUtils.copyProperties(newsReplyUp, userReply);

            newsReplyMapper.updateUserInfo(newsReplyUp);
            userReplyMapper.updateUserInfo(userReply);
        }
        //更新父级的评论
        List<NewsReply> parentNewsReplyList = newsReplyMapper.selectByParentUser(userId);
        for (NewsReply newsReply : parentNewsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setParentUserNickname(nickname);
            newsReplyUp.setParentHeadImg(headImg);

            UserReply userReply = new UserReply();
            BeanUtils.copyProperties(newsReplyUp, userReply);

            newsReplyMapper.updateParentUserInfo(newsReplyUp);
            userReplyMapper.updateParentUserInfo(userReply);
        }

    }

    @Override
    public Message doProduceNewsReplyLike(NewsReplyLikeParam newsReplyLikeParam) {
        if (!checkLikeParam(newsReplyLikeParam)) {
            return Message.build(false, "参数验证错误");
        }
        logger.info("点赞的参数是:{}", JSONObject.toJSONString(newsReplyLikeParam));
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");

        redisListAdapter.leftPush(keyGenerator, newsReplyLikeParam);
        this.callAsyncConsume();
        return Message.build(true);
    }

    private void callAsyncConsume() {
        NewNewsReplyService newsReplyService = SpringContextHolder.getBean(NewNewsReplyService.class);
        newsReplyService.doNewsReplyLikeConsume();
    }

    @Async
    @Override
    public void doNewsReplyLikeConsume() {
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");

        NewsReplyLikeParam newsReplyLikeWarper = redisListAdapter.rightPop(keyGenerator, NewsReplyLikeParam.class);
        if (null != newsReplyLikeWarper) {
            logger.info("新闻回复点赞开始消费...");
            int type = newsReplyLikeWarper.getType();
            NewsReply newsReply;
            if (null != newsReplyLikeWarper.getNewsId() && 0 != newsReplyLikeWarper.getNewsId()) {
                newsReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReplyLikeWarper.getReplyId(), newsReplyLikeWarper.getNewsId());
            } else {
                newsReply = newsReplyMapper.selectByPrimaryKey(newsReplyLikeWarper.getReplyId());
            }
            if (newsReply != null) {
                int count = saveReplyLiKeRecord(newsReply.getId(), newsReplyLikeWarper.getUserId(), type);
                if (count > 0) {
                    //1.增加评论点赞记录
                    logger.debug("评论实体:{}", JSONObject.toJSON(newsReply));
                    int likeCount = generatorLikeCount(type, newsReply.getLikeCount());
                    logger.debug("点赞数:{}", likeCount);
                    NewsReply newsReplyUp = new NewsReply();
                    newsReplyUp.setId(newsReplyLikeWarper.getReplyId());
                    newsReplyUp.setLikeCount(likeCount);
                    newsReplyUp.setUserId(newsReply.getUserId());
                    newsReplyUp.setNewsId(newsReply.getNewsId());
                    //根评论才计算互动值
                    if (newsReply.getRootId() == 0) {
                        if (type == 1) {
                            newsReplyUp.setInteractiveCount(newsReply.getInteractiveCount() + 1);
                        } else {
                            if (newsReply.getInteractiveCount() > 0) {
                                newsReplyUp.setInteractiveCount(newsReply.getInteractiveCount() - 1);
                            }
                        }
                    }
                    newsReplyMapper.updateByPrimaryKeySelective(newsReplyUp);
                    UserReply userReply = new UserReply();
                    BeanUtils.copyProperties(newsReplyUp, userReply);
                    userReplyMapper.updateinteractiveCountById(userReply);
                }

                //2.评论点赞推送
                if ((!newsReplyLikeWarper.getUserId().equals(newsReply.getUserId())) && newsReplyLikeWarper.getType() == 1) {
                    if (newsReply.getType() == 1 || newsReply.getType() == 2) {
                        messageIntegrationService.pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.NEWS_LIKE, newsReply);
                    } else if (newsReply.getType() == 3) {
                        messageIntegrationService.pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.POST_LIKE, newsReply);
                    }
                }
            }
            doNewsReplyLikeConsume();
        }
    }

    @Override
    public NewsReplyDetailDTO getNewsReplyDetailDTO(Long replyId, Long userId, Long newsId) {
        NewsReply newsReply;
        if (null != newsId && 0 != newsId) {
            newsReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId);
        } else {
            newsReply = newsReplyMapper.selectByPrimaryKey(replyId);
        }
        if (Objects.isNull(newsReply) || Objects.isNull(newsReply.getRootId())) {
            return null;
        }
        //判断评论是否是跟评论,不是则找出根评论
        if (newsReply.getRootId() != 0) {
            if (null != newsId) {
                newsReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsId);
            } else {
                newsReply = newsReplyMapper.selectByPrimaryKey(newsReply.getRootId());
            }
        }
        NewsReplyDetailDTO newsReplyDetailDTO = new NewsReplyDetailDTO();
        BeanUtils.copyProperties(newsReply, newsReplyDetailDTO);
        if (isLike(userId, newsReplyDetailDTO.getId())) {
            newsReplyDetailDTO.setIsLike(1);
        }
        newsReplyDetailDTO.setReplyTime(DateUtils.timeConvertString(newsReplyDetailDTO.getAddTime()));
        //添加评论的新闻.帖子.或视频的详细实体
        newsReplyDetailDTO = this.addSuperiorObject(newsReply, userId, newsReplyDetailDTO);
        //查询该评论下的回复
        List<NewsReplyMirrorDTO> replies = this.newsReplyMapper.
                selectSubReplyList(newsReply.getId(), newsReply.getNewsId());
        if (CollectionUtils.isNotEmpty(replies)) {
            replies.forEach(replay -> {
                List<Long> replyLike = newsReplyMapper.selectReplyLike(newsId, userId, replyId);
                this.dealSubMirrorDTO(replay, userId, replyLike);
            });
        }
        newsReplyDetailDTO.setList(replies);
        return newsReplyDetailDTO;
    }

    /**
     * 添加评论新闻.帖子.或视频的详细实体
     *
     * @param newsReply
     * @param userId
     * @param newsReplyDetailDTO
     * @return
     */
    private NewsReplyDetailDTO addSuperiorObject(NewsReply newsReply, Long userId, NewsReplyDetailDTO newsReplyDetailDTO) {
        Byte type = newsReply.getType();
        if (type == ReplyTypeEnum.NEWS_REPLY.getCode()) {
            News news = newsMapper.selectByPrimaryKey(newsReply.getNewsId());
            if (null != news) {
                ReplyNewsDTO replyNewsDTO = getNewsDto(news, userId);
                newsReplyDetailDTO.setReplyNewsDto(replyNewsDTO);
                newsReplyDetailDTO.setTitle(news.getTitle());
            }
        } else if (type == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
            Video video = videoMapper.selectByPrimaryKey(newsReply.getNewsId());
            if (null != video) {
                ReplyVideoDTO replyVideoDTO = getVideoDto(video, userId);
                newsReplyDetailDTO.setReplyVideoDto(replyVideoDTO);
                newsReplyDetailDTO.setTitle(video.getTitle());
            }
        } else if (type == ReplyTypeEnum.POST_REPLY.getCode()) {
            ForumPostVo forumPostVo = forumMapper.getPostDetailById(newsReply.getNewsId());
            if (null != forumPostVo) {
                ReplyPostDTO replyPostDTO = getForumPostReplyDto(forumPostVo);
                newsReplyDetailDTO.setReplyPostDto(replyPostDTO);
                if (StringUtils.isNotEmpty(forumPostVo.getTitle())) {
                    newsReplyDetailDTO.setTitle(forumPostVo.getTitle());
                } else {
                    if (forumPostVo.getTextField().length() > 50) {
                        newsReplyDetailDTO.setTitle(forumPostVo.getTextField().substring(0, 50));
                    } else {
                        newsReplyDetailDTO.setTitle(forumPostVo.getTextField());
                    }
                }
            }
        }
        return newsReplyDetailDTO;
    }

    private ReplyPostDTO getForumPostReplyDto(ForumPostVo forumPostVo) {
        ReplyPostDTO replyPostDTO = new ReplyPostDTO();
        replyPostDTO.setId(forumPostVo.getId());
        replyPostDTO.setStatus((byte) forumPostVo.getStatus().intValue());
        replyPostDTO.setTitle(forumPostVo.getTitle());
        if (StringUtils.isNotBlank(forumPostVo.getImgList())) {
            replyPostDTO.setPostImgList(JSON.parseArray(forumPostVo.getImgList(), PostImgVo.class));
        }
        return replyPostDTO;
    }

    private ReplyNewsDTO getNewsDto(News news, Long userId) {
        ReplyNewsDTO replyNewsDTO = new ReplyNewsDTO();
        replyNewsDTO.setId(news.getId());
        replyNewsDTO.setImgUrl(news.getImgUrl());
        replyNewsDTO.setLinkUrl(iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.DETAIL, news.getId(), userId));
        replyNewsDTO.setShareUrl(iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.SHARE, news.getId(), userId));
        replyNewsDTO.setComments(news.getComments());
        replyNewsDTO.setStatus(news.getStatus());
        return replyNewsDTO;
    }

    private ReplyVideoDTO getVideoDto(Video video, Long userId) {
        ReplyVideoDTO replyVideoDTO = new ReplyVideoDTO();
        replyVideoDTO.setAuthorImg(video.getAuthorImg());
        replyVideoDTO.setAuthor(video.getAuthorName());
        replyVideoDTO.setId(video.getId());

        VideoLike videoLike = videoLikeMapper.selectByModel(new VideoLike(video.getId(), userId));
        if (null != videoLike) {
            replyVideoDTO.setPraise(true);
        } else {
            replyVideoDTO.setPraise(false);
        }

        replyVideoDTO.setLikeCount(Math.toIntExact(video.getLikeCount()));
        replyVideoDTO.setVideoUrl(videoRecommendService.videoAdressConversion(video.getVideoUrl()));
        replyVideoDTO.setVideoImg(video.getVideoImg());
        replyVideoDTO.setCommentCount(Math.toIntExact(video.getCommentCount()));
        replyVideoDTO.setStatus(video.getStatus());
        return replyVideoDTO;
    }

    /**
     * 得到更新之后的点赞数
     *
     * @param type
     * @param likeCount
     * @return
     */
    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                likeCount -= 1;
            }
        } else {
            likeCount += 1;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        NewsReplayLike newsReplayLike = newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        if (type == 1) {
            if (null == newsReplayLike) {
                NewsReplayLike newsReplayLikeNew = new NewsReplayLike();
                newsReplayLikeNew.setAddTime(new Date());
                newsReplayLikeNew.setId(nextSequence());
                newsReplayLikeNew.setReplyId(replyId);
                newsReplayLikeNew.setUserId(userId);
                count = newsReplyLikeMapper.insert(newsReplayLikeNew);
            }
        } else {
            if (null != newsReplayLike) {
                count = newsReplyLikeMapper.deleteByPrimaryKey(newsReplayLike.getId());
            }
        }
        return count;
    }


    /**
     * 评论点赞时验证参数
     *
     * @param newsReplyLikeParam
     * @return
     */
    private boolean checkLikeParam(NewsReplyLikeParam newsReplyLikeParam) {
        return null != newsReplyLikeParam.getReplyId() && null != newsReplyLikeParam.getUserId();
    }


    @Override
    public Calendar getMorningTime(Integer amount) {
        Calendar morningTime = Calendar.getInstance();
        morningTime.set(Calendar.HOUR_OF_DAY, 0);
        morningTime.set(Calendar.MINUTE, 0);
        morningTime.set(Calendar.SECOND, 0);
        morningTime.set(Calendar.MILLISECOND, 0);
        morningTime.add(Calendar.DAY_OF_YEAR, amount);
        return morningTime;
    }


}
