package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.dto.NewsCollectDTO;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
@Service
public class NewsCollectServiceImpl extends BaseService implements NewsCollectService {

    @Resource
    private NewsCollectMapper newsCollectMapper;

    @Resource
    private NewsStatisticIntegrationService newsStatisticIntegrationService;

    @Override
    public List<NewsCollectDTO> queryList(Long userId, MPage page) {
        List<NewsCollectDTO> resultList = newsCollectMapper.queryList(userId, page);
        //过滤为空的新闻
        return  resultList.stream().filter(Objects::nonNull).filter(e-> StringUtils.isNotBlank(e.getTitle())).collect(Collectors.toList());
}

    @Override
    public Json collectNews(NewsCollect newsCollect) {
        NewsCollect collect = this.newsCollectMapper.selectUserCollect(newsCollect.getNewsId(),
                newsCollect.getUserId(),
                newsCollect.getType());

        if (!ObjectUtils.isEmpty(collect)) {
            this.newsCollectMapper.deleteByModel(collect);
            newsStatisticIntegrationService.pushCollectData(newsCollect.getUserId(), newsCollect.getNewsId(), (byte) 0);
        } else {
            newsCollect.setId(nextSequence());
            this.newsCollectMapper.insertSelective(newsCollect);
            newsStatisticIntegrationService.pushCollectData(newsCollect.getUserId(), newsCollect.getNewsId(), (byte) 1);
        }
        return ResultUtil.genSuccessResult();

    }

}
