package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.news.domain.VideoInformMapper;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoInformParam;
import com.bxm.localnews.news.service.VideoBlackService;
import com.bxm.localnews.news.vo.VideoInform;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class VideoBlackServiceImpl extends BaseService implements VideoBlackService {

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Autowired
    private VideoInformMapper videoInformMapper;

    @Autowired
    private NewsStatisticIntegrationService newsStatisticIntegrationService;

    @Override
    public Message produceVideoReply(VideoBlackParam videoBlackParam) {
        newsStatisticIntegrationService.pushVideoBlackData(videoBlackParam);
        return Message.build(true);
    }

    @Override
    public Message informVideo(VideoInformParam param) {
        VideoInform videoInformParam = new VideoInform();
        videoInformParam.setVideoId(param.getVideoId());
        videoInformParam.setUserId(param.getUserId());
        List<VideoInform> informList = this.videoInformMapper.selectByModel(videoInformParam);
        if (CollectionUtils.isNotEmpty(informList)) {
            return Message.build(false, "您已举报过");
        }
        VideoInform videoInform = new VideoInform();
        BeanUtils.copyProperties(param, videoInform);
        videoInform.setId(nextSequence());
        this.videoInformMapper.insertSelective(videoInform);
        return Message.build(true);
    }

    /**
     * 屏蔽视频时参数验证
     * @param videoBlackParam
     * @return
     */
    private boolean checkParam(VideoBlackParam videoBlackParam) {
        if (null == videoBlackParam.getVideoId() || null == videoBlackParam.getUserId()) {
            return false;
        }
        if (1 == videoBlackParam.getType() && null == videoBlackParam.getReason()) {
            return false;
        }
        return true;
    }

}
