package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.VideoReplyDto;
import com.bxm.localnews.news.param.*;
import com.bxm.localnews.news.service.*;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class VideoReplyServiceImpl extends BaseService implements VideoReplyService, VideoReplyFacadeService {

    private final VideoReplyMapper videoReplyMapper;

    private final RedisListAdapter redisListAdapter;

    private final VideoMapper videoMapper;

    private final VideoReplayLikeMapper videoReplayLikeMapper;

    private final UserIntegrationService userIntegrationService;

    private final NewsReplyMapper newsReplyMapper;

    private final NewNewsReplyService newsReplyService;

    private final UserReplyMapper userReplyMapper;

    @Autowired
    public VideoReplyServiceImpl(VideoReplyMapper videoReplyMapper, RedisListAdapter redisListAdapter,
                                 VideoMapper videoMapper, VideoReplayLikeMapper videoReplayLikeMapper,
                                 UserIntegrationService userIntegrationService,NewsReplyMapper newsReplyMapper,
                                 NewNewsReplyService newsReplyService,UserReplyMapper userReplyMapper) {
        this.videoReplyMapper = videoReplyMapper;
        this.redisListAdapter = redisListAdapter;
        this.videoMapper = videoMapper;
        this.videoReplayLikeMapper = videoReplayLikeMapper;
        this.userIntegrationService = userIntegrationService;
        this.newsReplyMapper = newsReplyMapper;
        this.newsReplyService = newsReplyService;
        this.userReplyMapper= userReplyMapper;
    }

    @Override
    public PageWarper<VideoReplyDto> queryByPageSize(VideoReplyListQueryParam param) {

        NewsReplyParam newsReplyParam = new NewsReplyParam();
        newsReplyParam.setPageNum(param.getPageNum());
        newsReplyParam.setPageSize(param.getPageSize());
        newsReplyParam.setUserId(param.getUserId());
        newsReplyParam.setNewsId(param.getVideoId());
        List<VideoReplyDto> videoReplyDtoList = new ArrayList<>();

        PageWarper<NewsReplyDTO> newsReplyDTOPageWarper = new PageWarper<>(this.newsReplyMapper.queryVideoReplyByPageSize(newsReplyParam));
        List<NewsReplyDTO> newsReplyDTOList = newsReplyDTOPageWarper.getList();
        for (NewsReplyDTO newsReplyDTO:newsReplyDTOList) {
            VideoReplyDto videoReplyDto = new VideoReplyDto();
            if (isLike(newsReplyDTO.getUserId(),newsReplyDTO.getId())) {
                videoReplyDto.setIsLike(1);
            }
            videoReplyDto.setAddTime(newsReplyDTO.getAddTime());
            videoReplyDto.setComment(newsReplyDTO.getReplyContent());
            videoReplyDto.setDeleleFlag(newsReplyDTO.getDeleteFlag());
            videoReplyDto.setId(newsReplyDTO.getId());
            videoReplyDto.setLikeCount(newsReplyDTO.getLikeCount());
            videoReplyDto.setUserId(newsReplyDTO.getUserId());
            videoReplyDto.setUserImg(newsReplyDTO.getHeadImg());
            videoReplyDto.setUserName(newsReplyDTO.getUserNickname());

            if (newsReplyDTO.getParentId()!=0) {
                NewsReply sourceReply = newsReplyMapper.selectByPrimaryKey(newsReplyDTO.getParentId());
                if (null != sourceReply) {
                    VideoReplyDto vSourceReply = new VideoReplyDto();
                    if (isLike(sourceReply.getUserId(),sourceReply.getId())) {
                        vSourceReply.setIsLike(1);
                    }
                    vSourceReply.setAddTime(sourceReply.getAddTime());
                    vSourceReply.setComment(sourceReply.getReplyContent());
                    vSourceReply.setDeleleFlag(sourceReply.getDeleteFlag());
                    vSourceReply.setId(sourceReply.getId());
                    vSourceReply.setLikeCount(sourceReply.getLikeCount());
                    vSourceReply.setUserId(sourceReply.getUserId());
                    vSourceReply.setUserImg(sourceReply.getHeadImg());
                    vSourceReply.setUserName(sourceReply.getUserNickname());
                    videoReplyDto.setSourceReply(vSourceReply);
                }

            }
            videoReplyDtoList.add(videoReplyDto);
        }




//        List<VideoReplyDto> videoReplyDtoList = videoReplyMapper.queryByPageSize(param);
//        for (VideoReplyDto videoReplyDto : videoReplyDtoList) {
//            VideoReplyDto sourceReply = videoReplyDto.getSourceReply();
//            if (null != sourceReply) {
//                if (isLike(param.getUserId(), sourceReply.getId())) {
//                    sourceReply.setIsLike(1);
//                }
//            }
//
//            if (isLike(param.getUserId(), videoReplyDto.getId())) {
//                videoReplyDto.setIsLike(1);
//            }
//        }
        return new PageWarper<>(videoReplyDtoList);
    }


    /**
     * 判断当前用户是否对此回复点赞
     * @param userId
     * @param replyId
     * @return
     */
    private boolean isLike(Long userId, Long replyId) {
        VideoReplayLike videoReplayLike = videoReplayLikeMapper.selectByModel(new VideoReplayLike(replyId, userId));
        return null != videoReplayLike;
    }

    @Override
    public Message replyVideo(VideoReplyParam videoReplyParam) {
        if (!checkReplyParam(videoReplyParam)) {
            return Message.build(false, "参数验证错误");
        }
        NewsReply newsReply = new NewsReply();
        newsReply.setType((byte) 2);
        newsReply.setNewsId(videoReplyParam.getVideoId());
        newsReply.setRootId(0L);
        newsReply.setParentId(0L);
        newsReply.setLevel((byte) 0);
        newsReply.setStatus((byte) 1);
        newsReply.setLikeCount(0);
        newsReply.setId(nextSequence());
        newsReply.setReplyContent(videoReplyParam.getComment());
        if (videoReplyParam.getReplyId() != null ) {
            NewsReply newsReplyDb = newsReplyMapper.selectByPrimaryKey(videoReplyParam.getReplyId());
            if (newsReplyDb != null) {
                UserInfoDTO userInfoDTO = userIntegrationService.getUserInfo(newsReplyDb.getUserId());
                if (null!=userInfoDTO) {
                    newsReply.setParentUserNickname(userInfoDTO.getNickname());
                    newsReply.setParentUserId(userInfoDTO.getId());
                    newsReply.setParentHeadImg(userInfoDTO.getHeadImg());
                }
                newsReply.setParentId(newsReplyDb.getId());
                newsReply.setRootId(newsReplyDb.getRootId());
                Byte level = newsReplyDb.getLevel();
                if (level == 0) {
                    newsReply.setLevel((byte) 1);
                    newsReply.setRootId(newsReplyDb.getId());
                } else {
                    newsReply.setLevel((byte) 2);
                    newsReply.setRootId(newsReplyDb.getRootId());
                }
            }
        }

        UserInfoDTO userInfoDTO = userIntegrationService.getUserInfo(videoReplyParam.getUserId());
        if (null!=userInfoDTO) {
            newsReply.setUserNickname(userInfoDTO.getNickname());
            newsReply.setUserId(userInfoDTO.getId());
            newsReply.setHeadImg(userInfoDTO.getHeadImg());
        }

        int count = newsReplyMapper.insertSelective(newsReply);
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties(newsReply,userReply);
        userReplyMapper.insertSelective(userReply);
        // 更新新闻评论数
        if (count>0) {
            Video video = videoMapper.selectByPrimaryKey(videoReplyParam.getVideoId());
            if (null != video) {
                Video videoUp = new Video();
                videoUp.setId(videoReplyParam.getVideoId());
                videoUp.setCommentCount(video.getCommentCount() + 1);
                videoMapper.updateByPrimaryKeySelective(videoUp);
            }
        }
        return Message.build(true);
    }

    /**
     * 评论回复时验证参数
     * @param videoReplyParam
     * @return
     */
    private boolean checkReplyParam(VideoReplyParam videoReplyParam) {
        if (null == videoReplyParam.getUserId()
                || null == videoReplyParam.getComment() || null == videoReplyParam.getVideoId()) {
            return false;
        }
        return true;
    }



    @Override
    public Message produceVideoReplyLike(VideoReplyLikeParam videoReplyLikeParam) {
        if (!checkLikeParam(videoReplyLikeParam)) {
            return Message.build(false, "参数验证错误");
        }
//        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoReplyLikeQueue");
//
//        redisListAdapter.leftPush(keyGenerator, videoReplyLikeParam);
//        this.callAsyncConsume();
//        return Message.build(true);

        NewsReplyLikeParam newsReplyLikeParam = new NewsReplyLikeParam();
        newsReplyLikeParam.setReplyId(videoReplyLikeParam.getReplyId());
        newsReplyLikeParam.setType(videoReplyLikeParam.getType());
        newsReplyLikeParam.setUserId(videoReplyLikeParam.getUserId());
        return newsReplyService.doProduceNewsReplyLike(newsReplyLikeParam);

    }

//    private void callAsyncConsume() {
//        VideoReplyService videoReplyService = SpringContextHolder.getBean(VideoReplyService.class);
//        videoReplyService.videoReplyLikeConsume();
//    }

    @Async
    @Override
    public void videoReplyLikeConsume() {
//        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoReplyLikeQueue");
//
//        VideoReplyLikeParam videoReplyLikeWarper = redisListAdapter.rightPop(keyGenerator, VideoReplyLikeParam.class);
//        if (null != videoReplyLikeWarper) {
//            logger.info("小视频回复点赞开始消费...");
//            int type = videoReplyLikeWarper.getType();
//            VideoReply videoReply = videoReplyMapper.selectByPrimaryKey(videoReplyLikeWarper.getReplyId());
//            if (videoReply != null) {
//                int count = saveReplyLiKeRecord(videoReply.getId(), videoReplyLikeWarper.getUserId(), type);
//
//                if (count > 0) {
//                    logger.debug("评论实体:{}", JSONObject.toJSON(videoReply));
//                    int likeCount = generatorLikeCount(type, videoReply.getLikeCount());
//                    logger.debug("点赞数:{}", likeCount);
//                    VideoReply videoReplyUp = new VideoReply();
//                    videoReplyUp.setId(videoReplyLikeWarper.getReplyId());
//                    videoReplyUp.setLikeCount(likeCount);
//                    videoReplyMapper.updateByPrimaryKeySelective(videoReplyUp);
//                }
//            }
//            videoReplyLikeConsume();
//        }
    }

    /**
     * 得到更新之后的点赞数
     * @param type
     * @param likeCount
     * @return
     */
    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                likeCount -= 1;
            }
        } else {
            likeCount += 1;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        VideoReplayLike videoReplayLike = videoReplayLikeMapper.selectByModel(new VideoReplayLike(replyId, userId));
        if (type == 1) {
            if (null == videoReplayLike) {
                VideoReplayLike videoReplayLikeNew = new VideoReplayLike();
                videoReplayLikeNew.setAddTime(new Date());
                videoReplayLikeNew.setId(nextSequence());
                videoReplayLikeNew.setReplyId(replyId);
                videoReplayLikeNew.setUserId(userId);
                count = videoReplayLikeMapper.insert(videoReplayLikeNew);
            }
        } else {
            if (null != videoReplayLike) {
                count = videoReplayLikeMapper.deleteByPrimaryKey(videoReplayLike.getId());
            }
        }
        return count;
    }

    @Async
    @Override
    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
//        VideoReply videoReply = new VideoReply();
//        videoReply.setUserId(userId);
//        videoReply.setUserImg(headImg);
//        videoReply.setUserName(nickname);
//        videoReplyMapper.updateByUserIdSelective(videoReply);
    }

    /**
     * 评论点赞时验证参数
     * @param videoReplyLikeParam
     * @return
     */
    private boolean checkLikeParam(VideoReplyLikeParam videoReplyLikeParam) {
        if (null == videoReplyLikeParam.getReplyId() || null == videoReplyLikeParam.getUserId()) {
            return false;
        }
        return true;
    }

}
