package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.news.domain.VideoShareMapper;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.service.VideoShareService;
import com.bxm.localnews.news.vo.VideoShare;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class VideoShareServiceImpl extends BaseService implements VideoShareService {

    @Autowired
    private VideoShareMapper videoShareMapper;

    @Autowired
    private NewsStatisticIntegrationService newsStatisticIntegrationService;

    @Override
    public Message produceVideoShare(VideoShareParam videoShareParam) {
        VideoShare videoShare = new VideoShare();
        BeanUtils.copyProperties(videoShareParam, videoShare);
        videoShare.setId(nextSequence());
        videoShare.setAddTime(new Date());
        videoShareMapper.insertSelective(videoShare);
        newsStatisticIntegrationService.pushVideoShareData(videoShareParam);
        return Message.build(true);
    }

    /**
     * 视频分享时参数验证
     * @param videoShareParam
     * @return
     */
    private boolean checkParam(VideoShareParam videoShareParam) {
        return null != videoShareParam.getUserId()
                && null != videoShareParam.getVideoId()
                && null != videoShareParam.getType();
    }


}
