package com.bxm.localnews.news.strategy;


import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.news.constant.AppConst;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Objects;

import static com.bxm.localnews.news.constant.AppConst.NN_GOLD;

/**
 * 文章阅读奖励策略
 */
@Service
public class GoldCalculatorOfEssay extends AbstractGoldenStrategy {

    @Resource
    private NewsRecordMapper newsRecordMapper;

    @Resource
    private MissionIntegrationService missionIntegrationService;

    public GoldCalculatorOfEssay() {
    }

    @Override
    public void calculator(ExecGoldCalParam execGoldCalParam) {
        Long newsId = execGoldCalParam.getNewsId();
        Long userId = execGoldCalParam.getUserId();
        Integer viewTime = execGoldCalParam.getViewTime();
        String tabType = execGoldCalParam.getTabType();
        String advertShow = execGoldCalParam.getAdvertShow();
        NewsGoldMeta newsGoldMeta = execGoldCalParam.getNewsGoldMeta();
        NewsRecord nRecord = execGoldCalParam.getnRecord();

        byte goldType = AppConst.UN_GOLD;


        viewTimeFlag = checkViewTimeFlag(configViewTime, viewTime);

        advertShowFlag = checkAdvertShowFlag(configAdvertShow, advertShow);

        tabTYpeFlag = checkTabTYpeFlag(configTabType, tabType);

        if (checkLegalWithFlag(viewTimeFlag, advertShowFlag, execGoldCalParam.isSuspendFlag(), tabTYpeFlag)) {
            NewsCompleTaskDTO reward = missionIntegrationService.compleTask(userId, "TASK_NEWS_READ", newsId.toString());
            if (reward != null) {
                goldType = NN_GOLD;
                nRecord.setGetGoldTime(new Date());
                nRecord.setIntervalNum(randomInterval);
                newsGoldMeta.setGoldNum(Objects.isNull(reward.getGoldNum())?0:reward.getGoldNum().intValue());
                newsGoldMeta.setTotalGold(reward.getTotalGold());
                newsGoldMeta.setTaskName(reward.getTaskName());
            }
        }

        nRecord.setLastLocation(tabType);
        nRecord.setGetGold(goldType);
        nRecord.setUserId(userId);
        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);

        newsGoldMeta.setGoldType(goldType);


    }

    @Override
    public boolean support(int newsType) {
        return AppConst.NEWS.ESSAY == newsType;
    }


    private boolean checkLegalWithFlag(boolean viewTimeFlag, boolean advertShowFlag, boolean isSuspendFlag, boolean tabTYpeFlag) {
        return viewTimeFlag && advertShowFlag && tabTYpeFlag && isSuspendFlag;
    }


}
