package com.bxm.localnews.news.strategy;

import com.bxm.localnews.news.param.ExecGoldCalParam;

/**
 * 文章阅读奖励策略接口
 */
public interface GoldenStrategy {

    /**
     * 不同类型的策略具体方法
     * @param execGoldCalParam
     */
    void calculator(ExecGoldCalParam execGoldCalParam);

    /**
     * 通用方法
     * @param execGoldCalParam
     */
    void commonJudgment(ExecGoldCalParam execGoldCalParam);

    /**
     * 当前新闻类型，改策略是否支持
     * @param newsType
     * @return
     */
    boolean support(int newsType);

    default int order() {
        return Integer.MIN_VALUE;
    };
}
