package com.bxm.localnews.news.timer;
import com.bxm.localnews.news.constant.NewsTemplateConst;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * 新闻内容模板同步
 */
@Component
@Slf4j
public class AssemblySchedule {

    @Autowired
    private AliyunOSSService aliyunOSSService;

    /**
     * 每五分钟将模板内容同步到内存中
     */
    @Scheduled(cron="0 0/5 * * * ?")
    public void synchronizeTemplate(){
        String content = aliyunOSSService.getOssContentByPath("news/detail.html");
        log.debug("获取的模板内容为:{}",content);
        NewsTemplateConst.setNewsTemplate(content);
    }
}
