/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.convert.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.news.convert.Converter;
import com.bxm.localnews.news.vo.ForumBasicVo;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.PostImgVo;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class ForumBasicConvert
implements Converter<ForumBasicVo, ForumPostVo> {
    @Override
    public ForumPostVo convert(ForumBasicVo data) {
        ForumPostVo forumPostVo = new ForumPostVo();
        BeanUtils.copyProperties((Object)data, (Object)forumPostVo);
        forumPostVo.setStatus(Integer.valueOf(2));
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getAreaCode()) && forumPostVo.getAreaCode().length() < 12) {
            String areaCode = forumPostVo.getAreaCode() + "000000000000".substring(forumPostVo.getAreaCode().length());
            forumPostVo.setAreaCode(areaCode);
        }
        StringBuilder content = new StringBuilder("<p>");
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getTextField())) {
            content.append(forumPostVo.getTextField().replaceAll("\\n", "</p><p>"));
        }
        content.append("</p>");
        if (CollectionUtils.isNotEmpty((Collection)forumPostVo.getPostImgList())) {
            forumPostVo.setImgList(JSON.toJSONString((Object)forumPostVo.getPostImgList()));
            for (PostImgVo postImgVo : forumPostVo.getPostImgList()) {
                content.append("<img src=\"");
                content.append(postImgVo.getImgUrl());
                content.append("\"></img>");
            }
        }
        forumPostVo.setContent(content.toString());
        String imgList = forumPostVo.getImgList();
        List postImgVos = JSONObject.parseArray((String)imgList, PostImgVo.class);
        if (CollectionUtils.isNotEmpty((Collection)postImgVos)) {
            postImgVos.stream().forEach(e -> {
                if (StringUtils.isBlank((CharSequence)e.getType())) {
                    e.setType("IMG");
                }
            });
            forumPostVo.setImgList(JSONObject.toJSONString((Object)postImgVos));
        }
        return forumPostVo;
    }
}

