/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.factory.impl;

import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.constant.UrlCategoryEnum;
import com.bxm.localnews.news.constant.UrlPositionEnum;
import com.bxm.localnews.news.constant.UrlTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UrlFactory
implements IUrlFactory {
    @Autowired
    private BizConfigProperties bizConfigProperties;

    @Override
    public String getAppUrl(UrlCategoryEnum urlCategoryEnum, UrlTypeEnum urlTypeEnum, Long id, Long userId) {
        if (UrlCategoryEnum.NEWS.equals((Object)urlCategoryEnum)) {
            if (UrlTypeEnum.DETAIL.equals((Object)urlTypeEnum)) {
                if (userId == null) {
                    return this.bizConfigProperties.getH5ServerHost() + "/newsDetail.html?newsId=" + id + "&type=" + 1;
                }
                return this.bizConfigProperties.getH5ServerHost() + "/newsDetail.html?newsId=" + id + "&userId=" + userId + "&type=" + 1;
            }
            if (UrlTypeEnum.SHARE.equals((Object)urlTypeEnum)) {
                if (userId == null) {
                    return this.bizConfigProperties.getH5ServerHost() + "/shareNewsDetail.html?newsId=" + id + "&type=" + 2;
                }
                return this.bizConfigProperties.getH5ServerHost() + "/shareNewsDetail.html?newsId=" + id + "&userId=" + userId + "&type=" + 2;
            }
        } else if (UrlCategoryEnum.FORUM.equals((Object)urlCategoryEnum)) {
            return this.bizConfigProperties.getH5ServerHost() + "/shareInvitationDetail.html?userId=" + userId + "&id=" + id;
        }
        return null;
    }

    @Override
    public String getAppletUrl(UrlPositionEnum urlPositionEnum, Long id, Long userId) {
        switch (urlPositionEnum) {
            case BLOCK: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=block&id=" + id + "&isShare=1&uid=" + userId;
            }
            case TOPIC: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=topic&id=" + id + "&isShare=1&uid=" + userId;
            }
            case POST: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=post&id=" + id + "&isShare=1&uid=" + userId;
            }
            case NEWS: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=news&id=" + id + "&isShare=1&uid=" + userId;
            }
            case MANLL_HOME: {
                return this.bizConfigProperties.getAppletServerHost() + "?tp=manllHome&id=" + id + "&isShare=1&uid=" + userId;
            }
        }
        return null;
    }
}

