/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.UserTagConsumeMapper;
import com.bxm.localnews.news.vo.UserTag;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class WeightService
extends BaseService {
    private static final long INTERVAL = 1800000L;
    @Resource
    private UserTagConsumeMapper userTagConsumeMapper;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    public void recalcuUserTagWeight(Long userId) {
        Long lastRecommendTime = (Long)this.redisHashMapAdapter.get(RedisConfig.NEWS_RECOMMEND_INTERVAL, userId.toString(), Long.class);
        long current = System.currentTimeMillis();
        if (lastRecommendTime == null || current - lastRecommendTime > 1800000L) {
            this.redisHashMapAdapter.put(RedisConfig.NEWS_RECOMMEND_INTERVAL, userId.toString(), (Object)current);
            this.execRecalcu(userId);
        }
    }

    private void execRecalcu(Long userId) {
        List recountTags = this.userTagConsumeMapper.recountUserTags(userId);
        List kindTags = this.userTagConsumeMapper.getKindTags();
        for (UserTag kindTag : kindTags) {
            if (!recountTags.stream().noneMatch(tag -> StringUtils.equals((CharSequence)kindTag.getName(), (CharSequence)tag.getName()))) continue;
            recountTags.add(kindTag);
        }
        boolean removeEmpty = recountTags.removeIf(tag -> tag.getName() == null || "".equals(tag.getName()));
        if (removeEmpty) {
            this.logger.error("[{}]\u63a8\u8350\u7684\u65b0\u95fb\u6807\u7b7e\u5305\u542b\u7a7a\u6807\u7b7e", (Object)userId);
        }
        Date current = new Date();
        recountTags.forEach(e -> {
            e.setId(Long.valueOf(this.nextId()));
            e.setUpdateTime(current);
            e.setUserId(userId);
        });
        this.userTagConsumeMapper.deleteUserTag(userId);
        this.batchSave(recountTags);
    }

    private void batchSave(List<UserTag> tags) {
        MybatisBatchBuilder.create(UserTagConsumeMapper.class, tags).run(UserTagConsumeMapper::insert);
    }
}

