/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.news.constant.NewsTemplateConst;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssemblyServiceImpl
implements AssemblyService {
    private static final Logger log = LoggerFactory.getLogger(AssemblyServiceImpl.class);
    private final AliyunOSSService aliyunOSSService;

    @Autowired
    public AssemblyServiceImpl(AliyunOSSService aliyunOSSService) {
        this.aliyunOSSService = aliyunOSSService;
    }

    @Override
    public String assemblyContent(String target) {
        String newsTemplate = NewsTemplateConst.getNewsTemplate();
        if (StringUtils.isBlank((String)newsTemplate)) {
            newsTemplate = this.aliyunOSSService.getOssContentByPath(NewsTemplateConst.getPath());
            NewsTemplateConst.setNewsTemplate((String)newsTemplate);
        }
        if (StringUtils.isNotBlank((String)target)) {
            target = this.fixContent(target);
            return newsTemplate.replace("{body}", target);
        }
        return newsTemplate;
    }

    @Override
    public String fixContent(String content) {
        content = this.appletAdapter(content);
        Document document = Jsoup.parse((String)content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        this.addWatermark(document);
        this.deleteNbspFromVideo(document);
        return document.body().html().replace("\n", "");
    }

    private String appletAdapter(String content) {
        return StringUtils.replace((String)content, (String)"\u4f60\u5c06\u83b7\u5f9710\u6735\u5c0f\u7ea2\u82b1", (String)"\u6700\u591a\u83b7\u5f97300\u6735\u5c0f\u7ea2\u82b1");
    }

    private void addWatermark(Document document) {
        Elements elements = document.select("img");
        if (null != elements) {
            for (Element element : elements) {
                String extend;
                String src = element.attr("src");
                if (StringUtils.isBlank((String)src) && StringUtils.isBlank((String)(src = element.attr("data-src")))) continue;
                String url = src;
                int lastIndex = src.lastIndexOf("?");
                if (-1 != lastIndex) {
                    url = src.substring(0, lastIndex);
                }
                url = "gif".equalsIgnoreCase(extend = FileUtils.getFilextension((String)url)) ? url + "?x-oss-process=style/mcompress" : url + "?x-oss-process=style/wcompress";
                element.attr("src", url);
            }
        }
    }

    @Override
    public String deleteVideoLabel(String content) {
        Document document = Jsoup.parse((String)content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        document.select("video").remove();
        return document.body().html().replace("\n", "");
    }

    @Override
    public String deleteNbspFromVideo(Document document) {
        Elements elements = document.select("video");
        if (!elements.isEmpty()) {
            for (Element element : elements) {
                Element parent = element.parent();
                parent.html(parent.html().replace("&nbsp;", ""));
            }
        }
        return document.body().html().replace("\n", "");
    }
}

