/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.facade.QuartzIntegrationService;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.config.BizConfigProperties;
import com.bxm.localnews.news.config.ClientConfigProperties;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.constant.UrlCategoryEnum;
import com.bxm.localnews.news.constant.UrlPositionEnum;
import com.bxm.localnews.news.constant.UrlTypeEnum;
import com.bxm.localnews.news.convert.impl.ForumBasicConvert;
import com.bxm.localnews.news.convert.impl.ForumParamPageConvert;
import com.bxm.localnews.news.convert.impl.ForumPostConvert;
import com.bxm.localnews.news.convert.impl.ForumTopPostConvert;
import com.bxm.localnews.news.domain.ForumMapper;
import com.bxm.localnews.news.domain.ForumPostCollectMapper;
import com.bxm.localnews.news.domain.ForumPostInformMapper;
import com.bxm.localnews.news.domain.ForumPostLikeMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostRecordMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.dto.ForumPostCreateDTO;
import com.bxm.localnews.news.dto.ForumPostLikeDTO;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.dto.PostTopicDTO;
import com.bxm.localnews.news.dto.ReplenishmentDTO;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.param.ForumPostInformParam;
import com.bxm.localnews.news.param.ForumPostListQueryParam;
import com.bxm.localnews.news.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.param.UserTopPostBuildParam;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.NewsReadRewardService;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.service.SensitiveWordService;
import com.bxm.localnews.news.vo.ForumBasicVo;
import com.bxm.localnews.news.vo.ForumPostCollect;
import com.bxm.localnews.news.vo.ForumPostInform;
import com.bxm.localnews.news.vo.ForumPostLike;
import com.bxm.localnews.news.vo.ForumPostRecord;
import com.bxm.localnews.news.vo.ForumPostStatistic;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.ForumTopPost;
import com.bxm.localnews.news.vo.ForumVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.PostForumVO;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.PostTopicVO;
import com.bxm.localnews.news.vo.TopicVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.param.AccountGoldParam;
import com.bxm.localnews.param.ForumParam;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.CharUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.HtmlContentUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.util.ObjectUtils;

@Service
public class ForumServiceImpl
extends BaseService
implements ForumService {
    private static final String COMMA = ",";
    @Resource
    private ForumMapper forumMapper;
    @Resource
    private SequenceCreater sequenceCreater;
    @Resource
    private SensitiveWordService sensitiveWordService;
    @Resource
    private IUrlFactory iUrlFactory;
    @Resource
    private ForumPostInformMapper forumPostInformMapper;
    @Resource
    private ForumPostCollectMapper forumPostCollectMapper;
    @Resource
    private ForumPostLikeMapper forumPostLikeMapper;
    @Resource
    private ForumPostMapper forumPostMapper;
    @Resource
    private UserIntegrationService userIntegrationService;
    @Resource
    private NewsRecommendIntegrationService newsRecommendIntegrationService;
    @Resource
    private BizLogIntegrationService bizLogIntegrationService;
    @Resource
    private AssemblyService assemblyService;
    @Resource
    private NewsReadRewardService newsReadRewardService;
    @Resource
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    @Resource
    private NewsMapper newsMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private UserAccountIntegrationService userAccountIntegrationService;
    @Resource
    private ForumPostRecordMapper forumPostRecordMapper;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private QuartzIntegrationService quartzIntegrationService;
    @Resource
    private RedisListAdapter redisListAdapter;
    @Resource
    private LocationIntegrationService locationIntegrationService;
    @Resource
    private MessageIntegrationService messageIntegrationService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private ForumBasicConvert forumBasicConvert;
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private ForumParamPageConvert forumParamPageConvert;
    @Resource
    private ForumTopPostConvert forumTopPostConvert;
    @Resource
    private ClientConfigProperties clientConfigProperties;
    @Resource
    private UserProperties userProperties;

    @Override
    public List<ForumVo> listForum(String areaCode, Integer enable, Long userId, Integer size, BasicParam basicParam) {
        List<ForumVo> forumVoList;
        if (null == size) {
            size = -1;
        }
        if (CollectionUtils.isNotEmpty((Collection)(forumVoList = this.forumMapper.getForumList(areaCode, enable)))) {
            this.sortForm(forumVoList, userId);
            forumVoList = forumVoList.stream().distinct().collect(Collectors.toList());
            if (size != -1) {
                forumVoList = forumVoList.stream().limit(size.intValue()).collect(Collectors.toList());
            }
            forumVoList.forEach(e -> {
                e.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, e.getId(), userId));
                e.setShareUrl(this.bizConfigProperties.getH5ServerHost());
            });
            if (5 == basicParam.getPlatform() && this.bizConfigProperties.getAppletReviewEnable().booleanValue()) {
                ArrayList<Long> postIds = new ArrayList<Long>(Arrays.asList(72317665317008L, 79585788760192L, 80775388106880L, 81892185086080L, 77973991071872L, 80669901684864L, 79211746459776L, 79211241126016L));
                forumVoList = forumVoList.stream().filter(e -> !postIds.contains(e.getId())).collect(Collectors.toList());
            }
        }
        return forumVoList;
    }

    private void sortForm(List<ForumVo> forumVoList, Long userId) {
        List forumList;
        KeyGenerator forumKey = RedisConfig.FORUM_INFO.copy().appendKey((Object)userId).appendKey((Object)"forum").appendKey((Object)"recent");
        if (this.redisListAdapter.size(forumKey) > 0L && CollectionUtils.isNotEmpty((Collection)(forumList = this.redisListAdapter.leftIndex(forumKey, this.redisListAdapter.size(forumKey).longValue(), Long.class)))) {
            ArrayList<ForumVo> existence = new ArrayList<ForumVo>();
            for (Long id : forumList) {
                for (ForumVo forumVo : forumVoList) {
                    if (!forumVo.getId().equals(id)) continue;
                    existence.add(forumVo);
                }
            }
            if (forumVoList.size() >= 2) {
                forumVoList.addAll(2, existence);
            } else {
                forumVoList.addAll(existence);
            }
        }
    }

    @Override
    public ForumVo getForumDetail(Long id, Long userId) {
        this.updateForum(id, userId);
        ForumVo forumVo = this.forumMapper.selectForumById(id);
        forumVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, forumVo.getId(), userId));
        forumVo.setShareUrl(this.bizConfigProperties.getH5ServerHost());
        return forumVo;
    }

    private void updateForum(Long forumId, Long userId) {
        List<Object> ids = new ArrayList<Long>();
        ids.add(forumId);
        KeyGenerator forumKey = RedisConfig.FORUM_INFO.copy().appendKey((Object)userId).appendKey((Object)"forum").appendKey((Object)"recent");
        if (this.redisListAdapter.size(forumKey) > 0L) {
            List forumList = this.redisListAdapter.leftIndex(forumKey, this.redisListAdapter.size(forumKey).longValue(), Long.class);
            ids.addAll(forumList);
        }
        ids = ids.stream().distinct().collect(Collectors.toList());
        this.logger.debug("\u6839\u636eid\u8fdb\u5165\u677f\u5757\u8be6\u60c5\u83b7\u53d6\u63a8\u8350\u6d41\u66f4\u65b0\u677f\u5757\u987a\u5e8f,id:{},userId:{},redisKey:{}", new Object[]{forumId, userId, forumKey.gen()});
        this.redisListAdapter.remove(forumKey);
        this.redisListAdapter.rightPush(forumKey, (Object[])ids.toArray(new Long[0]));
        this.redisListAdapter.expire(forumKey, 259200L);
    }

    @Override
    public List<TopicVo> listTopic(String areaCode, Integer enable, Integer size, Long userId) {
        List<TopicVo> topicVoList;
        if (null == size) {
            size = -1;
        }
        if (CollectionUtils.isNotEmpty((Collection)(topicVoList = this.forumMapper.getTopicList(areaCode, enable)))) {
            if (size == 2) {
                if ((topicVoList = topicVoList.stream().limit(6L).collect(Collectors.toList())).size() > 2) {
                    ArrayList<TopicVo> randomTopicVoList = new ArrayList<TopicVo>();
                    this.generateRandomTopic(topicVoList, randomTopicVoList);
                    topicVoList = randomTopicVoList;
                }
                this.logger.debug("\u83b7\u5f97\u8bdd\u9898:{}", (Object)JSONObject.toJSONString(topicVoList));
            }
            topicVoList.forEach(e -> {
                e.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, e.getId(), userId));
                e.setShareUrl(this.bizConfigProperties.getH5ServerHost());
            });
        }
        return topicVoList;
    }

    private void generateRandomTopic(List<TopicVo> originList, List<TopicVo> randomTopicVoList) {
        this.logger.debug("\u968f\u673a\u53d6\u4e24\u6761\u8bdd\u9898:{}", (Object)originList.size());
        if (CollectionUtils.isNotEmpty(originList)) {
            int random = RandomUtils.nextInt((int)0, (int)originList.size());
            this.logger.debug("\u968f\u673a\u53d6\u65701:{}", (Object)random);
            randomTopicVoList.add(originList.get(random));
            originList.remove(random);
            if (CollectionUtils.isNotEmpty(originList)) {
                int random2 = RandomUtils.nextInt((int)0, (int)originList.size());
                this.logger.debug("\u968f\u673a\u53d6\u65702:{}", (Object)random2);
                randomTopicVoList.add(originList.get(random2));
            }
        }
    }

    @Override
    public TopicVo getTopicDetail(Long id, Long userId) {
        TopicVo topicVo = this.forumMapper.selectTopicById(id);
        topicVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, topicVo.getId(), userId));
        topicVo.setShareUrl(this.bizConfigProperties.getH5ServerHost());
        return topicVo;
    }

    @Override
    public PageWarper<ForumPostVo> listForumPost(ForumPostListQueryParam param, BasicParam basicParam) {
        List postIdList;
        this.logger.debug("\u83b7\u53d6\u63a8\u8350\u6d41,param:{}", JSONObject.toJSON((Object)param));
        PageWarper forumPostPage = new PageWarper();
        if (5 == basicParam.getPlatform() && this.bizConfigProperties.getAppletReviewEnable().booleanValue() && 3 == param.getType()) {
            postIdList = this.forumMapper.listPostRecommend(param);
        } else {
            if (param.getRecommendType() == 1 && param.getForumId() != null) {
                this.updateForum(param.getForumId(), param.getUserId());
            }
            ForumParam forumParam = (ForumParam)this.forumParamPageConvert.convert(param);
            postIdList = this.newsRecommendIntegrationService.recommendList(forumParam);
        }
        if (CollectionUtils.isNotEmpty((Collection)postIdList)) {
            List postList = this.forumMapper.listPostByIds(postIdList);
            forumPostPage.setList(postList);
            forumPostPage.setPageNum(param.getPageNum().intValue());
            forumPostPage.setPageSize(param.getPageSize().intValue());
            this.fillExtInfo(forumPostPage.getList(), param.getUserId(), param.getAreaCode(), false);
        }
        if (CollectionUtils.isEmpty((Collection)postIdList) || postIdList.size() < param.getPageSize()) {
            forumPostPage.setIsLastPage(true);
            forumPostPage.setHasNextPage(false);
        } else {
            forumPostPage.setHasNextPage(true);
        }
        this.logger.debug("[listForumPost]\u62c9\u53d6\u5e16\u5b50\u5217\u8868\u5b8c\u6bd5,\u7ed3\u679c:{}", (Object)StringUtils.substring((String)JSONObject.toJSONString((Object)JSONObject.toJSONString((Object)forumPostPage)), (int)0, (int)500));
        return forumPostPage;
    }

    @Override
    public PageWarper<ForumPostVo> listForumPostByUser(ForumPostListUserQueryParam param) {
        PageWarper forumPostWarper = new PageWarper();
        if (null == param || null == param.getType()) {
            return null;
        }
        if (1 == param.getType()) {
            forumPostWarper = new PageWarper(this.forumMapper.getPostList(param));
        } else if (2 == param.getType()) {
            forumPostWarper = new PageWarper(this.forumMapper.getCollectPostList(param));
        }
        if (CollectionUtils.isNotEmpty((Collection)forumPostWarper.getList())) {
            if (param.getType() == 1) {
                this.fillExtInfo(forumPostWarper.getList(), param.getUserId(), null, false);
            } else if (param.getType() == 2) {
                this.fillExtInfo(forumPostWarper.getList(), param.getUserId(), null, true);
            }
        }
        return forumPostWarper;
    }

    @Override
    public ForumPostVo getForumPostDetail(Long id, Long userId, String deviceId, Long shareUserId, BasicParam basicParam, String areaCode) {
        LocationDTO location;
        ForumPostVo forumPostVo = this.forumMapper.getPostDetailById(id);
        String locationName = null;
        if (StringUtils.isNotEmpty((CharSequence)areaCode) && null != (location = this.locationIntegrationService.getLocationByGeocode(areaCode))) {
            locationName = location.getName();
        }
        this.completePostInfo(forumPostVo, userId, locationName);
        if (null != forumPostVo) {
            if (forumPostVo.getStatus() != null && (3 == forumPostVo.getStatus() || 4 == forumPostVo.getStatus())) {
                return null;
            }
            if (StringUtils.isNotEmpty((CharSequence)forumPostVo.getContent())) {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)deviceId) || 5 == basicParam.getPlatform()) {
                    forumPostVo.setContent(this.assemblyService.fixContent(forumPostVo.getContent()));
                } else {
                    String content = this.assemblyService.assemblyContent(forumPostVo.getContent());
                    forumPostVo.setContent(content);
                }
                if (StringUtils.isNotEmpty((CharSequence)forumPostVo.getEditorMessage())) {
                    forumPostVo.setContent(forumPostVo.getContent() + forumPostVo.getEditorMessage());
                }
            }
            this.doRecordForumPost(userId, id, shareUserId, basicParam.getPlatform(), forumPostVo);
            ((ForumService)SpringContextHolder.getBean(ForumService.class)).doAsyncReadPost(userId, id, shareUserId, basicParam.getPlatform(), forumPostVo);
        }
        return forumPostVo;
    }

    @Override
    public Message doCreateOrUpdatePost(ForumBasicVo forumBasicVo) {
        this.logger.debug("\u7528\u6237\u53d1\u5e16\u6216\u8005\u7f16\u8f91\uff0c\u53c2\u6570:[{}]", (Object)JSONObject.toJSONString((Object)forumBasicVo));
        if (this.sensitiveWordService.contains(forumBasicVo.getTextField())) {
            return Message.build((boolean)false);
        }
        Message message = Message.build((boolean)true);
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        ForumPostVo forumPostVo = this.forumBasicConvert.convert(forumBasicVo);
        if (null == forumPostVo.getId()) {
            this.saveForumPost(forumPostVo);
            ((ForumService)SpringContextHolder.getBean(ForumService.class)).doAsyncCallService(forumPostVo);
            ((ForumService)SpringContextHolder.getBean(ForumService.class)).createPostUserTopTaskJob(forumPostVo);
            newsCompleTaskDTO = this.completeTask(forumPostVo, forumBasicVo.getUserId(), forumPostVo.getId());
        } else {
            this.forumPostMapper.deleteMixRecommandPoolById(forumPostVo.getId());
            this.forumMapper.updateByPrimaryKeySelective(forumPostVo);
        }
        this.updateTopic(forumPostVo);
        ForumPostCreateDTO forumPostCreateDTO = this.generateForumPost(forumPostVo, newsCompleTaskDTO, forumBasicVo.getUserId());
        message.addParam("completeTaskAndPush", (Object)forumPostCreateDTO);
        return message;
    }

    private ForumPostCreateDTO generateForumPost(ForumPostVo forumPostVo, NewsCompleTaskDTO newsCompleTaskDTO, Long userId) {
        ForumPostCreateDTO.ForumPost forumPost = new ForumPostCreateDTO.ForumPost();
        forumPost.setId(forumPostVo.getId());
        if (CollectionUtils.isNotEmpty((Collection)forumPostVo.getPostImgList())) {
            forumPost.setPostImgUrl(((PostImgVo)forumPostVo.getPostImgList().get(0)).getImgUrl());
        }
        forumPost.setTextField(forumPostVo.getTextField());
        forumPost.setTitle(forumPostVo.getTitle());
        ForumPostCreateDTO forumPostCreateDTO = new ForumPostCreateDTO();
        forumPostCreateDTO.setGoldNum(Long.valueOf(Objects.isNull(newsCompleTaskDTO.getGoldNum()) ? 0L : newsCompleTaskDTO.getGoldNum()));
        forumPostCreateDTO.setTaskName(newsCompleTaskDTO.getTaskName());
        forumPostCreateDTO.setTotalGold(newsCompleTaskDTO.getTotalGold());
        forumPostCreateDTO.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), userId));
        forumPostCreateDTO.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), userId));
        forumPostCreateDTO.setForumPost(forumPost);
        return forumPostCreateDTO;
    }

    private NewsCompleTaskDTO completeTask(ForumPostVo forumPostVo, Long userId, Long postId) {
        NewsCompleTaskDTO newsCompleTaskDTO = new NewsCompleTaskDTO();
        String textField = forumPostVo.getTextField();
        if (CharUtil.isCharSatisfied((String)textField, (int)20) && (null == (newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, TaskEnum.TASK_FIRST_POST_INTIVATION.name(), postId.toString())) || null == newsCompleTaskDTO.getGoldNum() || 0L == newsCompleTaskDTO.getGoldNum())) {
            newsCompleTaskDTO = this.missionIntegrationService.compleTask(userId, TaskEnum.TASK_POST_INTIVATION.name(), postId.toString());
        }
        return newsCompleTaskDTO;
    }

    private void saveForumPost(ForumPostVo forumPostVo) {
        forumPostVo.setId(this.getPostId());
        UserBean user = this.userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
        if (null != user) {
            if (StringUtils.isBlank((CharSequence)user.getHeadImg()) || StringUtils.isBlank((CharSequence)user.getNickname())) {
                this.logger.info("\u5e16\u5b50\u4fdd\u5b58\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)user));
            }
            forumPostVo.setUserImg(user.getHeadImg());
            forumPostVo.setUserName(user.getNickname());
        }
        forumPostVo.setCreateTime(new Date());
        forumPostVo.setDisplayDateTime(new Date());
        forumPostVo.setPublishTime(new Date());
        this.forumMapper.insertSelective(forumPostVo);
    }

    private void updateTopic(ForumPostVo forumPostVo) {
        if (CollectionUtils.isNotEmpty((Collection)forumPostVo.getTopicIdList())) {
            ArrayList<PostTopicDTO> list = new ArrayList<PostTopicDTO>();
            for (Long topicId : forumPostVo.getTopicIdList()) {
                PostTopicDTO postTopicDTO = new PostTopicDTO();
                postTopicDTO.setId(this.sequenceCreater.nextLongId());
                postTopicDTO.setPostId(forumPostVo.getId());
                postTopicDTO.setTopicId(topicId);
                list.add(postTopicDTO);
            }
            this.forumMapper.batchDeleteTopic(forumPostVo.getId());
            this.forumMapper.batchInsertTopic(list);
        }
    }

    @Override
    @Async
    public void doAsyncCallService(ForumPostVo forumPostVo) {
        try {
            this.userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), Integer.valueOf(1));
            this.bizLogIntegrationService.forumSuccessed(forumPostVo.getUserId(), forumPostVo.getAreaCode(), null);
        }
        catch (Exception e) {
            this.logger.debug("\u65b0\u589e\u5e16\u5b50\u8c03\u7528\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @Override
    @Async
    public void createPostUserTopTaskJob(ForumPostVo forumPostVo) {
        ForumTopPost forumTopPost = (ForumTopPost)this.forumTopPostConvert.convert(forumPostVo);
        this.logger.debug("[createPostUserTopTaskJob]\u7528\u6237\u53d1\u5e16\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5904\u7406\u7528\u6237\u7f6e\u9876\u5e16\u5b50:{}", (Object)JSONObject.toJSONString((Object)forumTopPost));
        KeyGenerator postUserTop = RedisConfig.FORUM_RECOMMENDED.copy().appendKey((Object)forumPostVo.getUserId()).appendKey((Object)"top");
        Long size = this.redisListAdapter.size(postUserTop);
        List<Object> result = new ArrayList<ForumTopPost>();
        if (size == 0L) {
            result.add(forumTopPost);
        } else {
            List forumTopPostList = this.redisListAdapter.leftIndex(postUserTop, size - 1L, ForumTopPost.class);
            forumTopPostList.add(forumTopPost);
            result = forumTopPostList.stream().sorted(Comparator.comparing(ForumTopPost::getId).reversed()).collect(Collectors.toList());
        }
        this.logger.debug("[createPostUserTopTaskJob]\u5c06\u7528\u6237\u5e16\u5b50\u7f6e\u9876\u5b58\u5165redis\u4e2d:{}", (Object)JSONObject.toJSONString(result));
        this.redisListAdapter.remove(postUserTop);
        this.redisListAdapter.rightPush(postUserTop, (Object[])result.toArray(new ForumTopPost[0]));
        this.redisListAdapter.expire(postUserTop, 3600L);
        UserTopPostBuildParam param = new UserTopPostBuildParam();
        param.setPostId(forumPostVo.getId());
        param.setUserId(forumPostVo.getUserId());
        param.setAddTime(forumPostVo.getCreateTime());
        this.logger.debug("\u521b\u5efa\u53d1\u5e03\u5e16\u5b50\u7f6e\u9876:{}", (Object)JSON.toJSONString((Object)param));
        this.quartzIntegrationService.removePostUserTopTask(param);
    }

    @Override
    public Boolean deleteForumPost(Long id) {
        this.logger.debug("\u5f00\u59cb\u5220\u9664\u5e16\u5b50\uff0cid\uff1a" + id);
        ForumPostVo forumPostVo = this.forumMapper.getPostDetailById(id);
        if (forumPostVo == null) {
            return false;
        }
        forumPostVo.setStatus(Integer.valueOf(4));
        this.forumMapper.updateByPrimaryKeySelective(forumPostVo);
        this.forumPostMapper.deleteMixRecommandPoolById(id);
        this.logger.debug("\u5f00\u59cb\u56de\u6536\u91d1\u5e01\uff0cid\uff1a" + id);
        Integer goldNum = this.userAccountIntegrationService.countGoldByPostId(id, forumPostVo.getUserId());
        if (null != goldNum && goldNum > 0) {
            AccountGoldParam param = new AccountGoldParam();
            param.setUserId(forumPostVo.getUserId());
            param.setGold(Integer.valueOf(-goldNum.intValue()));
            param.setGoldType("USABLE_GOLD");
            param.setGoldFlowType("TASK_POST_DELETE");
            param.setAddTotal(Boolean.valueOf(false));
            param.setRelationId(id);
            this.userAccountIntegrationService.addGold(param);
        }
        this.newsRecommendIntegrationService.cleanUserTop(forumPostVo.getUserId(), forumPostVo.getId());
        this.userIntegrationService.addPostReplyNum(forumPostVo.getUserId(), Integer.valueOf(2));
        this.logger.debug("\u5e16\u5b50\u5220\u9664\u5b8c\u6210\uff0cid\uff1a" + id);
        return true;
    }

    @Override
    public void fillExtInfo(List<ForumPostVo> forumPostList, Long userId, String areaCode, boolean isFillTitle) {
        LocationDTO location;
        String locationName = null;
        if (StringUtils.isNotEmpty((CharSequence)areaCode) && null != (location = this.locationIntegrationService.getLocationByGeocode(areaCode))) {
            locationName = location.getName();
        }
        List postId = forumPostList.stream().map(ForumBasicVo::getId).collect(Collectors.toList());
        List postTopicVOList = this.forumMapper.listPostTopic(postId);
        postTopicVOList.forEach(e -> {
            e.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, e.getId(), userId));
            e.setShareUrl(this.bizConfigProperties.getH5ServerHost());
        });
        List postForumVOList = this.forumMapper.listPostForum(postId);
        postForumVOList.forEach(e -> {
            e.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, e.getId(), userId));
            e.setShareUrl(this.bizConfigProperties.getH5ServerHost());
        });
        List postLikeIdList = this.forumMapper.listUserPostLike(userId);
        List postCollectIdList = this.forumMapper.listUserPostCollect(userId);
        if (!CollectionUtils.isEmpty(forumPostList)) {
            for (ForumPostVo forumPostVo : forumPostList) {
                this.completePostInfo(forumPostVo, userId, locationName, postForumVOList, postTopicVOList, postLikeIdList, postCollectIdList, isFillTitle);
            }
        }
    }

    @Override
    public void doRecordForumPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo) {
        ForumPostRecord pRecord = this.forumPostRecordMapper.selectByIds(postId, userId, null);
        Date d = new Date();
        if (pRecord != null) {
            pRecord.setUpdateTime(d);
            this.forumPostRecordMapper.updateByPrimaryKeySelective(pRecord);
        } else {
            ForumPostRecord nr = new ForumPostRecord();
            nr.setId(this.nextSequence());
            nr.setPostId(postId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(Integer.valueOf(0));
            nr.setGetGold(Byte.valueOf((byte)1));
            nr.setAddTime(d);
            nr.setLastLocation("1");
            nr.setAdViewType(Byte.valueOf((byte)1));
            this.forumPostRecordMapper.insertSelective(nr);
        }
        this.doConsumeClickCount(postId, userId);
    }

    @Override
    @Async
    public void doAsyncReadPost(Long userId, Long postId, Long shareUserId, Integer platform, ForumPostVo forumPostVo) {
        if (5 == platform && Objects.nonNull(shareUserId) && !shareUserId.equals(userId)) {
            NewsCompleTaskDTO firstBrowse = this.missionIntegrationService.compleTask(shareUserId, TaskEnum.TASK_FISRT_BROWSE.name(), userId.toString());
            this.logger.info("\u7528\u6237={}\u5728\u5c0f\u7a0b\u5e8f\u4e2d\u6253\u5f00\u5e16\u5b50,\u65b0\u95fbid={},\u5206\u4eab\u4eba\u7684shareUserId={},\u5b8c\u6210\u4efb\u52a1\u63a5\u53e3\u8fd4\u56de={}", new Object[]{userId, forumPostVo.getId(), shareUserId, JSONObject.toJSONString((Object)firstBrowse)});
            if (Objects.nonNull(firstBrowse) && firstBrowse.getGoldNum() > 0L) {
                String extendContent = null;
                String extendUrl = this.getExtendUrl(forumPostVo.getImgList());
                if (com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)extendUrl)) {
                    extendContent = this.getExtendContent(forumPostVo.getTitle(), forumPostVo.getContent());
                }
                this.messageIntegrationService.addMessage(shareUserId, userId, firstBrowse, forumPostVo.getId(), Byte.valueOf(ReplyTypeEnum.POST_REPLY.getCode()), extendUrl, extendContent, forumPostVo.getTitle());
            }
        }
    }

    private String getExtendUrl(String imgStr) {
        List postImgVos = JSONObject.parseArray((String)imgStr, PostImgVo.class);
        List imageList = postImgVos.stream().filter(e -> StringUtils.equalsIgnoreCase((CharSequence)"IMG", (CharSequence)e.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(imageList)) {
            return ((PostImgVo)imageList.get(0)).getImgUrl();
        }
        return null;
    }

    private String getExtendContent(String title, String content) {
        if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)title)) {
            return title;
        }
        return HtmlContentUtils.getHtmlDesc((String)content, (int)10);
    }

    private void completePostInfo(ForumPostVo forumPostVo, Long userId, String locationName) {
        if (forumPostVo != null) {
            List topicVoList;
            ForumVo forumVo;
            if (null != forumPostVo.getForumId() && null != (forumVo = this.forumMapper.selectForumById(forumPostVo.getForumId()))) {
                forumVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.BLOCK, forumVo.getId(), userId));
                forumVo.setShareUrl(this.bizConfigProperties.getH5ServerHost());
                forumPostVo.setForum(forumVo);
            }
            if (CollectionUtils.isNotEmpty((Collection)(topicVoList = this.forumMapper.getTopicListByPostId(forumPostVo.getId())))) {
                topicVoList.forEach(e -> {
                    e.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.TOPIC, e.getId(), userId));
                    e.setShareUrl(this.bizConfigProperties.getH5ServerHost());
                });
                forumPostVo.setTopicList(topicVoList);
            }
            if (null != userId) {
                Integer like = this.forumMapper.getUserPostLike(forumPostVo.getId(), userId);
                if (null != like && 1 == like) {
                    forumPostVo.setLiked(Integer.valueOf(1));
                } else {
                    forumPostVo.setLiked(Integer.valueOf(0));
                }
                Integer count = this.forumMapper.countUserPostCollect(forumPostVo.getId(), userId);
                if (null != count && count > 0) {
                    forumPostVo.setCollected(Integer.valueOf(1));
                } else {
                    forumPostVo.setCollected(Integer.valueOf(0));
                }
            }
            this.completeCommonPostInfo(forumPostVo, locationName, userId);
        }
    }

    private void completePostInfo(ForumPostVo forumPostVo, Long userId, String locationName, List<PostForumVO> forumVoList, List<PostTopicVO> postTopVoList, List<Long> postLikeIdList, List<Long> postCollectIdList, boolean isFillTitle) {
        if (forumPostVo != null) {
            if (null != forumPostVo.getForumId()) {
                Optional<PostForumVO> forumVoOptional = forumVoList.stream().filter(e -> e.getPostId().equals(forumPostVo.getId())).findFirst();
                forumVoOptional.ifPresent(arg_0 -> ((ForumPostVo)forumPostVo).setForum(arg_0));
            }
            if (CollectionUtils.isNotEmpty(postTopVoList)) {
                List topicVoList = postTopVoList.stream().filter(e -> e.getPostId().equals(forumPostVo.getId())).collect(Collectors.toList());
                forumPostVo.setTopicList(topicVoList);
            }
            if (null != userId) {
                boolean postLikeFlag = postLikeIdList.stream().anyMatch(e -> e.equals(forumPostVo.getId()));
                if (postLikeFlag) {
                    forumPostVo.setLiked(Integer.valueOf(1));
                } else {
                    forumPostVo.setLiked(Integer.valueOf(0));
                }
                boolean postCollectFlag = postCollectIdList.stream().anyMatch(e -> e.equals(forumPostVo.getId()));
                if (postCollectFlag) {
                    forumPostVo.setCollected(Integer.valueOf(1));
                } else {
                    forumPostVo.setCollected(Integer.valueOf(0));
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)forumPostVo.getReplyInfo())) {
                forumPostVo.setLeftRelyNum(Integer.valueOf(forumPostVo.getCommentCount() - forumPostVo.getReplyInfo().size()));
            } else {
                forumPostVo.setLeftRelyNum(forumPostVo.getCommentCount());
            }
            this.completeCommonPostInfo(forumPostVo, locationName, userId);
            if (isFillTitle && StringUtils.isEmpty((CharSequence)forumPostVo.getTitle())) {
                if (forumPostVo.getTextField().length() > 50) {
                    forumPostVo.setTitle(forumPostVo.getTextField().substring(0, 50));
                } else {
                    forumPostVo.setTitle(forumPostVo.getTextField());
                }
            }
        }
    }

    private void completeCommonPostInfo(ForumPostVo forumPostVo, String locationName, Long userId) {
        if (null == forumPostVo.getLocation()) {
            forumPostVo.setLocation(locationName);
        }
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getTextField())) {
            forumPostVo.setTextField(StringEscapeUtils.unescapeHtml((String)forumPostVo.getTextField()));
        }
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getContent())) {
            forumPostVo.setContent(StringEscapeUtils.unescapeHtml((String)forumPostVo.getContent()));
        }
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getImgList())) {
            List postImgVoList = JSON.parseArray((String)forumPostVo.getImgList(), PostImgVo.class);
            this.processPostImg(postImgVoList);
            forumPostVo.setPostImgList(postImgVoList);
        }
        if (null != forumPostVo.getDisplayDateTime()) {
            forumPostVo.setDisplayTime(DateUtils.timeConvertString((Date)forumPostVo.getDisplayDateTime()));
        }
        forumPostVo.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.FORUM, UrlTypeEnum.SHARE, forumPostVo.getId(), userId));
        forumPostVo.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.POST, forumPostVo.getId(), userId));
    }

    private void processPostImg(List<PostImgVo> postImgVoList) {
        for (PostImgVo postImgVo : postImgVoList) {
            String url = postImgVo.getImgUrl();
            int lastIndex = url.lastIndexOf("?");
            if (-1 != lastIndex) {
                url = url.substring(0, lastIndex);
            }
            url = url + "?x-oss-process=style/thumbnail";
            postImgVo.setImgUrl(url);
        }
    }

    @Override
    public NewsCompleTaskDTO doShareForumPost(Long userId, Long postId, String areaCode, Byte type, Integer platform) {
        NewsCompleTaskDTO completeTaskDTO = new NewsCompleTaskDTO();
        this.bizLogIntegrationService.shareForumSuccessed(userId, postId, areaCode, platform);
        Json<NewsCompleTaskDTO> result = this.newsReadRewardService.saveShareForums(postId, userId, type);
        if (null != result) {
            completeTaskDTO = (NewsCompleTaskDTO)result.getResult();
        }
        return completeTaskDTO;
    }

    @Override
    public void doLikeForumPost(Long userId, Long postId, int type, String areaCode, Integer platform) {
        ForumPostLike postLike = this.forumPostLikeMapper.selectByUserIdAndPostId(userId, postId);
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        this.generateForumPostLike(postLike, type, postId, userId, userBean);
        this.doUpdateForumInfo(type, postId);
        ((ForumService)SpringContextHolder.getBean(ForumService.class)).doAsyncLikePost(userId, postId, type, areaCode, (byte)1, platform);
    }

    private Long generateForumPostLike(ForumPostLike postLike, int type, Long postId, Long userId, UserBean userBean) {
        long id;
        String updateNickname;
        String updateHeadImg = StringUtils.isBlank((CharSequence)userBean.getHeadImg()) ? this.userProperties.getDefaultHeadImgUrl() : userBean.getHeadImg();
        String string = updateNickname = StringUtils.isBlank((CharSequence)userBean.getNickname()) ? null : userBean.getNickname();
        if (Objects.isNull(postLike)) {
            id = this.nextId();
            ForumPostLike forumPostLike = ForumPostLike.buildPostLike((Long)postId, (Long)userId);
            forumPostLike.setId(Long.valueOf(id));
            forumPostLike.setType(Byte.valueOf((byte)type));
            forumPostLike.setHeadImg(updateHeadImg);
            forumPostLike.setUserNickname(updateNickname);
            this.forumPostLikeMapper.insertSelective(forumPostLike);
        } else {
            id = postLike.getId();
            postLike.setType(Byte.valueOf((byte)type));
            postLike.setHeadImg(updateHeadImg);
            postLike.setUserNickname(updateNickname);
            this.forumPostLikeMapper.updateByPrimaryKeySelective(postLike);
        }
        return id;
    }

    private void doUpdateForumInfo(int type, Long postId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setId(postId);
        forumPostStatistic.setLikeCount(Integer.valueOf(type == 0 ? -1 : 1));
        List forumPostLikes = this.forumPostLikeMapper.selectByPostIdAndOrderByAddtime(postId);
        if (CollectionUtils.isNotEmpty((Collection)forumPostLikes)) {
            forumPostStatistic.setLikeInfo(JSONObject.toJSONString((Object)forumPostLikes));
        }
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    @Async
    public void doAsyncLikePost(Long userId, Long postId, int type, String areaCode, byte isOld, Integer platform) {
        if (1 == type) {
            ForumPostVo forumPostVo = this.forumMapper.getPostDetailById(postId);
            this.generateVirtualLike(forumPostVo, isOld);
            if (Objects.nonNull(platform)) {
                this.bizLogIntegrationService.forumLikeSuccessed(userId, postId, areaCode, platform);
            } else {
                isOld = 0;
            }
            this.messageIntegrationService.pushPostLikeMessage(forumPostVo, userId, (int)isOld, this.getPostLikeConsume(forumPostVo.getIsBrilliant()));
        }
    }

    private void generateVirtualLike(ForumPostVo forumPostVo, int isOld) {
        List virtualUserList;
        if (isOld == 0 && CollectionUtils.isNotEmpty((Collection)(virtualUserList = this.userIntegrationService.getVirtualUserList(Integer.valueOf(20))))) {
            for (VirtualUserInfo virtualUserInfo : virtualUserList) {
                ForumPostLike like = this.forumPostLikeMapper.selectByUserIdAndPostId(virtualUserInfo.getId(), forumPostVo.getId());
                if (!Objects.isNull(like)) continue;
                Calendar calendar = Calendar.getInstance();
                calendar.add(12, 3);
                ForumPostLike postLike = ForumPostLike.buildVestPostLike((Long)this.nextId(), (Long)forumPostVo.getId(), (Long)virtualUserInfo.getId());
                postLike.setAddTime(calendar.getTime());
                postLike.setHeadImg(virtualUserInfo.getHeadImg());
                postLike.setUserNickname(virtualUserInfo.getNickname());
                this.forumPostLikeMapper.insertSelective(postLike);
                this.logger.info("\u6dfb\u52a0\u9a6c\u7532\u70b9\u8d5e\u6210\u529f,\u70b9\u8d5e\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)postLike));
                break;
            }
        }
    }

    @Override
    public Message doInformForumPost(ForumPostInformParam param) {
        ForumPostInform forumPostInformParam = new ForumPostInform();
        forumPostInformParam.setPostId(param.getPostId());
        forumPostInformParam.setUserId(param.getUserId());
        List informList = this.forumPostInformMapper.selectByModel(forumPostInformParam);
        if (CollectionUtils.isNotEmpty((Collection)informList)) {
            return Message.build((boolean)false, (String)"\u60a8\u5df2\u4e3e\u62a5\u8fc7");
        }
        ForumPostInform forumPostInform = new ForumPostInform();
        BeanUtils.copyProperties((Object)param, (Object)forumPostInform);
        forumPostInform.setId(this.nextSequence());
        this.forumPostInformMapper.insertSelective(forumPostInform);
        return Message.build((boolean)true);
    }

    @Override
    public void doCollectForumPost(Long userId, Long postId) {
        int num;
        ForumPostCollect forumPostCollect = this.forumPostCollectMapper.selectUserCollect(new ForumPostCollect(userId, postId));
        if (!ObjectUtils.isEmpty((Object)forumPostCollect)) {
            this.forumPostCollectMapper.deleteByPrimaryKey(forumPostCollect.getId());
            num = -1;
        } else {
            ForumPostCollect newForumPostCollect = new ForumPostCollect();
            newForumPostCollect.setAddTime(new Date());
            newForumPostCollect.setId(this.nextSequence());
            newForumPostCollect.setPostId(postId);
            newForumPostCollect.setUserId(userId);
            this.forumPostCollectMapper.insertSelective(newForumPostCollect);
            num = 1;
        }
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setCollectCount(Integer.valueOf(num));
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeRecommendedCount(List<Long> ids, Long userId) {
        List forumPostStatisticList = ids.stream().map(id -> ForumPostStatistic.buildRecommend((Long)id, (Integer)1)).collect(Collectors.toList());
        MybatisBatchBuilder.create(ForumPostMapper.class, forumPostStatisticList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public void doConsumeClickCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setClickCount(Integer.valueOf(1));
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    public void doConsumeActiveViewCount(Long postId, Long userId) {
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setReviewCount(Integer.valueOf(1));
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
    }

    @Override
    @Async
    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
        List forumPostVoList = this.forumMapper.selectForumPostByUser(userId);
        for (ForumPostVo forumPostVo : forumPostVoList) {
            this.forumPostMapper.updateUserInfo(forumPostVo.getId(), userId, headImg, nickname);
        }
    }

    @Override
    public void doSavePostClick(Long postId, Long clickCount) {
        this.forumPostMapper.addPostClick(postId, clickCount);
    }

    @Override
    public void calcParticipantsNum() {
        List topicVoList;
        this.logger.info("calculate participants num start. ");
        List forumVoList = this.forumMapper.getForumList(null, Integer.valueOf(0));
        if (CollectionUtils.isNotEmpty((Collection)forumVoList)) {
            for (ForumVo forumVo : forumVoList) {
                List postIdList;
                Integer participantsNum = this.forumMapper.calcPostNum(forumVo.getId(), null);
                if (null == participantsNum) {
                    participantsNum = 0;
                }
                if (CollectionUtils.isNotEmpty((Collection)(postIdList = this.forumMapper.getPostIdList(forumVo.getId(), null)))) {
                    for (Long postId : postIdList) {
                        Integer replyNum = this.forumMapper.calcReplyNum(postId);
                        if (replyNum == null) continue;
                        participantsNum = participantsNum + replyNum;
                    }
                }
                this.forumMapper.updateForum(forumVo.getId(), participantsNum);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(topicVoList = this.forumMapper.getTopicList(null, Integer.valueOf(0))))) {
            for (TopicVo topicVo : topicVoList) {
                List postIdList;
                Integer participantsNum = this.forumMapper.calcPostNum(null, topicVo.getId());
                if (null == participantsNum) {
                    participantsNum = 0;
                }
                if (CollectionUtils.isNotEmpty((Collection)(postIdList = this.forumMapper.getPostIdList(null, topicVo.getId())))) {
                    for (Long postId : postIdList) {
                        Integer replyNum = this.forumMapper.calcReplyNum(postId);
                        if (replyNum == null) continue;
                        participantsNum = participantsNum + replyNum;
                    }
                }
                this.forumMapper.updateTopic(topicVo.getId(), participantsNum);
            }
        }
        this.logger.info("calculate participants num end. ");
    }

    @Override
    public List<News4Client> listPostDetailRecommend(Long postId, Long userId, Integer size, String areaCode) {
        ForumParam forumParam = this.generateForumParam(size, postId, userId, areaCode);
        List idList = this.newsRecommendIntegrationService.recommendList(forumParam);
        this.logger.debug("[listPostDetailRecommend]\u65b0\u95fb\u8be6\u60c5\u63a8\u8350\uff1a{}", (Object)JSONObject.toJSONString((Object)idList));
        List<MixRecommendDTO> mixRecommendDTOList = ForumPostConvert.convertIds2MixRecommendDTO(idList);
        return ((RecommendService)SpringContextHolder.getBean(RecommendService.class)).listNews4Client(mixRecommendDTOList, userId, areaCode, true);
    }

    private ForumParam generateForumParam(Integer size, Long postId, Long userId, String areaCode) {
        if (null == size) {
            size = 5;
        }
        ForumParam forumParam = new ForumParam();
        forumParam.setOperationId(Integer.valueOf(7));
        forumParam.setPostId(postId);
        forumParam.setUserId(userId);
        forumParam.setAreaCode(areaCode);
        if (size == 5) {
            forumParam.setPostNum(Integer.valueOf(3));
            forumParam.setNewsNum(Integer.valueOf(2));
        } else if (size == 15) {
            forumParam.setPostNum(Integer.valueOf(10));
            forumParam.setNewsNum(Integer.valueOf(5));
        }
        return forumParam;
    }

    @Override
    public ReplenishmentDTO getHotPostOrNews(Long userId, String areaCode, Byte type) {
        News news;
        if (null == type) {
            type = 3;
        }
        ReplenishmentDTO replenishmentDTO = new ReplenishmentDTO();
        MixedRecommendPool mixedRecommendPool = this.mixedRecommendPoolMapper.selectHotRecommend(areaCode, userId);
        this.logger.info("[getHotPostOrNews]\u5f97\u5230\u6743\u91cd\u6700\u9ad8\u7684\u5e16\u5b50\u6216\u8005\u65b0\u95fb\uff0c\u63a8\u8350\u5e93\u4e2d\u6743\u91cd\u6700\u9ad8:{}", (Object)JSONObject.toJSONString((Object)mixedRecommendPool));
        if (null == mixedRecommendPool) {
            return null;
        }
        replenishmentDTO.setId(mixedRecommendPool.getId());
        replenishmentDTO.setOrigin(mixedRecommendPool.getOrigin());
        replenishmentDTO.setTitle(mixedRecommendPool.getTitle());
        if ("1".equals(mixedRecommendPool.getOrigin())) {
            ForumPostVo postVo = this.forumMapper.getPostDetailById(mixedRecommendPool.getId());
            if (postVo != null) {
                List postImgList;
                if (StringUtils.isNotEmpty((CharSequence)postVo.getImgList()) && CollectionUtils.isNotEmpty((Collection)(postImgList = JSON.parseArray((String)postVo.getImgList(), PostImgVo.class)))) {
                    List<String> imgList = postImgList.stream().map(PostImgVo::getImgUrl).collect(Collectors.toList());
                    String[] imgStr = new String[imgList.size()];
                    replenishmentDTO.setImgList(imgList.toArray(imgStr));
                }
                if (StringUtils.isBlank((CharSequence)postVo.getTitle())) {
                    replenishmentDTO.setTitle(postVo.getTextField().substring(0, 10));
                }
            }
        } else if (("2".equals(mixedRecommendPool.getOrigin()) || "3".equals(mixedRecommendPool.getOrigin())) && (news = this.newsMapper.selectByPrimaryKey(mixedRecommendPool.getId())) != null && StringUtils.isNotEmpty((CharSequence)news.getImgUrl())) {
            JSONArray imgArray = JSON.parseArray((String)news.getImgUrl());
            ArrayList<String> imgList = new ArrayList<String>();
            for (Object jsonpObject : imgArray) {
                imgList.add((String)jsonpObject);
            }
            String[] imgStr = new String[imgList.size()];
            replenishmentDTO.setImgList(imgList.toArray(imgStr));
        }
        this.logger.info("[getHotPostOrNews]\u5f97\u5230\u6743\u91cd\u6700\u9ad8\u7684\u5e16\u5b50\u6216\u8005\u65b0\u95fb,\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)replenishmentDTO));
        return replenishmentDTO;
    }

    @Override
    public PostLikeDto doLikeForumPost(Long postId, Long userId, String areaCode, String userNickname, String headImg, Integer platform) {
        PostLikeDto postLikeDto = new PostLikeDto();
        ForumPostLike postLike = this.forumPostLikeMapper.selectByUserIdAndPostId(userId, postId);
        UserBean userBean = this.userIntegrationService.selectUserFromCache(userId);
        if (StringUtils.isBlank((CharSequence)userBean.getHeadImg()) || StringUtils.isBlank((CharSequence)userBean.getNickname())) {
            this.logger.info("\u5e16\u5b50\u70b9\u8d5e\u7528\u6237\u5934\u50cf\u6216\u6635\u79f0\u4e3a\u7a7a,userInfo={}", (Object)JSON.toJSONString((Object)userBean));
        }
        if (Objects.isNull(postLike) || postLike.getType() == 0) {
            boolean flag;
            long id = this.generateForumPostLike(postLike, 1, postId, userId, userBean);
            this.doUpdateForumInfo(1, postId);
            ForumPostVo postVo = this.forumPostMapper.selectByPrimaryKey(postId);
            boolean bl = flag = Objects.nonNull(userId) && Objects.nonNull(postVo.getUserId()) && userId.equals(postVo.getUserId());
            if (flag) {
                postLikeDto.setCode(Integer.valueOf(1));
                postLikeDto.setCopyWriter(null);
                postLikeDto.setShowFlower(Integer.valueOf(0));
            } else {
                postLikeDto = this.calculateFlower(postVo, userId, id, areaCode, platform);
            }
        } else {
            return null;
        }
        return postLikeDto;
    }

    private PostLikeDto calculateFlower(ForumPostVo postVo, Long userId, Long id, String areaCode, int platform) {
        int postLikeConsume = this.getPostLikeConsume(postVo.getIsBrilliant());
        Boolean consume = this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeExpendParam((Long)userId, (int)postLikeConsume, (Long)id));
        PostLikeDto postLikeDto = new PostLikeDto();
        if (consume.booleanValue()) {
            this.userAccountIntegrationService.addGold(AccountGoldParam.buildPostLikeAddParam((Long)postVo.getUserId(), (int)postLikeConsume, (Long)id));
            postLikeDto.setAmount(Integer.valueOf(postLikeConsume));
            postLikeDto.setCode(Integer.valueOf(1));
            this.fillPostLikeDto(postLikeDto, userId, postVo.getUserId(), postLikeConsume);
            ((ForumService)SpringContextHolder.getBean(ForumService.class)).doAsyncLikePost(userId, postVo.getId(), 1, areaCode, (byte)0, platform);
        } else {
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            postLikeDto.setCode(Integer.valueOf(0));
            postLikeDto.setShowFlower(Integer.valueOf(0));
            postLikeDto.setCopyWriter("\u4f60\u7684\u5c0f\u7ea2\u82b1\u4f59\u989d\u4e0d\u8db3\uff0c\u5feb\u8f6c\u53d1\u6587\u7ae0\u8d5a\u5c0f\u7ea2\u82b1");
        }
        return postLikeDto;
    }

    private void fillPostLikeDto(PostLikeDto postLikeDto, Long userId, Long authorUserId, int postLikeConsume) {
        String dateKey = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
        KeyGenerator forumPostLikeTimeKey = RedisConfig.FORUMPOST_LIEK_TIME.copy().appendKey((Object)dateKey).appendKey((Object)userId);
        long likeCount = this.redisStringAdapter.incrementWithDefault(forumPostLikeTimeKey, 1L, 1, 86400L);
        if (likeCount <= 2L) {
            postLikeDto.setCopyWriter("\u5df2\u8d5e\u8d4f\u4f5c\u8005" + postLikeConsume + "\u6735\u5c0f\u7ea2\u82b1");
            postLikeDto.setShowFlower(Integer.valueOf(1));
        } else {
            postLikeDto.setCopyWriter(null);
            postLikeDto.setShowFlower(Integer.valueOf(0));
        }
    }

    @Override
    public int getPostLikeConsume(Integer isBrilliant) {
        if (Objects.isNull(isBrilliant) || isBrilliant == 0) {
            return this.clientConfigProperties.getPostCommonLikeConsume();
        }
        return this.clientConfigProperties.getPostBrilliantLikeConsume();
    }

    @Override
    public List<ForumPostLikeDTO> getPostLikeDetail(Long id, Long userId, String devcId) {
        ArrayList result = Lists.newArrayList();
        List forumPostLikes = this.forumPostLikeMapper.selectPostById(id);
        forumPostLikes.forEach(e -> {
            ForumPostLikeDTO postLikeDTO = new ForumPostLikeDTO();
            BeanUtils.copyProperties((Object)e, (Object)postLikeDTO);
            if (StringUtils.isBlank((CharSequence)postLikeDTO.getHeadImg())) {
                postLikeDTO.setHeadImg(this.userProperties.getDefaultHeadImgUrl());
            }
            result.add(postLikeDTO);
        });
        return result;
    }

    @Override
    public int doRefreshLikeInfo() {
        Date currentTime = new Date();
        List postLikes = this.forumPostLikeMapper.selectNotShowPostLike(currentTime);
        int result = this.forumPostLikeMapper.updateNotShowPostLike(currentTime);
        postLikes.forEach(e -> {
            ForumPostVo postVo = this.forumPostMapper.selectByPrimaryKey(e.getPostId());
            int postLikeConsume = this.getPostLikeConsume(postVo.getIsBrilliant());
            AccountGoldParam usableParam = new AccountGoldParam(postVo.getUserId(), "USABLE_GOLD", Boolean.valueOf(true), Integer.valueOf(postLikeConsume), e.getId(), "ARTICLE_LIKE_ADD");
            this.userAccountIntegrationService.addGold(usableParam);
            this.doUpdateForumInfo(1, postVo.getId());
            ((ForumService)SpringContextHolder.getBean(ForumService.class)).doAsyncLikePost(e.getUserId(), e.getPostId(), 1, postVo.getAreaCode(), (byte)1, null);
        });
        return result;
    }

    @Override
    public void doSyncPostLikeInfo() {
        List list = this.forumPostLikeMapper.selectNotExitsUserInfo();
        ArrayList paramList = Lists.newArrayList();
        list.forEach(e -> {
            ForumPostLike postLike = new ForumPostLike();
            postLike.setUserId(e);
            UserInfoDTO userInfo = this.userIntegrationService.getUserInfo(e);
            if (Objects.nonNull(userInfo)) {
                postLike.setUserNickname(userInfo.getNickname());
                postLike.setHeadImg(userInfo.getHeadImg());
                paramList.add(postLike);
            }
        });
        MybatisBatchBuilder.create(ForumPostLikeMapper.class, (Collection)paramList).run(ForumPostLikeMapper::updateUserInfoByUserId);
    }

    @Override
    public void doSyncPostStaticInfo() {
        List list = this.forumPostMapper.selectNotExitReplyAndLikeInfo();
        ArrayList paramList = Lists.newArrayList();
        list.forEach(e -> {
            boolean flag;
            List forumPostLikes;
            ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
            forumPostStatistic.setId(e);
            List replyList = this.newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(e);
            if (CollectionUtils.isNotEmpty((Collection)replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString((Object)replyList));
            }
            if (CollectionUtils.isNotEmpty((Collection)(forumPostLikes = this.forumPostLikeMapper.selectByPostIdAndOrderByAddtime(e)))) {
                forumPostStatistic.setLikeInfo(JSONObject.toJSONString((Object)forumPostLikes));
            }
            boolean bl = flag = !StringUtils.isBlank((CharSequence)forumPostStatistic.getLikeInfo()) || !StringUtils.isBlank((CharSequence)forumPostStatistic.getReplyInfo());
            if (flag) {
                paramList.add(forumPostStatistic);
            }
        });
        MybatisBatchBuilder.create(ForumPostMapper.class, (Collection)paramList).run(ForumPostMapper::updateStatisticByPrimaryKeySelective);
    }

    @Override
    public CalculatePostDTO calculatePostCount() {
        CalculatePostDTO calculatePostDTO = new CalculatePostDTO();
        Calendar instance = Calendar.getInstance();
        instance.add(12, -30);
        Date time = instance.getTime();
        int pendingReviewCount = this.forumPostMapper.selectPendingReviewCount(time);
        calculatePostDTO.setPendingReviewCount(Integer.valueOf(pendingReviewCount));
        int newPostCount = this.forumPostMapper.selectNewPostCount(time);
        calculatePostDTO.setNewPostCount(Integer.valueOf(newPostCount));
        int userCount = this.forumPostMapper.selectUserCount(time);
        calculatePostDTO.setUserCount(Integer.valueOf(userCount));
        return calculatePostDTO;
    }

    @Override
    public void doTriggerUpdateForumpostLikeInfo(Long userId, String nickname, String headImg) {
        if (StringUtils.isBlank((CharSequence)nickname) && StringUtils.isBlank((CharSequence)nickname)) {
            return;
        }
        this.forumPostMapper.updateNickNameAndHeadImgByUserId(userId, nickname, headImg);
    }

    @Override
    public List<ForumPostVo> getPostListByIds(String postIds) {
        List<Long> postIdList = this.convertStringToList(postIds);
        if (CollectionUtils.isEmpty(postIdList)) {
            return null;
        }
        List forumPostVoList = this.forumMapper.listPostByIds(postIdList);
        if (CollectionUtils.isNotEmpty((Collection)forumPostVoList)) {
            for (ForumPostVo forumPostVo : forumPostVoList) {
                this.completeCommonPostInfo(forumPostVo, null, null);
            }
        }
        return forumPostVoList;
    }

    @Override
    public Boolean createPost(ForumBasicVo forumBasicVo) {
        ForumPostVo forumPostVo = this.forumBasicConvert.convert(forumBasicVo);
        forumPostVo.setStatus(Integer.valueOf(1));
        this.saveForumPost(forumPostVo);
        this.userIntegrationService.addPostReplyNum(forumBasicVo.getUserId(), Integer.valueOf(1));
        ((ForumService)SpringContextHolder.getBean(ForumService.class)).createPostUserTopTaskJob(forumPostVo);
        return true;
    }

    private List<Long> convertStringToList(String s) {
        String[] array;
        ArrayList<Long> resultList = new ArrayList<Long>();
        if (StringUtils.isBlank((CharSequence)s)) {
            return resultList;
        }
        for (String sa : array = s.split(COMMA)) {
            resultList.add(Long.valueOf(sa));
        }
        return resultList;
    }

    private Long getPostId() {
        KeyGenerator postKeyGenerator = RedisConfig.SEQ_POST_ID.copy();
        return this.redisStringAdapter.incrementWithDefault(postKeyGenerator, 4000000000000000L, 1);
    }
}

