/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.integration.BizLogIntegrationService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.constant.UrlCategoryEnum;
import com.bxm.localnews.news.constant.UrlTypeEnum;
import com.bxm.localnews.news.convert.impl.NewsReplyConver;
import com.bxm.localnews.news.domain.ForumMapper;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsReplyLikeMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.NewsTotalMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.domain.VideoLikeMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.NewsReplyDetailDTO;
import com.bxm.localnews.news.dto.NewsReplyMirrorDTO;
import com.bxm.localnews.news.dto.ReplyDTO;
import com.bxm.localnews.news.dto.ReplyNewsDTO;
import com.bxm.localnews.news.dto.ReplyPostDTO;
import com.bxm.localnews.news.dto.ReplyVideoDTO;
import com.bxm.localnews.news.enums.NewsConstant;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.UserReplyParam;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.ForumPostStatistic;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.NewsReplayLike;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.UserReply;
import com.bxm.localnews.news.vo.Video;
import com.bxm.localnews.news.vo.VideoLike;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.CharUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class NewNewsReplyServiceImpl
extends BaseService
implements NewNewsReplyService {
    @Resource
    private NewsReplyMapper newsReplyMapper;
    @Resource
    private NewsReplyLikeMapper newsReplyLikeMapper;
    @Resource
    private RedisListAdapter redisListAdapter;
    @Resource
    private UserReplyMapper userReplyMapper;
    @Resource
    private VideoMapper videoMapper;
    @Resource
    private NewsMapper newsMapper;
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private VideoLikeMapper videoLikeMapper;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private IUrlFactory iUrlFactory;
    @Autowired
    private VideoRecommendService videoRecommendService;
    @Autowired
    private NewsStatisticIntegrationService newsStatisticIntegrationService;
    @Autowired
    private NewsTotalMapper newsTotalMapper;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private BizLogIntegrationService bizLogIntegrationService;
    @Autowired
    private ForumMapper forumMapper;
    @Autowired
    private MessageIntegrationService messageIntegrationService;
    @Autowired
    private MissionIntegrationService missionIntegrationService;
    @Autowired
    private NewsReplyConver newsReplyConver;

    @Override
    public PageWarper<NewsReplyDTO> queryReplyList(NewsReplyParam newsReplyParam) {
        PageWarper newsReplyDTOPageWarper = new PageWarper(this.newsReplyMapper.queryByPageSize(newsReplyParam));
        List list = newsReplyDTOPageWarper.getList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List rootIds = list.stream().map(NewsReplyDTO::getId).collect(Collectors.toList());
            List allReplies = this.newsReplyMapper.selectSubReplyLists(rootIds, newsReplyParam.getNewsId());
            List replyLikes = this.newsReplyMapper.selectReplyLike(newsReplyParam.getNewsId(), newsReplyParam.getUserId(), null);
            if (CollectionUtils.isNotEmpty((Collection)newsReplyDTOPageWarper.getList())) {
                for (NewsReplyDTO vo : newsReplyDTOPageWarper.getList()) {
                    vo.setIsLike(Integer.valueOf(this.checkIsLike(replyLikes, vo.getId())));
                    vo.setReplyTime(DateUtils.timeConvertString((Date)vo.getAddTime()));
                    List<NewsReplyMirrorDTO> replies = allReplies.stream().filter(e -> e.getRootId().equals(vo.getId())).collect(Collectors.toList());
                    if (!CollectionUtils.isNotEmpty(replies)) continue;
                    replies.forEach(replay -> this.dealSubMirrorDTO((NewsReplyMirrorDTO)replay, newsReplyParam.getUserId(), replyLikes));
                    vo.setList(replies);
                }
            }
        }
        return newsReplyDTOPageWarper;
    }

    private void dealSubMirrorDTO(NewsReplyMirrorDTO replay, Long userId, List<Long> replyLikes) {
        replay.setIsLike(Integer.valueOf(this.checkIsLike(replyLikes, replay.getId())));
        if (replay.getLevel().equals(NewsConstant.REPLY_LEVEL_1)) {
            replay.setParentHeadImg(null);
            replay.setParentUserId(null);
            replay.setParentUserNickname(null);
        }
        replay.setReplyTime(DateUtils.timeConvertString((Date)replay.getAddTime()));
    }

    private int checkIsLike(List<Long> replyLikes, Long replyId) {
        return replyLikes.contains(replyId) ? 1 : 0;
    }

    private boolean isLike(Long userId, Long replyId) {
        NewsReplayLike newsReplayLike = this.newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        return null != newsReplayLike;
    }

    @Override
    public ReplyDTO doReply(NewsReplyAddParam newsReplyAddParam, Integer platform) {
        this.logger.debug("[doReply]\u53d1\u8868\u8bc4\u8bba\uff0c\u53c2\u6570:[{}]", (Object)JSONObject.toJSONString((Object)newsReplyAddParam));
        NewsReply newsReply = this.newsReplyConver.convert(newsReplyAddParam);
        this.newsReplyMapper.insertSelective(newsReply);
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
        this.userReplyMapper.insertSelective(userReply);
        newsReply.setReplyTime(DateUtils.timeConvertString((Date)newsReply.getAddTime()));
        NewsReply param = new NewsReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)param);
        this.updateComment(newsReply);
        NewNewsReplyService newNewsReplyService = (NewNewsReplyService)SpringContextHolder.getBean(this.getClass());
        newNewsReplyService.processWhenReply(param, newsReplyAddParam, platform);
        if (newsReply.getLevel().equals(NewsConstant.REPLY_LEVEL_1) && platform != 5) {
            newsReply.setParentUserId(null);
            newsReply.setParentUserNickname(null);
        }
        ReplyDTO result = new ReplyDTO();
        BeanUtils.copyProperties((Object)newsReply, (Object)result);
        if (ReplyTypeEnum.VIDEO_REPLY.getCode() != newsReply.getType().byteValue() && CharUtil.isCharSatisfied((String)newsReply.getReplyContent(), (int)15)) {
            NewsCompleTaskDTO taskDTO = this.missionIntegrationService.compleTask(newsReply.getUserId(), "TASK_COMMENT_NEWS", newsReply.getId().toString());
            this.logger.info("user_id ={}\u5b8c\u6210\u8bc4\u8bba\u4efb\u52a1,\u5956\u52b1{}\u591a\u7ea2\u82b1;", (Object)newsReply.getUserId(), (Object)taskDTO.getGoldNum());
            result.setGoldNum(Long.valueOf(Objects.isNull(taskDTO.getGoldNum()) ? 0L : taskDTO.getGoldNum()));
        }
        return result;
    }

    @Override
    @Async
    public void processWhenReply(NewsReply newsReply, NewsReplyAddParam newsReplyAddParam, Integer platform) {
        if (Objects.nonNull(newsReply.getRootId()) && newsReply.getRootId() != 0L) {
            NewsReply rootReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = Objects.isNull(interactiveCount) || interactiveCount == 0 ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            this.newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            UserReply userRootReply = new UserReply();
            BeanUtils.copyProperties((Object)rootReply, (Object)userRootReply);
            this.userReplyMapper.updateinteractiveCountById(userRootReply);
        }
        this.userIntegrationService.addPostReplyNum(newsReplyAddParam.getUserId(), Integer.valueOf(3));
        this.logger.info("\u7528\u6237[{}]\u8bc4\u8bba\u4e86\u7528\u6237[{}]\u7684\u6d88\u606f\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c \n\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{newsReplyAddParam.getUserId(), newsReplyAddParam.getParentUserId(), newsReplyAddParam.getParentUserId(), newsReplyAddParam.getType(), JSON.toJSONString((Object)newsReplyAddParam)});
        if (Objects.nonNull(newsReplyAddParam.getParentUserId()) && !newsReplyAddParam.getParentUserId().equals(newsReply.getUserId())) {
            this.logger.debug("\u5c01\u88c5\u7684\u6d88\u606f\u683c\u5f0f\u4e3a\uff1a[{}]", (Object)JSON.toJSONString((Object)newsReply));
            if (newsReply.getType().byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode() || newsReply.getType().byteValue() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                this.messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.NEWS_REPLY);
            } else if (newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
                this.messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY);
            }
        }
        if (null == newsReplyAddParam.getParentUserId() && newsReply.getType().byteValue() == ReplyTypeEnum.POST_REPLY.getCode()) {
            this.messageIntegrationService.pushPostRepkyMessage(newsReply);
        }
        if (StringUtils.isNotBlank((CharSequence)newsReplyAddParam.getAreaCode())) {
            this.bizLogIntegrationService.replySuccessed(newsReplyAddParam.getUserId(), newsReplyAddParam.getNewsId(), new Integer(newsReplyAddParam.getType().byteValue()), newsReplyAddParam.getAreaCode(), platform);
        }
    }

    private void updateComment(NewsReply newsReply) {
        if (ReplyTypeEnum.NEWS_REPLY.getCode() == newsReply.getType().byteValue()) {
            this.newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId(), Integer.valueOf(1));
            this.newsStatisticIntegrationService.pushCommentData(newsReply.getUserId(), newsReply.getNewsId());
        } else if (ReplyTypeEnum.VIDEO_REPLY.getCode() == newsReply.getType().byteValue()) {
            Video video = new Video();
            video.setId(newsReply.getNewsId());
            video.setCommentCount(Long.valueOf(1L));
            this.videoMapper.updateStatisticByPrimaryKeySelective(video);
        } else if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType().byteValue()) {
            ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments((Long)newsReply.getNewsId(), (Integer)1);
            List replyList = this.newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(newsReply.getNewsId());
            if (CollectionUtils.isNotEmpty((Collection)replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString((Object)replyList));
            }
            this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        }
    }

    @Override
    public PageWarper<MyReplysVO> selectMyReplys(UserReplyParam newsReplyParam) {
        PageWarper myReplysVOPageWarper = new PageWarper(this.userReplyMapper.selectMyReplys(newsReplyParam));
        List myReplysVOList = myReplysVOPageWarper.getList();
        for (MyReplysVO myReplysVO : myReplysVOList) {
            ForumPostVo forumPostVo;
            Date addTime = myReplysVO.getAddTime();
            String replyTime = DateUtils.timeConvertString((Date)addTime);
            myReplysVO.setReplyTime(replyTime);
            Byte type = myReplysVO.getType();
            if (type.byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode()) {
                News news = this.newsMapper.selectByPrimaryKey(myReplysVO.getNewsId());
                if (null == news) continue;
                NewsCollect newsCollect = this.newsCollectMapper.selectUserCollect(news.getId(), newsReplyParam.getUserId(), Byte.valueOf((byte)1));
                ReplyNewsDTO replyNewsDTO = this.getNewsDto(news, newsReplyParam.getUserId());
                if (null != newsCollect) {
                    replyNewsDTO.setCollect(Integer.valueOf(1));
                } else {
                    replyNewsDTO.setCollect(Integer.valueOf(0));
                }
                myReplysVO.setReplyNewsDto(replyNewsDTO);
                myReplysVO.setTitle(news.getTitle());
                myReplysVO.setNewsImgUrl(news.getImgUrl());
                continue;
            }
            if (type.byteValue() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
                Video video = this.videoMapper.selectByPrimaryKey(myReplysVO.getNewsId());
                if (null == video) continue;
                ReplyVideoDTO replyVideoDTO = this.getVideoDto(video, newsReplyParam.getUserId());
                replyVideoDTO.setVideoImg("[\"" + video.getVideoImg() + "\"]");
                myReplysVO.setReplyVideoDto(replyVideoDTO);
                myReplysVO.setTitle(video.getTitle());
                myReplysVO.setNewsImgUrl("[\"" + video.getVideoImg() + "\"]");
                continue;
            }
            if (type.byteValue() != ReplyTypeEnum.POST_REPLY.getCode() || null == (forumPostVo = this.forumMapper.getPostDetailById(myReplysVO.getNewsId()))) continue;
            ReplyPostDTO replyPostDTO = this.getForumPostReplyDto(forumPostVo);
            myReplysVO.setReplyPostDto(replyPostDTO);
            if (StringUtils.isNotEmpty((CharSequence)forumPostVo.getTitle())) {
                myReplysVO.setTitle(forumPostVo.getTitle());
                continue;
            }
            if (forumPostVo.getTextField().length() > 50) {
                myReplysVO.setTitle(forumPostVo.getTextField().substring(0, 50));
                continue;
            }
            myReplysVO.setTitle(forumPostVo.getTextField());
        }
        return myReplysVOPageWarper;
    }

    @Override
    public NewsReplyDTO delMyReply(Long replyId, Long userId, Long newsId) {
        NewsReply newsReply = null;
        if (null != newsId && 0L != newsId) {
            newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId);
        }
        if (Objects.isNull(newsReply)) {
            newsReply = this.newsReplyMapper.selectByPrimaryKey(replyId);
        }
        this.newsReplyMapper.deleteByPrimaryKey(replyId, newsReply.getNewsId());
        this.userReplyMapper.deleteByPrimaryKey(replyId, newsReply.getUserId());
        NewsReplyDTO newsReplyDTO = new NewsReplyDTO();
        BeanUtils.copyProperties((Object)newsReply, (Object)newsReplyDTO);
        newsReplyDTO.setDeleteFlag((byte)1);
        newsReplyDTO.setReplyTime(DateUtils.timeConvertString((Date)newsReplyDTO.getAddTime()));
        newsReplyDTO.setReplyContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664\uff01");
        newsReplyDTO.setIsLike(Integer.valueOf(this.isLike(userId, replyId) ? 1 : 0));
        if (newsReply.getRootId() == 0L) {
            List replyMirrorDTOS = this.newsReplyMapper.selectSubReplyList(replyId, newsReply.getNewsId());
            List replyLike = this.newsReplyMapper.selectReplyLike(newsReply.getNewsId(), userId, replyId);
            replyMirrorDTOS.forEach(e -> this.dealSubMirrorDTO((NewsReplyMirrorDTO)e, userId, replyLike));
            newsReplyDTO.setList(replyMirrorDTOS);
        }
        if (newsReply.getLevel() == 1) {
            newsReplyDTO.setParentUserId(null);
            newsReplyDTO.setParentUserNickname(null);
        }
        this.userIntegrationService.addPostReplyNum(userId, Integer.valueOf(4));
        this.reduceComment(newsReply);
        return newsReplyDTO;
    }

    private void reduceComment(NewsReply newsReply) {
        if (ReplyTypeEnum.NEWS_REPLY.getCode() == newsReply.getType().byteValue()) {
            this.newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId(), Integer.valueOf(-1));
        } else if (ReplyTypeEnum.VIDEO_REPLY.getCode() == newsReply.getType().byteValue()) {
            Video video = new Video();
            video.setId(newsReply.getNewsId());
            video.setCommentCount(Long.valueOf(-1L));
            this.videoMapper.updateStatisticByPrimaryKeySelective(video);
        } else if (ReplyTypeEnum.POST_REPLY.getCode() == newsReply.getType().byteValue()) {
            ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments((Long)newsReply.getNewsId(), (Integer)-1);
            List replyList = this.newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(newsReply.getNewsId());
            if (CollectionUtils.isNotEmpty((Collection)replyList)) {
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString((Object)replyList));
            }
            this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        }
    }

    @Override
    public List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page) {
        List result = this.newsReplyMapper.myReceiveReplys(userId, page);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            result.forEach(reply -> {
                if (reply.getDeleteFlag() == 1) {
                    reply.setReplyContent(null);
                }
            });
        }
        return result;
    }

    @Override
    @Async
    public void doTriggerUpdateInfo(Long userId, String nickname, String headImg) {
        List newsReplyList = this.newsReplyMapper.selectByUser(userId);
        for (NewsReply newsReply : newsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setUserNickname(nickname);
            newsReplyUp.setHeadImg(headImg);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
            this.newsReplyMapper.updateUserInfo(newsReplyUp);
            this.userReplyMapper.updateUserInfo(userReply);
        }
        List parentNewsReplyList = this.newsReplyMapper.selectByParentUser(userId);
        for (NewsReply newsReply : parentNewsReplyList) {
            NewsReply newsReplyUp = new NewsReply();
            newsReplyUp.setId(newsReply.getId());
            newsReplyUp.setUserId(userId);
            newsReplyUp.setNewsId(newsReply.getNewsId());
            newsReplyUp.setParentUserNickname(nickname);
            newsReplyUp.setParentHeadImg(headImg);
            UserReply userReply = new UserReply();
            BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
            this.newsReplyMapper.updateParentUserInfo(newsReplyUp);
            this.userReplyMapper.updateParentUserInfo(userReply);
        }
    }

    @Override
    public Message doProduceNewsReplyLike(NewsReplyLikeParam newsReplyLikeParam) {
        if (!this.checkLikeParam(newsReplyLikeParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        this.logger.info("\u70b9\u8d5e\u7684\u53c2\u6570\u662f:{}", (Object)JSONObject.toJSONString((Object)newsReplyLikeParam));
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");
        this.redisListAdapter.leftPush(keyGenerator, new Object[]{newsReplyLikeParam});
        this.callAsyncConsume();
        return Message.build((boolean)true);
    }

    private void callAsyncConsume() {
        NewNewsReplyService newsReplyService = (NewNewsReplyService)SpringContextHolder.getBean(NewNewsReplyService.class);
        newsReplyService.doNewsReplyLikeConsume();
    }

    @Override
    @Async
    public void doNewsReplyLikeConsume() {
        KeyGenerator keyGenerator = RedisConfig.NEWS_QUEUE.copy().setKey("newsReplyLikeQueue");
        NewsReplyLikeParam newsReplyLikeWarper = (NewsReplyLikeParam)this.redisListAdapter.rightPop(keyGenerator, NewsReplyLikeParam.class);
        if (null != newsReplyLikeWarper) {
            this.logger.info("\u65b0\u95fb\u56de\u590d\u70b9\u8d5e\u5f00\u59cb\u6d88\u8d39...");
            int type = newsReplyLikeWarper.getType();
            NewsReply newsReply = null != newsReplyLikeWarper.getNewsId() && 0L != newsReplyLikeWarper.getNewsId() ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReplyLikeWarper.getReplyId(), newsReplyLikeWarper.getNewsId()) : this.newsReplyMapper.selectByPrimaryKey(newsReplyLikeWarper.getReplyId());
            if (newsReply != null) {
                int count = this.saveReplyLiKeRecord(newsReply.getId(), newsReplyLikeWarper.getUserId(), type);
                if (count > 0) {
                    this.logger.debug("\u8bc4\u8bba\u5b9e\u4f53:{}", JSONObject.toJSON((Object)newsReply));
                    int likeCount = this.generatorLikeCount(type, newsReply.getLikeCount());
                    this.logger.debug("\u70b9\u8d5e\u6570:{}", (Object)likeCount);
                    NewsReply newsReplyUp = new NewsReply();
                    newsReplyUp.setId(newsReplyLikeWarper.getReplyId());
                    newsReplyUp.setLikeCount(Integer.valueOf(likeCount));
                    newsReplyUp.setUserId(newsReply.getUserId());
                    newsReplyUp.setNewsId(newsReply.getNewsId());
                    if (newsReply.getRootId() == 0L) {
                        if (type == 1) {
                            newsReplyUp.setInteractiveCount(Integer.valueOf(newsReply.getInteractiveCount() + 1));
                        } else if (newsReply.getInteractiveCount() > 0) {
                            newsReplyUp.setInteractiveCount(Integer.valueOf(newsReply.getInteractiveCount() - 1));
                        }
                    }
                    this.newsReplyMapper.updateByPrimaryKeySelective(newsReplyUp);
                    UserReply userReply = new UserReply();
                    BeanUtils.copyProperties((Object)newsReplyUp, (Object)userReply);
                    this.userReplyMapper.updateinteractiveCountById(userReply);
                }
                if (!newsReplyLikeWarper.getUserId().equals(newsReply.getUserId()) && newsReplyLikeWarper.getType() == 1) {
                    if (newsReply.getType() == 1 || newsReply.getType() == 2) {
                        this.messageIntegrationService.pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.NEWS_LIKE, newsReply);
                    } else if (newsReply.getType() == 3) {
                        this.messageIntegrationService.pushNewLikeMessage(newsReplyLikeWarper, PushMessageEnum.POST_LIKE, newsReply);
                    }
                }
            }
            this.doNewsReplyLikeConsume();
        }
    }

    @Override
    public NewsReplyDetailDTO getNewsReplyDetailDTO(Long replyId, Long userId, Long newsId) {
        NewsReply newsReply = null != newsId && 0L != newsId ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(replyId, newsId) : this.newsReplyMapper.selectByPrimaryKey(replyId);
        if (Objects.isNull(newsReply) || Objects.isNull(newsReply.getRootId())) {
            return null;
        }
        if (newsReply.getRootId() != 0L) {
            newsReply = null != newsId ? this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsId) : this.newsReplyMapper.selectByPrimaryKey(newsReply.getRootId());
        }
        NewsReplyDetailDTO newsReplyDetailDTO = new NewsReplyDetailDTO();
        BeanUtils.copyProperties((Object)newsReply, (Object)newsReplyDetailDTO);
        if (this.isLike(userId, newsReplyDetailDTO.getId())) {
            newsReplyDetailDTO.setIsLike(Integer.valueOf(1));
        }
        newsReplyDetailDTO.setReplyTime(DateUtils.timeConvertString((Date)newsReplyDetailDTO.getAddTime()));
        newsReplyDetailDTO = this.addSuperiorObject(newsReply, userId, newsReplyDetailDTO);
        List replies = this.newsReplyMapper.selectSubReplyList(newsReply.getId(), newsReply.getNewsId());
        if (CollectionUtils.isNotEmpty((Collection)replies)) {
            replies.forEach(replay -> {
                List replyLike = this.newsReplyMapper.selectReplyLike(newsId, userId, replyId);
                this.dealSubMirrorDTO((NewsReplyMirrorDTO)replay, userId, replyLike);
            });
        }
        newsReplyDetailDTO.setList(replies);
        return newsReplyDetailDTO;
    }

    private NewsReplyDetailDTO addSuperiorObject(NewsReply newsReply, Long userId, NewsReplyDetailDTO newsReplyDetailDTO) {
        ForumPostVo forumPostVo;
        Byte type = newsReply.getType();
        if (type.byteValue() == ReplyTypeEnum.NEWS_REPLY.getCode()) {
            News news = this.newsMapper.selectByPrimaryKey(newsReply.getNewsId());
            if (null != news) {
                ReplyNewsDTO replyNewsDTO = this.getNewsDto(news, userId);
                newsReplyDetailDTO.setReplyNewsDto(replyNewsDTO);
                newsReplyDetailDTO.setTitle(news.getTitle());
            }
        } else if (type.byteValue() == ReplyTypeEnum.VIDEO_REPLY.getCode()) {
            Video video = this.videoMapper.selectByPrimaryKey(newsReply.getNewsId());
            if (null != video) {
                ReplyVideoDTO replyVideoDTO = this.getVideoDto(video, userId);
                newsReplyDetailDTO.setReplyVideoDto(replyVideoDTO);
                newsReplyDetailDTO.setTitle(video.getTitle());
            }
        } else if (type.byteValue() == ReplyTypeEnum.POST_REPLY.getCode() && null != (forumPostVo = this.forumMapper.getPostDetailById(newsReply.getNewsId()))) {
            ReplyPostDTO replyPostDTO = this.getForumPostReplyDto(forumPostVo);
            newsReplyDetailDTO.setReplyPostDto(replyPostDTO);
            if (StringUtils.isNotEmpty((CharSequence)forumPostVo.getTitle())) {
                newsReplyDetailDTO.setTitle(forumPostVo.getTitle());
            } else if (forumPostVo.getTextField().length() > 50) {
                newsReplyDetailDTO.setTitle(forumPostVo.getTextField().substring(0, 50));
            } else {
                newsReplyDetailDTO.setTitle(forumPostVo.getTextField());
            }
        }
        return newsReplyDetailDTO;
    }

    private ReplyPostDTO getForumPostReplyDto(ForumPostVo forumPostVo) {
        ReplyPostDTO replyPostDTO = new ReplyPostDTO();
        replyPostDTO.setId(forumPostVo.getId());
        replyPostDTO.setStatus(Byte.valueOf((byte)forumPostVo.getStatus().intValue()));
        replyPostDTO.setTitle(forumPostVo.getTitle());
        if (StringUtils.isNotBlank((CharSequence)forumPostVo.getImgList())) {
            replyPostDTO.setPostImgList(JSON.parseArray((String)forumPostVo.getImgList(), PostImgVo.class));
        }
        return replyPostDTO;
    }

    private ReplyNewsDTO getNewsDto(News news, Long userId) {
        ReplyNewsDTO replyNewsDTO = new ReplyNewsDTO();
        replyNewsDTO.setId(news.getId());
        replyNewsDTO.setImgUrl(news.getImgUrl());
        replyNewsDTO.setLinkUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.DETAIL, news.getId(), userId));
        replyNewsDTO.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.SHARE, news.getId(), userId));
        replyNewsDTO.setComments(news.getComments());
        replyNewsDTO.setStatus(news.getStatus());
        return replyNewsDTO;
    }

    private ReplyVideoDTO getVideoDto(Video video, Long userId) {
        ReplyVideoDTO replyVideoDTO = new ReplyVideoDTO();
        replyVideoDTO.setAuthorImg(video.getAuthorImg());
        replyVideoDTO.setAuthor(video.getAuthorName());
        replyVideoDTO.setId(video.getId());
        VideoLike videoLike = this.videoLikeMapper.selectByModel(new VideoLike(video.getId(), userId));
        if (null != videoLike) {
            replyVideoDTO.setPraise(Boolean.valueOf(true));
        } else {
            replyVideoDTO.setPraise(Boolean.valueOf(false));
        }
        replyVideoDTO.setLikeCount(Integer.valueOf(Math.toIntExact(video.getLikeCount())));
        replyVideoDTO.setVideoUrl(this.videoRecommendService.videoAdressConversion(video.getVideoUrl()));
        replyVideoDTO.setVideoImg(video.getVideoImg());
        replyVideoDTO.setCommentCount(Integer.valueOf(Math.toIntExact(video.getCommentCount())));
        replyVideoDTO.setStatus(video.getStatus());
        return replyVideoDTO;
    }

    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                --likeCount;
            }
        } else {
            ++likeCount;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        NewsReplayLike newsReplayLike = this.newsReplyLikeMapper.selectByModel(new NewsReplayLike(replyId, userId));
        if (type == 1) {
            if (null == newsReplayLike) {
                NewsReplayLike newsReplayLikeNew = new NewsReplayLike();
                newsReplayLikeNew.setAddTime(new Date());
                newsReplayLikeNew.setId(this.nextSequence());
                newsReplayLikeNew.setReplyId(replyId);
                newsReplayLikeNew.setUserId(userId);
                count = this.newsReplyLikeMapper.insert(newsReplayLikeNew);
            }
        } else if (null != newsReplayLike) {
            count = this.newsReplyLikeMapper.deleteByPrimaryKey(newsReplayLike.getId());
        }
        return count;
    }

    private boolean checkLikeParam(NewsReplyLikeParam newsReplyLikeParam) {
        return null != newsReplyLikeParam.getReplyId() && null != newsReplyLikeParam.getUserId();
    }

    @Override
    public Calendar getMorningTime(Integer amount) {
        Calendar morningTime = Calendar.getInstance();
        morningTime.set(11, 0);
        morningTime.set(12, 0);
        morningTime.set(13, 0);
        morningTime.set(14, 0);
        morningTime.add(6, amount);
        return morningTime;
    }
}

