/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.dto.NewsCollectDTO;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.newidea.component.service.BaseService;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class NewsCollectServiceImpl
extends BaseService
implements NewsCollectService {
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private NewsStatisticIntegrationService newsStatisticIntegrationService;

    @Override
    public List<NewsCollectDTO> queryList(Long userId, MPage page) {
        List resultList = this.newsCollectMapper.queryList(userId, page);
        return resultList.stream().filter(Objects::nonNull).filter(e -> StringUtils.isNotBlank((CharSequence)e.getTitle())).collect(Collectors.toList());
    }

    @Override
    public Json collectNews(NewsCollect newsCollect) {
        NewsCollect collect = this.newsCollectMapper.selectUserCollect(newsCollect.getNewsId(), newsCollect.getUserId(), newsCollect.getType());
        if (!ObjectUtils.isEmpty((Object)collect)) {
            this.newsCollectMapper.deleteByModel(collect);
            this.newsStatisticIntegrationService.pushCollectData(newsCollect.getUserId(), newsCollect.getNewsId(), Byte.valueOf((byte)0));
        } else {
            newsCollect.setId(this.nextSequence());
            this.newsCollectMapper.insertSelective(newsCollect);
            this.newsStatisticIntegrationService.pushCollectData(newsCollect.getUserId(), newsCollect.getNewsId(), Byte.valueOf((byte)1));
        }
        return ResultUtil.genSuccessResult();
    }
}

