/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.integration.AppVersionIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.constant.SensitiveFlagEnum;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.dto.KindDTO;
import com.bxm.localnews.news.service.NewsKindService;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import com.ctrip.framework.apollo.spring.annotation.ApolloJsonValue;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="newsKindService")
@RefreshScope
public class NewsKindServiceImpl
extends BaseService
implements NewsKindService {
    private static final Logger logger = LoggerFactory.getLogger(NewsKindServiceImpl.class);
    private NewsKindMapper newsKindMapper;
    private UserKindMapper userKindMapper;
    private RedisStringAdapter redisStringAdapter;
    private RedisHashMapAdapter redisHashMapAdapter;
    private RedisSetAdapter redisSetAdapter;
    private AppVersionIntegrationService appVersionIntegrationService;
    private LocationIntegrationService locationIntegrationService;
    private NewsProperties newsProperties;
    @ApolloJsonValue(value="${news.config.promotion:[]}")
    private List<NewsKind> promotion;

    @Autowired
    public NewsKindServiceImpl(NewsKindMapper newsKindMapper, UserKindMapper userKindMapper, RedisStringAdapter redisStringAdapter, RedisHashMapAdapter redisHashMapAdapter, RedisSetAdapter redisSetAdapter, AppVersionIntegrationService appVersionIntegrationService, LocationIntegrationService locationIntegrationService, NewsProperties newsProperties) {
        this.newsKindMapper = newsKindMapper;
        this.userKindMapper = userKindMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.locationIntegrationService = locationIntegrationService;
        this.newsProperties = newsProperties;
    }

    private Boolean getPublishState(BasicParam basicParam) {
        return this.appVersionIntegrationService.getPublishState(basicParam);
    }

    @Override
    public List<NewsKind> selectAll(BasicParam basicParam, String areaName, String areaCode) {
        List<NewsKind> allKinds = this.selectAllToRedis();
        this.replaceLocalAreaName(areaCode, areaName, allKinds);
        if (this.getPublishState(basicParam).booleanValue()) {
            allKinds.removeIf(newsKind -> SensitiveFlagEnum.IS_SENSITIVE.getState().equals(newsKind.getSensitiveFlag()));
        }
        return allKinds;
    }

    @Override
    public Message createUserDefaultKinds(Long userId) {
        return Message.build((int)this.newsKindMapper.initUserDefaultKinds(userId));
    }

    @Override
    public Message createUserDefaultKindsForPublish(Long userId, BasicParam basicParam) {
        List<NewsKind> allKinds = this.selectAllToRedis();
        List ids = allKinds.stream().filter(newsKind -> newsKind.getIsDefault() == 1).map(NewsKind::getId).collect(Collectors.toList());
        List<Integer> userKindList = this.getFixKindId();
        if (CollectionUtils.isNotEmpty(ids)) {
            userKindList.addAll(ids);
        }
        userKindList = userKindList.stream().distinct().collect(Collectors.toList());
        ArrayList userKinds = Lists.newArrayList();
        for (int i = 0; i < userKindList.size(); ++i) {
            UserKind userKind = new UserKind();
            userKind.setUserKindId(this.nextSequence());
            userKind.setUserId(userId);
            userKind.setKindId(userKindList.get(i));
            userKind.setSortNo(Integer.valueOf(i));
            userKinds.add(userKind);
        }
        this.userKindMapper.batchInsert((List)userKinds);
        return Message.build((boolean)true);
    }

    @Override
    public KindDTO getMyKindAndAllKind(Long userId, String areaName, BasicParam basicParam, String areaCode) {
        List<NewsKind> allKinds = this.selectAllToRedis();
        KindDTO kindDTO = new KindDTO(allKinds, null);
        if (null != userId) {
            List<NewsKind> myKinds;
            if (this.checkForumPostEnable(areaCode) && !this.redisSetAdapter.exists(RedisConfig.FIRST_ENTER_PROMOTION_AREA, (Object)userId).booleanValue()) {
                myKinds = this.generatePromotionKinds(userId);
                logger.debug("[getMyKindAndAllKind]\u7528\u6237\u7b2c\u4e00\u6b21\u8fdb\u63a8\u5e7f\u9891\u9053\uff0c\u9891\u9053\u5217\u8868:{}", (Object)JSONObject.toJSONString(myKinds));
                this.redisSetAdapter.add(RedisConfig.FIRST_ENTER_PROMOTION_AREA, new Object[]{userId});
            } else {
                myKinds = this.getMyKind(userId);
            }
            if (CollectionUtils.isEmpty(myKinds)) {
                myKinds = this.generateCommonMyKinds(userId);
            }
            kindDTO = new KindDTO(allKinds, myKinds);
        }
        this.replaceLocalAreaName(areaCode, areaName, kindDTO.getAllKinds());
        if (this.getPublishState(basicParam).booleanValue()) {
            kindDTO.getAllKinds().removeIf(newsKind -> SensitiveFlagEnum.IS_SENSITIVE.getState().equals(newsKind.getSensitiveFlag()));
        }
        if (CollectionUtils.isNotEmpty((Collection)kindDTO.getMyKinds())) {
            this.replaceLocalAreaName(areaCode, areaName, kindDTO.getMyKinds());
            if (this.getPublishState(basicParam).booleanValue()) {
                kindDTO.getMyKinds().removeIf(newsKind -> SensitiveFlagEnum.IS_SENSITIVE.getState().equals(newsKind.getSensitiveFlag()));
            }
        }
        return kindDTO;
    }

    private List<NewsKind> generatePromotionKinds(Long userId) {
        ArrayList<NewsKind> result = new ArrayList();
        List<Object> fixKindList = new ArrayList();
        try {
            fixKindList = this.deepCopy(this.promotion);
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("\u63a8\u5e7f\u5730\u533a\u9ed8\u8ba4\u9891\u9053\u590d\u5236\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        result.addAll(fixKindList);
        result = result.stream().distinct().collect(Collectors.toList());
        NewsKindService newsKindService = (NewsKindService)SpringContextHolder.getBean(NewsKindService.class);
        newsKindService.saveKind(userId, result);
        return result;
    }

    private List<NewsKind> generateCommonMyKinds(Long userId) {
        List<NewsKind> fixKindList = this.newsKindMapper.selectAll();
        fixKindList = fixKindList.stream().distinct().collect(Collectors.toList());
        NewsKindService newsKindService = (NewsKindService)SpringContextHolder.getBean(NewsKindService.class);
        newsKindService.saveKind(userId, fixKindList);
        return fixKindList;
    }

    @Override
    @Async
    public void saveKind(Long userId, List<NewsKind> fixKindList) {
        AtomicInteger i = new AtomicInteger(0);
        fixKindList.forEach(x -> {
            x.setSortNo(Integer.valueOf(i.get()));
            i.getAndIncrement();
        });
        Integer[] myKindArray = (Integer[])fixKindList.stream().map(NewsKind::getId).toArray(Integer[]::new);
        this.resortUserKind(userId, myKindArray, "0");
    }

    private void replaceLocalAreaName(String areaCode, String areaName, List<NewsKind> myKinds) {
        if (StringUtils.isNotBlank((CharSequence)areaName) && myKinds != null && myKinds.size() > 0) {
            boolean isPostEnable = this.checkForumPostEnable(areaCode);
            for (NewsKind newsKind : myKinds) {
                logger.debug("newsKind.getName:{}", (Object)newsKind.getName());
                if (!StringUtils.equals((CharSequence)newsKind.getName(), (CharSequence)"\u672c\u5730")) continue;
                if (isPostEnable) {
                    newsKind.setName(areaName + "\u793e\u533a");
                    break;
                }
                myKinds.remove(newsKind);
                break;
            }
        }
    }

    private boolean checkForumPostEnable(String areaCode) {
        LocationDTO locationDTO;
        if (StringUtils.isNotEmpty((CharSequence)areaCode) && (locationDTO = this.locationIntegrationService.getLocationByGeocode(areaCode)) != null) {
            int enableCommunityContent = locationDTO.getEnableCommunityContent() == null ? 0 : locationDTO.getEnableCommunityContent();
            return 1 == enableCommunityContent;
        }
        return false;
    }

    @Override
    public Message addUserKind(Long userId, Integer kindId) {
        List<NewsKind> myKinds = this.getMyKind(userId);
        if (myKinds.stream().anyMatch(item -> item.getId().equals(kindId))) {
            return Message.build((boolean)false, (String)"\u91cd\u590d\u6dfb\u52a0");
        }
        List<NewsKind> allKinds = this.selectAllToRedis();
        Optional<NewsKind> newsKindOptional = allKinds.stream().filter(item -> item.getId().equals(kindId)).findFirst();
        if (newsKindOptional.isPresent()) {
            NewsKind newsKind = newsKindOptional.get();
            myKinds.add(newsKind);
        }
        this.syncMyKind(myKinds, userId);
        return Message.build();
    }

    @Override
    public void resortUserKind(Long userId, Integer[] kindIds, String firstOpenType) {
        if (ArrayUtils.isEmpty((Object[])kindIds)) {
            return;
        }
        List userKindIds = Stream.of(kindIds).collect(Collectors.toList());
        List<Integer> userKindList = this.getFixKindId();
        userKindList.addAll(userKindIds);
        userKindList = userKindList.stream().distinct().collect(Collectors.toList());
        List<NewsKind> allKinds = this.selectAllToRedis();
        ArrayList myKinds = Lists.newArrayList();
        userKindList.forEach(id -> allKinds.forEach(newsKind -> {
            if (newsKind.getId().equals(id)) {
                myKinds.add(newsKind);
            }
        }));
        this.syncMyKind(myKinds, userId);
    }

    private List<NewsKind> getMyKind(Long userId) {
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>(){};
        List myKinds = (List)this.redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), (TypeReference)typeReference);
        if (CollectionUtils.isEmpty((Collection)myKinds)) {
            myKinds = this.userKindMapper.selectMyKinds(userId);
            this.syncMyKind(myKinds, userId);
        }
        return myKinds;
    }

    private void syncMyKind(List<NewsKind> myKinds, Long userId) {
        if (CollectionUtils.isNotEmpty(myKinds)) {
            this.redisHashMapAdapter.put(RedisConfig.NEWS_USER_KIND, userId.toString(), myKinds);
            this.redisSetAdapter.add(RedisConfig.NEWS_USER_KIND_SET, new Object[]{userId});
        }
    }

    private List<NewsKind> selectAllToRedis() {
        List newsKindList;
        String str = (String)this.redisStringAdapter.get(RedisConfig.NEWS_KIND, String.class);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            newsKindList = JSONArray.parseArray((String)str, NewsKind.class);
        } else {
            newsKindList = this.newsKindMapper.selectAll();
            try {
                if (null != newsKindList) {
                    this.redisStringAdapter.set(RedisConfig.NEWS_KIND, (Object)JSONArray.toJSONString((Object)newsKindList));
                }
            }
            catch (Exception e) {
                logger.error("newsKind set redis error");
            }
        }
        return newsKindList;
    }

    private List<Integer> getFixKindId() {
        List<NewsKind> allKinds = this.selectAllToRedis();
        return allKinds.stream().filter(newsKind -> newsKind.getIsFix() == 1).map(NewsKind::getId).collect(Collectors.toList());
    }

    public <T> List<T> deepCopy(List<T> src) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(src);
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        ObjectInputStream in = new ObjectInputStream(byteIn);
        List dest = (List)in.readObject();
        return dest;
    }
}

