/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.ForumPostShareMapper;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsShareMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.service.NewsReadRewardService;
import com.bxm.localnews.news.strategy.GoldenStrategyContext;
import com.bxm.localnews.news.vo.ForumPostShare;
import com.bxm.localnews.news.vo.ForumPostStatistic;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsShare;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsReadRewardServiceImpl
extends BaseService
implements NewsReadRewardService {
    private UserIntegrationService userIntegrationService;
    private RedisStringAdapter redisStringAdapter;
    private NewsStatisticsMapper newsStatisticsMapper;
    private NewsCollectMapper newsCollectMapper;
    private NewsMapper newsMapper;
    private NewsShareMapper newsShareMapper;
    private GoldenStrategyContext goldenStrategyContext;
    private MissionIntegrationService missionIntegrationService;
    private NewsStatisticIntegrationService newsStatisticIntegrationService;
    private ForumPostMapper forumPostMapper;
    private ForumPostShareMapper forumPostShareMapper;
    private DistributedLock distributedLock;

    @Autowired
    public NewsReadRewardServiceImpl(UserIntegrationService userIntegrationService, RedisStringAdapter redisStringAdapter, NewsStatisticsMapper newsStatisticsMapper, NewsCollectMapper newsCollectMapper, NewsMapper newsMapper, NewsShareMapper newsShareMapper, GoldenStrategyContext goldenStrategyContext, MissionIntegrationService missionIntegrationService, NewsStatisticIntegrationService newsStatisticIntegrationService, ForumPostMapper forumPostMapper, ForumPostShareMapper forumPostShareMapper, DistributedLock distributedLock) {
        this.userIntegrationService = userIntegrationService;
        this.redisStringAdapter = redisStringAdapter;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsCollectMapper = newsCollectMapper;
        this.newsMapper = newsMapper;
        this.newsShareMapper = newsShareMapper;
        this.goldenStrategyContext = goldenStrategyContext;
        this.missionIntegrationService = missionIntegrationService;
        this.newsStatisticIntegrationService = newsStatisticIntegrationService;
        this.forumPostMapper = forumPostMapper;
        this.forumPostShareMapper = forumPostShareMapper;
        this.distributedLock = distributedLock;
    }

    @Override
    public Json<NewsCompleTaskDTO> saveShareNews(Long newsId, Long userId, Byte type) {
        this.logger.info("\u7528\u6237\u5206\u4eab\u65b0\u95fb\uff0c\u53c2\u6570->newsId:{},userId:{},type:{}", new Object[]{newsId, userId, type});
        if (newsId == null || userId == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        UserBean user = this.userIntegrationService.selectUserFromCache(userId);
        if (user == null || user.getState() != 1) {
            return ResultUtil.genSuccessResult((Object)new NewsCompleTaskDTO());
        }
        NewsCompleTaskDTO shareGoldDTO = null;
        KeyGenerator shareRecordKey = RedisConfig.USER_SHARE_NEWS_RECORD.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)newsId.toString());
        String requestId = String.valueOf(this.nextSequence());
        String key = "share_" + userId + "_" + newsId;
        if (this.distributedLock.lock(key, requestId)) {
            if (!this.redisStringAdapter.hasKey(shareRecordKey).booleanValue()) {
                shareGoldDTO = this.missionIntegrationService.compleTask(userId, "TASK_NEWS_SHARE", newsId.toString());
                this.redisStringAdapter.set(shareRecordKey, (Object)"exist");
                this.redisStringAdapter.expire(shareRecordKey, (long)DateUtils.getCurSeconds());
                NewsShare share = new NewsShare();
                share.setAddTime(new Date());
                share.setNewsId(newsId);
                share.setUserId(userId);
                share.setId(this.nextSequence());
                share.setReward(Integer.valueOf(Objects.isNull(shareGoldDTO.getGoldNum()) ? 0 : shareGoldDTO.getGoldNum().intValue()));
                share.setType(type);
                this.newsShareMapper.insertSelective(share);
            }
            this.newsStatisticIntegrationService.pushShareData(userId, newsId);
            this.distributedLock.unlock(key, requestId);
        }
        return ResultUtil.genSuccessResult(shareGoldDTO);
    }

    @Override
    public Json<NewsCompleTaskDTO> saveShareForums(Long postId, Long userId, Byte type) {
        this.logger.info("\u7528\u6237\u5206\u4eab\u5e16\u5b50\uff0c\u53c2\u6570->postId:{},userId:{},type:{}", new Object[]{postId, userId, type});
        if (postId == null || userId == null) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u53c2\u6570\u9519\u8bef");
        }
        UserBean user = this.userIntegrationService.selectUserFromCache(userId);
        if (user == null || user.getState() != 1) {
            return ResultUtil.genSuccessResult((Object)new NewsCompleTaskDTO());
        }
        NewsCompleTaskDTO shareGoldDTO = null;
        KeyGenerator shareRecordKey = RedisConfig.USER_SHARE_NEWS_RECORD.copy().appendKey((Object)userId.toString()).appendKey((Object)DateUtils.formatDate((Date)new Date())).appendKey((Object)postId.toString());
        if (!this.redisStringAdapter.hasKey(shareRecordKey).booleanValue()) {
            shareGoldDTO = this.missionIntegrationService.compleTask(userId, "TASK_NEWS_SHARE", postId.toString());
            this.redisStringAdapter.set(shareRecordKey, (Object)"exist");
            this.redisStringAdapter.expire(shareRecordKey, (long)DateUtils.getCurSeconds());
            ForumPostShare forumPostShare = new ForumPostShare();
            forumPostShare.setAddTime(new Date());
            forumPostShare.setId(this.nextSequence());
            forumPostShare.setPostId(postId);
            forumPostShare.setReward(Integer.valueOf(Objects.isNull(shareGoldDTO.getGoldNum()) ? 0 : shareGoldDTO.getGoldNum().intValue()));
            forumPostShare.setUserId(userId);
            forumPostShare.setType(type);
            this.forumPostShareMapper.insertSelective(forumPostShare);
        }
        ForumPostStatistic forumPostStatistic = new ForumPostStatistic();
        forumPostStatistic.setShareCount(Integer.valueOf(1));
        forumPostStatistic.setId(postId);
        this.forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        return ResultUtil.genSuccessResult((Object)shareGoldDTO);
    }

    @Override
    public Json<NewsGoldMeta> execGetGold(ExecGoldParam execGoldParam) {
        News news;
        if (null != execGoldParam.getUserId() && null != execGoldParam.getNewsId() && this.isNewsExsit(news = this.newsMapper.selectByPrimaryKey(execGoldParam.getNewsId()), execGoldParam.getViewTime())) {
            NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
            ExecGoldCalParam execGoldCalParam = new ExecGoldCalParam();
            BeanUtils.copyProperties((Object)execGoldParam, (Object)execGoldCalParam);
            execGoldCalParam.setNewsGoldMeta(newsGoldMeta);
            execGoldCalParam.setNews(news);
            this.goldenStrategyContext.chooseCalulator(execGoldCalParam);
            return ResultUtil.genSuccessResult((Object)execGoldCalParam.getNewsGoldMeta());
        }
        NewsGoldMeta newsGoldMeta = new NewsGoldMeta();
        newsGoldMeta.setGoldNum(0);
        newsGoldMeta.setTaskName("\u9605\u8bfb\u65b0\u95fb");
        newsGoldMeta.setGoldType((byte)1);
        newsGoldMeta.setTotalGold(BigDecimal.ZERO);
        return ResultUtil.genSuccessResult((Object)newsGoldMeta);
    }

    private boolean isNewsExsit(News news, Integer viewTime) {
        return news != null && viewTime != null;
    }
}

