/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.integration.AppVersionIntegrationService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.integration.NewsStatisticIntegrationService;
import com.bxm.localnews.news.constant.UrlCategoryEnum;
import com.bxm.localnews.news.constant.UrlPositionEnum;
import com.bxm.localnews.news.constant.UrlTypeEnum;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.domain.NewsSearchWordMapper;
import com.bxm.localnews.news.domain.NewsStatisticsMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.enums.TaskEnum;
import com.bxm.localnews.news.factory.IUrlFactory;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.AssemblyService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.FailVideo;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.NewsDetailVO;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.NewsRecord;
import com.bxm.localnews.news.vo.NewsSearchWord;
import com.bxm.localnews.news.vo.NewsUrlVo;
import com.bxm.localnews.news.vo.NewsVO;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.HtmlContentUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service(value="newsService")
public class NewsServiceImpl
extends BaseService
implements NewsService {
    @Resource
    private NewsMapper newsMapper;
    @Resource
    private NewsRecordMapper newsRecordMapper;
    @Resource
    private NewsStatisticsMapper newsStatisticsMapper;
    @Resource
    private NewsSearchWordMapper newsSearchWordMapper;
    @Resource
    private NewsKindMapper newsKindMapper;
    @Resource
    private AppVersionIntegrationService appVersionIntegrationService;
    @Resource
    private NewsRecommendIntegrationService newsRecommendIntegrationService;
    @Resource
    private NewsSearchIntegrationService newsSearchIntegrationService;
    @Resource
    private NewsStatisticIntegrationService newsStatisticIntegrationService;
    @Resource
    private NewsCollectMapper newsCollectMapper;
    @Resource
    private AssemblyService assemblyService;
    @Resource
    private MissionIntegrationService missionIntegrationService;
    @Resource
    private MessageIntegrationService messageIntegrationService;
    @Resource
    private IUrlFactory iUrlFactory;

    @Override
    public Json<NewsUrlVo> getUrlAddress(Long newsId, Long userId, Byte type) {
        News news;
        if (this.isNews(type) && null != (news = this.newsMapper.selectByPrimaryKey(newsId))) {
            String url = this.getNewsUrlBegin(type, news.getType()) + "newsId=" + newsId + "&userId=" + userId + "&type=" + type;
            NewsUrlVo newsUrlVo = new NewsUrlVo(url);
            return ResultUtil.genSuccessResult((Object)newsUrlVo);
        }
        this.logger.error("\u83b7\u5f97\u8be6\u60c5\u5730\u5740\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728-newsId:{},userId:{},type:{}", new Object[]{newsId, userId, type});
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83b7\u5f97\u8be6\u60c5\u5730\u5740\u65f6\u65b0\u95fb\u4e0d\u5b58\u5728");
    }

    private boolean isEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 1;
    }

    private boolean isIconEssayShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 2;
    }

    private boolean isVideoShare(Byte type, Byte newsType) {
        return type == 2 && newsType == 3;
    }

    private boolean isEssayDetail(Byte type) {
        return type == 1 || type == 3;
    }

    private boolean isNews(Byte type) {
        return type != 4;
    }

    private String getNewsUrlBegin(byte type, byte newsType) {
        String url = "";
        if (this.isEssayShare(type, newsType)) {
            url = "shareNewsDetail.html?";
        }
        if (this.isIconEssayShare(type, newsType)) {
            url = "sharePicDetail.html?";
        }
        if (this.isVideoShare(type, newsType)) {
            url = "shareVideoDetail.html?";
        }
        if (this.isEssayDetail(type)) {
            url = "newsDetail.html?";
        }
        return url;
    }

    @Override
    public Json<NewsDetailVO> getNewsDetail(NewsParam newsParam) {
        long begin = System.currentTimeMillis();
        if (null == newsParam.getNewsId()) {
            return ResultUtil.genSuccessResult((Object)new NewsDetailVO());
        }
        List newsVOList = this.newsSearchIntegrationService.multipleGet(new Long[]{newsParam.getNewsId()});
        if (newsVOList.isEmpty()) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u83b7\u53d6\u8be6\u60c5\u65f6\u65b0\u95fb\u7f3a\u5931");
        }
        NewsVO newsVO = (NewsVO)newsVOList.get(0);
        if (newsVO.getStatus() != 1) {
            return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u65b0\u95fb\u5df2\u4e0b\u67b6");
        }
        this.fillDetailExtInfo(newsVO, newsParam);
        NewsDetailVO newsDetailVO = new NewsDetailVO(newsVO);
        this.logger.debug("[getNewsDetail]\u65b0\u95fb\u8be6\u60c5es\u62c9\u53d6\u5b8c\u6bd5, param:[{}] ,content:[{}],\u8017\u65f6:[{}]", new Object[]{newsParam, StringUtils.substring((String)JSONObject.toJSONString((Object)newsDetailVO), (int)0, (int)50), System.currentTimeMillis() - begin});
        if (null != newsParam.getUserId()) {
            this.newsStatisticIntegrationService.pushNewClickData(newsParam.getUserId(), newsParam.getNewsId());
            this.newsStatisticIntegrationService.pushViewData(newsParam.getUserId(), newsParam.getNewsId());
        }
        return ResultUtil.genSuccessResult((Object)newsDetailVO);
    }

    private void fillDetailExtInfo(NewsVO newsVO, NewsParam newsParam) {
        newsVO.setCollect(Integer.valueOf(0));
        if (newsParam.getUserId() != null) {
            newsVO.setCollect(Integer.valueOf(this.countCollect(newsParam.getUserId(), newsParam.getNewsId())));
        }
        newsVO.setContent(this.assemblyService.fixContent(newsVO.getContent()));
        newsVO.setLocal(Byte.valueOf((byte)1));
        if (StringUtils.isNotEmpty((CharSequence)newsVO.getAreaDetail())) {
            newsVO.setLocal(Byte.valueOf((byte)2));
        }
        newsVO.setLinkUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.DETAIL, newsParam.getNewsId(), newsParam.getUserId()));
        newsVO.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.SHARE, newsParam.getNewsId(), newsParam.getUserId()));
        newsVO.setAppletShareUrl(this.iUrlFactory.getAppletUrl(UrlPositionEnum.NEWS, newsParam.getNewsId(), newsParam.getUserId()));
        if (StringUtils.isNotEmpty((CharSequence)newsVO.getVideoStr())) {
            newsVO.setVideoList(JSONArray.parseArray((String)newsVO.getVideoStr(), PostImgVo.class));
        }
        if (this.appVersionIntegrationService.getPublishState((BasicParam)newsParam).booleanValue()) {
            newsVO.setAuthor("");
            newsVO.setAuthorImg("");
        }
        if (Objects.isNull(newsVO.getIsBootDownload())) {
            newsVO.setIsBootDownload(Byte.valueOf((byte)0));
        }
    }

    private int countCollect(Long userId, Long newsId) {
        NewsCollect newsCollect = this.newsCollectMapper.selectUserCollect(newsId, userId, Byte.valueOf((byte)1));
        return null != newsCollect ? 1 : 0;
    }

    @Override
    @Async
    public void completeTaskAndPush(NewsParam newsParam, NewsVO newsVO) {
        NewsCompleTaskDTO completeTask;
        if (5 == newsParam.getPlatform() && Objects.nonNull(newsParam.getShareUserId()) && !newsParam.getShareUserId().equals(newsParam.getUserId()) && Objects.nonNull(completeTask = this.missionIntegrationService.compleTask(newsParam.getShareUserId(), TaskEnum.TASK_FISRT_BROWSE.name(), newsParam.getUserId().toString())) && completeTask.getGoldNum() > 0L) {
            String extendContent = null;
            String extendUrl = this.getExtendUrl(newsVO.getImgUrl());
            if (StringUtils.isEmpty((CharSequence)extendUrl)) {
                extendContent = this.getExtendContent(newsVO.getTitle(), newsVO.getContent());
            }
            this.messageIntegrationService.addMessage(newsParam.getShareUserId(), newsParam.getUserId(), completeTask, newsParam.getNewsId(), Byte.valueOf(ReplyTypeEnum.NEWS_REPLY.getCode()), extendUrl, extendContent, newsVO.getTitle());
        }
    }

    private String getExtendUrl(String imgStr) {
        List imageList = JSONObject.parseArray((String)imgStr, String.class);
        if (CollectionUtils.isNotEmpty((Collection)imageList)) {
            return (String)imageList.get(0);
        }
        return null;
    }

    private String getExtendContent(String title, String content) {
        if (StringUtils.isNotBlank((CharSequence)title)) {
            return title;
        }
        return HtmlContentUtils.getHtmlDesc((String)content, (int)10);
    }

    @Override
    public Json doRecordNews(Long newsId, Long userId, Integer viewTime, String tabType, String advertShow) {
        NewsRecord nRecord = this.newsRecordMapper.getByIds(newsId, userId, null);
        Date d = new Date();
        if (nRecord != null) {
            nRecord.setUpdateTime(d);
            if (viewTime > nRecord.getCheckTime()) {
                nRecord.setCheckTime(viewTime);
            }
            this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
        } else {
            NewsRecord nr = new NewsRecord();
            nr.setId(this.nextSequence());
            nr.setNewsId(newsId);
            nr.setUserId(userId);
            nr.setUpdateTime(d);
            nr.setCheckTime(viewTime);
            nr.setGetGold(Byte.valueOf((byte)1));
            nr.setAddTime(d);
            nr.setLastLocation(tabType);
            nr.setAdViewType(Byte.valueOf(advertShow));
            this.newsRecordMapper.insertSelective(nr);
        }
        return ResultUtil.genSuccessResult();
    }

    @Override
    public Json<List<News4Client>> listRecommendNews(Long newsId, Long userId, Integer size) {
        List ids;
        List<Long> nonNullIds;
        if (newsId == null || userId == null) {
            this.logger.error("\u65b0\u95fb\u8be6\u60c5\u63a8\u8350\u5217\u8868\u63a5\u53e3----\u53c2\u6570\u6709\u8bef,newsId:{},userId:{}", (Object)newsId, (Object)userId);
        }
        if (size == null) {
            size = 5;
        }
        if (!(nonNullIds = (ids = this.newsRecommendIntegrationService.recommendByNewsDetail(newsId, userId, size)).stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            nonNullIds = nonNullIds.stream().limit(size.intValue()).collect(Collectors.toList());
            Long[] s = nonNullIds.toArray(new Long[0]);
            List list = this.newsSearchIntegrationService.listRecommendedNews(s);
            this.fillExtInfo(userId, list);
            List news4ClientList = list.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
            return ResultUtil.genSuccessResult(news4ClientList);
        }
        return ResultUtil.genSuccessResult(new ArrayList());
    }

    @Override
    public Json<List<News4Client>> listRecommendNews4ImgNews(Long newsId) {
        List list = this.newsMapper.queryRecommendNewsList(newsId, 8, null);
        ArrayList<News4Client> news4ClientList = new ArrayList<News4Client>();
        for (News aList : list) {
            news4ClientList.add(new News4Client(aList, null));
        }
        return ResultUtil.genSuccessResult(news4ClientList);
    }

    @Override
    public Json<List<NewsSearchWord>> listHotTitle() {
        return ResultUtil.genSuccessResult((Object)this.newsSearchWordMapper.queryList());
    }

    @Override
    public Json<List<NewsKind>> listNewsKinds() {
        return ResultUtil.genSuccessResult((Object)this.newsKindMapper.selectVideoKinds());
    }

    @Override
    @Deprecated
    public Json<FailVideo> getFailVideo(Long newsId) {
        return ResultUtil.genFailedResult((int)RespCode.BAD_REQUEST, (String)"\u65e0\u6548\u89c6\u9891");
    }

    @Override
    public Json doSaveNewsClick(Long newsId) {
        this.newsStatisticsMapper.searchRecommended(newsId);
        return ResultUtil.genSuccessResult();
    }

    @Override
    public void fillExtInfo(Long userId, List<News> result) {
        List newsCollect = new ArrayList();
        if (userId != null) {
            newsCollect = this.newsCollectMapper.selectByIds(userId, Byte.valueOf((byte)1));
        }
        ArrayList finalNewsCollect = newsCollect;
        result.forEach(item -> {
            item.setLinkUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.DETAIL, item.getId(), userId));
            item.setShareUrl(this.iUrlFactory.getAppUrl(UrlCategoryEnum.NEWS, UrlTypeEnum.SHARE, item.getId(), userId));
            item.setCollect(Integer.valueOf(0));
            if (CollectionUtils.isNotEmpty((Collection)finalNewsCollect)) {
                for (NewsCollect collect : finalNewsCollect) {
                    if (!item.getId().equals(collect.getNewsId())) continue;
                    item.setCollect(Integer.valueOf(1));
                    break;
                }
            }
            item.setLocal(Byte.valueOf((byte)1));
            if (StringUtils.isNotEmpty((CharSequence)item.getAreaDetail())) {
                item.setLocal(Byte.valueOf((byte)2));
            }
            if (StringUtils.isNotEmpty((CharSequence)item.getVideoStr())) {
                item.setVideoList(JSONArray.parseArray((String)item.getVideoStr(), PostImgVo.class));
            }
        });
    }

    @Override
    public Json<NewsDetailVO> getNewsDetailById(NewsParam newsParam, BasicParam basicParam) {
        Json<NewsDetailVO> data = this.getNewsDetail(newsParam);
        NewsDetailVO result = (NewsDetailVO)data.getResult();
        NewsVO news = result.getNews();
        String content = news.getContent();
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            if (StringUtils.isNotBlank((CharSequence)news.getEditorMessage())) {
                content = content + news.getEditorMessage();
            }
            String htmlContent = 5 == basicParam.getPlatform() ? this.assemblyService.fixContent(content) : this.assemblyService.assemblyContent(content);
            news.setContent(htmlContent);
        }
        news.setShareDesc(HtmlContentUtils.getHtmlDesc((String)content, (int)50));
        result.setNews(news);
        data.setResult((Object)result);
        NewsService newsService = (NewsService)SpringContextHolder.getBean(NewsService.class);
        newsService.completeTaskAndPush(newsParam, news);
        return data;
    }
}

