/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.dto.MixRecommendDTO;
import com.bxm.localnews.facade.NewsRecommendFeignService;
import com.bxm.localnews.integration.AppVersionIntegrationService;
import com.bxm.localnews.integration.LocationIntegrationService;
import com.bxm.localnews.integration.NewsRecommendIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.convert.impl.ForumPostConvert;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MarketingActivitiesMapper;
import com.bxm.localnews.news.domain.MarketingActivitiesRecommendedMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.domain.NewsCollectMapper;
import com.bxm.localnews.news.dto.ForumPostDTO;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.news.param.HomeRecommendParam;
import com.bxm.localnews.news.param.VideoQueryParam;
import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MarketingActivities;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.news.vo.NewsTopListParam;
import com.bxm.localnews.param.MixRecommendParam;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="recommendService")
public class RecommendServiceImpl
extends BaseService
implements RecommendService {
    private MixedRecommendPoolMapper mixedRecommendPoolMapper;
    private MarketingActivitiesMapper marketingActivitiesMapper;
    private MarketingActivitiesRecommendedMapper marketingActivitiesRecommendedMapper;
    private AppVersionIntegrationService appVersionIntegrationService;
    private NewsProperties newsProperties;
    private VideoRecommendService videoRecommendService;
    private RedisStringAdapter redisStringAdapter;
    private NewsRecommendFeignService newsRecommendFeignService;
    private NewsSearchIntegrationService newsSearchIntegrationService;
    private NewsCollectMapper newsCollectMapper;
    private NewsService newsService;
    private DistributedLock distributedLock;
    private NewsRecommendIntegrationService newsRecommendIntegrationService;
    private ForumPostMapper forumPostMapper;
    private LocationIntegrationService locationIntegrationService;
    private ForumService forumService;

    @Autowired
    public RecommendServiceImpl(MixedRecommendPoolMapper mixedRecommendPoolMapper, MarketingActivitiesMapper marketingActivitiesMapper, MarketingActivitiesRecommendedMapper marketingActivitiesRecommendedMapper, AppVersionIntegrationService appVersionIntegrationService, NewsProperties newsProperties, VideoRecommendService videoRecommendService, RedisStringAdapter redisStringAdapter, NewsRecommendFeignService newsRecommendFeignService, NewsSearchIntegrationService newsSearchIntegrationService, NewsCollectMapper newsCollectMapper, NewsService newsService, DistributedLock distributedLock, NewsRecommendIntegrationService newsRecommendIntegrationService, ForumPostMapper forumPostMapper, LocationIntegrationService locationIntegrationService, ForumService forumService) {
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.marketingActivitiesMapper = marketingActivitiesMapper;
        this.marketingActivitiesRecommendedMapper = marketingActivitiesRecommendedMapper;
        this.appVersionIntegrationService = appVersionIntegrationService;
        this.newsProperties = newsProperties;
        this.videoRecommendService = videoRecommendService;
        this.redisStringAdapter = redisStringAdapter;
        this.newsRecommendFeignService = newsRecommendFeignService;
        this.newsSearchIntegrationService = newsSearchIntegrationService;
        this.newsCollectMapper = newsCollectMapper;
        this.newsService = newsService;
        this.distributedLock = distributedLock;
        this.newsRecommendIntegrationService = newsRecommendIntegrationService;
        this.forumPostMapper = forumPostMapper;
        this.locationIntegrationService = locationIntegrationService;
        this.forumService = forumService;
    }

    @Override
    public Json<NewsMeta> execRecommend(NewsRecommendParam param, BasicParam basicParam) {
        this.logger.debug("[oldExecRecommend]\u65b0\u95fb\u63a8\u8350\u8bf7\u6c42+1\uff1a{}", (Object)param);
        int count = 0;
        return this.retry(param, count, basicParam);
    }

    private Json<NewsMeta> retry(NewsRecommendParam param, int count, BasicParam basicParam) {
        long begin = System.currentTimeMillis();
        NewsMeta meta = new NewsMeta();
        List<Long> idList = new ArrayList();
        idList = this.newsRecommendIntegrationService.recommendList(param.getUserId(), Integer.valueOf(param.getKindId().intValue()), param.getPagesize(), param.getAreaCode(), param.getCurPage());
        this.logger.debug("[oldExecRecommend]\u7528\u6237id:{},\u63a8\u8350\u5f15\u64ce\u8fd4\u56de:{},\u8017\u65f6:{}", new Object[]{param.getUserId(), idList, System.currentTimeMillis() - begin});
        if (CollectionUtils.isEmpty(idList)) {
            return ResultUtil.genSuccessResult((Object)meta);
        }
        List list = this.newsSearchIntegrationService.listRecommendedNews(idList.toArray(new Long[0]));
        this.logger.debug("[oldExecRecommend]\u4ecees\u4e2d\u83b7\u53d6\u65b0\u95fb\u5217\u8868\u4fe1\u606f,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - begin));
        List<News> result = this.packageNews(list, idList, param.getUserId(), param.getAreaCode());
        this.logger.debug("[oldExecRecommend]\u65b0\u95fb\u5305\u88c5(\u65b0\u95fb&\u8425\u9500\u6d3b\u52a8),\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - begin));
        List<News4Client> news4ClientList = result.stream().map(news -> new News4Client(news, null)).collect(Collectors.toList());
        this.logger.debug("[oldExecRecommend]\u65b0\u95fb\u8fd4\u56de\u4f53\u5305\u88c5,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - begin));
        if (CollectionUtils.isEmpty(news4ClientList)) {
            return ResultUtil.genSuccessResult((Object)meta);
        }
        if (!(this.getPublishState(basicParam).booleanValue() || param.getKindId() != null && (long)this.newsProperties.getRecommendKindId() != param.getKindId())) {
            this.addRecommendVideo(param.getUserId(), param.getCurPage(), news4ClientList);
        }
        this.logger.debug("[oldExecRecommend]\u5c0f\u89c6\u9891\u6dfb\u52a0,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - begin));
        meta.setList(news4ClientList);
        meta.setNewsCount(meta.getList().size());
        this.hideInfo((BasicParam)param, meta);
        this.logger.debug("[oldExecRecommend]\u62c9\u53d6\u65b0\u95fb\u5217\u8868\u5b8c\u6bd5,\u53c2\u6570:{},\u8017\u65f6\uff1a{}", (Object)JSONObject.toJSONString((Object)meta), (Object)(System.currentTimeMillis() - begin));
        return ResultUtil.genSuccessResult((Object)meta);
    }

    private List<News> packageNews(List<News> list, List<Long> idList, Long userId, String areaCode) {
        List<Object> result = new ArrayList<News>();
        List<News> activityNews = this.addMarketingActivities(userId, areaCode);
        if (CollectionUtils.isNotEmpty(activityNews)) {
            result.addAll(activityNews);
            result = result.stream().sorted(Comparator.comparing(News::getShowLevel)).collect(Collectors.toList());
        }
        result.addAll(list);
        this.newsService.fillExtInfo(userId, result);
        return result;
    }

    private void addRecommendVideo(Long userId, Integer curPage, List<News4Client> news4ClientList) {
        this.logger.info("NewsRecommendParam----userId:{},curPage:{}", (Object)userId, (Object)curPage);
        if (curPage != 0 && curPage % 2 == 0) {
            VideoQueryParam videoParam = new VideoQueryParam();
            videoParam.setUserId(userId);
            List<VideoDto> videoDtoList = this.videoRecommendService.execRecommend(videoParam);
            if (CollectionUtils.isNotEmpty(videoDtoList)) {
                int size = news4ClientList.size();
                news4ClientList.add(size / 2, new News4Client(videoDtoList));
            }
        }
    }

    private List<News> addMarketingActivities(Long userId, String areaCode) {
        List list = this.marketingActivitiesMapper.listForRecommend(userId, areaCode);
        ArrayList<News> newsList = new ArrayList<News>();
        for (MarketingActivities activities : list) {
            News news = new News();
            news.setId(activities.getId());
            news.setTitle(activities.getTitle());
            news.setAuthor(activities.getAuthor());
            news.setContent(activities.getLinkUrl());
            news.setKindId(activities.getDeliveryChannel());
            news.setActivity(Byte.valueOf((byte)2));
            news.setIssueTime(activities.getShowTime());
            if (activities.getCoverUrl() != null) {
                String[] coverUrls = StringUtils.split((String)activities.getCoverUrl(), (String)",");
                news.setImgUrl(JSON.toJSONString((Object)coverUrls));
            }
            news.setHot(Byte.valueOf((byte)1));
            news.setTop(Byte.valueOf((byte)1));
            news.setType(Byte.valueOf((byte)1));
            news.setShowLevel(activities.getShowLevel());
            news.setShowLevelDetail(activities.getShowLevelDetail());
            news.setDeliveryType(activities.getDeliveryType());
            news.setAreaDetail(activities.getAreaDetail());
            news.setLinkUrl(activities.getLinkUrl());
            newsList.add(news);
            this.marketingActivitiesRecommendedMapper.save(userId, activities.getId());
        }
        return newsList;
    }

    private void hideInfo(BasicParam param, NewsMeta meta) {
        if (this.appVersionIntegrationService.getPublishState(param).booleanValue()) {
            meta.getList().removeIf(client -> client.getVideos() != null);
            for (News4Client client2 : meta.getList()) {
                if (client2.getNews() == null) continue;
                client2.getNews().setAuthor(null);
                client2.getNews().setAuthorImg(null);
            }
        }
    }

    @Override
    public Json<NewsMeta> getTopNewsList(NewsTopListParam param) {
        List topNewsOfWholeCountryList;
        List<News> topNewsOfAreaList = new ArrayList();
        KeyGenerator keyGeneratorOfArea = RedisConfig.TOP_NEW_OF_AREA_LIST.copy().appendKey((Object)param.getAreaCode());
        String topNewsOfAreaListStr = this.redisStringAdapter.getString(keyGeneratorOfArea);
        if (StringUtils.isNotBlank((String)topNewsOfAreaListStr)) {
            topNewsOfAreaList = JSON.parseArray((String)topNewsOfAreaListStr, News.class);
        } else if (param.getAreaCode() != null) {
            topNewsOfAreaList = this.newsSearchIntegrationService.listTopNews(5, param.getAreaCode());
            if (topNewsOfAreaList != null && topNewsOfAreaList.size() > 0) {
                this.redisStringAdapter.set(keyGeneratorOfArea, (Object)JSON.toJSONString(topNewsOfAreaList));
            }
        } else {
            this.redisStringAdapter.set(keyGeneratorOfArea, (Object)"[]");
            this.redisStringAdapter.expire(keyGeneratorOfArea, 10L);
        }
        KeyGenerator keyGeneratorOfWholeCountry = RedisConfig.TOP_NEW_OF_WHOLE_COUNTRY_LIST;
        String topNewsOfWholeCountryListStr = this.redisStringAdapter.getString(keyGeneratorOfWholeCountry);
        if (StringUtils.isNotBlank((String)topNewsOfWholeCountryListStr)) {
            topNewsOfWholeCountryList = JSON.parseArray((String)topNewsOfWholeCountryListStr, News.class);
        } else {
            topNewsOfWholeCountryList = this.newsSearchIntegrationService.listTopNews(5, null);
            if (topNewsOfWholeCountryList != null && topNewsOfWholeCountryList.size() > 0) {
                this.redisStringAdapter.set(keyGeneratorOfWholeCountry, (Object)JSON.toJSONString((Object)topNewsOfWholeCountryList));
            } else {
                this.redisStringAdapter.set(keyGeneratorOfWholeCountry, (Object)"[]");
                this.redisStringAdapter.expire(keyGeneratorOfWholeCountry, 10L);
            }
        }
        NewsMeta newsMeta = new NewsMeta();
        if (CollectionUtils.isEmpty(topNewsOfAreaList) && CollectionUtils.isEmpty((Collection)topNewsOfWholeCountryList)) {
            this.logger.debug("\u5f53\u524d\u672a\u914d\u7f6e\u7f6e\u9876\u65b0\u95fb");
            return ResultUtil.genSuccessResult((Object)newsMeta);
        }
        List<News> topNewsList = this.filterTopNews(topNewsOfAreaList, topNewsOfWholeCountryList, param);
        List newTopNewsList = this.newsSearchIntegrationService.listRecommendedNews((Long[])topNewsList.stream().map(News::getId).toArray(Long[]::new));
        if (CollectionUtils.isEmpty((Collection)newTopNewsList)) {
            return ResultUtil.genSuccessResult((Object)newsMeta);
        }
        this.newsService.fillExtInfo(param.getUserId(), newTopNewsList);
        ArrayList news4ClientList = Lists.newArrayList();
        for (News news : newTopNewsList) {
            News4Client news4Client = new News4Client();
            news4Client.setNews(news);
            news4ClientList.add(news4Client);
        }
        newsMeta.setList((List)news4ClientList);
        newsMeta.setNewsCount(newsMeta.getList().size());
        this.hideInfo((BasicParam)param, newsMeta);
        return ResultUtil.genSuccessResult((Object)newsMeta);
    }

    @Override
    public Json<NewsMeta> listMixRecommend(HomeRecommendParam param, BasicParam basicParam) {
        if (this.getPublishState(basicParam).booleanValue()) {
            NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
            newsRecommendParam.setAreaCode(param.getAreaCode());
            newsRecommendParam.setCurPage(param.getPageNum());
            newsRecommendParam.setKindId(param.getKindId());
            newsRecommendParam.setPagesize(param.getPageSize());
            if (param.getRecommendType() != null) {
                newsRecommendParam.setType(Byte.valueOf((byte)param.getRecommendType().intValue()));
            } else {
                newsRecommendParam.setType(Byte.valueOf((byte)1));
            }
            newsRecommendParam.setUserId(param.getUserId());
            return this.execRecommend(newsRecommendParam, basicParam);
        }
        if (this.checkIsNewVersionRecommend(param)) {
            return this.listMixRecommendByPromotion(param, basicParam);
        }
        NewsRecommendParam newsRecommendParam = new NewsRecommendParam();
        newsRecommendParam.setAreaCode(param.getAreaCode());
        newsRecommendParam.setCurPage(param.getPageNum());
        newsRecommendParam.setKindId(param.getKindId());
        newsRecommendParam.setPagesize(param.getPageSize());
        if (param.getRecommendType() != null) {
            newsRecommendParam.setType(Byte.valueOf((byte)param.getRecommendType().intValue()));
        } else {
            newsRecommendParam.setType(Byte.valueOf((byte)1));
        }
        newsRecommendParam.setUserId(param.getUserId());
        return this.execRecommend(newsRecommendParam, basicParam);
    }

    private Boolean getPublishState(BasicParam basicParam) {
        return this.appVersionIntegrationService.getPublishState(basicParam);
    }

    private boolean checkIsNewVersionRecommend(HomeRecommendParam param) {
        return this.checkForumPostEnable(param.getAreaCode()) && (param.getKindId() == null || param.getKindId() == (long)this.newsProperties.getRecommendKindId());
    }

    private boolean checkForumPostEnable(String areaCode) {
        LocationDTO locationDTO;
        if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)areaCode) && (locationDTO = this.locationIntegrationService.getLocationByGeocode(areaCode)) != null) {
            return locationDTO.getEnableCommunityContent() == 1;
        }
        return false;
    }

    public Json<NewsMeta> listMixRecommendByPromotion(HomeRecommendParam param, BasicParam basicParam) {
        this.logger.debug("[listMixRecommendByPromotion]\u65b0\u95fb\u63a8\u8350\u8bf7\u6c42+1\uff1a{}", (Object)param);
        int count = 0;
        return this.retryMixResult(param, basicParam, count);
    }

    private Json<NewsMeta> retryMixResult(HomeRecommendParam param, BasicParam basicParam, Integer count) {
        long begin = System.currentTimeMillis();
        NewsMeta meta = new NewsMeta();
        ArrayList<MixRecommendDTO> mixRecommendDTOList = new ArrayList();
        MixRecommendParam mixRecommendParam = new MixRecommendParam();
        BeanUtils.copyProperties((Object)param, (Object)mixRecommendParam);
        mixRecommendParam.setActionType(param.getRecommendType());
        mixRecommendDTOList = this.newsRecommendIntegrationService.listMixRecommendDTO(mixRecommendParam);
        this.logger.debug("[listMixRecommendByPromotion]\u4ecees\u4e2d\u83b7\u53d6\u65b0\u95fb\u5217\u8868\u4fe1\u606f,\u7ed3\u679c\uff1a{},\u8017\u65f6:{}", (Object)JSONObject.toJSONString(mixRecommendDTOList), (Object)(System.currentTimeMillis() - begin));
        if (CollectionUtils.isEmpty(mixRecommendDTOList)) {
            return ResultUtil.genSuccessResult((Object)meta);
        }
        List<News4Client> news4ClientList = this.listNews4Client(mixRecommendDTOList, param.getUserId(), param.getAreaCode(), true);
        this.logger.debug("[listMixRecommendByPromotion]\u65b0\u95fb\u5305\u88c5(\u65b0\u95fb&\u8425\u9500\u6d3b\u52a8),\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - begin));
        if (CollectionUtils.isEmpty(news4ClientList)) {
            return ResultUtil.genSuccessResult((Object)meta);
        }
        if (5 != basicParam.getPlatform()) {
            this.addRecommendVideo(param.getUserId(), param.getPageNum(), news4ClientList);
            this.logger.debug("[listMixRecommendByPromotion]\u5c0f\u89c6\u9891\u6dfb\u52a0,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - begin));
        }
        this.hideInfo(basicParam, meta);
        meta.setList(news4ClientList);
        meta.setNewsCount(meta.getList().size());
        this.logger.debug("[listMixRecommendByPromotion]\u62c9\u53d6\u65b0\u95fb\u5217\u8868\u5b8c\u6bd5,\u7ed3\u679c:{},\u8017\u65f6\uff1a{}", (Object)JSONObject.toJSONString((Object)meta), (Object)(System.currentTimeMillis() - begin));
        return ResultUtil.genSuccessResult((Object)meta);
    }

    @Override
    public List<News4Client> listNews4Client(List<MixRecommendDTO> mixRecommendDTOList, Long userId, String areaCode, boolean isFillTitle) {
        List postIdList = mixRecommendDTOList.stream().filter(mix -> mix.getOrigin().equals("1")).map(MixRecommendDTO::getId).collect(Collectors.toList());
        List<Long> newsIdList = mixRecommendDTOList.stream().filter(mix -> !mix.getOrigin().equals("1")).map(MixRecommendDTO::getId).collect(Collectors.toList());
        List list = this.newsSearchIntegrationService.listRecommendedNews(newsIdList.toArray(new Long[0]));
        List<News> result = this.packageNews(list, newsIdList, userId, areaCode);
        ArrayList<ForumPostVo> forumPostVoList = new ArrayList();
        if (CollectionUtils.isNotEmpty(postIdList)) {
            forumPostVoList = this.forumPostMapper.listPostByIds(postIdList);
            this.forumService.fillExtInfo(forumPostVoList, userId, areaCode, isFillTitle);
        }
        List forumPostResult = forumPostVoList.stream().map(ForumPostConvert::convertForumPost2DTO).collect(Collectors.toList());
        ArrayList<News4Client> news4ClientList = new ArrayList<News4Client>();
        for (MixRecommendDTO mixRecommendDTO : mixRecommendDTOList) {
            News4Client news4Client;
            if (mixRecommendDTO.getOrigin().equals("1")) {
                ForumPostDTO post = forumPostResult.stream().filter(forumPostDTO -> forumPostDTO.getId().equals(mixRecommendDTO.getId())).findFirst().orElse(null);
                if (!Objects.nonNull(post)) continue;
                news4Client = new News4Client();
                news4Client.setPost(post);
                news4ClientList.add(news4Client);
                continue;
            }
            News news = result.stream().filter(newsDTO -> newsDTO.getId().equals(mixRecommendDTO.getId())).findFirst().orElse(null);
            if (!Objects.nonNull(news) || 1 != news.getStatus()) continue;
            news4Client = new News4Client();
            news4Client.setNews(news);
            news4ClientList.add(news4Client);
        }
        return news4ClientList;
    }

    @Override
    public Json<NewsMeta> listPostByMixRecommendPool(HomeRecommendParam param) {
        NewsMeta meta = new NewsMeta();
        List postIdList = this.mixedRecommendPoolMapper.listPostRecommend(param);
        if (CollectionUtils.isNotEmpty((Collection)postIdList)) {
            List forumPostVoList = this.forumPostMapper.listPostByIds(postIdList);
            this.forumService.fillExtInfo(forumPostVoList, param.getUserId(), param.getAreaCode(), false);
            List forumPostResult = forumPostVoList.stream().map(ForumPostConvert::convertForumPost2DTO).collect(Collectors.toList());
            ArrayList<News4Client> news4ClientList = new ArrayList<News4Client>();
            for (Long mixRecommendDTO : postIdList) {
                ForumPostDTO post = forumPostResult.stream().filter(forumPostDTO -> forumPostDTO.getId().equals(mixRecommendDTO)).findFirst().orElse(null);
                if (!Objects.nonNull(post)) continue;
                News4Client news4Client = new News4Client();
                news4Client.setPost(post);
                news4ClientList.add(news4Client);
            }
            meta.setList(news4ClientList);
            meta.setNewsCount(meta.getList().size());
        }
        return ResultUtil.genSuccessResult((Object)meta);
    }

    @Override
    public Json<NewsMeta> listTopMixRecommend(NewsTopListParam param) {
        return null;
    }

    private List<News> filterTopNews(List<News> topNewsOfAreaList, List<News> topNewsOfWholeCountryList, NewsTopListParam param) {
        ArrayList<News> topNewsList = new ArrayList<News>();
        if (CollectionUtils.isNotEmpty(topNewsOfAreaList) && CollectionUtils.isNotEmpty(topNewsOfWholeCountryList)) {
            topNewsList.add(topNewsOfAreaList.get(0));
            topNewsList.add(topNewsOfWholeCountryList.get(0));
            return topNewsList;
        }
        if (CollectionUtils.isNotEmpty(topNewsOfAreaList) && CollectionUtils.isEmpty(topNewsOfWholeCountryList)) {
            topNewsList.addAll(topNewsOfAreaList);
        } else if (CollectionUtils.isNotEmpty(topNewsOfWholeCountryList) && CollectionUtils.isEmpty(topNewsOfAreaList)) {
            topNewsList.addAll(topNewsOfWholeCountryList);
        }
        topNewsList = topNewsList.stream().limit(2L).collect(Collectors.toList());
        return topNewsList;
    }
}

