/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.news.domain.NewsKindMapper;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.service.UserKindService;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserKindServiceImpl
extends BaseService
implements UserKindService {
    private UserKindMapper userKindMapper;
    private NewsKindMapper newsKindMapper;

    @Autowired
    public UserKindServiceImpl(UserKindMapper userKindMapper, NewsKindMapper newsKindMapper) {
        this.userKindMapper = userKindMapper;
        this.newsKindMapper = newsKindMapper;
    }

    @Override
    public Message copyKinds(Long fromUserId, Long toUserId) {
        List newsKindList = this.userKindMapper.selectKindByUserId(fromUserId);
        List newsKindDefaultList = this.newsKindMapper.selectAll();
        List<Object> newNewsKindList = new ArrayList();
        newNewsKindList.addAll(newsKindList);
        newNewsKindList.addAll(newsKindDefaultList);
        newNewsKindList = newNewsKindList.stream().distinct().sorted(Comparator.comparing(x -> x.getSortNo() < x.getSortNo())).collect(Collectors.toList());
        List userKindList = newNewsKindList.stream().map(x -> {
            UserKind userKind = new UserKind();
            userKind.setUserKindId(this.nextSequence());
            userKind.setKindId(x.getId());
            userKind.setSortNo(x.getSortNo());
            userKind.setUserId(toUserId);
            return userKind;
        }).collect(Collectors.toList());
        this.userKindMapper.deleteByUserId(toUserId);
        MybatisBatchBuilder.create(UserKindMapper.class, userKindList).run(UserKindMapper::insertSelective);
        return Message.build();
    }

    @Override
    public void resortKinds(Long userId, Integer[] kindIds, String firstOpenType) {
        this.userKindMapper.deleteByUserId(userId);
        if (kindIds != null && kindIds.length > 0) {
            ArrayList<UserKind> userKindList = new ArrayList<UserKind>();
            for (int i = 0; i < kindIds.length; ++i) {
                UserKind userKind = new UserKind();
                userKind.setUserKindId(this.nextSequence());
                userKind.setUserId(userId);
                userKind.setKindId(kindIds[i]);
                userKind.setSortNo(Integer.valueOf(i));
                userKindList.add(userKind);
            }
            this.userKindMapper.batchInsert(userKindList);
        }
    }
}

